/***************************************************************************
                          snes9xdlgimpl.cpp  -  description
                             -------------------
    begin                : Sun Nov 18 22:07:24 EST 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "snes9xdlgimpl.h"
#include "snes9x.h"
#include <qstring.h>
#include <kfiledialog.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qcombobox.h>

Snes9xDlgImpl::Snes9xDlgImpl(QWidget *parent, const char *name, bool modal, WFlags fl) : Snes9xDlg(parent, name, modal, fl) {
	_snes9x = new Snes9x();

	// Filesystem
	lineeditExecutable->setText(_snes9x->executable());
	lineeditRom->setText(_snes9x->romDir());

	// Audio
	checkboxSound->setChecked(_snes9x->sound());
	checkboxStereo->setChecked(_snes9x->stereo());
	comboboxSoundquality->setCurrentItem(_snes9x->soundquality());
	spinboxBuffersize->setValue(_snes9x->buffersize());
	checkboxEcho->setChecked(_snes9x->echo());
	checkboxEnvx->setChecked(_snes9x->envx());
	checkboxSamplecaching->setChecked(_snes9x->samplecaching());
	checkboxMastervolume->setChecked(_snes9x->mastervolume());
	checkboxSoundsync->setChecked(_snes9x->soundsync());
	checkboxSoundsync2->setChecked(_snes9x->soundsync2());
	checkboxInterpolatedsound->setChecked(_snes9x->interpolatedsound());
	checkboxThreadsound->setChecked(_snes9x->threadsound());
	checkboxAltsampledecode->setChecked(_snes9x->altsampledecode());

	// Cheat
	lineeditGamegenie->setText(_snes9x->gamegenie());
	lineeditActionreplay->setText(_snes9x->actionreplay());
	lineeditGoldfinger->setText(_snes9x->goldfinger());

	// Input
	checkboxMouse->setChecked(_snes9x->mouse());
	checkboxSuperscope->setChecked(_snes9x->superscope());
	checkboxJoy->setChecked(_snes9x->joy());
	checkboxSwapjoypads->setChecked(_snes9x->swapjoypads());
	lineeditJoydev1->setText(_snes9x->joydev1());
	lineeditJoydev2->setText(_snes9x->joydev2());
	lineeditJoymap1->setText(_snes9x->joymap1());
	lineeditJoymap2->setText(_snes9x->joymap2());

	// Netplay
	checkboxMultiplayer5->setChecked(_snes9x->multiplayer5());
	checkboxNet->setChecked(_snes9x->net());
	lineeditServer->setText(_snes9x->server());
	spinboxPort->setValue(_snes9x->port());

	// ROM
	checkboxInterleaved->setChecked(_snes9x->interleaved());
	checkboxInterleaved2->setChecked(_snes9x->interleaved2());
	checkboxHirom->setChecked(_snes9x->hirom());
	checkboxLorom->setChecked(_snes9x->lorom());
	checkboxHeader->setChecked(_snes9x->header());
	checkboxNoheader->setChecked(_snes9x->noheader());
	checkboxPal->setChecked(_snes9x->pal());
	checkboxNtsc->setChecked(_snes9x->ntsc());
	checkboxLayering->setChecked(_snes9x->layering());
	checkboxHdma->setChecked(_snes9x->hdma());
	checkboxSpeedhacks->setChecked(_snes9x->speedhacks());
	checkboxWindows->setChecked(_snes9x->windows());
	lineeditLoadsnapshot->setText(_snes9x->loadsnapshot());

	// Video
	radiobuttonTransparency->setChecked(_snes9x->transparency());
	radiobuttonSixteen->setChecked(_snes9x->sixteen());
	radiobuttonHires->setChecked(_snes9x->hires());
	radiobuttonInterpolate->setChecked(_snes9x->interpolate());
	radiobuttonInterpolate2->setChecked(_snes9x->interpolate2());
	radiobuttonInterpolate3->setChecked(_snes9x->interpolate3());
	radiobuttonInterpolate4->setChecked(_snes9x->interpolate4());
	radiobuttonInterpolate5->setChecked(_snes9x->interpolate5());
	checkboxModeswitch->setChecked(_snes9x->modeswitch());
	checkboxFullscreen->setChecked(_snes9x->fullscreen());
	checkboxScale->setChecked(_snes9x->scale());
	checkboxDisplayframerate->setChecked(_snes9x->displayframerate());
	spinboxFrameskip->setValue(_snes9x->frameskip());
	spinboxFrametime->setValue(_snes9x->frametime());
	spinboxCycles->setValue(_snes9x->cycles());
}

Snes9xDlgImpl::~Snes9xDlgImpl(){
	delete _snes9x;
}

void Snes9xDlgImpl::slotBrowseExecutable()
{
	QString string(KFileDialog::getOpenFileName(":"));
	if (!string.isNull()) lineeditExecutable->setText(string);
}

void Snes9xDlgImpl::slotBrowseRom()
{
	QString string(KFileDialog::getExistingDirectory(":"));
	if (!string.isNull()) lineeditRom->setText(string);
}

void Snes9xDlgImpl::slotLoadSnapshot()
{
	QString string(KFileDialog::getOpenFileName(":"));
	if (!string.isNull()) lineeditLoadsnapshot->setText(string);
}

void Snes9xDlgImpl::slotDefaults()
{
	QString tabLabel = tabSnes9x->tabLabel(tabSnes9x->currentPage());

	if (tabLabel == "Filesystem")
	{
		lineeditExecutable->setText(_snes9x->defaultExecutable());
		lineeditRom->setText(_snes9x->defaultRomDir());
	}

	if (tabLabel == "Audio")
	{
		checkboxSound->setChecked(_snes9x->defaultSound());
		checkboxStereo->setChecked(_snes9x->defaultStereo());
		comboboxSoundquality->setCurrentItem(_snes9x->defaultSoundquality());
		spinboxBuffersize->setValue(_snes9x->defaultBuffersize());
		checkboxEcho->setChecked(_snes9x->defaultEcho());
		checkboxEnvx->setChecked(_snes9x->defaultEnvx());
		checkboxSamplecaching->setChecked(_snes9x->defaultSamplecaching());
		checkboxMastervolume->setChecked(_snes9x->defaultMastervolume());
		checkboxSoundsync->setChecked(_snes9x->defaultSoundsync());
		checkboxSoundsync2->setChecked(_snes9x->defaultSoundsync2());
		checkboxInterpolatedsound->setChecked(_snes9x->defaultInterpolatedsound());
		checkboxThreadsound->setChecked(_snes9x->defaultThreadsound());
		checkboxAltsampledecode->setChecked(_snes9x->defaultAltsampledecode());
	}

	if (tabLabel == "Cheat")
	{
		lineeditGamegenie->setText(_snes9x->defaultGamegenie());
		lineeditActionreplay->setText(_snes9x->defaultActionreplay());
		lineeditGoldfinger->setText(_snes9x->defaultGoldfinger());
	}

	if (tabLabel == "Input")
	{
		checkboxMouse->setChecked(_snes9x->defaultMouse());
		checkboxSuperscope->setChecked(_snes9x->defaultSuperscope());
		checkboxJoy->setChecked(_snes9x->defaultJoy());
		checkboxSwapjoypads->setChecked(_snes9x->defaultSwapjoypads());
		lineeditJoydev1->setText(_snes9x->defaultJoydev1());
		lineeditJoydev2->setText(_snes9x->defaultJoydev2());
		lineeditJoymap1->setText(_snes9x->defaultJoymap1());
		lineeditJoymap2->setText(_snes9x->defaultJoymap2());
	}

	if (tabLabel == "Netplay")
	{
		checkboxMultiplayer5->setChecked(_snes9x->defaultMultiplayer5());
		checkboxNet->setChecked(_snes9x->defaultNet());
		lineeditServer->setText(_snes9x->defaultServer());
		spinboxPort->setValue(_snes9x->defaultPort());
	}

	if (tabLabel == "ROM")
	{
		checkboxInterleaved->setChecked(_snes9x->defaultInterleaved());
		checkboxInterleaved2->setChecked(_snes9x->defaultInterleaved2());
		checkboxHirom->setChecked(_snes9x->defaultHirom());
		checkboxLorom->setChecked(_snes9x->defaultLorom());
		checkboxHeader->setChecked(_snes9x->defaultHeader());
		checkboxNoheader->setChecked(_snes9x->defaultNoheader());
		checkboxPal->setChecked(_snes9x->defaultPal());
		checkboxNtsc->setChecked(_snes9x->defaultNtsc());
		checkboxLayering->setChecked(_snes9x->defaultLayering());
		checkboxHdma->setChecked(_snes9x->defaultHdma());
		checkboxSpeedhacks->setChecked(_snes9x->defaultSpeedhacks());
		checkboxWindows->setChecked(_snes9x->defaultWindows());
		lineeditLoadsnapshot->setText(_snes9x->defaultLoadsnapshot());
	}

	if (tabLabel == "Video")
	{
		radiobuttonTransparency->setChecked(_snes9x->defaultTransparency());
		radiobuttonSixteen->setChecked(_snes9x->defaultSixteen());
		radiobuttonHires->setChecked(_snes9x->defaultHires());
		radiobuttonInterpolate->setChecked(_snes9x->defaultInterpolate());
		radiobuttonInterpolate2->setChecked(_snes9x->defaultInterpolate2());
		radiobuttonInterpolate3->setChecked(_snes9x->defaultInterpolate3());
		radiobuttonInterpolate4->setChecked(_snes9x->defaultInterpolate4());
		radiobuttonInterpolate5->setChecked(_snes9x->defaultInterpolate5());
		checkboxModeswitch->setChecked(_snes9x->defaultModeswitch());
		checkboxFullscreen->setChecked(_snes9x->defaultFullscreen());
		checkboxScale->setChecked(_snes9x->defaultScale());
		checkboxDisplayframerate->setChecked(_snes9x->defaultDisplayframerate());
		spinboxFrameskip->setValue(_snes9x->defaultFrameskip());
		spinboxFrametime->setValue(_snes9x->defaultFrametime());
		spinboxCycles->setValue(_snes9x->defaultCycles());
	}
}

void Snes9xDlgImpl::slotSave()
{
	// Filesystem
	_snes9x->setExecutable(lineeditExecutable->text());
	_snes9x->setRomDir(lineeditRom->text());

	// Audio
	_snes9x->setSound(checkboxSound->isChecked());
	_snes9x->setStereo(checkboxStereo->isChecked());
	_snes9x->setSoundquality(comboboxSoundquality->currentItem());
	_snes9x->setBuffersize(spinboxBuffersize->value());
	_snes9x->setEcho(checkboxEcho->isChecked());
	_snes9x->setEnvx(checkboxEnvx->isChecked());
	_snes9x->setSamplecaching(checkboxSamplecaching->isChecked());
	_snes9x->setMastervolume(checkboxMastervolume->isChecked());
	_snes9x->setSoundsync(checkboxSoundsync->isChecked());
	_snes9x->setSoundsync2(checkboxSoundsync2->isChecked());
	_snes9x->setInterpolatedsound(checkboxInterpolatedsound->isChecked());
	_snes9x->setThreadsound(checkboxThreadsound->isChecked());
	_snes9x->setAltsampledecode(checkboxAltsampledecode->isChecked());

	// Cheat
	_snes9x->setGamegenie(lineeditGamegenie->text());
	_snes9x->setActionreplay(lineeditActionreplay->text());
	_snes9x->setGoldfinger(lineeditGoldfinger->text());

	// Input
	_snes9x->setMouse(checkboxMouse->isChecked());
	_snes9x->setSuperscope(checkboxSuperscope->isChecked());
	_snes9x->setJoy(checkboxJoy->isChecked());
	_snes9x->setSwapjoypads(checkboxSwapjoypads->isChecked());
	_snes9x->setJoydev1(lineeditJoydev1->text());
	_snes9x->setJoydev2(lineeditJoydev2->text());
	_snes9x->setJoymap1(lineeditJoymap1->text());
	_snes9x->setJoymap2(lineeditJoymap2->text());

	// Netplay
	_snes9x->setMultiplayer5(checkboxMultiplayer5->isChecked());
	_snes9x->setNet(checkboxNet->isChecked());
	_snes9x->setServer(lineeditServer->text());
	_snes9x->setPort(spinboxPort->value());

	// ROM
	_snes9x->setInterleaved(checkboxInterleaved->isChecked());
	_snes9x->setInterleaved2(checkboxInterleaved2->isChecked());
	_snes9x->setHirom(checkboxHirom->isChecked());
	_snes9x->setLorom(checkboxLorom->isChecked());
	_snes9x->setHeader(checkboxHeader->isChecked());
	_snes9x->setNoheader(checkboxNoheader->isChecked());
	_snes9x->setPal(checkboxPal->isChecked());
	_snes9x->setNtsc(checkboxNtsc->isChecked());
	_snes9x->setLayering(checkboxLayering->isChecked());
	_snes9x->setHdma(checkboxHdma->isChecked());
	_snes9x->setSpeedhacks(checkboxSpeedhacks->isChecked());
	_snes9x->setWindows(checkboxWindows->isChecked());
	_snes9x->setLoadsnapshot(lineeditLoadsnapshot->text());

	// Video
	_snes9x->setTransparency(radiobuttonTransparency->isChecked());
	_snes9x->setSixteen(radiobuttonSixteen->isChecked());
	_snes9x->setHires(radiobuttonHires->isChecked());
	_snes9x->setInterpolate(radiobuttonInterpolate->isChecked());
	_snes9x->setInterpolate2(radiobuttonInterpolate2->isChecked());
	_snes9x->setInterpolate3(radiobuttonInterpolate3->isChecked());
	_snes9x->setInterpolate4(radiobuttonInterpolate4->isChecked());
	_snes9x->setInterpolate5(radiobuttonInterpolate5->isChecked());
	_snes9x->setModeswitch(checkboxModeswitch->isChecked());
	_snes9x->setFullscreen(checkboxFullscreen->isChecked());
	_snes9x->setScale(checkboxScale->isChecked());
	_snes9x->setDisplayframerate(checkboxDisplayframerate->isChecked());
	_snes9x->setFrameskip(spinboxFrameskip->value());
	_snes9x->setFrametime(spinboxFrametime->value());
	_snes9x->setCycles(spinboxCycles->value());

	_snes9x->save();
	accept();
}
