/***************************************************************************
                          fce.cpp  -  Fce emulator
                             -------------------
    begin                : Fri Nov  2 20:09:20 EST 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "fce.h"
#include <qdir.h>
#include <qfileinfo.h>
#include <iostream.h>
#include <kprocess.h>

Fce::Fce() : Emulator()
{
	refresh();
}

void Fce::refresh()
{
	Emulator::refresh();
	load();
	setRomList();
}

void Fce::load()
{
	config->setGroup("Fce");
	Emulator::load();

	// Audio
	setSound(config->readBoolEntry("Sound", defaultSound()));
	setSoundquality(config->readNumEntry("Sound Quality", defaultSoundquality()));
	setBuffersize(config->readNumEntry("Buffer Size", defaultBuffersize()));

	// Video
	setPal(config->readBoolEntry("Pal", defaultPal()));
	setTvcolor(config->readBoolEntry("Tvcolor", defaultTvcolor()));
	setFrameskip(config->readNumEntry("Frameskip", defaultFrameskip()));
	setResolution(config->readNumEntry("Resolution", defaultResolution()));
}

void Fce::save()
{
	config->setGroup("Fce");
	Emulator::save();

	// Audio
	config->writeEntry("Sound", sound());
	config->writeEntry("Sound Quality", soundquality());
	config->writeEntry("Buffer Size", buffersize());

	// Video
	config->writeEntry("Pal", pal());
	config->writeEntry("Tvcolor", tvcolor());
	config->writeEntry("Frameskip", frameskip());
	config->writeEntry("Resolution", resolution());
}

// TODO - Could probably optimize the arguments string creation
void Fce::emulate(int index)
{
	// Executable
	QString command;
	command.append(executable());
	command.append(" ");

	// Audio
	if (sound()) command.append("-sound 1 "); else command.append("-sound 0 ");
	command.append("-freq ");
	command.append(QString::number(soundquality()));
	command.append(" ");
	command.append("-buffer ");
	command.append(QString::number(buffersize()));
	command.append(" ");

	// Video
	if (pal()) command.append("-pal ");
	if (tvcolor()) command.append("-ntsccol 1 "); else command.append("-ntsccol 0 ");
	if (frameskip() != 0)
	{
		command.append("-frameskip ");
		command.append(QString::number(frameskip()));
		command.append(" ");
	}
	command.append("-vmode ");
	command.append(QString::number(resolution() + 1));
	command.append(" ");

	// Full path to ROM
	QDir dir(_romDir);
	QFileInfo fileinfo(dir, _romList[index]);
	command.append("\"");
	command.append(fileinfo.filePath());
	command.append("\" ");

	// Run it
	command.append("& ");
	cout << command << endl;
	KShellProcess process;
	process << command;
	process.start(KProcess::DontCare, KProcess::NoCommunication);
}
