/***************************************************************************
                          stella.h  -  Stella emulator settings
                             -------------------
    begin                : Wed Sep 19 09:43:31 EDT 2001
    copyright            : (C) 2001 by Scott L. Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STELLA_H
#define STELLA_H

#include "emulator.h"
#include <qstring.h>

class Stella : public Emulator
{ 
public:
	/** Constructor */
	Stella();
	/** Destructor */
	~Stella() {};

	/** recreate the romlist */
	virtual void refresh();

	/** load the emulator settings */
	virtual void load();
	/** save the emulator settings */
	virtual void save();

	/** command to run the emulator */
	virtual void emulate(int);

	/** returns the default executable */
	virtual QString defaultExecutable() const { return "xstella"; }
	/** returns the default ROM directory */
	virtual QString defaultRomDir() const { return "/usr/local/games/a2600/roms/"; }

	/** returns the display setting */
	QString display() const { return _display; }
	/** return the frames per second */
	int fps() const { return _fps; };
	/** return whether or not a private colormap is to be used */
	bool owncmap() const { return _owncmap; }
	/** return the mouse setting */
	int paddle() const { return _paddle; }
    
	/** returns the display setting */
	QString defaultDisplay() const { return 0; }
	/** return the frames per second */
	int defaultFps() const { return 60; }
	/** return whether or not a private colormap is to be used */
	bool defaultOwncmap() const { return false; }
	/** return the mouse setting */
	int defaultPaddle() const { return 0; }
    
	/** sets the display */
	void setDisplay(const QString &display) { _display = display; }
	/** sets the frames per second */
	void setFps(int fps) { _fps = fps; }
	/** sets whether or not to use a private colormap */
	void setOwncmap(bool owncmap) { _owncmap = owncmap; }
	/** defines how to emulate the paddle */
	void setPaddle(int paddle) { _paddle = paddle; }

protected:
	/** Connect to the designated X display */
	QString _display;
	/** Display the given number of frames per second */
	int _fps;
	/** Install a private colormap */
	bool _owncmap;
	/** Indicates which paddle the mouse should emulate or that real Atari 2600 paddles are being used */
	int _paddle;
};

#endif // STELLA_H
