/***************************************************************************
                          stelladlgimpl.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Scott Patterson
    email                : kashis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "stelladlgimpl.h"
#include "stella.h"
#include <qstring.h>
#include <kfiledialog.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>

StellaDlgImpl::StellaDlgImpl(QWidget *parent, const char *name, bool modal, WFlags fl) : StellaDlg(parent, name, modal, fl) {
	_stella = new Stella();

	lineeditExecutable->setText(_stella->executable());
	lineeditRom->setText(_stella->romDir());

	lineeditDisplay->setText(_stella->display());
	spinboxFps->setValue(_stella->fps());
	checkboxColormap->setChecked(_stella->owncmap());

	radiobutton0->setChecked(false);
	radiobutton1->setChecked(false);
	radiobutton2->setChecked(false);
	radiobutton3->setChecked(false);
	radiobutton4->setChecked(false);
	switch (_stella->paddle())
	{
		case 0: radiobutton0->setChecked(true); break;
		case 1: radiobutton1->setChecked(true); break;
		case 2: radiobutton2->setChecked(true); break;
		case 3: radiobutton3->setChecked(true); break;
		case 4: radiobutton4->setChecked(true); break;
		default: radiobutton0->setChecked(true); break;
	}
}

StellaDlgImpl::~StellaDlgImpl(){
	delete _stella;
}

void StellaDlgImpl::slotBrowseExecutable()
{
	QString string(KFileDialog::getOpenFileName(":"));
	if (!string.isNull()) lineeditExecutable->setText(string);
}

void StellaDlgImpl::slotBrowseRom()
{
	QString string(KFileDialog::getExistingDirectory(":"));
	if (!string.isNull()) lineeditRom->setText(string);
}

void StellaDlgImpl::slotDefaults()
{
	QString tabLabel = tabStella->tabLabel(tabStella->currentPage());

	if (tabLabel == "Filesystem")
	{
		lineeditExecutable->setText(_stella->defaultExecutable());
		lineeditRom->setText(_stella->defaultRomDir());
	}

	if (tabLabel == "Preferences")
	{
		lineeditDisplay->setText(_stella->defaultDisplay());
		spinboxFps->setValue(_stella->defaultFps());
		checkboxColormap->setChecked(_stella->defaultOwncmap());

		radiobutton0->setChecked(false);
		radiobutton1->setChecked(false);
		radiobutton2->setChecked(false);
		radiobutton3->setChecked(false);
		radiobutton4->setChecked(false);
		int paddle = _stella->defaultPaddle();
		switch(paddle)
		{
			case 0: radiobutton0->setChecked(true); break;
			case 1: radiobutton1->setChecked(true); break;
			case 2: radiobutton2->setChecked(true); break;
			case 3: radiobutton3->setChecked(true); break;
			case 4: radiobutton4->setChecked(true); break;
			default: radiobutton0->setChecked(true); break;
		}
	}
}

void StellaDlgImpl::slotSave()
{
	_stella->setExecutable(lineeditExecutable->text());
	_stella->setRomDir(lineeditRom->text());
	_stella->setDisplay(lineeditDisplay->text());
	_stella->setFps(spinboxFps->value());
	_stella->setOwncmap(checkboxColormap->isChecked());
	if (radiobutton0->isChecked()) _stella->setPaddle(0);
	if (radiobutton1->isChecked()) _stella->setPaddle(1);
	if (radiobutton2->isChecked()) _stella->setPaddle(2);
	if (radiobutton3->isChecked()) _stella->setPaddle(3);
	if (radiobutton4->isChecked()) _stella->setPaddle(4);

	_stella->save();
	accept();
}
