/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.security.MessageDigest;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LadySwordPatcher {
    final JFileChooser fc = new JFileChooser();
    final String[] keys = new String[]{"6959F7D27FAF72B76176D3A3C1BD14A6D0BBD1AE", "5D76C3FFDB56C83854400DA91A4257B380AC4941", "7384D0D863DA43C64D704F4F36CE55502E3B6159", "1BADB6F4F4D23EBF7CAF11CC8C93403111AD9F82", "B384056DC6C92BCED4A5FCFCDCC97D001D5AEA22", "4AF49F37B3B61572131AE5560D7CB0A01D809568", "6120D1B89535F134482862B5B7806798DD726CF6", "17FF042979006AA18D27B584CC8384569D5EC1DD"};
    private URI linkToMyth;
    private JFrame frmLadySwordPatcheur;
    private JTextField textSource;
    private JTextField textDest;
    private JCheckBox chkPVInfinit;
    private JCheckBox chkStr255;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LadySwordPatcher window = new LadySwordPatcher();
                    window.frmLadySwordPatcheur.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public LadySwordPatcher() {
        try {
            this.linkToMyth = new URI("http://myth-project.legtux.org");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize();
        ExtensionFileFilter filter = new ExtensionFileFilter("PCE Rom", "PCE");
        this.fc.setFileFilter(filter);
        this.fc.setCurrentDirectory(new File(System.getProperty("user.dir")));
    }

    private void initialize() {
        this.frmLadySwordPatcheur = new JFrame();
        this.frmLadySwordPatcheur.setTitle("Lady Sword Patcheur");
        this.frmLadySwordPatcheur.setResizable(false);
        this.frmLadySwordPatcheur.setIconImage(Toolkit.getDefaultToolkit().getImage(LadySwordPatcher.class.getResource("/image/icon.jpg")));
        this.frmLadySwordPatcheur.setBounds(100, 100, 580, 400);
        this.frmLadySwordPatcheur.setDefaultCloseOperation(3);
        this.frmLadySwordPatcheur.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        panel.setBorder(null);
        this.frmLadySwordPatcheur.getContentPane().add((Component)panel, "Center");
        panel.setLayout(null);
        JLabel label = new JLabel("");
        label.setIcon(new ImageIcon(LadySwordPatcher.class.getResource("/image/background.jpg")));
        label.setBounds(10, 11, 256, 224);
        panel.add(label);
        this.chkPVInfinit = new JCheckBox("PV Infinis");
        this.chkPVInfinit.setHorizontalAlignment(2);
        this.chkPVInfinit.setBounds(272, 182, 130, 23);
        panel.add(this.chkPVInfinit);
        this.chkStr255 = new JCheckBox("Force \u00e0 255");
        this.chkStr255.setHorizontalAlignment(2);
        this.chkStr255.setBounds(404, 182, 145, 23);
        panel.add(this.chkStr255);
        JButton cmdPatch = new JButton("Patcher");
        cmdPatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File fileToRead = new File(LadySwordPatcher.this.textSource.getText());
                    File fileToWrite = new File(LadySwordPatcher.this.textDest.getText());
                    if (!fileToRead.exists() || !fileToRead.isFile()) {
                        JOptionPane.showMessageDialog(LadySwordPatcher.this.frmLadySwordPatcheur, "Vous devez selectionner un fichier comme source !", "Erreur", 0);
                        return;
                    }
                    if (fileToWrite.isDirectory() || !fileToWrite.getParentFile().exists()) {
                        JOptionPane.showMessageDialog(LadySwordPatcher.this.frmLadySwordPatcheur, "Vous devez selectionner un fichier comme destination !", "Erreur", 0);
                        return;
                    }
                    long size = fileToRead.length();
                    if (size != 0x100000L && size != 0x100200L) {
                        JOptionPane.showMessageDialog(LadySwordPatcher.this.frmLadySwordPatcheur, "Le fichier n'a pas une taille valide !", "Erreur", 0);
                        return;
                    }
                    RandomAccessFile streamFile = new RandomAccessFile(fileToRead.getAbsolutePath(), "r");
                    byte[] fileData = new byte[(int)streamFile.length()];
                    streamFile.read(fileData);
                    streamFile.close();
                    MessageDigest md = MessageDigest.getInstance("SHA1");
                    md.update(fileData);
                    byte[] sha1key = md.digest();
                    if (!LadySwordPatcher.this.IsValidKey(LadySwordPatcher.bytesToHex(sha1key))) {
                        JOptionPane.showMessageDialog(LadySwordPatcher.this.frmLadySwordPatcheur, "Votre fichier ne semble pas \u00eatre une ROM valide.\nSi vous pensez le contraire, veuillez contacter pinky.", "Erreur", 0);
                        return;
                    }
                    if (size == 0x100000L) {
                        byte[] oldData = fileData;
                        fileData = new byte[0x100200];
                        InputStream headerPatch = LadySwordPatcher.class.getResourceAsStream("/patch/header.patch");
                        byte[] headerData = new byte[512];
                        headerPatch.read(headerData);
                        headerPatch.close();
                        int i = 0;
                        while (i < 512) {
                            fileData[i] = headerData[i];
                            ++i;
                        }
                        i = 0;
                        while (i < 0x100000) {
                            fileData[i + 512] = oldData[i];
                            ++i;
                        }
                    }
                    InputStream fixPatch = LadySwordPatcher.class.getResourceAsStream("/patch/fix.patch");
                    byte[] fixData = new byte[fixPatch.available()];
                    fixPatch.read(fixData);
                    fixPatch.close();
                    int i = 0;
                    while (i < fixData.length) {
                        fileData[i + 358401] = fixData[i];
                        ++i;
                    }
                    FileOutputStream outRom = new FileOutputStream(fileToWrite);
                    outRom.write(fileData);
                    outRom.close();
                    InputStream ipsPatch = LadySwordPatcher.class.getResourceAsStream("/patch/lsfr.ips");
                    byte[] ipsData = new byte[ipsPatch.available()];
                    int iRead = 0;
                    while (ipsPatch.available() != 0) {
                        iRead += ipsPatch.read(ipsData, iRead, ipsData.length - iRead);
                    }
                    ipsPatch.close();
                    File tempIPS = File.createTempFile("temp", ".ips");
                    FileOutputStream outIPS = new FileOutputStream(tempIPS);
                    outIPS.write(ipsData, 0, ipsData.length);
                    outIPS.close();
                    new IpsPatcher(tempIPS, fileToWrite).patch();
                    tempIPS.deleteOnExit();
                    streamFile = new RandomAccessFile(fileToWrite.getAbsolutePath(), "r");
                    streamFile.read(fileData);
                    streamFile.close();
                    fileData[10476] = LadySwordPatcher.this.chkStr255.isSelected() ? -1 : 90;
                    if (LadySwordPatcher.this.chkPVInfinit.isSelected()) {
                        int i2 = 0;
                        while (i2 < 26) {
                            fileData[10722 + i2] = -22;
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < 32) {
                            fileData[21680 + i2] = -22;
                            ++i2;
                        }
                    } else {
                        int[] data1 = new int[]{56, 173, 215, 55, 237, 47, 50, 141, 215, 55, 173, 216, 55, 237, 48, 50, 141, 216, 55, 144, 6, 13, 215, 55, 240, 1};
                        int[] data2 = new int[]{56, 173, 215, 55, 237, 47, 50, 141, 215, 55, 173, 216, 55, 237, 48, 50, 141, 216, 55, 144, 5, 13, 215, 55, 208, 6, 156, 215, 55, 156, 216, 55};
                        int i3 = 0;
                        while (i3 < 26) {
                            fileData[10722 + i3] = (byte)data1[i3];
                            ++i3;
                        }
                        i3 = 0;
                        while (i3 < 32) {
                            fileData[21680 + i3] = (byte)data2[i3];
                            ++i3;
                        }
                    }
                    outRom = new FileOutputStream(fileToWrite);
                    outRom.write(fileData);
                    outRom.close();
                    JOptionPane.showMessageDialog(LadySwordPatcher.this.frmLadySwordPatcheur, "Votre fichier a \u00e9t\u00e9 correctement patch\u00e9.");
                }
                catch (Exception error) {
                    try {
                        JOptionPane.showMessageDialog(LadySwordPatcher.this.frmLadySwordPatcheur, error, "Erreurr", 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        cmdPatch.setBounds(276, 212, 288, 23);
        panel.add(cmdPatch);
        JLabel lblRom = new JLabel("Source (La ROM japonaise ou fran\u00e7aise) : ");
        lblRom.setBounds(276, 85, 288, 14);
        panel.add(lblRom);
        this.textSource = new JTextField();
        this.textSource.setBounds(276, 106, 257, 20);
        panel.add(this.textSource);
        this.textSource.setColumns(10);
        JButton cmdOpen = new JButton("...");
        cmdOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LadySwordPatcher.this.fc.showOpenDialog(LadySwordPatcher.this.frmLadySwordPatcheur) == 0) {
                    LadySwordPatcher.this.textSource.setText(LadySwordPatcher.this.fc.getSelectedFile().getAbsolutePath());
                }
            }
        });
        cmdOpen.setBounds(543, 105, 21, 23);
        panel.add(cmdOpen);
        JTextArea txtrCePatcheurPermet = new JTextArea();
        txtrCePatcheurPermet.setFont(new Font("Tahoma", 0, 11));
        txtrCePatcheurPermet.setBackground(SystemColor.control);
        txtrCePatcheurPermet.setWrapStyleWord(true);
        txtrCePatcheurPermet.setLineWrap(true);
        txtrCePatcheurPermet.setText("Ce patcheur permet de jouer en fran\u00e7ais \u00e0 Lady Sword, quelle que soit la ROM utilis\u00e9e. Il est possible de cheater sa ROM pour avoir ses PV infinis et une force de base \u00e0 255 (au lieu de 90).");
        txtrCePatcheurPermet.setBounds(276, 11, 288, 74);
        panel.add(txtrCePatcheurPermet);
        JTextArea txtrTraductionEffectuePar = new JTextArea();
        txtrTraductionEffectuePar.setWrapStyleWord(true);
        txtrTraductionEffectuePar.setText("Traduction effectu\u00e9e par pinky (MYTH) \u00e0 partir du travail d'Esperknight et Filler.\r\n\r\nMerci \u00e0 tous ceux qui ont rendu ce projet possible.\r\n");
        txtrTraductionEffectuePar.setLineWrap(true);
        txtrTraductionEffectuePar.setFont(new Font("Tahoma", 0, 11));
        txtrTraductionEffectuePar.setBackground(SystemColor.menu);
        txtrTraductionEffectuePar.setBounds(132, 266, 432, 54);
        panel.add(txtrTraductionEffectuePar);
        JLabel logoLabel = new JLabel("");
        logoLabel.setIcon(new ImageIcon(new ImageIcon(LadySwordPatcher.class.getResource("/image/icon.jpg")).getImage().getScaledInstance(112, 112, 4)));
        logoLabel.setBounds(10, 248, 112, 112);
        panel.add(logoLabel);
        JButton linkMyth = new JButton("<HTML><FONT color=\"#000099\"><U>http://myth-project.legtux.org</U></FONT></HTML>");
        linkMyth.setFocusable(false);
        linkMyth.setFocusPainted(false);
        linkMyth.setFocusTraversalKeysEnabled(false);
        linkMyth.setCursor(Cursor.getPredefinedCursor(12));
        linkMyth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(LadySwordPatcher.this.linkToMyth);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        linkMyth.setBackground(SystemColor.control);
        linkMyth.setBounds(132, 331, 432, 29);
        linkMyth.setBorderPainted(false);
        linkMyth.setOpaque(false);
        panel.add(linkMyth);
        JLabel lblFichierPatcherpeuttre = new JLabel("Destination (Peut-\u00eatre la m\u00eame que la source) :");
        lblFichierPatcherpeuttre.setBounds(276, 137, 288, 14);
        panel.add(lblFichierPatcherpeuttre);
        this.textDest = new JTextField();
        this.textDest.setColumns(10);
        this.textDest.setBounds(276, 154, 257, 20);
        panel.add(this.textDest);
        JButton cmdDest = new JButton("...");
        cmdDest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LadySwordPatcher.this.fc.showSaveDialog(LadySwordPatcher.this.frmLadySwordPatcheur) == 0) {
                    LadySwordPatcher.this.textDest.setText(LadySwordPatcher.this.fc.getSelectedFile().getAbsolutePath());
                }
            }
        });
        cmdDest.setBounds(543, 153, 21, 23);
        panel.add(cmdDest);
    }

    private boolean IsValidKey(String key) {
        int i = 0;
        while (i < this.keys.length) {
            if (key.equals(this.keys[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String bytesToHex(byte[] b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < b.length) {
            buf.append(hexDigit[b[j] >> 4 & 0xF]);
            buf.append(hexDigit[b[j] & 0xF]);
            ++j;
        }
        return buf.toString();
    }
}

