/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.RandomAccessFile;

class IpsPatcher {
    private RandomAccessFile input;
    private RandomAccessFile output;

    public IpsPatcher(File pfname, File tfname) throws Exception {
        this.input = new RandomAccessFile(pfname, "r");
        this.output = new RandomAccessFile(tfname, "rw");
    }

    public void patch() throws Exception {
        byte[] lookaHead = new byte[3];
        byte[] r_size = new byte[2];
        this.readHead();
        this.input.read(lookaHead);
        while (!this.eofMarker(lookaHead)) {
            this.output.seek(IpsPatcher.getUnsignedSmallInt(lookaHead[0], lookaHead[1], lookaHead[2]));
            this.input.read(r_size);
            int i_size = IpsPatcher.getUnsignedShort(r_size[0], r_size[1]);
            if (i_size == 0) {
                this.writeRLERecord();
            } else {
                byte[] data = new byte[i_size];
                this.input.read(data);
                this.output.write(data);
            }
            this.input.read(lookaHead);
        }
    }

    private void readHead() throws Exception {
        byte[] head = new byte[5];
        String headTemplate = "PATCH";
        this.input.read(head);
        if (!headTemplate.equals(new String(head))) {
            throw new Exception("Le patch n'est pas en format IPS !");
        }
    }

    private boolean eofMarker(byte[] chs) {
        String name = "EOF";
        return name.equals(new String(chs));
    }

    private void writeRLERecord() throws Exception {
        byte[] r_RLEsize = new byte[2];
        this.input.read(r_RLEsize);
        int stride = IpsPatcher.getUnsignedShort(r_RLEsize[0], r_RLEsize[1]);
        int val = IpsPatcher.getUnsignedByte(this.input.read());
        int i = 0;
        while (i < stride) {
            this.output.write(val);
            ++i;
        }
    }

    private static int getUnsignedByte(int b) {
        return b & 0xFF;
    }

    private static int getUnsignedShort(int f, int s) {
        return IpsPatcher.getUnsignedByte(f) << 8 | IpsPatcher.getUnsignedByte(s);
    }

    private static int getUnsignedSmallInt(int f, int s, int t) {
        return IpsPatcher.getUnsignedByte(f) << 16 | IpsPatcher.getUnsignedShort(s, t);
    }
}

