; ZeroMem.asm
; ZeroMemory Function
bits 32

global ZeroMemory

segment code public align=4 use32 class=code

; void WINAPI ZeroMemory(PVOID Destination,DWORD Length):
; Zeros out the memory pointed by `dest' for `size' bytes
align 4
ZeroMemory:
   push ebp
   mov ebp, esp

; PARAMS
.dest  equ 8
.size  equ 12

   push es
   push ds
   pop es
   push edi

   xor eax, eax            ; zero out eax
   mov edi, [ebp + .dest]  ; edi = dest
   mov ecx, [ebp + .size]  ; ecx = size

   test ecx, 15
   jle .bytetransfer

   test edi, 3             ; test for alignment
   jz .aligned
.unaligned:
   stosb                   ; tranfer by byte until aligned
   dec ecx
   test edi, 3
   jnz .unaligned
.aligned:
   mov edx, ecx
   shr ecx, 2
   and edx, 3

   rep stosd               ; 4 byte transfer

   mov ecx, edx
.bytetransfer:
   rep stosb

   pop edi
   pop es

   leave
   retn 8
