; crc32.asm
; Cyclic Redundancy Check
; CRC32 Algorithm for IPSEXE

bits 32

global init_crc
global update_crc

segment code public align=4 use32 class=code

; Initializes the crc_table, call this first
init_crc:
   xor eax, eax
   xor edx, edx

.loop:
   mov ecx, eax
   mov edx, 8
.inloop:
   test ecx, 1
   jz .clear
   shr ecx, 1
   xor ecx, 0xedb88320
   jmp short .set
.clear:
   shr ecx, 1
.set:
   dec edx
   jnz .inloop

   mov [crc_table + eax*4], ecx
   inc eax
   cmp eax, 256
   jl .loop

   retn

; update_crc: Updates a running crc with bytes buf[0..len-1] and returns the crc
; Takes 3 parameters, (DWORD crc,LPBYTE buf,DWORD len)
; crc: The current crc value
; buf: Pointer to the buffer to update crc
; len: length of the buffer
align 4
update_crc:
   push ebp
   mov ebp, esp

; PARAMS
%define crc ebp + 8
%define buf ebp + 12
%define len ebp + 16

   push edi

   mov eax, [crc]
   xor eax, 0xFFFFFFFF

   mov edi, [buf]
   xor ecx, ecx

   cmp [len], dword 0
   je .done
.loop:
   mov edx, eax
   xor edx, [edi + ecx]
   and edx, 0xFF
   shr eax, 8
   xor eax, [crc_table + edx*4]

   inc ecx
   cmp ecx, [len]
   jl .loop
.done:
   xor eax, 0xFFFFFFFF

   pop edi

   leave
   retn 12

segment bss public align=4 use32 class=bss

crc_table resd 256