/*
   ips2exe.cpp
   IPSEXE patch maker
*/
#include <windows.h>
#include "ips2exe.rh"

static HINSTANCE ghInst; // global instance
static BYTE buffer[65536]; // temporary buffer
static char szFileToPatch[MAX_PATH]; // file to patch
static char szCwd[MAX_PATH]; // current directory

BOOL CALLBACK MainDlgProc(HWND hDlg,UINT msg,WPARAM wParam,LPARAM );
BOOL WINAPI FileDialog(HWND hWnd,const char *mask,char *file,char *title,unsigned int flag = 0);
void WINAPI CreatePatch(HWND hWnd);

#undef ZeroMemory
// define externals
extern "C" {
   void WINAPI ZeroMemory(PVOID Destination,DWORD Length);
   void WINAPI init_crc();
   DWORD WINAPI update_crc(DWORD crc,PVOID buffer,DWORD len);
   BOOL WINAPI MakePatch(LPCSTR UnchangedFile,LPCSTR ChangedFile,LPCSTR OutputFile,LPSTR ErrorMsg,BOOL bUseRle);
}

// the IPSEXEHEADER struct that is appended at the end of the file
typedef struct IPSEXEHEADER
{
   char filename[32];      // file name to patch
   char description[256];  // description field
   unsigned long ipslen;   // size of ips file
   unsigned short ipscrc;  // CRC of the ips patch
   unsigned short flags;   // flags
   unsigned long crc32;    // crc32 to file to patch
} IPSEXEHEADER;

int WINAPI WinMain(HINSTANCE hInst,HINSTANCE ,LPSTR ,int )
{
   ghInst = hInst;

   init_crc(); // set up CRC operations
   GetCurrentDirectory(MAX_PATH,szCwd); // grab current directory
   *szFileToPatch = NULL;

   return DialogBox(ghInst,MAKEINTRESOURCE(DIALOG_1),NULL,(DLGPROC)MainDlgProc);
}

BOOL CALLBACK MainDlgProc(HWND hDlg,UINT msg,WPARAM wParam,LPARAM lParam)
{
   char szFile[MAX_PATH];

   switch(msg) {
      case WM_INITDIALOG: {
         HANDLE fp;
         LPBYTE buf;
         DWORD nSize;

         fp = CreateFile("instruct.ifo",GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
         if(fp == INVALID_HANDLE_VALUE) {
            MessageBox(hDlg,"Can't find file \"instruct.ifo\".","Error",MB_OK | MB_SYSTEMMODAL);
            EndDialog(hDlg,1);
            break;
         }

         buf = (LPBYTE)GlobalAlloc(GPTR,GetFileSize(fp,NULL) + 1);
         if(!buf) {
            MessageBox(hDlg,"Out of memory.","Error",MB_OK | MB_SYSTEMMODAL);
            CloseHandle(fp);
            EndDialog(hDlg,1);
            break;
         }

         ReadFile(fp,buf,GetFileSize(fp,NULL),&nSize,NULL);
         CloseHandle(fp);

         SetDlgItemText(hDlg,IDC_INSTRUCTIONS,(LPCSTR)buf);
         GlobalFree(buf);

         // initialize dialog by limiting text of fields
         SendDlgItemMessage(hDlg,IDC_DESCRIPTION,EM_LIMITTEXT,255,0);
         SendDlgItemMessage(hDlg,IDC_UNCHANGEDFILE,EM_LIMITTEXT,MAX_PATH,0);
         SendDlgItemMessage(hDlg,IDC_PATCH,EM_LIMITTEXT,MAX_PATH,0);
         SendDlgItemMessage(hDlg,IDC_FILETOPATCH,EM_LIMITTEXT,31,0);
         CheckRadioButton(hDlg,IDC_CREATEBYFILE,IDC_CREATEBYIPS,IDC_CREATEBYFILE);
         CheckRadioButton(hDlg,IDC_EXE,IDC_IPS,IDC_EXE);
         EnableWindow(GetDlgItem(hDlg,IDC_PATCH),FALSE);
         EnableWindow(GetDlgItem(hDlg,IDC_FILETOPATCH),FALSE);
         EnableWindow(GetDlgItem(hDlg,IDC_BROWSE3),FALSE);
         EnableWindow(GetDlgItem(hDlg,IDC_BROWSE4),FALSE);
         break;
      }
      case WM_COMMAND:
         switch(LOWORD(wParam)) {
            case IDC_BROWSE1: // browse for unchanged files
               if(FileDialog(hDlg,"All Files (*.*)\0*.*\0\0",szFile,NULL))
                  SetDlgItemText(hDlg,IDC_UNCHANGEDFILE,szFile);
               break;
            case IDC_BROWSE2: // browse for changed files
               if(FileDialog(hDlg,"All Files (*.*)\0*.*\0\0",szFile,NULL))
                  SetDlgItemText(hDlg,IDC_CHANGEDFILE,szFile);
               break;
            case IDC_BROWSE3: // browse for IPS
               if(FileDialog(hDlg,"IPS File (*.ips)\0*.ips\0All Files (*.*)\0*.*\0",szFile,NULL))
                  SetDlgItemText(hDlg,IDC_PATCH,szFile);
               break;
            case IDC_BROWSE4: // browse for file to change
               if(FileDialog(hDlg,"All Files (*.*)\0*.*\0\0",szFileToPatch,szFile))
                  SetDlgItemText(hDlg,IDC_FILETOPATCH,szFile);
               break;
            case IDC_CREATEBYFILE:
               EnableWindow(GetDlgItem(hDlg,IDC_PATCH),FALSE);
               EnableWindow(GetDlgItem(hDlg,IDC_FILETOPATCH),FALSE);
               EnableWindow(GetDlgItem(hDlg,IDC_BROWSE3),FALSE);
               EnableWindow(GetDlgItem(hDlg,IDC_BROWSE4),FALSE);
               EnableWindow(GetDlgItem(hDlg,IDC_UNCHANGEDFILE),TRUE);
               EnableWindow(GetDlgItem(hDlg,IDC_CHANGEDFILE),TRUE);
               EnableWindow(GetDlgItem(hDlg,IDC_BROWSE1),TRUE);
               EnableWindow(GetDlgItem(hDlg,IDC_BROWSE2),TRUE);
               EnableWindow(GetDlgItem(hDlg,IDC_IPS),TRUE);
               EnableWindow(GetDlgItem(hDlg,IDC_NORLE),TRUE);
               break;
            case IDC_CREATEBYIPS:
               EnableWindow(GetDlgItem(hDlg,IDC_PATCH),TRUE);
               EnableWindow(GetDlgItem(hDlg,IDC_FILETOPATCH),TRUE);
               EnableWindow(GetDlgItem(hDlg,IDC_BROWSE3),TRUE);
               EnableWindow(GetDlgItem(hDlg,IDC_BROWSE4),TRUE);
               EnableWindow(GetDlgItem(hDlg,IDC_UNCHANGEDFILE),FALSE);
               EnableWindow(GetDlgItem(hDlg,IDC_CHANGEDFILE),FALSE);
               EnableWindow(GetDlgItem(hDlg,IDC_BROWSE1),FALSE);
               EnableWindow(GetDlgItem(hDlg,IDC_BROWSE2),FALSE);
               EnableWindow(GetDlgItem(hDlg,IDC_IPS),FALSE);
               EnableWindow(GetDlgItem(hDlg,IDC_NORLE),FALSE);
               CheckRadioButton(hDlg,IDC_EXE,IDC_IPS,IDC_EXE);
               break;
            case IDC_NEXT: {
               char szDummy[MAX_PATH];
               // test if any of the fields are empty
               if(IsDlgButtonChecked(hDlg,IDC_CREATEBYFILE)) {
                  // give error messages if fields are left unfilled
                  if(!GetDlgItemText(hDlg,IDC_UNCHANGEDFILE,szDummy,MAX_PATH)) {
                     MessageBox(hDlg,"Please select an unchanged file.","Error",MB_OK | MB_SYSTEMMODAL);
                     break;
                  }
                  if(!GetDlgItemText(hDlg,IDC_CHANGEDFILE,szDummy,MAX_PATH)) {
                     MessageBox(hDlg,"Please select a changed file.","Error",MB_OK | MB_SYSTEMMODAL);
                     break;
                  }
               } else {
                  if(!GetDlgItemText(hDlg,IDC_PATCH,szDummy,MAX_PATH)) {
                     MessageBox(hDlg,"Please select a patch.","Error",MB_OK | MB_SYSTEMMODAL);
                     break;
                  }
                  if(!GetDlgItemText(hDlg,IDC_FILETOPATCH,szDummy,MAX_PATH)) {
                     MessageBox(hDlg,"Please enter a filename to patch.","Error",MB_OK | MB_SYSTEMMODAL);
                     break;
                  }
               }
               CreatePatch(hDlg);
               break;
            }
            case IDCANCEL:
               EndDialog(hDlg,0); // close program
               break;
         }
         break;
      case WM_CTLCOLOREDIT:
         if(IsWindowEnabled((HWND)lParam)) return FALSE;
      case WM_CTLCOLORDLG:
      case WM_CTLCOLORSTATIC:
      case WM_CTLCOLORBTN:
         SetBkColor((HDC)wParam,RGB(192,192,192));
         return (BOOL)GetStockObject(LTGRAY_BRUSH);
      case WM_DESTROY:
         break;
      default:
         return FALSE;
   }

   return TRUE;
}

// helper function that handles the file selection dialog
BOOL WINAPI FileDialog(HWND hWnd,const char *mask,char *file,char *title,unsigned int flag)
{
   OPENFILENAME ofn;
   char dummy[MAX_PATH];

   dummy[0] = 0;
   if(file) *file = 0;
   if(title) *title = 0;

   ZeroMemory(&ofn,sizeof(ofn));
   ofn.lStructSize = sizeof(OPENFILENAME);
   ofn.hwndOwner = hWnd;
   ofn.lpstrFilter = mask;
   ofn.nFilterIndex = 1;
   ofn.lpstrFile = file ? file : dummy;
   ofn.nMaxFile = MAX_PATH;
   ofn.lpstrFileTitle = title ? title : dummy;
   ofn.nMaxFileTitle = MAX_PATH;
   ofn.lpstrInitialDir = NULL;
   ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | flag;

   return GetOpenFileName(&ofn);
}

void WINAPI CreatePatch(HWND hWnd)
{
   OPENFILENAME ofn;
   char szFile[MAX_PATH], szPatch[MAX_PATH], szTemp[MAX_PATH];
   IPSEXEHEADER h;
   HANDLE ips, stub, out;

   *szFile = NULL;
   *szTemp = NULL;

   SetCurrentDirectory(szCwd); // change to current directory

   ZeroMemory(&ofn,sizeof(ofn));
   ofn.lStructSize = sizeof(OPENFILENAME);
   ofn.hwndOwner = hWnd;
   ofn.lpstrFilter = "Executable (*.exe)\0*.exe\0IPS File (*.ips)\0*.ips\0All Files (*.*)\0*.*\0\0";
   ofn.nFilterIndex = IsDlgButtonChecked(hWnd,IDC_EXE) ? 1 : 2;
   ofn.lpstrFile = szFile;
   ofn.nMaxFile = MAX_PATH;
   ofn.lpstrDefExt = IsDlgButtonChecked(hWnd,IDC_EXE) ? "exe" : "ips";
   ofn.Flags = OFN_EXTENSIONDIFFERENT | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;
   if(GetSaveFileName(&ofn)) { // do save as dialog
      DWORD nSize;

      ZeroMemory(&h,sizeof(h));
      SetCurrentDirectory(szCwd); // change to current directory

      // read field to IPSEXEHEADER
      GetDlgItemText(hWnd,IDC_DESCRIPTION,h.description,256);
      GetDlgItemText(hWnd,IDC_FILETOPATCH,h.filename,32);
      GetDlgItemText(hWnd,IDC_PATCH,szPatch,MAX_PATH);

      /* if create by file, then runpatch maker */
      if(IsDlgButtonChecked(hWnd,IDC_CREATEBYFILE)) {
         char szUnchanged[MAX_PATH], szChanged[MAX_PATH], szError[80];
         int slashpos;

         GetDlgItemText(hWnd,IDC_UNCHANGEDFILE,szUnchanged,MAX_PATH);
         GetDlgItemText(hWnd,IDC_CHANGEDFILE,szChanged,MAX_PATH);
         //GetTempFileName(szCwd,"~$t",0,szTemp);
         lstrcpy(szTemp,"$tmp@3$1.tmp");

         if(!MakePatch(szUnchanged,szChanged,szTemp,szError,IsDlgButtonChecked(hWnd,IDC_NORLE) == FALSE)) {
            MessageBox(hWnd,szError,"ips.dll: Error",MB_OK);
            return;
         }

         if(IsDlgButtonChecked(hWnd,IDC_IPS)) {
            CopyFile(szTemp,szFile,FALSE);
            DeleteFile(szTemp);

            MessageBox(hWnd,"Patch created!","Success!",MB_OK | MB_SYSTEMMODAL);
            EndDialog(hWnd,0);
            return;
         }

         GetDlgItemText(hWnd,IDC_UNCHANGEDFILE,szFileToPatch,MAX_PATH);
         slashpos = 0;
         for(int i = 0; i < lstrlen(szFileToPatch); i++)
            if(szFileToPatch[i] == '\\') slashpos = i + 1;
         lstrcpy(h.filename,szFileToPatch + slashpos);
         lstrcpy(szPatch,szTemp);
      }

      // calculate CRC32 for FILE
      if(IsDlgButtonChecked(hWnd,IDC_ENABLECRCCHECK)) {
         HANDLE fp;
         DWORD crc = 0;

         if(!*szFileToPatch) GetDlgItemText(hWnd,IDC_FILETOPATCH,szFileToPatch,MAX_PATH);
         // load the file to patch
         fp = CreateFile(szFileToPatch,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,NULL,NULL);
         if(fp != INVALID_HANDLE_VALUE) {
            ReadFile(fp,buffer,65536,&nSize,NULL);
            while(nSize > 0) {
               crc = update_crc(crc,buffer,nSize); // compute crc32
               ReadFile(fp,buffer,65536,&nSize,NULL);
            }
            CloseHandle(fp);
            h.crc32 = crc;
            h.flags = 1;
         } else {
            MessageBox(hWnd,szFileToPatch,"Warning! Couldn't load file.",MB_OK | MB_SYSTEMMODAL);
         }
      }

      // open patch file
      ips = CreateFile(szPatch,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,NULL,NULL);
      if(ips == INVALID_HANDLE_VALUE) {
         MessageBox(hWnd,szPatch,"File not found.",MB_OK | MB_SYSTEMMODAL);
         return;
      }
      h.ipslen = GetFileSize(ips,NULL);

      ZeroMemory(buffer,65536);
      ReadFile(ips,buffer,65536,&nSize,NULL);
      SetFilePointer(ips,0,NULL,FILE_BEGIN);

      buffer[5] = 0;
      if(lstrcmp((char *)buffer,"PATCH")) {
         CloseHandle(ips);
         MessageBox(hWnd,"Invalid IPS patch file!","Error!",MB_OK | MB_SYSTEMMODAL);
         return;
      }

      // calculate crc
      h.ipscrc = (unsigned short)update_crc(0,buffer,65536);

      // load the stub
      stub = CreateFile("ipsexe.stb",GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,NULL,NULL);
      if(stub == INVALID_HANDLE_VALUE) {
         CloseHandle(ips);
         MessageBox(hWnd,"\"ipsexe.stb\" not found.","Error",MB_OK | MB_SYSTEMMODAL);
         return;
      }

      // create output file
      out = CreateFile(szFile,GENERIC_WRITE,FILE_SHARE_WRITE,NULL,CREATE_ALWAYS,NULL,NULL);
      if(out == INVALID_HANDLE_VALUE) {
         CloseHandle(ips);
         CloseHandle(stub);
         MessageBox(hWnd,szFile,"File could not be opened.",MB_OK | MB_SYSTEMMODAL);
         return;
      }

      // copy stub to output
      ReadFile(stub,buffer,65536,&nSize,NULL);
      while(nSize > 0) {
         WriteFile(out,buffer,nSize,&nSize,NULL);
         ReadFile(stub,buffer,65536,&nSize,NULL);
      }
      CloseHandle(stub);

      // copy patch to output
      ReadFile(ips,buffer,65536,&nSize,NULL);
      while(nSize > 0) {
         WriteFile(out,buffer,nSize,&nSize,NULL);
         ReadFile(ips,buffer,65536,&nSize,NULL);
      }
      CloseHandle(ips);
      if(*szTemp) DeleteFile(szTemp);

      // finally, write the IPSEXEHEADER
      WriteFile(out,&h,sizeof(h),&nSize,NULL);
      CloseHandle(out);

      MessageBox(hWnd,"Patch created!","Success!",MB_OK | MB_SYSTEMMODAL);
      EndDialog(hWnd,0);
   }
}
