; ipsexew.asm
; EXE Patcher code of (IPS) files (Win32)
; Compiled under NASM and ALINK

bits 32

%include "ipsexew.inc"
%include "win32n.inc"

imprt GetModuleHandleA, kernel32.dll
imprt GetModuleFileNameA, kernel32.dll
imprt GetCommandLineA, kernel32.dll
imprt GetCurrentDirectoryA, kernel32.dll
imprt GetStartupInfoA, kernel32.dll
imprt CreateProcessA, kernel32.dll
imprt ExitProcess, kernel32.dll

imprt CreateFileA, kernel32.dll
imprt CloseHandle, kernel32.dll
imprt SetFilePointer, kernel32.dll
imprt ReadFile, kernel32.dll
imprt WriteFile, kernel32.dll
imprt GetFileSize, kernel32.dll

imprt lstrcpyA, kernel32.dll
imprt lstrcatA, kernel32.dll
imprt lstrcmpA, kernel32.dll

imprt wsprintfA, user32.dll

imprt MessageBoxA, user32.dll
imprt SendDlgItemMessageA, user32.dll
imprt SetDlgItemTextA, user32.dll

imprt UpdateWindow, user32.dll

imprt DialogBoxParamA, user32.dll
imprt EndDialog, user32.dll

imprt SetBkColor, gdi32.dll
imprt GetStockObject, gdi32.dll

imprt GetOpenFileNameA, comdlg32.dll

global ghInst

segment code public align=4 use32 class=code

..start:
   ; grab module
   invoke GetModuleHandleA, NULL
   mov [ghInst], eax
   ; get current directory
   invoke GetCurrentDirectoryA, 256, szCwd
   ; init the crc table
   call init_crc

   invoke DialogBoxParamA, [ghInst], DIALOG_IPSEXE, NULL, IpsexeDlgProc, 0
   invoke ExitProcess, eax

   retn

align 4
IpsexeDlgProc:
   push ebp
   mov ebp, esp
   sub esp, 264

; PARAMS
%define hDlg   ebp + 8
%define msg    ebp + 12
%define wParam ebp + 16
%define lParam ebp + 20

   mov eax, [msg]
   cmp eax, WM_COMMAND
   je .wm_command
   cmp eax, WM_CTLCOLORDLG
   je .wm_col
   cmp eax, WM_CTLCOLORSTATIC
   je .wm_col
   cmp eax, WM_CTLCOLORBTN
   je .wm_col
   cmp eax, WM_INITDIALOG
   je .wm_initdialog
.default:
   xor eax, eax
   leave
   retn 16
.done:
   mov eax, 1
   leave
   retn 16
.wm_command:
   mov edx, [wParam]
   and edx, 0xFFFF
   push LPARAM [lParam]
   push edx
   push HWND [hDlg]
   call ProcessCommands
   jmp .done
.wm_col:
   invoke SetBkColor, [wParam], 0xC0C0C0
   invoke GetStockObject, LTGRAY_BRUSH
   leave
   retn 16
;  jmp .done
.wm_initdialog:

; LOCALS
%define szModName ebp - 260
%define nSize     ebp - 264

   ; First validate if this is a good patch

   ; get program filename
   lea edx, [szModName]
   invoke GetModuleFileNameA, [ghInst], edx, 260

   ; load exe
   lea edx, [szModName]
   invoke CreateFileA, edx, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL
   cmp eax, INVALID_HANDLE_VALUE
   je near .loaderr

   mov [ipsfd], eax ; store handle

   ; seek to beginning of header
   invoke SetFilePointer, eax, -ipsexeheader_size, NULL, FILE_END

   ; read header
   lea edx, [nSize]
   invoke ReadFile, [ipsfd], ipsexeheader, ipsexeheader_size, edx, NULL

   mov eax, [ipslen]
   add eax, ipsexeheader_size
   neg eax

   ; seek to beginning of header
   invoke SetFilePointer, [ipsfd], eax, NULL, FILE_END

   ; test for PATCH signature
   mov eax, [ipslen]
   cmp eax, 65536
   jle .notrnc
   mov eax, 65536
.notrnc:
   cmp eax, 5
   jge .noboost
   mov eax, 5
.noboost:
   push edi
   push eax
   push es
   push ds
   pop es

   lea edi, [buffer]
   mov ecx, 16384
   xor eax, eax

   cld
   rep stosd

   pop es
   pop eax
   pop edi

   lea edx, [nSize]
   invoke ReadFile, [ipsfd], buffer, eax, edx, NULL
   mov [buffer + 5], byte 0

   push dword 65536
   push LPBYTE buffer
   push dword 0
   call update_crc
   cmp ax, word [ipscrc]
   jne near .comerr

   invoke lstrcmpA, buffer, string_patch
   test eax, eax
   jnz near .comerr

   invoke CloseHandle, [ipsfd]

   ; program reaches here if valid file

   invoke SendDlgItemMessageA, [hDlg], IDC_FILE, EM_LIMITTEXT, 256, 0
   invoke SetDlgItemTextA, [hDlg], IDC_DESCRIPTION, description
   invoke SetDlgItemTextA, [hDlg], IDC_STATUS, string_ready
   invoke SetDlgItemTextA, [hDlg], IDC_FILE, filename
   invoke lstrcpyA, szFile, filename
   jmp .done
.comerr:
   invoke CloseHandle, [ipsfd]
   lea edx, [string_ipscorp]
   jmp .err
.loaderr:
   lea edx, [string_pcnbl]
.err:
   invoke MessageBoxA, [hDlg], edx, string_error, MB_OK | MB_ICONSTOP
   invoke EndDialog, [hDlg], 1
   jmp .done


align 4
ProcessCommands:
   push ebp
   mov ebp, esp
   sub esp, (OPENFILENAME_size + 256)

; PARAMS
%define hDlg   ebp + 8
%define msg    ebp + 12
%define lParam ebp + 16

   mov eax, [msg]
   cmp eax, IDC_PATCH
   je .idc_patch
   cmp eax, IDC_BROWSE
   je .idc_browse
   cmp eax, IDC_INFO
   je near .idc_info
   cmp eax, IDCANCEL
   je near .id_cancel
.default:
   leave
   retn 12

.idc_patch:
   push HWND [hDlg]
   call PatchFile
   jmp .default

.idc_browse:
; LOCALS
%define ofn       ebp - OPENFILENAME_size
%define szTitle   ebp - (OPENFILENAME_size + 256)
   ; clear out ofn struct
   push edi
   push es
   push ds
   pop es

   lea edi, [ofn]
   mov ecx, OPENFILENAME_size
   xor eax, eax

   cld
   rep stosb

   pop es
   pop edi

   mov [ofn + OPENFILENAME.lStructSize], dword OPENFILENAME_size
   mov eax, [hDlg]
   mov [ofn + OPENFILENAME.hWndOwner], eax
   mov [ofn + OPENFILENAME.lpstrFilter], LPTSTR string_filter
   mov [ofn + OPENFILENAME.nFilterIndex], dword 1
   mov [ofn + OPENFILENAME.lpstrFile], LPTSTR szFile
   mov [ofn + OPENFILENAME.nMaxFile], dword 256
   lea edx, [szTitle]
   mov [ofn + OPENFILENAME.lpstrFileTitle], edx
   mov [ofn + OPENFILENAME.nMaxFileTitle], dword 256
   mov [ofn + OPENFILENAME.Flags], dword (OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY)

   mov [szFile], byte 0
   mov [szTitle], byte 0

   lea eax, [ofn]
   invoke GetOpenFileNameA, eax
   test eax, eax
   jz near .default
   invoke SetDlgItemTextA, [hDlg], IDC_FILE, szFile
   jmp .default

.idc_info:
   invoke GetStartupInfoA, startupinfo
   mov [startupinfo + STARTUPINFO.cb], dword STARTUPINFO_size

   ; run note pad
   invoke CreateProcessA, NULL, string_launchhelp, NULL, NULL, FALSE, 0, NULL, szCwd, startupinfo, processinfo
   jmp .default

.id_cancel:
   invoke EndDialog, [hDlg], 0
   jmp .default


; PatchFile: Patchs the rom!!
; Params: hWnd - handle to the current window
align 4
PatchFile:
   push ebp
   mov ebp, esp
   sub esp, 528

; PARAMS
%define hWnd ebp + 8
; LOCALS
%define szModName ebp - 260
%define nSize ebp - 264
%define string ebp - 520
%define romsize ebp - 524
%define base ebp - 528

   push edi

   lea edx, [szModName]
   invoke GetModuleFileNameA, [ghInst], edx, 260

   ; load exe
   lea edx, [szModName]
   invoke CreateFileA, edx, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL
   cmp eax, INVALID_HANDLE_VALUE
   je near .ipserr
   mov [ipsfd], eax ; store handle

   ; load rom
   invoke CreateFileA, szFile, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL
   cmp eax, INVALID_HANDLE_VALUE
   je near .romerr
   mov [romfd], eax ; store handle

   ; if crc tests are on
   test word [flags], FLAG_TESTCRC32
   jz near .nocrctest

   xor edi, edi
   invoke GetFileSize, [romfd], NULL
   mov [romsize], eax
.checkloop:
   invoke SetFilePointer, [romfd], 0, NULL, FILE_CURRENT

   imul eax, 100
   xor edx, edx
   div dword [romsize]

   lea edx, [string]
   invoke wsprintfA, edx, string_validate, eax
   add esp, 12

   lea edx, [string]
   invoke SetDlgItemTextA, [hWnd], IDC_STATUS, edx
   invoke UpdateWindow, [hWnd]

   ; read and compute check sum
   lea edx, [nSize]
   invoke ReadFile, [romfd], buffer, 65536, edx, NULL
   cmp [nSize], dword 0
   je .testcrc
   ; compute crc
   push dword [nSize]
   push dword buffer
   push dword edi
   call update_crc
   mov edi, eax
   jmp .checkloop
.testcrc:
   lea edx, [string]
   invoke wsprintfA, edx, string_validate, 100
   add esp, 12

   lea edx, [string]
   invoke SetDlgItemTextA, [hWnd], IDC_STATUS, edx
   invoke UpdateWindow, [hWnd]

   cmp edi, [crc32]  ; compare if crc is the same
   je .nocrctest

   ; if they are not the same....
   invoke MessageBoxA, [hWnd], string_intended, string_crc, MB_YESNO | MB_SYSTEMMODAL
   cmp eax, IDYES
   je .nocrctest

   invoke SetDlgItemTextA, [hWnd], IDC_STATUS, string_fcrc
   invoke UpdateWindow, [hWnd]

   invoke CloseHandle, [ipsfd]
   invoke CloseHandle, [romfd]
   jmp .done

.nocrctest:

   mov eax, [ipslen]
   add eax, ipsexeheader_size
   sub eax, 5
   neg eax

   mov [offset], dword 0
   mov [length], dword 0

   invoke SetFilePointer, [ipsfd], eax, NULL, FILE_END
   mov [base], eax
.loop:
   invoke SetFilePointer, [ipsfd], 0, NULL, FILE_CURRENT

   sub eax, [base]
   imul eax, 100
   xor edx, edx
   div dword [ipslen]

   lea edx, [string]
   invoke wsprintfA, edx, string_patching, eax
   add esp, 12

   lea edx, [string]
   invoke SetDlgItemTextA, [hWnd], IDC_STATUS, edx
   invoke UpdateWindow, [hWnd]

   ; read offset
   lea edx, [nSize]
   invoke ReadFile, [ipsfd], offset, 3, edx, NULL
   cmp [nSize], dword 0
   je near .break

   ; swap MSB->LSB order
   mov eax, [offset]
   mov byte [offset + 2], al
   shr eax, 16
   mov byte [offset], al

   ; break if 'EOF' is found
   cmp dword [offset], 454F46h
   je near .break

   ; seek to offset
   invoke SetFilePointer, [romfd], [offset], NULL, FILE_BEGIN

   ; read length
   lea edx, [nSize]
   invoke ReadFile, [ipsfd], length, 2, edx, NULL
   cmp [nSize], dword 0
   je near .break

   ; MSB->LSB
   mov ax, [length]
   xchg ah, al
   mov [length], ax

   ; Test for runlength coding
   test ax, ax
   jnz near .norle

   ; read runlength
   lea edx, [nSize]
   invoke ReadFile, [ipsfd], length, 2, edx, NULL
   cmp [nSize], dword 0
   je near .break

   ; read runbyte
   lea edx, [nSize]
   invoke ReadFile, [ipsfd], buffer, 1, edx, NULL
   cmp [nSize], dword 0
   je near .break

   ; fill buffer
   mov al, [buffer]
   ; MSB->LSB the runcount
   xor ecx, ecx
   mov cx, [length]
   xchg ch, cl
   mov [length], cx
   push es
   push ds
   pop es
   lea edi, [buffer]
   ; fill buffer with run byte
   cld
   rep stosb
   pop es
   jmp .writebuf
.norle:
   ; read buffer data
   lea edx, [nSize]
   invoke ReadFile, [ipsfd], buffer, [length], edx, NULL
   cmp [nSize], dword 0
   je near .break
.writebuf:
   ; update rom data
   lea edx, [nSize]
   invoke WriteFile, [romfd], buffer, [length], edx, NULL
   cmp [nSize], dword 0
   je near .break

   jmp .loop
.break:
   invoke CloseHandle, [ipsfd]
   invoke CloseHandle, [romfd]

   invoke SetDlgItemTextA, [hWnd], IDC_STATUS, string_filepatched
   invoke UpdateWindow, [hWnd]
.done:
   pop edi

   leave
   retn 4
.ipserr:
   push dword string_eripf
   jmp .error
.romerr:
   invoke CloseHandle, [ipsfd]
   push dword string_cfftp
.error:
   invoke SetDlgItemTextA, [hWnd], IDC_STATUS
   invoke UpdateWindow, [hWnd]
   jmp .done

segment data public align=4 use32 class=data

ghInst dd 0
string_ready db 'Ready', 0
string_error db 'Error', 0
string_pcnbl db 'Program could not be loaded!', 0
string_ipscorp db 'It appears that this is not a valid patch file.', 0
string_filter db 'All files (*.*)', 0, '*.*', 0, 0
string_launchhelp db 'notepad readme', 0
string_patch db 'PATCH', 0
string_patching db 'Patching file... %d%%', 0
string_cfftp db '[ERROR] Cannot find file to patch.', 0
string_eripf db '[ERROR] Error reading IPS patch file.', 0
string_filepatched db 'File patched successfully.', 0
string_fcrc db '[FAIL] '
string_crc db 'File CRC does not match.', 0
string_intended db 'The file you selected to patch is not the same file intended to patch.',0dh,0ah
   db 'It is possible that your file has been modified (or is already patched).',0dh,0ah
   db 'Please check to make sure you have selected the right file.', 0dh,0ah,
   db 'Continue anyways?', 0
string_validate db 'Validating file... %d%%', 0

segment bss public align=4 use32 class=bss

ipsexeheader:
   filename    resb 32
   description resb 256
   ipslen      resd 1
   ipscrc      resw 1
   flags       resw 1
   crc32       resd 1
ipsexeheader_size: equ $-ipsexeheader

alignb 4
ipsfd resd 1      ; file handle
romfd resd 1      ; rom handle

alignb 4
startupinfo resb STARTUPINFO_size
alignb 4
processinfo resb PROCESS_INFORMATION_size

alignb 4
offset resd 1
length resd 1

szFile   resb 256       ; filename of file to patch
szCwd    resb 256       ; stores the path of the current directory

alignb 4
buffer   resb 65536     ; buffer for data
