/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class FenetrePrincipale
extends JFrame
implements ActionListener,
MenuListener {
    File dossierDefaut = new File(System.getProperty("user.home"));
    File fichierApplicationOriginal;
    File fichierApplicationIPS;
    File fichierCreationOriginal;
    File fichierCreationModifie;
    FileInputStream fichierApplicationLectureIPS;
    FileInputStream fichierApplicationLectureOriginal;
    FileInputStream fichierCreationLectureModifie;
    FileInputStream fichierCreationLectureOriginal;
    FileOutputStream fichierApplicationEcritureTraduit;
    FileOutputStream fichierCreationEcritureIPS;
    private JLabel labelFichierApplicationOriginalAdresse;
    private JLabel labelFichierApplicationOriginalTaille;
    private JLabel labelFichierApplicationIPSAdresse;
    private JLabel labelFichierApplicationIPSTaille;
    private JLabel labelFichierCreationOriginalAdresse;
    private JLabel labelFichierCreationOriginalTaille;
    private JLabel labelFichierCreationModifieAdresse;
    private JLabel labelFichierCreationModifieTaille;
    private JMenuItem menuApplicationCreation;
    private JMenuItem menuCreationCreation;
    JScrollBar ascenseurVerticalApplication;
    JScrollBar ascenseurVerticalCreation;
    JTabbedPane onglets;
    JTextPane zoneTexteInfoApplication;
    JTextPane zoneTexteInfoCreation;
    private ApplicationIpsSwingWorker modificationIpsSwingWorker;
    private CreationIpsSwingWorker creationIpsSwingWorker;
    private JProgressBar barreProgression;

    public FenetrePrincipale() {
        super("Spi");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FenetrePrincipale.this.quitteProgramme();
            }
        });
        this.setSize(610, 340);
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - this.getSize().width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - this.getSize().height) / 2);
        this.setResizable(false);
        this.ouvreConfiguration();
        this.initialiseFenetre();
    }

    private void initialiseFenetre() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/icones/spi.png")));
        this.setLayout(new BorderLayout());
        this.creeMenu();
        JPanel panelCreation = new JPanel(null);
        panelCreation.setBackground(new Color(255, 255, 255));
        JPanel panelApplication = new JPanel(null);
        panelApplication.setBackground(new Color(255, 255, 255));
        this.onglets = new JTabbedPane(1);
        this.onglets.setBackground(new Color(255, 255, 255));
        this.onglets.addTab(Demarrage.getTexte("application"), panelApplication);
        this.onglets.addTab(Demarrage.getTexte("creation"), panelCreation);
        this.add((Component)this.onglets, "Center");
        this.barreProgression = new JProgressBar(0, 0, 10000);
        this.add((Component)this.barreProgression, "South");
        JLabel labelFichierApplicationOriginal = new JLabel(Demarrage.getTexte("fichierOriginal") + Demarrage.getTexte("DEUX_POINTS"));
        labelFichierApplicationOriginal.setBounds(5, 5, 200, 20);
        labelFichierApplicationOriginal.setForeground(new Color(0, 0, 255));
        panelApplication.add(labelFichierApplicationOriginal);
        this.labelFichierApplicationOriginalAdresse = new JLabel("");
        this.labelFichierApplicationOriginalAdresse.setBounds(15, 30, 560, 20);
        panelApplication.add(this.labelFichierApplicationOriginalAdresse);
        this.labelFichierApplicationOriginalTaille = new JLabel("");
        this.labelFichierApplicationOriginalTaille.setBounds(15, 55, 560, 20);
        panelApplication.add(this.labelFichierApplicationOriginalTaille);
        JLabel labelFichierApplicationIPS = new JLabel(Demarrage.getTexte("fichierIPS") + Demarrage.getTexte("DEUX_POINTS"));
        labelFichierApplicationIPS.setForeground(new Color(255, 130, 0));
        labelFichierApplicationIPS.setBounds(5, 85, 200, 20);
        panelApplication.add(labelFichierApplicationIPS);
        this.labelFichierApplicationIPSAdresse = new JLabel("");
        this.labelFichierApplicationIPSAdresse.setBounds(15, 110, 560, 20);
        panelApplication.add(this.labelFichierApplicationIPSAdresse);
        this.labelFichierApplicationIPSTaille = new JLabel("");
        this.labelFichierApplicationIPSTaille.setBounds(15, 135, 560, 20);
        panelApplication.add(this.labelFichierApplicationIPSTaille);
        this.zoneTexteInfoApplication = new JTextPane();
        this.zoneTexteInfoApplication.setEditable(false);
        this.zoneTexteInfoApplication.setText(Demarrage.getTexte("bienvenue") + " (c) Lyssal ( http://www.lyssal.fr/ )\n");
        JScrollPane ascenseursApplication = new JScrollPane();
        ascenseursApplication.setViewportView(this.zoneTexteInfoApplication);
        ascenseursApplication.setBounds(15, 160, 570, 80);
        this.ascenseurVerticalApplication = ascenseursApplication.getVerticalScrollBar();
        panelApplication.add(ascenseursApplication);
        JLabel labelFichierCreationOriginal = new JLabel(Demarrage.getTexte("fichierOriginal") + Demarrage.getTexte("DEUX_POINTS"));
        labelFichierCreationOriginal.setBounds(5, 5, 200, 20);
        labelFichierCreationOriginal.setForeground(new Color(0, 0, 255));
        panelCreation.add(labelFichierCreationOriginal);
        this.labelFichierCreationOriginalAdresse = new JLabel("");
        this.labelFichierCreationOriginalAdresse.setBounds(15, 30, 560, 20);
        panelCreation.add(this.labelFichierCreationOriginalAdresse);
        this.labelFichierCreationOriginalTaille = new JLabel("");
        this.labelFichierCreationOriginalTaille.setBounds(15, 55, 560, 20);
        panelCreation.add(this.labelFichierCreationOriginalTaille);
        JLabel labelFichierCreationModifie = new JLabel(Demarrage.getTexte("fichierModifie") + Demarrage.getTexte("DEUX_POINTS"));
        labelFichierCreationModifie.setBounds(5, 85, 200, 20);
        labelFichierCreationModifie.setForeground(new Color(180, 0, 255));
        panelCreation.add(labelFichierCreationModifie);
        this.labelFichierCreationModifieAdresse = new JLabel("");
        this.labelFichierCreationModifieAdresse.setBounds(15, 110, 560, 20);
        panelCreation.add(this.labelFichierCreationModifieAdresse);
        this.labelFichierCreationModifieTaille = new JLabel("");
        this.labelFichierCreationModifieTaille.setBounds(15, 135, 560, 20);
        panelCreation.add(this.labelFichierCreationModifieTaille);
        this.zoneTexteInfoCreation = new JTextPane();
        this.zoneTexteInfoCreation.setEditable(false);
        this.zoneTexteInfoCreation.setText(this.zoneTexteInfoApplication.getText());
        JScrollPane ascenseursCreation = new JScrollPane();
        ascenseursCreation.setViewportView(this.zoneTexteInfoCreation);
        ascenseursCreation.setBounds(15, 160, 570, 80);
        this.ascenseurVerticalCreation = ascenseursCreation.getVerticalScrollBar();
        panelCreation.add(ascenseursCreation);
    }

    private void quitteProgramme() {
        Demarrage.setPreference("dossierParDefaut", this.dossierDefaut.getAbsolutePath());
        System.exit(0);
    }

    private void ouvreConfiguration() {
        Properties langages = new Properties();
        try {
            langages.load(this.getClass().getResourceAsStream("/langages/" + Demarrage.getLangage() + ".properties"));
        }
        catch (IOException e) {
            Demarrage.afficheMessage("Ouverture du fichier de langage impossible", e);
        }
        Demarrage.setLangage(langages);
        File dossier = new File(Demarrage.getPreference("dossierParDefaut"));
        if (dossier.exists() && dossier.isDirectory() && dossier.canWrite()) {
            this.dossierDefaut = dossier;
        }
    }

    private void creeMenu() {
        JMenuBar menu = new JMenuBar();
        JMenu menuSpi = new JMenu("Spi");
        JMenu menuSpiLangage = new JMenu(Demarrage.getTexte("langage"));
        menuSpiLangage.setIcon(new ImageIcon(this.getClass().getResource("/langages/" + Demarrage.getLangage() + ".png")));
        JMenuItem menuSpiLangageFr = new JMenuItem("Fran\u00e7ais", new ImageIcon(this.getClass().getResource("/langages/fr.png")));
        menuSpiLangageFr.setName("changeLangageFr");
        menuSpiLangageFr.setEnabled(!Demarrage.getLangage().equals(Demarrage.LANGAGE_FRANCAIS));
        menuSpiLangageFr.addActionListener(this);
        menuSpiLangage.add(menuSpiLangageFr);
        JMenuItem menuSpiLangageEn = new JMenuItem("Anglais", new ImageIcon(this.getClass().getResource("/langages/en.png")));
        menuSpiLangageEn.setName("changeLangageEn");
        menuSpiLangageEn.setEnabled(!Demarrage.getLangage().equals(Demarrage.LANGAGE_ANGLAIS));
        menuSpiLangageEn.addActionListener(this);
        menuSpiLangage.add(menuSpiLangageEn);
        JMenuItem menuSpiLangageEs = new JMenuItem("Espagnol", new ImageIcon(this.getClass().getResource("/langages/es.png")));
        menuSpiLangageEs.setName("changeLangageEs");
        menuSpiLangageEs.setEnabled(!Demarrage.getLangage().equals(Demarrage.LANGAGE_ESPAGNOL));
        menuSpiLangageEs.addActionListener(this);
        menuSpiLangage.add(menuSpiLangageEs);
        menuSpi.add(menuSpiLangage);
        menuSpi.addSeparator();
        JMenuItem menuSpiFermeture = new JMenuItem(Demarrage.getTexte("label.quitter"), new ImageIcon(this.getClass().getResource("/images/icones/fermeture.png")));
        menuSpiFermeture.setName("quitte");
        menuSpiFermeture.setAccelerator(KeyStroke.getKeyStroke(115, 512));
        menuSpiFermeture.addActionListener(this);
        menuSpi.add(menuSpiFermeture);
        menu.add(menuSpi);
        JMenu menuApplication = new JMenu(Demarrage.getTexte("application"));
        menuApplication.setName("menuApplication");
        menuApplication.addMenuListener(this);
        JMenuItem menuApplicationfichierApplicationOriginal = new JMenuItem(Demarrage.getTexte("ouvertureFichierOriginal"), new ImageIcon(this.getClass().getResource("/images/icones/dossier_original.png")));
        menuApplicationfichierApplicationOriginal.setName("ouvreFichierOriginalPourApplication");
        menuApplicationfichierApplicationOriginal.addActionListener(this);
        menuApplication.add(menuApplicationfichierApplicationOriginal);
        JMenuItem menuApplicationfichierApplicationIPS = new JMenuItem(Demarrage.getTexte("ouvertureFichierIPS"), new ImageIcon(this.getClass().getResource("/images/icones/dossier_ips.png")));
        menuApplicationfichierApplicationIPS.setName("ouvreFichierIpsPourApplication");
        menuApplicationfichierApplicationIPS.addActionListener(this);
        menuApplication.add(menuApplicationfichierApplicationIPS);
        menuApplication.addSeparator();
        this.menuApplicationCreation = new JMenuItem(Demarrage.getTexte("creationNouveauFichier"), new ImageIcon(this.getClass().getResource("/images/icones/enregistrement.png")));
        this.menuApplicationCreation.setName("appliqueIps");
        this.menuApplicationCreation.setEnabled(false);
        this.menuApplicationCreation.addActionListener(this);
        menuApplication.add(this.menuApplicationCreation);
        menu.add(menuApplication);
        JMenu menuCreation = new JMenu(Demarrage.getTexte("creation"));
        menuCreation.setName("menuCreation");
        menuCreation.addMenuListener(this);
        JMenuItem menuCreationfichierApplicationOriginal = new JMenuItem(Demarrage.getTexte("ouvertureFichierOriginal"), new ImageIcon(this.getClass().getResource("/images/icones/dossier_original.png")));
        menuCreationfichierApplicationOriginal.setName("ouvreFichierIpsPourCreation");
        menuCreationfichierApplicationOriginal.addActionListener(this);
        menuCreation.add(menuCreationfichierApplicationOriginal);
        JMenuItem menuCreationFichierModifie = new JMenuItem(Demarrage.getTexte("ouvertureFichierModifie"), new ImageIcon(this.getClass().getResource("/images/icones/dossier_modifie.png")));
        menuCreationFichierModifie.setName("ouvreFichierModifiePourCreation");
        menuCreationFichierModifie.addActionListener(this);
        menuCreation.add(menuCreationFichierModifie);
        menuCreation.addSeparator();
        this.menuCreationCreation = new JMenuItem(Demarrage.getTexte("creationFichierIPS"), new ImageIcon(this.getClass().getResource("/images/icones/enregistrement.png")));
        this.menuCreationCreation.setName("creeIps");
        this.menuCreationCreation.setEnabled(false);
        this.menuCreationCreation.addActionListener(this);
        menuCreation.add(this.menuCreationCreation);
        menu.add(menuCreation);
        JMenu menuInformations = new JMenu("Informations");
        JMenuItem menuInformationsFAQ = new JMenuItem(Demarrage.getTexte("faq"), new ImageIcon(this.getClass().getResource("/images/icones/faq.png")));
        menuInformationsFAQ.setName("afficheFaq");
        menuInformationsFAQ.addActionListener(this);
        menuInformations.add(menuInformationsFAQ);
        JMenuItem menuInformationsPropos = new JMenuItem(Demarrage.getTexte("propos"), new ImageIcon(this.getClass().getResource("/images/icones/propos.png")));
        menuInformationsPropos.setName("affichePropos");
        menuInformationsPropos.addActionListener(this);
        menuInformations.add(menuInformationsPropos);
        menu.add(menuInformations);
        this.setJMenuBar(menu);
    }

    private void interditInteractions() {
        this.menuApplicationCreation.setEnabled(false);
        this.menuCreationCreation.setEnabled(false);
    }

    private void autoriseInteractions() {
        this.menuApplicationCreation.setEnabled(true);
        this.menuCreationCreation.setEnabled(true);
    }

    private void ouvreFenetreFaq() {
        FenetreDocument fenetre = new FenetreDocument(this.getClass().getResource("/langages/faq_" + Demarrage.getLangage() + ".html"));
        fenetre.setVisible(true);
    }

    private void ouvreFenetreApropos() {
        FenetreDocument fenetre = new FenetreDocument(this.getClass().getResource("/langages/propos_" + Demarrage.getLangage() + ".html"));
        fenetre.setVisible(true);
    }

    private void changeLangage(String langue) {
        switch (JOptionPane.showConfirmDialog(this, Demarrage.getTexte("texte.confirmationModificationApresRedemarrage") + "\n\n" + Demarrage.getTexte("question.redemarrer"), Demarrage.getTexte("label.confirmationModifications"), 1)) {
            case 0: {
                Demarrage.setPreference("langage", langue);
                try {
                    Runtime.getRuntime().exec("java -jar Spi.jar");
                    System.exit(0);
                }
                catch (IOException iOException) {}
                break;
            }
            case 1: {
                Demarrage.setPreference("langage", langue);
            }
        }
    }

    private void afficheMessageInfoApplication(String message) {
        this.zoneTexteInfoApplication.setText(this.zoneTexteInfoApplication.getText() + "\n" + message);
        this.ascenseurVerticalApplication.setValue(this.ascenseurVerticalApplication.getMaximum());
    }

    private void afficheMessageInfoCreation(String message) {
        this.zoneTexteInfoCreation.setText(this.zoneTexteInfoCreation.getText() + "\n" + message);
        this.ascenseurVerticalCreation.setValue(this.ascenseurVerticalCreation.getMaximum());
    }

    private String donneTaille(File fichier) {
        long taille = fichier.length();
        String ch = String.valueOf(taille) + " " + Demarrage.getTexte("octets");
        if (taille >= 0x100000L) {
            return String.valueOf((int)taille / 1024 / 1024) + " " + Demarrage.getTexte("mo") + " (" + ch + ")";
        }
        if (taille >= 1024L) {
            return String.valueOf((int)taille / 1024) + " " + Demarrage.getTexte("ko") + " (" + ch + ")";
        }
        return ch;
    }

    private void ouvreFichierApplicationOriginal() {
        JFileChooser fenetreChoixFichier = new JFileChooser(this.dossierDefaut);
        fenetreChoixFichier.setDialogTitle(Demarrage.getTexte("ouvertureFichierOriginal"));
        if (0 == fenetreChoixFichier.showOpenDialog(this)) {
            if (fenetreChoixFichier.getSelectedFile().canRead()) {
                this.fichierApplicationOriginal = new File(fenetreChoixFichier.getSelectedFile().getPath());
                this.dossierDefaut = new File(this.fichierApplicationOriginal.getParent());
                this.labelFichierApplicationOriginalAdresse.setText(this.fichierApplicationOriginal.getPath());
                this.labelFichierApplicationOriginalTaille.setText(this.donneTaille(this.fichierApplicationOriginal));
                if (!this.menuApplicationCreation.isEnabled() && this.fichierApplicationIPS != null && this.fichierApplicationIPS.exists()) {
                    this.menuApplicationCreation.setEnabled(true);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Ce fichier est prot\u00e9g\u00e9 en lecture.\nVeuillez changer ses droits pour le lire.", "Fichier prot\u00e9g\u00e9", 0);
                this.fichierApplicationOriginal = null;
            }
        }
    }

    private void ouvreFichierApplicationIPS() {
        JFileChooser fenetreChoixFichier = new JFileChooser(this.dossierDefaut);
        fenetreChoixFichier.setDialogTitle(Demarrage.getTexte("ouvertureFichierIPS"));
        if (0 == fenetreChoixFichier.showOpenDialog(this)) {
            if (fenetreChoixFichier.getSelectedFile().canRead()) {
                this.fichierApplicationIPS = new File(fenetreChoixFichier.getSelectedFile().getPath());
                this.dossierDefaut = new File(this.fichierApplicationIPS.getParent());
                this.labelFichierApplicationIPSAdresse.setText(this.fichierApplicationIPS.getPath());
                this.labelFichierApplicationIPSTaille.setText(this.donneTaille(this.fichierApplicationIPS));
                if (!this.fichierApplicationIPS.getName().substring(this.fichierApplicationIPS.getName().length() - 4).toUpperCase().equals(".IPS")) {
                    JOptionPane.showMessageDialog(this, "Le fichier choisi n'a pas l'extension IPS.\nIl est possible que ce fichier soit incompatible.", "Extension incorrecte", 2);
                }
                if (!this.menuApplicationCreation.isEnabled() && this.fichierApplicationOriginal != null && this.fichierApplicationOriginal.exists()) {
                    this.menuApplicationCreation.setEnabled(true);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Ce fichier est prot\u00e9g\u00e9 en lecture.\nVeuillez changer ses droits pour le lire.", "Fichier prot\u00e9g\u00e9", 0);
                this.fichierApplicationIPS = null;
            }
        }
    }

    private void ouvreFichierCreationOriginal() {
        JFileChooser fenetreChoixFichier = new JFileChooser(this.dossierDefaut);
        fenetreChoixFichier.setDialogTitle(Demarrage.getTexte("ouvertureFichierOriginal"));
        if (0 == fenetreChoixFichier.showOpenDialog(this)) {
            if (fenetreChoixFichier.getSelectedFile().canRead()) {
                this.fichierCreationOriginal = new File(fenetreChoixFichier.getSelectedFile().getPath());
                this.dossierDefaut = new File(this.fichierCreationOriginal.getParent());
                this.labelFichierCreationOriginalAdresse.setText(this.fichierCreationOriginal.getPath());
                this.labelFichierCreationOriginalTaille.setText(this.donneTaille(this.fichierCreationOriginal));
                if (!this.menuCreationCreation.isEnabled() && this.fichierCreationModifie != null && this.fichierCreationModifie.exists()) {
                    this.menuCreationCreation.setEnabled(true);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Ce fichier est prot\u00e9g\u00e9 en lecture.\nVeuillez changer ses droits pour le lire.", "Fichier prot\u00e9g\u00e9", 0);
                this.fichierCreationOriginal = null;
            }
        }
    }

    private void ouvreFichierCreationModifie() {
        JFileChooser fenetreChoixFichier = new JFileChooser(this.dossierDefaut);
        fenetreChoixFichier.setDialogTitle(Demarrage.getTexte("ouvertureFichierModifie"));
        if (0 == fenetreChoixFichier.showOpenDialog(this)) {
            if (fenetreChoixFichier.getSelectedFile().canRead()) {
                this.fichierCreationModifie = new File(fenetreChoixFichier.getSelectedFile().getPath());
                this.dossierDefaut = new File(this.fichierCreationModifie.getParent());
                this.labelFichierCreationModifieAdresse.setText(this.fichierCreationModifie.getPath());
                this.labelFichierCreationModifieTaille.setText(this.donneTaille(this.fichierCreationModifie));
                if (!this.menuCreationCreation.isEnabled() && this.fichierCreationOriginal != null && this.fichierCreationOriginal.exists()) {
                    this.menuCreationCreation.setEnabled(true);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Ce fichier est prot\u00e9g\u00e9 en lecture.\nVeuillez changer ses droits pour le lire.", "Fichier prot\u00e9g\u00e9", 0);
                this.fichierCreationModifie = null;
            }
        }
    }

    private void appliqueIPS() {
        this.modificationIpsSwingWorker = new ApplicationIpsSwingWorker();
        this.modificationIpsSwingWorker.execute();
    }

    private void creeIPS() {
        this.creationIpsSwingWorker = new CreationIpsSwingWorker();
        this.creationIpsSwingWorker.execute();
    }

    private boolean ecritBlocIps(int adresse, byte[] octets) {
        int adresse3 = adresse % 256;
        int adresse2 = (adresse - adresse3) / 256 % 256;
        int adresse1 = (adresse - adresse3 - adresse2 * 256) / 65536;
        int longueur2 = octets.length % 256;
        int longueur1 = (octets.length - longueur2) / 256 % 256;
        try {
            this.fichierCreationEcritureIPS.write(new byte[]{(byte)(adresse1 & 0xFF), (byte)(adresse2 & 0xFF), (byte)(adresse3 & 0xFF), (byte)(longueur1 & 0xFF), (byte)(longueur2 & 0xFF)});
            this.fichierCreationEcritureIPS.write(octets, 0, octets.length);
        }
        catch (IOException e) {
            this.afficheMessageInfoCreation("Erreur: Ecriture du fichier impossible");
            JOptionPane.showMessageDialog(this, "Une erreur inconnue s'est produite durant l'\u00e9criture.\n" + e.getMessage(), "Erreur", 0);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            if (menuItem.getName().equals("changeLangageFr")) {
                this.changeLangage("fr");
            } else if (menuItem.getName().equals("changeLangageEn")) {
                this.changeLangage("en");
            } else if (menuItem.getName().equals("changeLangageEs")) {
                this.changeLangage("es");
            } else if (menuItem.getName().equals("quitte")) {
                this.quitteProgramme();
            } else if (menuItem.getName().equals("ouvreFichierOriginalPourApplication")) {
                this.ouvreFichierApplicationOriginal();
            } else if (menuItem.getName().equals("ouvreFichierIpsPourApplication")) {
                this.ouvreFichierApplicationIPS();
            } else if (menuItem.getName().equals("appliqueIps")) {
                this.appliqueIPS();
            } else if (menuItem.getName().equals("ouvreFichierIpsPourCreation")) {
                this.ouvreFichierCreationOriginal();
            } else if (menuItem.getName().equals("ouvreFichierModifiePourCreation")) {
                this.ouvreFichierCreationModifie();
            } else if (menuItem.getName().equals("creeIps")) {
                this.creeIPS();
            } else if (menuItem.getName().equals("afficheFaq")) {
                this.ouvreFenetreFaq();
            } else if (menuItem.getName().equals("affichePropos")) {
                this.ouvreFenetreApropos();
            }
        }
    }

    @Override
    public void menuSelected(MenuEvent e) {
        if (e.getSource() instanceof JMenu) {
            JMenu menu = (JMenu)e.getSource();
            if (menu.getName().equals("menuApplication")) {
                this.onglets.setSelectedIndex(0);
            } else if (menu.getName().equals("menuCreation")) {
                this.onglets.setSelectedIndex(1);
            }
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    public class CreationIpsSwingWorker
    extends SwingWorker {
        protected Object doInBackground() throws Exception {
            FenetrePrincipale.this.interditInteractions();
            FenetrePrincipale.this.ascenseurVerticalApplication.setValue(FenetrePrincipale.this.ascenseurVerticalApplication.getMinimum());
            if (FenetrePrincipale.this.fichierCreationOriginal.length() > FenetrePrincipale.this.fichierCreationModifie.length()) {
                JOptionPane.showMessageDialog(null, "Le fichier original est plus volumineux que le fichier modifi\u00e9. Le fichier IPS ne peut \u00eatre cr\u00e9\u00e9.", "Fichiers incompatibles", 0);
                return null;
            }
            FenetrePrincipale.this.zoneTexteInfoCreation.setText(Demarrage.getTexte("creationFichierIPS"));
            if (!FenetrePrincipale.this.fichierCreationOriginal.canRead()) {
                FenetrePrincipale.this.afficheMessageInfoCreation("Erreur: Le fichier original (\"" + FenetrePrincipale.this.fichierCreationOriginal.getPath() + "\") est prot\u00e9g\u00e9 en lecture.");
                JOptionPane.showMessageDialog(null, "Le fichier original est prot\u00e9g\u00e9 en lecture.\nVeuillez changer ses droits pour le lire.", "Fichier prot\u00e9g\u00e9", 0);
                return null;
            }
            if (!FenetrePrincipale.this.fichierCreationModifie.canRead()) {
                FenetrePrincipale.this.afficheMessageInfoCreation("Erreur: Le fichier modifi\u00e9 (\"" + FenetrePrincipale.this.fichierCreationModifie.getPath() + "\") est prot\u00e9g\u00e9 en lecture.");
                JOptionPane.showMessageDialog(null, "Le fichier modifi\u00e9 est prot\u00e9g\u00e9 en lecture.\nVeuillez changer ses droits pour le lire.", "Fichier prot\u00e9g\u00e9", 0);
                return null;
            }
            JFileChooser boiteFichier = new JFileChooser();
            String nomFichier = FenetrePrincipale.this.fichierCreationOriginal.getName();
            if (nomFichier.indexOf(46) != -1) {
                nomFichier = nomFichier.substring(0, nomFichier.indexOf(46));
            }
            nomFichier = nomFichier + ".ips";
            boiteFichier.setSelectedFile(new File(FenetrePrincipale.this.fichierCreationOriginal.getParent() + File.separator + nomFichier));
            if (0 == boiteFichier.showSaveDialog(null)) {
                if (boiteFichier.getSelectedFile().exists()) {
                    if (JOptionPane.showConfirmDialog(null, Demarrage.getTexte("confirmationFichierExistantContenu"), Demarrage.getTexte("confirmationFichierExistantTitre"), 0) == 1) {
                        return null;
                    }
                } else if (!boiteFichier.getSelectedFile().getParentFile().canWrite()) {
                    FenetrePrincipale.this.afficheMessageInfoCreation("Erreur: Les droits d'\u00e9criture vous emp\u00eachent de cr\u00e9er ce fichier (\"" + boiteFichier.getSelectedFile().getPath() + "\").");
                    JOptionPane.showMessageDialog(null, "Les droits d'\u00e9criture vous emp\u00eachent de cr\u00e9er ce fichier.\nVeuillez changer les droits pour l'\u00e9crire.", "Fichier prot\u00e9g\u00e9", 0);
                    return null;
                }
            } else {
                return null;
            }
            if (boiteFichier.getSelectedFile().getPath().equals(FenetrePrincipale.this.fichierCreationOriginal.getPath())) {
                FenetrePrincipale.this.afficheMessageInfoCreation("Erreur: Le fichier qui doit \u00eatre cr\u00e9\u00e9 ne peut avoir le m\u00eame nom que le fichier original (\"" + FenetrePrincipale.this.fichierCreationOriginal.getPath() + "\").");
                JOptionPane.showMessageDialog(null, "Veuillez choisir un nom de fichier diff\u00e9rent du fichier original.", "Nom de fichier incorrecte", 0);
                return null;
            }
            if (boiteFichier.getSelectedFile().getPath().equals(FenetrePrincipale.this.fichierCreationModifie.getPath())) {
                FenetrePrincipale.this.afficheMessageInfoCreation("Erreur: Le fichier qui doit \u00eatre cr\u00e9\u00e9 ne peut avoir le m\u00eame nom que le fichier modifi\u00e9 (\"" + FenetrePrincipale.this.fichierCreationModifie.getPath() + "\").");
                JOptionPane.showMessageDialog(null, "Veuillez choisir un nom de fichier diff\u00e9rent du fichier modifi\u00e9.", "Nom de fichier incorrecte", 0);
                return null;
            }
            try {
                FenetrePrincipale.this.fichierCreationLectureModifie = new FileInputStream(FenetrePrincipale.this.fichierCreationModifie);
                FenetrePrincipale.this.fichierCreationLectureOriginal = new FileInputStream(FenetrePrincipale.this.fichierCreationOriginal);
                FenetrePrincipale.this.fichierCreationEcritureIPS = new FileOutputStream(boiteFichier.getSelectedFile());
            }
            catch (FileNotFoundException e) {
                FenetrePrincipale.this.afficheMessageInfoCreation("Erreur: Lecture ou \u00e9criture d'un fichier impossible");
                JOptionPane.showMessageDialog(null, "Une erreur inconnue s'est produite.\n" + e.getMessage(), "Erreur", 0);
                return null;
            }
            FenetrePrincipale.this.afficheMessageInfoCreation(Demarrage.getTexte("debutTraitement"));
            try {
                FenetrePrincipale.this.fichierCreationEcritureIPS.write(new String("PATCH").getBytes());
            }
            catch (IOException e) {
                FenetrePrincipale.this.afficheMessageInfoCreation("Erreur: L'\u00e9criture a \u00e9chou\u00e9e.");
                JOptionPane.showMessageDialog(null, "Une erreur inconnue s'est produite durant l'\u00e9criture.\n" + e.getMessage(), "Erreur", 0);
                return null;
            }
            byte[] octetsOriginaux = new byte[(int)FenetrePrincipale.this.fichierCreationModifie.length()];
            byte[] octetsModifies = new byte[(int)FenetrePrincipale.this.fichierCreationModifie.length()];
            try {
                FenetrePrincipale.this.fichierCreationLectureOriginal.read(octetsOriginaux);
                FenetrePrincipale.this.fichierCreationLectureModifie.read(octetsModifies);
            }
            catch (IOException e) {
                FenetrePrincipale.this.afficheMessageInfoCreation("Erreur: Lecture d'un fichier impossible");
                JOptionPane.showMessageDialog(null, "Une erreur inconnue s'est produite durant la lecture.\n" + e.getMessage(), "Erreur", 0);
                return null;
            }
            boolean ecritFichierIPS = false;
            int octetsNonChanges = 0;
            int octetsAEcrire = 0;
            int adresseDebut = 0;
            String registre = "";
            for (int i = 0; i < octetsOriginaux.length; ++i) {
                if (octetsOriginaux[i] != octetsModifies[i] || (long)i > FenetrePrincipale.this.fichierCreationOriginal.length()) {
                    octetsNonChanges = 0;
                    if (!ecritFichierIPS) {
                        octetsAEcrire = 1;
                        ecritFichierIPS = true;
                        adresseDebut = i;
                        continue;
                    }
                    ++octetsAEcrire;
                    continue;
                }
                if (!ecritFichierIPS) continue;
                if (octetsNonChanges > 4) {
                    byte[] octets = new byte[octetsAEcrire -= 5];
                    System.arraycopy(octetsModifies, adresseDebut, octets, 0, octetsAEcrire);
                    if (!FenetrePrincipale.this.ecritBlocIps(adresseDebut, octets)) {
                        return null;
                    }
                    registre = registre + "\n" + Demarrage.getTexte("Adresse") + " " + Long.toHexString(adresseDebut).toUpperCase() + ": " + String.valueOf(octets.length) + " " + Demarrage.getTexte("octets") + " " + Demarrage.getTexte("ecrits");
                    ecritFichierIPS = false;
                    octetsNonChanges = 0;
                    FenetrePrincipale.this.barreProgression.setValue(i * FenetrePrincipale.this.barreProgression.getMaximum() / octetsOriginaux.length);
                    continue;
                }
                ++octetsAEcrire;
                octetsNonChanges = (byte)(octetsNonChanges + 1);
            }
            FenetrePrincipale.this.afficheMessageInfoCreation(registre);
            if (ecritFichierIPS) {
                byte[] octets = new byte[octetsAEcrire];
                System.arraycopy(octetsModifies, adresseDebut, octets, 0, octetsAEcrire);
                if (FenetrePrincipale.this.ecritBlocIps(adresseDebut, octets)) {
                    FenetrePrincipale.this.afficheMessageInfoCreation(Demarrage.getTexte("Adresse") + " " + Long.toHexString(adresseDebut).toUpperCase() + ": " + String.valueOf(octets.length) + " " + Demarrage.getTexte("octets") + " " + Demarrage.getTexte("ecrits"));
                } else {
                    return null;
                }
            }
            try {
                FenetrePrincipale.this.fichierCreationEcritureIPS.write(new String("EOF").getBytes());
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                FenetrePrincipale.this.fichierCreationLectureModifie.close();
                FenetrePrincipale.this.fichierCreationLectureOriginal.close();
                FenetrePrincipale.this.fichierCreationEcritureIPS.close();
            }
            catch (IOException e) {
                FenetrePrincipale.this.afficheMessageInfoCreation("Erreur: Fermeture d'un fichier impossible.");
                JOptionPane.showMessageDialog(null, "Une erreur de lecture/\u00e9criture s'est produite mais le fichier a \u00e9t\u00e9 correctement cr\u00e9\u00e9.\nIl peut cependant \u00eatre recommand\u00e9 de relancer Spi.", "Erreur", 0);
                return null;
            }
            FenetrePrincipale.this.afficheMessageInfoCreation(Demarrage.getTexte("creationFichierSucces"));
            return null;
        }

        @Override
        public void done() {
            FenetrePrincipale.this.autoriseInteractions();
            FenetrePrincipale.this.barreProgression.setValue(FenetrePrincipale.this.barreProgression.getMaximum());
        }
    }

    public class ApplicationIpsSwingWorker
    extends SwingWorker {
        protected Object doInBackground() throws Exception {
            FenetrePrincipale.this.interditInteractions();
            FenetrePrincipale.this.ascenseurVerticalApplication.setValue(FenetrePrincipale.this.ascenseurVerticalApplication.getMinimum());
            FenetrePrincipale.this.zoneTexteInfoApplication.setText(Demarrage.getTexte("applicationFichierIPS"));
            if (!FenetrePrincipale.this.fichierApplicationOriginal.canRead()) {
                FenetrePrincipale.this.afficheMessageInfoApplication("Erreur: Le fichier original (\"" + FenetrePrincipale.this.fichierApplicationOriginal.getPath() + "\") est prot\u00e9g\u00e9 en lecture.");
                JOptionPane.showMessageDialog(null, "Le fichier original est prot\u00e9g\u00e9 en lecture.\nVeuillez changer ses droits pour le lire.", "Fichier prot\u00e9g\u00e9", 0);
                return null;
            }
            if (!FenetrePrincipale.this.fichierApplicationIPS.canRead()) {
                FenetrePrincipale.this.afficheMessageInfoApplication("Erreur: Le fichier IPS (\"" + FenetrePrincipale.this.fichierApplicationIPS.getPath() + "\") est prot\u00e9g\u00e9 en lecture.");
                JOptionPane.showMessageDialog(null, "Le fichier IPS est prot\u00e9g\u00e9 en lecture.\nVeuillez changer ses droits pour le lire.", "Fichier prot\u00e9g\u00e9", 0);
                return null;
            }
            JFileChooser boiteFichier = new JFileChooser();
            boiteFichier.setSelectedFile(new File(FenetrePrincipale.this.fichierApplicationOriginal.getParent() + File.separator + "SPI- " + FenetrePrincipale.this.fichierApplicationOriginal.getName().replace('[', '(').replace(']', ')')));
            if (0 == boiteFichier.showSaveDialog(null)) {
                if (boiteFichier.getSelectedFile().exists()) {
                    if (JOptionPane.showConfirmDialog(null, Demarrage.getTexte("confirmationFichierExistantContenu"), Demarrage.getTexte("confirmationFichierExistantTitre"), 0) == 1) {
                        return null;
                    }
                } else if (!boiteFichier.getSelectedFile().getParentFile().canWrite()) {
                    FenetrePrincipale.this.afficheMessageInfoApplication("Erreur: Les droits d'\u00e9criture vous emp\u00eachent de cr\u00e9er ce fichier (\"" + boiteFichier.getSelectedFile().getPath() + "\").");
                    JOptionPane.showMessageDialog(null, "Les droits d'\u00e9criture vous emp\u00eachent de cr\u00e9er ce fichier.\nVeuillez changer les droits pour l'\u00e9crire.", "Fichier prot\u00e9g\u00e9", 0);
                    return null;
                }
            } else {
                return null;
            }
            if (boiteFichier.getSelectedFile().getPath().equals(FenetrePrincipale.this.fichierApplicationOriginal.getPath())) {
                if (1 == JOptionPane.showConfirmDialog(null, "Le fichier que vous voulez cr\u00e9er a le m\u00eame nom que le fichier original, voulez-vous le remplacer?", "Noms de fichier identiques", 0)) {
                    FenetrePrincipale.this.appliqueIPS();
                    return null;
                }
            } else if (boiteFichier.getSelectedFile().getPath().equals(FenetrePrincipale.this.fichierApplicationIPS.getPath()) && 1 == JOptionPane.showConfirmDialog(null, "Le fichier que vous voulez cr\u00e9er a le m\u00eame nom que le fichier IPS (ce qui est quand m\u00eame \u00e9trange), voulez-vous le remplacer?", "Noms de fichier identiques", 0)) {
                FenetrePrincipale.this.appliqueIPS();
                return null;
            }
            try {
                FenetrePrincipale.this.fichierApplicationLectureIPS = new FileInputStream(FenetrePrincipale.this.fichierApplicationIPS);
                FenetrePrincipale.this.fichierApplicationLectureOriginal = new FileInputStream(FenetrePrincipale.this.fichierApplicationOriginal);
                FenetrePrincipale.this.fichierApplicationEcritureTraduit = new FileOutputStream(boiteFichier.getSelectedFile());
            }
            catch (FileNotFoundException e) {
                FenetrePrincipale.this.afficheMessageInfoApplication("Fichier introuvable.");
                JOptionPane.showMessageDialog(null, "Fichier introuvable.\n" + e.getMessage(), "Erreur", 0);
                return null;
            }
            int indiceFichierIPS = 5;
            boolean indiceFichierOriginal = false;
            byte[] octetsDuFichierOriginal = new byte[(int)FenetrePrincipale.this.fichierApplicationOriginal.length()];
            byte[] octetsDuFichierIPS = new byte[(int)FenetrePrincipale.this.fichierApplicationIPS.length()];
            try {
                FenetrePrincipale.this.fichierApplicationLectureIPS.read(octetsDuFichierIPS);
                FenetrePrincipale.this.fichierApplicationLectureOriginal.read(octetsDuFichierOriginal);
            }
            catch (IOException e) {
                FenetrePrincipale.this.afficheMessageInfoCreation("Erreur de lecture ou \u00e9criture du fichier.");
                JOptionPane.showMessageDialog(null, "Erreur de lecture ou \u00e9criture du fichier.\n" + e.getMessage(), "Erreur", 0);
                return null;
            }
            if (octetsDuFichierIPS[0] != 80 || octetsDuFichierIPS[1] != 65 || octetsDuFichierIPS[2] != 84 || octetsDuFichierIPS[3] != 67 || octetsDuFichierIPS[4] != 72) {
                FenetrePrincipale.this.afficheMessageInfoApplication("Erreur: Fichier IPS non valide. Il ne comporte pas l'en-t\u00eate PATCH.");
                JOptionPane.showMessageDialog(null, "Spi ne reconna\u00eet pas ce fichier: \"" + FenetrePrincipale.this.fichierApplicationIPS.getPath() + "\" comme un fichier IPS.\nL'en-t\u00eate du fichier ne correspond pas.", "Fichier IPS invalide", 0);
                return null;
            }
            FenetrePrincipale.this.afficheMessageInfoApplication(Demarrage.getTexte("debutTraitement"));
            String registre = "";
            while (indiceFichierIPS + 5 < octetsDuFichierIPS.length) {
                int i;
                int nombreBits;
                int adresseDebutModification = (octetsDuFichierIPS[indiceFichierIPS++] & 0xFF) * 256 * 256 + (octetsDuFichierIPS[indiceFichierIPS++] & 0xFF) * 256 + (octetsDuFichierIPS[indiceFichierIPS++] & 0xFF);
                if ((nombreBits = (octetsDuFichierIPS[indiceFichierIPS++] & 0xFF) * 256 + (octetsDuFichierIPS[indiceFichierIPS++] & 0xFF)) == 0) {
                    if (adresseDebutModification + (nombreBits = (octetsDuFichierIPS[indiceFichierIPS++] & 0xFF) * 256 + (octetsDuFichierIPS[indiceFichierIPS++] & 0xFF)) > octetsDuFichierOriginal.length) {
                        byte[] nouveauTab = new byte[adresseDebutModification + nombreBits];
                        System.arraycopy(octetsDuFichierOriginal, 0, nouveauTab, 0, Array.getLength(octetsDuFichierOriginal));
                        octetsDuFichierOriginal = nouveauTab;
                        registre = registre + "\nLe fichier IPS souhaite \u00e9crire au-del\u00e0 du fichier original. Celui-ci sera agrandi.";
                    }
                    byte octet = octetsDuFichierIPS[indiceFichierIPS++];
                    registre = registre + "\n" + Demarrage.getTexte("Adresse") + " " + Long.toHexString(adresseDebutModification).toUpperCase() + ": " + String.valueOf(nombreBits) + " " + Demarrage.getTexte("octets") + " (" + Demarrage.getTexte("caractere") + " \"" + (char)octet + "\" [" + Integer.toHexString(octet).toUpperCase() + "]) " + Demarrage.getTexte("modifies");
                    for (i = adresseDebutModification; i < adresseDebutModification + nombreBits && i < octetsDuFichierOriginal.length; ++i) {
                        octetsDuFichierOriginal[i] = octet;
                    }
                } else {
                    if (adresseDebutModification + nombreBits > octetsDuFichierOriginal.length) {
                        byte[] nouveauTab = new byte[adresseDebutModification + nombreBits];
                        System.arraycopy(octetsDuFichierOriginal, 0, nouveauTab, 0, Array.getLength(octetsDuFichierOriginal));
                        octetsDuFichierOriginal = nouveauTab;
                        registre = registre + "\nLe fichier IPS souhaite \u00e9crire au-del\u00e0 du fichier original. Celui-ci sera agrandi.";
                    }
                    registre = registre + "\n" + Demarrage.getTexte("Adresse") + " " + Long.toHexString(adresseDebutModification).toUpperCase() + ": " + String.valueOf(nombreBits) + " " + Demarrage.getTexte("octets") + " " + Demarrage.getTexte("modifies");
                    for (i = adresseDebutModification; i < adresseDebutModification + nombreBits; ++i) {
                        octetsDuFichierOriginal[i] = octetsDuFichierIPS[indiceFichierIPS++];
                    }
                }
                FenetrePrincipale.this.barreProgression.setValue(indiceFichierIPS * FenetrePrincipale.this.barreProgression.getMaximum() / octetsDuFichierIPS.length);
            }
            FenetrePrincipale.this.afficheMessageInfoApplication(registre);
            try {
                FenetrePrincipale.this.fichierApplicationEcritureTraduit.write(octetsDuFichierOriginal);
            }
            catch (IOException e) {
                FenetrePrincipale.this.afficheMessageInfoApplication("Erreur: Lecture du fichier original/IPS ou \u00e9criture de fichier cr\u00e9\u00e9 impossible.");
                JOptionPane.showMessageDialog(null, "Une erreur de lecture/\u00e9criture s'est produite.", "Erreur", 0);
                return null;
            }
            if (octetsDuFichierIPS.length - indiceFichierIPS != 3) {
                FenetrePrincipale.this.afficheMessageInfoApplication("Erreur: Fichier IPS invalide.");
                JOptionPane.showMessageDialog(null, "Le fichier IPS est apparemment mal form\u00e9.\nIl se peut que le fichier cr\u00e9\u00e9 ne soit pas le fichier attendu.", "Fichier IPS invalide", 0);
            }
            if (octetsDuFichierIPS[octetsDuFichierIPS.length - 3] != 69 && octetsDuFichierIPS[octetsDuFichierIPS.length - 2] != 79 && octetsDuFichierIPS[octetsDuFichierIPS.length - 1] != 70) {
                FenetrePrincipale.this.afficheMessageInfoApplication("Erreur: Fichier IPS invalide.");
                JOptionPane.showMessageDialog(null, "Le fichier IPS est apparemment mal form\u00e9.\nIl se peut que le fichier cr\u00e9\u00e9 ne soit pas le fichier attendu.", "Fichier IPS invalide", 0);
            }
            try {
                FenetrePrincipale.this.fichierApplicationLectureIPS.close();
                FenetrePrincipale.this.fichierApplicationLectureOriginal.close();
                FenetrePrincipale.this.fichierApplicationEcritureTraduit.close();
            }
            catch (IOException e) {
                FenetrePrincipale.this.afficheMessageInfoApplication("Erreur: Fermeture d'un fichier impossible.");
                JOptionPane.showMessageDialog(null, "Une erreur de lecture/\u00e9criture s'est produite mais le fichier a \u00e9t\u00e9 correctement cr\u00e9\u00e9.\nIl peut cependant \u00eatre recommand\u00e9 de relancer Spi.", "Erreur", 0);
                return null;
            }
            FenetrePrincipale.this.afficheMessageInfoApplication(Demarrage.getTexte("creationFichierSucces"));
            return null;
        }

        @Override
        public void done() {
            FenetrePrincipale.this.autoriseInteractions();
            FenetrePrincipale.this.barreProgression.setValue(FenetrePrincipale.this.barreProgression.getMaximum());
        }
    }
}

