/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Pom3
extends JFrame
implements ActionListener {
    JTextField textfield_1;
    JTextField textfield_2;
    JLabel label_1;
    JLabel label_2;
    JButton button_1;
    JButton button_2;
    JButton button_3;
    JButton button_4;
    JButton button_5;
    JCheckBox checkbox_1;
    JTextArea textarea_1;
    JScrollPane sp_textarea_1;
    JLabel label_3;
    File ppffile;
    File binfile;
    RandomAccessFile ppf;
    RandomAccessFile bin;
    int ppfloaded = 0;
    int binloaded = 0;
    byte ppfmethod;
    byte imagetype;
    byte validation;
    byte undo;
    byte undowrite;
    byte[] validationblock = new byte[1024];
    long patchdatasize = 0L;
    long currentposition = 0L;
    long patchposition;
    long patchcount;

    public Pom3() {
        pomLayout pomLayout2 = new pomLayout();
        this.getContentPane().setFont(new Font("Helvetica", 0, 12));
        this.getContentPane().setLayout(pomLayout2);
        this.textfield_1 = new JTextField("");
        this.textfield_1.setEditable(false);
        this.textfield_1.setBackground(Color.white);
        this.textfield_1.setForeground(Color.red);
        this.getContentPane().add(this.textfield_1);
        this.textfield_2 = new JTextField("");
        this.textfield_2.setEditable(false);
        this.textfield_2.setBackground(Color.white);
        this.textfield_2.setForeground(Color.red);
        this.getContentPane().add(this.textfield_2);
        this.label_1 = new JLabel("PPF-File");
        this.getContentPane().add(this.label_1);
        this.label_2 = new JLabel("BIN-File");
        this.getContentPane().add(this.label_2);
        this.button_1 = new JButton("Load");
        this.button_1.setActionCommand("LoadPPF");
        this.getContentPane().add(this.button_1);
        this.button_2 = new JButton("Load");
        this.button_2.setActionCommand("LoadBIN");
        this.getContentPane().add(this.button_2);
        this.button_3 = new JButton("Apply");
        this.getContentPane().add(this.button_3);
        this.button_4 = new JButton("Quit");
        this.getContentPane().add(this.button_4);
        this.button_5 = new JButton("About");
        this.getContentPane().add(this.button_5);
        this.checkbox_1 = new JCheckBox("Apply Undo-Patch-Data");
        this.checkbox_1.setEnabled(false);
        this.getContentPane().add(this.checkbox_1);
        this.textarea_1 = new JTextArea("Ready.\n\n");
        this.sp_textarea_1 = new JScrollPane(this.textarea_1);
        this.getContentPane().add(this.sp_textarea_1);
        this.label_3 = new JLabel("PPF-O-MATIC v3.0 Java", 0);
        this.getContentPane().add(this.label_3);
        this.setSize(this.getPreferredSize());
        this.button_1.addActionListener(this);
        this.button_2.addActionListener(this);
        this.button_3.addActionListener(this);
        this.button_4.addActionListener(this);
        this.button_5.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Pom3.this.closeOpenedFiles();
                System.exit(0);
            }
        });
    }

    public static void main(String[] stringArray) {
        Pom3 pom3 = new Pom3();
        pom3.setTitle("PPF-O-MATIC 3.0 Java");
        pom3.pack();
        pom3.setResizable(false);
        pom3.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        JFileChooser jFileChooser;
        if (actionEvent.getActionCommand().equals("Quit")) {
            this.closeOpenedFiles();
            System.exit(0);
        }
        if (actionEvent.getActionCommand().equals("About")) {
            this.showAbout();
        }
        if (actionEvent.getActionCommand().equals("LoadPPF")) {
            jFileChooser = new JFileChooser();
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            short s = 0;
            byte[] byArray = new byte[50];
            if (this.ppfloaded == 1) {
                try {
                    this.ppf.close();
                    this.checkbox_1.setEnabled(false);
                    this.textarea_1.setText("");
                    this.ppfloaded = 0;
                }
                catch (IOException iOException) {
                    System.out.println("Note: Failed to close old file\n");
                }
            }
            jFileChooser.setDialogTitle("Choose a PPF File");
            n = jFileChooser.showOpenDialog(this.getContentPane());
            if (n != 0) {
                this.textarea_1.append("PPF Load aborted..\n");
            } else {
                try {
                    String string;
                    byte[] byArray2;
                    int n4;
                    this.ppffile = new File(jFileChooser.getSelectedFile().getAbsolutePath());
                    this.ppf = new RandomAccessFile(this.ppffile, "r");
                    this.ppf.seek(0L);
                    n2 = this.ppf.readInt();
                    if ((n2 &= 0xFFFFFF00) != 1347438080) {
                        this.textarea_1.append("Error: File " + jFileChooser.getSelectedFile().getName() + " is not a PPF 1.0, 2.0 or 3.0 patch.\n\n");
                        this.ppf.close();
                        return;
                    }
                    this.undowrite = 0;
                    this.textarea_1.append("Filename: " + jFileChooser.getSelectedFile().getName() + "\n");
                    this.textfield_1.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    this.ppf.seek(5L);
                    this.ppfmethod = this.ppf.readByte();
                    if (this.ppfmethod == 0) {
                        this.textarea_1.append("PPF-Version: 1.0\nPPF Encode Method: 0\n");
                    }
                    if (this.ppfmethod == 1) {
                        this.textarea_1.append("PPF-Version: 2.0\nPPF Encode Method: 1\n");
                    }
                    if (this.ppfmethod == 2) {
                        this.textarea_1.append("PPF-Version: 3.0\nPPF Encode Method: 2\n");
                    }
                    this.ppf.seek(6L);
                    this.ppf.read(byArray);
                    String string2 = new String(byArray);
                    this.textarea_1.append("Patchinfo: " + string2 + "\n");
                    if (this.ppfmethod == 0) {
                        this.patchdatasize = this.ppf.length();
                        this.patchdatasize -= 56L;
                        this.currentposition = 56L;
                    }
                    if (this.ppfmethod == 1) {
                        this.ppf.seek(56L);
                        int n5 = this.ppf.readInt();
                        n5 = Pom3.intSwap(n5);
                        this.textarea_1.append("Size of original bin: " + n5 + "\n");
                        this.ppf.seek(this.ppf.length() - 11L);
                        n4 = this.ppf.readInt();
                        if (n4 == 1598637102) {
                            this.ppf.seek(this.ppf.length() - 4L);
                            n3 = this.ppf.readInt();
                            n3 = Pom3.intSwap(n3);
                            this.ppf.seek(this.ppf.length() - (long)(n3 + 20));
                            byArray2 = new byte[n3];
                            this.ppf.read(byArray2);
                            bl = true;
                            this.textarea_1.append("File_id.diz  : yes, showing...\n");
                            string = new String(byArray2);
                            this.textarea_1.append(string + "\n");
                        } else {
                            bl = false;
                            this.textarea_1.append("File_id.diz  : not available.\n");
                        }
                        this.patchdatasize = this.ppf.length();
                        this.patchdatasize -= 1084L;
                        this.currentposition = 1084L;
                        if (bl) {
                            this.patchdatasize -= (long)n3;
                            this.patchdatasize -= 38L;
                        }
                        this.ppf.seek(60L);
                        this.ppf.read(this.validationblock);
                    }
                    if (this.ppfmethod == 2) {
                        this.ppf.seek(56L);
                        this.imagetype = this.ppf.readByte();
                        this.ppf.seek(57L);
                        this.validation = this.ppf.readByte();
                        this.ppf.seek(58L);
                        this.undo = this.ppf.readByte();
                        if (this.imagetype == 0) {
                            this.textarea_1.append("Imagetype: BIN/CUE\n");
                        } else {
                            this.textarea_1.append("Imagetype: GI\n");
                        }
                        if (this.validation == 0) {
                            this.textarea_1.append("Patchvalidation: OFF\n");
                        } else {
                            this.textarea_1.append("Patchvalidation: ON\n");
                        }
                        if (this.undo == 0) {
                            this.textarea_1.append("Undodata: Unavailable\n");
                        } else {
                            this.textarea_1.append("Undodata: Available\n");
                            this.checkbox_1.setEnabled(true);
                        }
                        if (this.validation == 1) {
                            this.ppf.seek(60L);
                            this.ppf.read(this.validationblock);
                        }
                        this.ppf.seek(this.ppf.length() - 9L);
                        n4 = this.ppf.readInt();
                        if (n4 == 1598637102) {
                            this.ppf.seek(this.ppf.length() - 2L);
                            s = this.ppf.readShort();
                            s = Pom3.shortSwap(s);
                            this.ppf.seek(this.ppf.length() - (long)(s + 18));
                            byArray2 = new byte[s];
                            this.ppf.read(byArray2);
                            bl = true;
                            this.textarea_1.append("File_id.diz  : yes, showing...\n");
                            string = new String(byArray2);
                            this.textarea_1.append(string + "\n");
                        } else {
                            bl = false;
                            this.textarea_1.append("File_id.diz  : not available.\n");
                        }
                        this.patchdatasize = this.ppf.length();
                        if (this.validation == 1) {
                            this.patchdatasize -= 1084L;
                            this.currentposition = 1084L;
                        } else {
                            this.patchdatasize -= 60L;
                            this.currentposition = 60L;
                        }
                        if (bl) {
                            this.patchdatasize -= (long)s;
                            this.patchdatasize -= 36L;
                        }
                    }
                    this.ppfloaded = 1;
                    this.textarea_1.append("\nPPF load OKAY\n");
                }
                catch (IOException iOException) {
                    this.textarea_1.append("\nError: While accessing file " + jFileChooser.getSelectedFile().getName() + " or file could not be opened.\n");
                    this.textarea_1.append("Java Message:" + iOException + "\n");
                    this.ppfloaded = 0;
                }
            }
        }
        if (actionEvent.getActionCommand().equals("Apply")) {
            if (this.ppfloaded == 0 || this.binloaded == 0) {
                this.textarea_1.append("Load a PPF and or BIN-File first, silly\n");
                return;
            }
            this.applyPPF();
        }
        if (actionEvent.getActionCommand().equals("LoadBIN")) {
            jFileChooser = new JFileChooser();
            if (this.binloaded == 1) {
                try {
                    this.bin.close();
                    this.binloaded = 0;
                }
                catch (IOException iOException) {
                    System.out.println("Could not close file..\n");
                }
            }
            jFileChooser.setDialogTitle("Choose a BIN File");
            n = jFileChooser.showOpenDialog(this.getContentPane());
            if (n != 0) {
                this.textarea_1.append("BIN Load aborted..\n");
            } else {
                try {
                    this.binfile = new File(jFileChooser.getSelectedFile().getAbsolutePath());
                    this.bin = new RandomAccessFile(this.binfile, "rw");
                    this.textfield_2.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    this.textarea_1.append("\nBIN load OKAY\n");
                    this.binloaded = 1;
                }
                catch (IOException iOException) {
                    this.textarea_1.append("\nError: While accessing file " + jFileChooser.getSelectedFile().getName() + " or file could not be opened.\n");
                    this.textarea_1.append("Java Message:" + iOException + "\n");
                    this.binloaded = 0;
                }
            }
        }
    }

    private void closeOpenedFiles() {
        if (this.ppfloaded == 1) {
            try {
                this.ppf.close();
                this.checkbox_1.setEnabled(false);
            }
            catch (IOException iOException) {
                System.out.println("Could not close file..\n");
            }
        }
        if (this.binloaded == 1) {
            try {
                this.bin.close();
            }
            catch (IOException iOException) {
                System.out.println("Could not close file..\n");
            }
        }
    }

    private void showAbout() {
        this.textarea_1.setText("");
        this.textarea_1.append("PPF-O-MATIC 3.0 Java\n");
        this.textarea_1.append("Written by Icarus/Paradox\n\n");
        this.textarea_1.append("This should work for all operating systems\n");
        this.textarea_1.append("running JavaVM. Please note that for PPF3.0\n");
        this.textarea_1.append("64bit offset I/O routines (large files) have to be supported\n");
        this.textarea_1.append("by the OS and filesystem.\n");
        this.textarea_1.append("Supports PPF1.0, PPF2.0 and PPF3.0 patches.\n\n");
    }

    private int applyPPF() {
        int n;
        int n2;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[1024];
        if (this.ppfmethod == 0) {
            try {
                do {
                    this.ppf.seek(this.currentposition);
                    n2 = this.ppf.readInt();
                    n2 = Pom3.intSwap(n2);
                    this.currentposition += 4L;
                    this.patchdatasize -= 4L;
                    this.ppf.seek(this.currentposition);
                    this.patchcount = this.ppf.readByte();
                    ++this.currentposition;
                    --this.patchdatasize;
                    this.ppf.seek(this.currentposition);
                    this.ppf.readFully(byArray, 0, (int)this.patchcount);
                    this.currentposition += this.patchcount;
                    this.patchdatasize -= this.patchcount;
                    this.bin.seek(n2);
                    this.bin.write(byArray, 0, (int)this.patchcount);
                } while (this.patchdatasize != 0L);
                this.textarea_1.append("Patch applied, have fun ;-)\n");
            }
            catch (IOException iOException) {
                this.textarea_1.append("Fatal error while accessing or writing patchdata\n");
                this.textarea_1.append("Java Message:" + iOException + "\n");
                return 0;
            }
        }
        if (this.ppfmethod == 1) {
            try {
                this.bin.seek(37664L);
                this.bin.readFully(byArray2);
                n = 0;
                while (n < 1024) {
                    if (byArray2[n] != this.validationblock[n]) {
                        this.textarea_1.append("Patchvalidation failed, can't apply patchdata to binary.\n");
                        return 0;
                    }
                    ++n;
                }
                do {
                    this.ppf.seek(this.currentposition);
                    n2 = this.ppf.readInt();
                    n2 = Pom3.intSwap(n2);
                    this.currentposition += 4L;
                    this.patchdatasize -= 4L;
                    this.ppf.seek(this.currentposition);
                    this.patchcount = this.ppf.readByte();
                    ++this.currentposition;
                    --this.patchdatasize;
                    this.ppf.seek(this.currentposition);
                    this.ppf.readFully(byArray, 0, (int)this.patchcount);
                    this.currentposition += this.patchcount;
                    this.patchdatasize -= this.patchcount;
                    this.bin.seek(n2);
                    this.bin.write(byArray, 0, (int)this.patchcount);
                } while (this.patchdatasize != 0L);
                this.textarea_1.append("Patch applied, have fun ;-)\n");
            }
            catch (IOException iOException) {
                this.textarea_1.append("Fatal error while accessing or writing patchdata\n");
                this.textarea_1.append("Java Message:" + iOException + "\n");
                return 0;
            }
        }
        if (this.ppfmethod == 2) {
            try {
                if (this.validation == 1) {
                    if (this.imagetype == 0) {
                        this.bin.seek(37664L);
                    } else {
                        this.bin.seek(32928L);
                    }
                    this.bin.readFully(byArray2);
                    n = 0;
                    while (n < 1024) {
                        if (byArray2[n] != this.validationblock[n]) {
                            this.textarea_1.append("Patchvalidation failed, can't apply patchdata to binary.\n");
                            return 0;
                        }
                        ++n;
                    }
                }
                this.undowrite = this.undo == 1 && this.checkbox_1.isSelected() ? (byte)1 : 0;
                do {
                    this.ppf.seek(this.currentposition);
                    this.patchposition = this.ppf.readLong();
                    this.patchposition = Pom3.longSwap(this.patchposition);
                    this.currentposition += 8L;
                    this.patchdatasize -= 8L;
                    this.ppf.seek(this.currentposition);
                    this.bin.seek(this.patchposition);
                    this.patchcount = this.ppf.readByte();
                    ++this.currentposition;
                    --this.patchdatasize;
                    this.ppf.seek(this.currentposition);
                    this.ppf.readFully(byArray, 0, (int)this.patchcount);
                    if (this.undowrite == 1) {
                        this.ppf.readFully(byArray, 0, (int)this.patchcount);
                    }
                    this.bin.write(byArray, 0, (int)this.patchcount);
                    this.currentposition += this.patchcount;
                    this.patchdatasize -= this.patchcount;
                    if (this.undo == 1) {
                        this.currentposition += this.patchcount;
                        this.patchdatasize -= this.patchcount;
                    }
                    this.ppf.seek(this.currentposition);
                } while (this.patchdatasize != 0L);
                if (this.undowrite == 0) {
                    this.textarea_1.append("Patch applied, have fun ;-)\n");
                } else {
                    this.textarea_1.append("Undo data applied, have fun ;-)\n");
                }
            }
            catch (IOException iOException) {
                this.textarea_1.append("Fatal error while accessing or writing patchdata\n");
                this.textarea_1.append("Java Message:" + iOException + "\n");
                return 0;
            }
        }
        return 1;
    }

    private static int intSwap(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return n2 << 56 | n3 << 48 | n4 << 40 | n5 << 32;
    }

    private static short shortSwap(short s) {
        return (short)(s << 8 | s >> 8 & 0xFF);
    }

    private static long longSwap(long l) {
        long l2 = l & 0xFFL;
        long l3 = l >> 8 & 0xFFL;
        long l4 = l >> 16 & 0xFFL;
        long l5 = l >> 24 & 0xFFL;
        long l6 = l >> 32 & 0xFFL;
        long l7 = l >> 40 & 0xFFL;
        long l8 = l >> 48 & 0xFFL;
        long l9 = l >> 56 & 0xFFL;
        return l2 << 56 | l3 << 48 | l4 << 40 | l5 << 32 | l6 << 24 | l7 << 16 | l8 << 8 | l9;
    }
}

