DECLARE FUNCTION CV2! (str AS STRING)
DECLARE FUNCTION MDec! (str AS STRING)
DECLARE FUNCTION Bin$ (num!)
DECLARE FUNCTION CV3! (str AS STRING)
PRINT "IPS Patcher v1.0a (written in QuickBasic 4.5)"
PRINT "(c)2005 Mike Chambers under the GNU license."
PRINT
cmd$ = COMMAND$
xp = INSTR(1, cmd$, " "): IF xp < 1 THEN xp = 1
file$ = LEFT$(cmd$, xp - 1)
ips$ = MID$(cmd$, xp + 1)

IF INSTR(1, ips$, " ") THEN
        xp = INSTR(1, ips$, " ")
        outfile$ = MID$(ips$, xp + 1)
        ips$ = LEFT$(ips$, xp - 1)
END IF

IF file$ = "" OR ips$ = "" THEN
        PRINT "Syntax: IPSP <original filename> <IPS filename> <new file>"
        PRINT
        PRINT "<new file> is an optional argument. If specified, the patched"
        PRINT "           data will be written to the specified file. If it"
        PRINT "           is NOT specified, the original file WILL be altered.": END
END IF

PRINT "Patching " + file$ + " with data from " + ips$
PRINT

IF outfile$ <> "" THEN
        OPEN outfile$ FOR BINARY AS #3: CLOSE #3: KILL outfile$
        shl$ = "copy " + file$ + " " + outfile$
        SHELL shl$
ELSE
        outfile$ = file$
END IF

OPEN ips$ FOR BINARY AS #1
OPEN outfile$ FOR BINARY AS #2

a$ = SPACE$(5): GET #1, , a$
IF a$ <> "PATCH" THEN PRINT ips$ + " is not a valid IPS file.": CLOSE : END
DO UNTIL EOF(1)
offs$ = SPACE$(3): siz$ = SPACE$(2)
GET #1, , offs$: GET #1, , siz$
IF offs$ = "EOF" THEN EXIT DO
offset = CV3(offs$)
'DEBUG LINE: PRINT "Patch at offset:" + STR$(offset)
sze = CV2(siz$)
IF sze = 0 THEN PRINT "RLE encoded IPS files are not supported!": CLOSE : END
'DEBUG LINE: PRINT "Data chunk size:" + STR$(sze)
newdat$ = SPACE$(sze)
GET #1, , newdat$
PUT #2, offset + 1, newdat$
patches = patches + 1

pct = FIX((LOC(1) / LOF(1)) * 100)
LOCATE CSRLIN - 1, 1: PRINT "Progress:" + STR$(pct) + "% (" + MID$(STR$(patches), 2) + " chunks patched)"
LOOP
CLOSE
LOCATE CSRLIN - 1, 1: PRINT "Progress: 100% (" + MID$(STR$(patches), 2) + " chunks patched)"
PRINT
PRINT "Thank you for using Mike Chambers' IPS Patcher v1.0a"
PRINT "http://dextrometh.com/qbsoft"

FUNCTION Bin$ (num)
nm = num
cb = 128
bst$ = ""
FOR n = 1 TO 8
IF nm - cb >= 0 THEN
        nm = nm - cb
        bst$ = bst$ + "1"
ELSE
        bst$ = bst$ + "0"
END IF
cb = cb / 2
NEXT n
Bin$ = bst$
END FUNCTION

FUNCTION CV2 (str AS STRING)
bs$ = Bin$(ASC(LEFT$(str, 1))) + Bin$(ASC(MID$(str, 2, 1)))
CV2 = MDec(bs$)
END FUNCTION

FUNCTION CV3 (str AS STRING)
bs$ = Bin$(ASC(LEFT$(str, 1))) + Bin$(ASC(MID$(str, 2, 1))) + Bin$(ASC(MID$(str, 3, 1)))
CV3 = MDec(bs$)
END FUNCTION

FUNCTION MDec (str AS STRING)
vl = 0
cb = 1
FOR n = LEN(str) TO 1 STEP -1
IF MID$(str, n, 1) = "1" THEN vl = vl + cb
cb = cb * 2
NEXT n
MDec = vl
END FUNCTION

