/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class JavaPatcher {
    File rom;
    File patch;
    static byte[] romData;
    static byte[] newRomData;
    static byte[] patchData;
    static BufferedInputStream bin;
    static BufferedOutputStream bon;

    public static void main(String[] args) {
        if (args[0].toLowerCase().equals(new String("help"))) {
            System.out.println("[Rom name] [Patch name] [Output file name].");
            System.exit(1);
        } else if (args[0].toLowerCase().equals(new String("credits"))) {
            System.out.println("Cyips (Sai P.S.) Made by CyanPrime AKA Cypri.");
            System.exit(1);
        }
        File rom = new File(args[0]);
        File patch = new File(args[1]);
        romData = new byte[(int)rom.length()];
        patchData = new byte[(int)patch.length()];
        try {
            bin = new BufferedInputStream(new FileInputStream(rom));
        }
        catch (FileNotFoundException e) {
            System.out.println("Rom not found.");
            System.exit(1);
        }
        try {
            bin.read(romData);
        }
        catch (IOException e) {
            System.out.println("Error reading rom.");
            System.exit(1);
        }
        try {
            bin = new BufferedInputStream(new FileInputStream(patch));
        }
        catch (FileNotFoundException e) {
            System.out.println("Patch not found.");
            System.exit(1);
        }
        try {
            bin.read(patchData);
        }
        catch (IOException e) {
            System.out.println("Error reading patch.");
            System.exit(1);
        }
        try {
            if ((patchData[0] & 0xFF) == 80 && (patchData[1] & 0xFF) == 65 && (patchData[2] & 0xFF) == 84 && (patchData[3] & 0xFF) == 67 && (patchData[4] & 0xFF) == 72) {
                int length;
                int offset;
                int maxSize = 0;
                int i = 5;
                while (i < patchData.length - 3) {
                    offset = (patchData[i] & 0xFF) << 16 | (patchData[i + 1] & 0xFF) << 8 | patchData[i + 2] & 0xFF;
                    length = (patchData[i += 3] & 0xFF) << 8 | patchData[i + 1] & 0xFF;
                    i += 2;
                    if (length == 0) {
                        length = (patchData[i] & 0xFF) << 8 | patchData[i + 1] & 0xFF;
                        i += 3;
                    } else {
                        i += length;
                    }
                    if (offset + length <= maxSize) continue;
                    maxSize = offset + length;
                }
                newRomData = new byte[maxSize];
                System.arraycopy(romData, 0, newRomData, 0, romData.length);
                i = 5;
                while (i < patchData.length - 3) {
                    int j;
                    offset = (patchData[i] & 0xFF) << 16 | (patchData[i + 1] & 0xFF) << 8 | patchData[i + 2] & 0xFF;
                    length = (patchData[i += 3] & 0xFF) << 8 | patchData[i + 1] & 0xFF;
                    i += 2;
                    if (length == 0) {
                        length = (patchData[i] & 0xFF) << 8 | patchData[i + 1] & 0xFF;
                        i += 2;
                        j = 0;
                        while (j < length) {
                            JavaPatcher.newRomData[offset + j] = patchData[i];
                            ++j;
                        }
                        ++i;
                        continue;
                    }
                    j = 0;
                    while (j < length) {
                        JavaPatcher.newRomData[offset + j] = patchData[i + j];
                        ++j;
                    }
                    i += length;
                }
                bon = new BufferedOutputStream(new FileOutputStream(args[2]));
                bon.write(newRomData);
                bon.close();
                System.out.println("Patching compelete.");
                System.exit(0);
            } else {
                System.out.println("Patch isn't a patch.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

