// license:GPL_2.0
// copyright-holders:Robbbert
#include "../mame/drivers/dkong.cpp"

/* Websites:
DKafe / Jon Wilson / 10yard: https://github.com/10yard/dkafe
John Kowalski / Sock Master: none
Jeff Kulczycki: http://jeffsromhack.com/products/d2k.htm
Don Hodges: http://www.donhodges.com/how_high_can_you_get.htm
Kirai Shouen and 125scratch: https://www.romhacking.net/hacks/6689/
Tim Appleton: https://www.oocities.org/wigglebeat
Paul Goes: https://www.donkeykonghacks.net
*/

static INPUT_PORTS_START( dkongex )
	PORT_INCLUDE( dkong )
	PORT_MODIFY("DSW0")
	PORT_DIPNAME( 0x70, 0x00, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x70, "Freeplay" )
	PORT_DIPSETTING(    0x50, DEF_STR( 4C_1C ) )
	PORT_DIPSETTING(    0x30, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(    0x10, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x20, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x40, DEF_STR( 1C_3C ) )
	PORT_DIPSETTING(    0x60, DEF_STR( 1C_4C ) )
INPUT_PORTS_END

static INPUT_PORTS_START( dkrdemo )
	PORT_INCLUDE( dkong )
	PORT_MODIFY("DSW0")
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Lives ) )       PORT_DIPLOCATION( "SW1:!1,!2" )
	PORT_DIPSETTING(    0x00, "3" )
	PORT_DIPSETTING(    0x01, "5" )
	PORT_DIPSETTING(    0x02, "7" )
	PORT_DIPSETTING(    0x03, "9" )
	PORT_DIPNAME( 0x0c, 0x00, DEF_STR( Bonus_Life ) )   PORT_DIPLOCATION( "SW1:!3,!4" )
	PORT_DIPSETTING(    0x00, "10000" )
	PORT_DIPSETTING(    0x04, "15000" ) // and each additional 150k
	PORT_DIPSETTING(    0x08, "25000" ) // and each additional 250k
	PORT_DIPSETTING(    0x0c, "35000" ) // and each additional 350k
	PORT_DIPNAME( 0x30, 0x00, DEF_STR( Coinage ) )      PORT_DIPLOCATION( "SW1:!5,!6" )
	PORT_DIPSETTING(    0x30, "Free Play" )
	PORT_DIPSETTING(    0x10, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x20, DEF_STR( 1C_2C ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Difficulty ) )   PORT_DIPLOCATION( "SW1:!8" )
	PORT_DIPSETTING(    0x00, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Hard ) )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Cabinet ) )      PORT_DIPLOCATION( "SW1:!8" )
	PORT_DIPSETTING(    0x80, DEF_STR( Upright ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Cocktail ) )
INPUT_PORTS_END


/*****************
 Donkey Kong
*****************/
/* same as mame 'dkongf' except 4th rom is different */
ROM_START( dkongex )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dk_f.5et",       0x0000, 0x1000, CRC(00b7efaf) SHA1(97ed5930eb5d0cb98a9008b1d329ba7f3b8b8dbf) )
	ROM_LOAD( "dk_f.5ct",       0x1000, 0x1000, CRC(88af9b69) SHA1(c5621dd8198c333b3fa32fdece60ee5a3d8b2276) )
	ROM_LOAD( "dk_f.5bt",       0x2000, 0x1000, CRC(de74ad91) SHA1(c80227361bdbc565e9f5764e6364b52d40ca778a) )
	ROM_LOAD( "dkongex.5at",    0x3000, 0x1000, CRC(9fa3e5b7) SHA1(5c34170f762a147d5285d17d6689fd64dab99ff2) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongp ) // Don Hodges - fixes the level 22 killscreen
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongp_c_5et",   0x0000, 0x1000, CRC(2066139d) SHA1(2eaf4cd6eb18eacb210892a85147e70db58bee48) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",    0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong01 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s01.5et",      0x0000, 0x1000, CRC(13d328c1) SHA1(7d8e19ea301fe36a97514da1e29dd27871103b8b) )
	ROM_LOAD( "s01.5ct",      0x1000, 0x1000, CRC(5f9f85b7) SHA1(211211c4f1b8b0bb23f4bd0a515129fa1fe5be7a) )
	ROM_LOAD( "c_5bt_g.bin",  0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s01.5at",      0x3000, 0x1000, CRC(5de178ca) SHA1(cf7460b1ee76290803834950a2da28bd06971506) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s01.5h",       0x0000, 0x0800, CRC(88791795) SHA1(5066bdecc39dc7828746d4b8e526f2264e791772) )
	ROM_LOAD( "s01.3pt",      0x0800, 0x0800, CRC(5fa452f7) SHA1(6435383249442f2e00914f537886ddfb72202708) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",   0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",   0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",   0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",   0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong02 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s02.5et",      0x0000, 0x1000, CRC(167da4a2) SHA1(6bac9c7438e3372f9d805a657526da49bd00a9f0) )
	ROM_LOAD( "s01.5ct",      0x1000, 0x1000, CRC(5f9f85b7) SHA1(211211c4f1b8b0bb23f4bd0a515129fa1fe5be7a) )
	ROM_LOAD( "c_5bt_g.bin",  0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s02.5at",      0x3000, 0x1000, CRC(54abe269) SHA1(53e369210fe46b193cf6d551049b5fd9161234eb) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s01.5h",       0x0000, 0x0800, CRC(88791795) SHA1(5066bdecc39dc7828746d4b8e526f2264e791772) )
	ROM_LOAD( "s01.3pt",      0x0800, 0x0800, CRC(5fa452f7) SHA1(6435383249442f2e00914f537886ddfb72202708) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",   0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",   0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",   0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",   0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong03 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s03.5et",      0x0000, 0x1000, CRC(8ab9cd48) SHA1(291b716dd73e186cbde8e73f077ef6a4bd4016b0) )
	ROM_LOAD( "s01.5ct",      0x1000, 0x1000, CRC(5f9f85b7) SHA1(211211c4f1b8b0bb23f4bd0a515129fa1fe5be7a) )
	ROM_LOAD( "c_5bt_g.bin",  0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s03.5at",      0x3000, 0x1000, CRC(753e688c) SHA1(9647621645af814d688e49d142911b821d0495b3) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s01.5h",       0x0000, 0x0800, CRC(88791795) SHA1(5066bdecc39dc7828746d4b8e526f2264e791772) )
	ROM_LOAD( "s01.3pt",      0x0800, 0x0800, CRC(5fa452f7) SHA1(6435383249442f2e00914f537886ddfb72202708) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",   0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",   0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",   0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",   0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong04 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",  0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",  0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",  0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s04.5at",      0x3000, 0x1000, CRC(09a3dd4a) SHA1(3e23387ca6f95da28af8f780c6b1200087c924df) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",   0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",    0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s04.4m",       0x0000, 0x0800, CRC(05e0178d) SHA1(b18d82c18cc86e5835407368c6c69b2cd420f3e0) )
	ROM_LOAD( "s04.4n",       0x0800, 0x0800, CRC(84e00e39) SHA1(9752a278b29ecd46f46154a01a26067d7d37a608) )
	ROM_LOAD( "s04.4r",       0x1000, 0x0800, CRC(ed02bdad) SHA1(0d946c0c520803e7b42e46195edb18d62da2c98c) )
	ROM_LOAD( "s04.4s",       0x1800, 0x0800, CRC(3c34b034) SHA1(a90cffb1fd8a7a46306f8cbbbaa4f2c2d7f009b1) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong05 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",  0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "s05.5ct",      0x1000, 0x1000, CRC(bcf79636) SHA1(eac1b8c80c10cbc58dc2cf205084b0cb05ea6f5a) )
	ROM_LOAD( "c_5bt_g.bin",  0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s05.5at",      0x3000, 0x1000, CRC(c1b95bd3) SHA1(a447c9f82e7c4a9b7f60b33a037156ae355aa949) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",   0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",    0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong06 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s06.5et",  0x0000, 0x1000, CRC(da0c3028) SHA1(5a2d8d9c05906eb891757917dab61757e1c6dc5a) )
	ROM_LOAD( "c_5ct_g.bin",  0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",  0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s06.5at",  0x3000, 0x1000, CRC(f41cd662) SHA1(1fad3138c8f920b0425a11f8e29a8d1c542c11e9) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s06.5h",   0x0000, 0x0800, CRC(77b4c1f9) SHA1(8fc70474542c573869981d7754ab05ed4dfbdf1d) )
	ROM_LOAD( "s06.3pt",  0x0800, 0x0800, CRC(4a4ba8d4) SHA1(045b72caa312bb4fba2b938856b73996346d2adf) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s06.4m",   0x0000, 0x0800, CRC(8f6b9786) SHA1(303fc53fef58ce41aa230f87ba582ab660d53ff9) )
	ROM_LOAD( "s06.4n",   0x0800, 0x0800, CRC(8744b5e3) SHA1(c20bc6ff27e67b65aa891d57f1279712a75c7d98) )
	ROM_LOAD( "s06.4r",   0x1000, 0x0800, CRC(2839cb25) SHA1(71884c312e469d97ea82a87d2d9e016ae0ec3710) )
	ROM_LOAD( "s06.4s",   0x1800, 0x0800, CRC(c0981d89) SHA1(7a305d07000f94607621a7d1bbeba46c4f87d25e) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong07 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",  0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",  0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",  0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",  0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s07.5h",   0x0000, 0x0800, CRC(d314c451) SHA1(bb28f431c5ce6e9c1dd77a0aad3728e882f0f9c0) )
	ROM_LOAD( "s07.3pt",  0x0800, 0x0800, CRC(3525a8c0) SHA1(7e94f5c212dfb6fe00f7dbcd8e1ecb56b6066d5e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s07.4m",   0x0000, 0x0800, CRC(089af499) SHA1(33445181a67a25be2e953dec7a0d2437070e71f1) )
	ROM_LOAD( "s07.4n",   0x0800, 0x0800, CRC(7375d02d) SHA1(8c0d3130c01d7a0e3cd50eb7de6cc000a4215c67) )
	ROM_LOAD( "s07.4r",   0x1000, 0x0800, CRC(a8142c34) SHA1(7bbaf33f12ce971a02e1c38e8b9b807554657ec6) )
	ROM_LOAD( "s07.4s",   0x1800, 0x0800, CRC(72de5617) SHA1(01a08d52aeb1151b5261218afb980cfcb6bef937) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "s07.2k",     0x0000, 0x0100, CRC(2f18a54e) SHA1(098f70fe519102ebb146a3aa42b0aa1d6fb7fbe7) )
	ROM_LOAD( "s07.2j",     0x0100, 0x0100, CRC(4f1f882a) SHA1(df95e3424ba7372b1096e39d6c10f7eaa51cf739) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong08 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",  0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",  0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "s08.5bt",  0x2000, 0x1000, CRC(ca1e5693) SHA1(422f14bef6d80903d950298f97242fbd0b69f32b) )
	ROM_LOAD( "s08.5at",  0x3000, 0x1000, CRC(a72252cd) SHA1(bfdd01ac68ebb65d5da661347fa7d2abeeb8cf05) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s08.5h",   0x0000, 0x0800, CRC(9fd983a7) SHA1(3b80759286e69aa60d5efe308373d28a6639e525) )
	ROM_LOAD( "s08.3pt",  0x0800, 0x0800, CRC(f866040f) SHA1(7740f95ccdad7f89b67fed6d068a5dda12a88ff0) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s08.4m",   0x0000, 0x0800, CRC(4b882a01) SHA1(9f95a032b2d19800e9271b71e70dbe64f1ee5ae4) )
	ROM_LOAD( "s08.4n",   0x0800, 0x0800, CRC(dc13a5b3) SHA1(b78b3239b00b2b2fd0b461764fbabbf79c1091e9) )
	ROM_LOAD( "s08.4r",   0x1000, 0x0800, CRC(80558471) SHA1(a50ea67e4d78d3d02d2d8082c7e566d2adb49acb) )
	ROM_LOAD( "s08.4s",   0x1800, 0x0800, CRC(18d7d478) SHA1(7cc666f28deba131c3fe8805f79a53199e0363c9) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong09 ) // from dkafe  - supposed to say PANIC! and have red lava rising, but none of that happens.
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",  0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",  0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",  0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s09.5at",  0x3000, 0x1000, CRC(e9fb42fc) SHA1(162b70fe4dfa7a4f66816aefa532a2f9da79de16) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong10 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s10.5et",  0x0000, 0x1000, CRC(b653104f) SHA1(8bf17b6695b4593ba46aba909aeea2a56cf6e489) )
	ROM_LOAD( "s10.5ct",  0x1000, 0x1000, CRC(89363e27) SHA1(fa5493c30d1be98ca1c6facb99d1e4e1ecc5e4c0) )
	ROM_LOAD( "s10.5bt",  0x2000, 0x1000, CRC(11e0a7a2) SHA1(4af6ab490ffc297a31631184e903b5206486ed9a) )
	ROM_LOAD( "s10.5at",  0x3000, 0x1000, CRC(8df18df7) SHA1(bcc765395fb1af47154bae0291f38d8864ed3382) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s10.5h",       0x0000, 0x0800, CRC(659aaeb5) SHA1(ba5e11ed16cdc6aed4ea9a557f4780ea645a31c0) )
	ROM_LOAD( "s10.3pt",      0x0800, 0x0800, CRC(4f158a44) SHA1(4660c62d1b14571f549a696e0797c75a0707e285) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong11 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s11.5et",  0x0000, 0x1000, CRC(264d83c7) SHA1(9270264ecd8a9c8598196ef244efd87507cdeeae) )
	ROM_LOAD( "c_5ct_g.bin",  0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s11.5at",  0x3000, 0x1000, CRC(36768adf) SHA1(0ca5fc7a2a3e13d4751b2626f51a01d3ebc896c4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s11.5h",       0x0000, 0x0800, CRC(43488249) SHA1(0df7629167ae2c188ce22d2642c90686ca807ca1) )
	ROM_LOAD( "s11.3pt",      0x0800, 0x0800, CRC(9bfa72d3) SHA1(5a0aec001f8fcbd2d35603629860c772fd6d6f70) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s11.4m",   0x0000, 0x0800, CRC(b31de054) SHA1(fd270483858bfac85ff08b5df03ec66964b45e69) )
	ROM_LOAD( "s11.4n",   0x0800, 0x0800, CRC(2154c474) SHA1(401c438a1a8314ba769d791d6adab09f9ffb76f7) )
	ROM_LOAD( "s11.4r",   0x1000, 0x0800, CRC(144fbcf7) SHA1(c723ce2f5976b050d58f9498408bb9bc54fd35e0) )
	ROM_LOAD( "s11.4s",   0x1800, 0x0800, CRC(66886c1e) SHA1(b16ec71a1926280e1ef317c8cdacb9d5ae26b1db) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong12 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s12.5et",  0x0000, 0x1000, CRC(fa9b1242) SHA1(4c139e31a040844f3a61089da2614000c7104f48) )
	ROM_LOAD( "s05.5ct",  0x1000, 0x1000, CRC(bcf79636) SHA1(eac1b8c80c10cbc58dc2cf205084b0cb05ea6f5a) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s12.5at",  0x3000, 0x1000, CRC(9eae173c) SHA1(e5dc63bede32763fa7b5b0de0dab0b96113e764e) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong13 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s13.5et",  0x0000, 0x1000, CRC(7bb6a069) SHA1(860e5e3c85fcdf932dc5df3b7c3e98e0495a062d) )
	ROM_LOAD( "c_5ct_g.bin",  0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s13.5at",  0x3000, 0x1000, CRC(2d95e2dc) SHA1(2f72341b626b25745e83987929883eda7df6478d) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s13.5h",       0x0000, 0x0800, CRC(3123e13e) SHA1(8b444bacdabc91c472d24daa64f94cd3396877b0) )
	ROM_LOAD( "s13.3pt",      0x0800, 0x0800, CRC(8a7cc885) SHA1(2c369e023051dcaba711c1f3ad49fff8f6c4671f) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s13.4m",     0x0000, 0x0800, CRC(43899f5d) SHA1(44b1e9ce7dea9289796515679c787765110fcff4) )
	ROM_LOAD( "s13.4n",     0x0800, 0x0800, CRC(a3c087db) SHA1(bc6a579aaeb872dbd9074d0b1f2f21ff63bc4fa9) )
	ROM_LOAD( "s13.4r",     0x1000, 0x0800, CRC(e4dbc3fe) SHA1(97944896a0be4f55c05b698eb3a3a9d67afc2790) )
	ROM_LOAD( "s13.4s",     0x1800, 0x0800, CRC(e41c2fb1) SHA1(3d167796b5f987f9d772af703b04280f1b670e11) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong14 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s14.5et",  0x0000, 0x1000, CRC(7b4c47d0) SHA1(ad95cb487a6598fef7d4610d5ab88846cf64285a) )
	ROM_LOAD( "c_5ct_g.bin",  0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s14.5at",  0x3000, 0x1000, CRC(6f2d5bfe) SHA1(5799e972234e3b3c8cc27e884b43088dec70192d) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong15 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s15.5et",  0x0000, 0x1000, CRC(73ed763a) SHA1(d9db48fe1478fd0b6e8ef05cb21429d02dde5cff) )
	ROM_LOAD( "s05.5ct",  0x1000, 0x1000, CRC(bcf79636) SHA1(eac1b8c80c10cbc58dc2cf205084b0cb05ea6f5a) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s15.5at",  0x3000, 0x1000, CRC(bf13dd67) SHA1(0acddff1087445cd93a8b0e63e5e8d98ceb1513b) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong16 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s16.5et",    0x0000, 0x1000, CRC(df6f3ad0) SHA1(a87c1262c8f0ccf6a906a88ddcfe1d147504ff53) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "s16.5bt",    0x2000, 0x1000, CRC(c34b67aa) SHA1(84ef5e509f32eb544179e5a186cbe3f1193d1ee3) )
	ROM_LOAD( "s16.5at",    0x3000, 0x1000, CRC(c282c79c) SHA1(0612b15738e5a5ad0ceffa988886fbadcece68d3) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong17 ) // from dkafe
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "s17.5at",    0x3000, 0x1000, CRC(9591efd4) SHA1(025043df8d4b27343cf4532f3737a843ca6d20ee) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s17.5h",       0x0000, 0x0800, CRC(621f575c) SHA1(15884de84759421ba59faadf4b2da669a6d9a1be) )
	ROM_LOAD( "s17.3pt",      0x0800, 0x0800, CRC(36fb859c) SHA1(577d7d0027b789561800963dfb7bcbb84037d85a) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s17.4m",     0x0000, 0x0800, CRC(8c2b5bcd) SHA1(6f6445eb1ceff1a0c22b3654edb5976469ecf57f) )
	ROM_LOAD( "s17.4n",     0x0800, 0x0800, CRC(3876fdb6) SHA1(c1a0c0fc7084d0ae3679d13c578f8542c7cdc620) )
	ROM_LOAD( "s17.4r",     0x1000, 0x0800, CRC(dd96b24c) SHA1(5318ded576d3e027c58b5667c68d26df8b390bee) )
	ROM_LOAD( "s17.4s",     0x1800, 0x0800, CRC(1feca016) SHA1(b0ea321fb85a16c6b96db4b1fcb22532615046aa) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong19 ) // kong2600, gorilla graphics are original, not 2600
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",    0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s19.5h",         0x0000, 0x0800, CRC(0e6a2a6d) SHA1(7ebbcb78b269184cf588b5ad0b90f449d6d4e299) )
	ROM_LOAD( "s19.3pt",        0x0800, 0x0800, CRC(ca57e0f4) SHA1(12c7821fc9f7fee276f7aa27dd0421f565b0f469) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s19.4m",         0x0000, 0x0800, CRC(cf450a43) SHA1(efa772f92b890181c0823b8113e069b7c4400ede) )
	ROM_LOAD( "s19.4n",         0x0800, 0x0800, CRC(d5046907) SHA1(1eb08ed67f6de04c4f3cb8f449503bbedc6207bc) )
	ROM_LOAD( "s19.4r",         0x1000, 0x0800, CRC(1539fe2a) SHA1(ea599987a2d65ffe2d09ca0951529bde2d31b1be) )
	ROM_LOAD( "s19.4s",         0x1800, 0x0800, CRC(77cc00ab) SHA1(7560bf4fd65c03f28f015abf64f83fc4ad7ae512) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "s19.2k",         0x0000, 0x0100, CRC(1e82d375) SHA1(8f2da5cedd1f62be08555dd0eb929eb41da5079d) )
	ROM_LOAD( "s19.2j",         0x0100, 0x0100, CRC(2ab01dc8) SHA1(c25958d0706cabf997efe16fad71f454fc1ced0b) )
	ROM_LOAD( "s19.5e",         0x0200, 0x0100, CRC(44988665) SHA1(68c474fc81aff46eae6c9a7ac6ab80288303e291) )
ROM_END


ROM_START( dkong20 ) // from dkafe, the gorilla graphics are missing
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",    0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s20.5h",         0x0000, 0x0800, CRC(04cfd877) SHA1(8cbbcbc4d2c459bde0a652d8dbd2c6cec9d90ef3) )
	ROM_LOAD( "s20.3pt",        0x0800, 0x0800, CRC(50c92785) SHA1(27411c03ecf6b3cbd864d310af42d54cc25d659d) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s20.4m",         0x0000, 0x0800, CRC(ac877f07) SHA1(2392789f7a9ddcc9e48ffba6a786f08e55b7bef0) )
	ROM_LOAD( "s20.4n",         0x0800, 0x0800, CRC(5c9e71e1) SHA1(4981f6d4fe21baeb35e267eca19771c6cd995944) )
	ROM_LOAD( "s20.4r",         0x1000, 0x0800, CRC(f1834ba5) SHA1(8ba39a25f1085d9e9a7be4b3ed953a2584a4db84) )
	ROM_LOAD( "s20.4s",         0x1800, 0x0800, CRC(d1ce232a) SHA1(0531ddc86c76048689eadd39911adb236901cf2a) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "s19.2k",         0x0000, 0x0100, CRC(1e82d375) SHA1(8f2da5cedd1f62be08555dd0eb929eb41da5079d) )
	ROM_LOAD( "s19.2j",         0x0100, 0x0100, CRC(2ab01dc8) SHA1(c25958d0706cabf997efe16fad71f454fc1ced0b) )
	ROM_LOAD( "s19.5e",         0x0200, 0x0100, CRC(44988665) SHA1(68c474fc81aff46eae6c9a7ac6ab80288303e291) )
ROM_END


ROM_START( dkong21 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s21.5et",        0x0000, 0x1000, CRC(a7a913d5) SHA1(163f851b0517a84d54d6612f8bbe52d214a0f846) )
	ROM_LOAD( "s21.5ct",        0x1000, 0x1000, CRC(03ce5531) SHA1(9d8c1df41dfb04f3b9498109fad7d9288f4a00fe) )
	ROM_LOAD( "s21.5bt",        0x2000, 0x1000, CRC(abaf3fa1) SHA1(d05ae561800b8386b932aae4921c4b197bf8f9c4) )
	ROM_LOAD( "s21.5at",        0x3000, 0x1000, CRC(843a9751) SHA1(c6b564e4bf0b472dfb42e9d23f9ec5ee157e7832) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s21.3i",         0x0000, 0x0800, CRC(4f865d26) SHA1(d31c431ff2512d3a8f983fc4676ba51995d945e6) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "s21.5h",         0x0000, 0x0800, CRC(b212d49b) SHA1(941d907990eb6982793d79ed63974f9c9c6a159d) )
	ROM_LOAD( "s21.3pt",        0x0800, 0x0800, CRC(2bd67b35) SHA1(7e5660b35f53f81410a68b73bf8784a56bb6ebac) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s21.4m",         0x0000, 0x0800, CRC(7db40811) SHA1(a149e5fdcd3f0c1a570cebcdd236013eaefd5398) )
	ROM_LOAD( "s21.4n",         0x0800, 0x0800, CRC(c9f3b37a) SHA1(87ac9f2b5d0c0150e95aa9ebfba7438b49958c1d) )
	ROM_LOAD( "s21.4r",         0x1000, 0x0800, CRC(137ad00e) SHA1(38e0717af7601803c7cd7b1cf0286cd6c8a2cbda) )
	ROM_LOAD( "s21.4s",         0x1800, 0x0800, CRC(72b56559) SHA1(99fa2699f0a2652e4048f09187b17619bf2e8c80) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "s21.2k",         0x0000, 0x0100, CRC(929a396b) SHA1(bc5f50ab46fad619e2bee782fc9676868affb08e) )
	ROM_LOAD( "s21.2j",         0x0100, 0x0100, CRC(1aa9c17e) SHA1(0c6e11caec0e805aa8c6173895963bb6e50417ea) )
	ROM_LOAD( "s21.5e",         0x0200, 0x0100, CRC(d06c6ba8) SHA1(71989ca72740e44c1f967239236b9764be0698c2) )
ROM_END


ROM_START( dkong22 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s22.5et",    0x0000, 0x1000, CRC(866487b7) SHA1(25f3000c9925a8c2b54b507d72020007ad99fbe9) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "dkongchm.5bt",   0x2000, 0x1000, CRC(fce41e06) SHA1(fdab4f37f914d56a28092592f9cbb3d2502c925e) )
	ROM_LOAD( "s22.5at",    0x3000, 0x1000, CRC(592e538c) SHA1(8b8dca78149df5c2190a1eadda8ad6374b59d58d) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s22.4m",     0x0000, 0x0800, CRC(2ca964fe) SHA1(550c685f59ddf45dfeac245c9fea4d8041d8d188) )
	ROM_LOAD( "s22.4n",     0x0800, 0x0800, CRC(8ca9f14e) SHA1(5fd2646e272147ef184f9f1a0b8b36f53bd5069a) )
	ROM_LOAD( "s22.4r",     0x1000, 0x0800, CRC(7241e939) SHA1(8083eb54e148e8b4d6c1b0c1c0db96037c59e391) )
	ROM_LOAD( "s22.4s",     0x1800, 0x0800, CRC(65904993) SHA1(e618a8638a295c413a85d7ba568735c6db08ad8a) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong23 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s22.5et",    0x0000, 0x1000, CRC(866487b7) SHA1(25f3000c9925a8c2b54b507d72020007ad99fbe9) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "dkongchm.5bt",   0x2000, 0x1000, CRC(fce41e06) SHA1(fdab4f37f914d56a28092592f9cbb3d2502c925e) )
	ROM_LOAD( "s22.5at",    0x3000, 0x1000, CRC(592e538c) SHA1(8b8dca78149df5c2190a1eadda8ad6374b59d58d) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "s23.4m",     0x0000, 0x0800, CRC(7b285f39) SHA1(0826a9c69226a4aaa663170c032f87c8dfd89664) )
	ROM_LOAD( "s23.4n",     0x0800, 0x0800, CRC(979ca7dc) SHA1(b685aaae4c7512abc55a6ba8a72ea6eaf9214064) )
	ROM_LOAD( "s23.4r",     0x1000, 0x0800, CRC(63fee21c) SHA1(1b1c2826597e9d958241ee7ee5e6a1c8a570bb3e) )
	ROM_LOAD( "s23.4s",     0x1800, 0x0800, CRC(d9a8536e) SHA1(3fe4edbc1d5e42506f2dbadc548538276581839e) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkrdemo )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkrdemo.5et",    0x0000, 0x1000, CRC(f9fdff29) SHA1(c2eb8f0ede8384369e17d8616f4ce063ae12b6c2) )
	ROM_LOAD( "dkrdemo.5ct",    0x1000, 0x1000, CRC(f48cb898) SHA1(470b8bee7f55e1d828abc0b1ec4b423392c83a78) )
	ROM_LOAD( "dkrdemo.5bt",    0x2000, 0x1000, CRC(660d43ec) SHA1(8bba334cec022ea851c4a82f6ecbc91c0708daea) )
	ROM_LOAD( "dkrdemo.5at",    0x3000, 0x1000, CRC(e59d406c) SHA1(7698e319ae191bb8bf7deeea5c4f18da04d73f73) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( nadkong )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",    0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "nadkong.5h",     0x0000, 0x0800, CRC(88772f5b) SHA1(0fd6cbb593e87b863eb317b063151ef3b81565c2) )
	ROM_LOAD( "nadkong.3p",     0x0800, 0x0800, CRC(4c8aa728) SHA1(a277988d48f0d2f5d7cf9ef05eef222a36248cd3) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "nadkong.4m",     0x0000, 0x0800, CRC(2afbf9e6) SHA1(51e4f2f67903158b77574d55fcd17f302bc04a52) )
	ROM_LOAD( "nadkong.4n",     0x0800, 0x0800, CRC(4f077877) SHA1(4f2c2bc693b0e8d36114024b6eaeb37a3b5d853d) )
	ROM_LOAD( "nadkong.4r",     0x1000, 0x0800, CRC(d868da93) SHA1(c1c5d21f8c6a057fd5f54cab1eb4dbef06120405) )
	ROM_LOAD( "nadkong.4s",     0x1800, 0x0800, CRC(7ebfe9f3) SHA1(75bd16e9590ada93b061dee3ec7916e1e1f113c3) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkong2m )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",    0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_bm.bin",    0x0000, 0x0800, CRC(4b67ccf9) SHA1(8206436a0e5d1f7d5569f918eb87102f03b6cea3) )
	ROM_LOAD( "l_4n_bm.bin",    0x0800, 0x0800, CRC(32a708cb) SHA1(2c8b4d5179f10fb2e8e9da2012419bdfb436a545) )
	ROM_LOAD( "l_4r_bm.bin",    0x1000, 0x0800, CRC(22b5d5c4) SHA1(6bf39a5766786023cc18620283f12dbb9194cbfd) )
	ROM_LOAD( "l_4s_bm.bin",    0x1800, 0x0800, CRC(b212b185) SHA1(03d3586e80cafd2440d03d60b7a4c8808b0c6caa) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongpac )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "dkongpac.5a",    0x3000, 0x1000, CRC(56d28137) SHA1(62ad0783df4a4d8a7c45693966858b69343045ff) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongpac.3n",    0x0000, 0x0800, CRC(1beba830) SHA1(04dce2464d0627b78d185924706f8ca38892d6d3) )
	ROM_LOAD( "dkongpac.3p",    0x0800, 0x0800, CRC(94d61766) SHA1(f45f10d523fefe0581dde42450b713cb94ce2072) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkongpac.7c",    0x0000, 0x0800, CRC(065e2713) SHA1(a32d506a247a692a10962c9e47024d51bbb52d22) )
	ROM_LOAD( "dkongpac.7d",    0x0800, 0x0800, CRC(a84b347d) SHA1(5a3e6fa3d520aef3c529e515d1e9fa464cbc6a78) )
	ROM_LOAD( "dkongpac.7e",    0x1000, 0x0800, CRC(6ae6f476) SHA1(a79927a1c7511bf510107d9ba5fcc8f284541259) )
	ROM_LOAD( "dkongpac.7f",    0x1800, 0x0800, CRC(9d293922) SHA1(14af1cd7f9854dec820c899d999be4623d0048b0) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "s19.2k",         0x0000, 0x0100, CRC(1e82d375) SHA1(8f2da5cedd1f62be08555dd0eb929eb41da5079d) )
	ROM_LOAD( "s19.2j",         0x0100, 0x0100, CRC(2ab01dc8) SHA1(c25958d0706cabf997efe16fad71f454fc1ced0b) )
	ROM_LOAD( "s19.5e",         0x0200, 0x0100, CRC(44988665) SHA1(68c474fc81aff46eae6c9a7ac6ab80288303e291) )
ROM_END


ROM_START( dkrainbow )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",    0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "rainbow_c.2k",   0x0000, 0x0100, CRC(c0dce2f5) SHA1(d2195886f509359ac483fd6c96a0477eef514929) )
	ROM_LOAD( "rainbow_c.2j",   0x0100, 0x0100, CRC(03c3153f) SHA1(611267c0a205c9fe258451b7b5545c7a3d2fb541) )
	ROM_LOAD( "rainbow_v.5e",   0x0200, 0x0100, CRC(d9f3005a) SHA1(c4f09f27f5c78d95d31e6af1b8a977b86bbab9a4) )
ROM_END


ROM_START( dkchrmx )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",    0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x10000, "braze", 0 )
	ROM_LOAD( "dkchrmx.bin",    0x0000, 0x10000, CRC(e5273cee) SHA1(c440d47e7e3ca356ae1d748cc673393efb2b6c4a) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.ch",      0x0000, 0x0800, CRC(0b92cc7a) SHA1(cd217c2b45a86744c2fc7df8a3b624489e07f01f) )
	ROM_LOAD( "v_3pt.ch",       0x0800, 0x0800, CRC(6a04f93f) SHA1(b78342f89186c3d2b83fff6fd208afaba4584a5c) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.ch",      0x0000, 0x0800, CRC(c6ddc85f) SHA1(4f19be0904460ec8494bad13b3b55292889e7400) )
	ROM_LOAD( "l_4n_b.ch",      0x0800, 0x0800, CRC(2cd9cfdf) SHA1(fd9b0b75084661441680188ef3faf233579ceeb7) )
	ROM_LOAD( "l_4r_b.ch",      0x1000, 0x0800, CRC(c1ea6688) SHA1(3509bb96d2da1f364d0cb4c60636933cdd42f6e3) )
	ROM_LOAD( "l_4s_b.ch",      0x1800, 0x0800, CRC(9473d658) SHA1(2c5acf47c0ab8bd2e863e9bdea018d17ac4c96c8) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.ch",        0x0000, 0x0100, CRC(c6cee97e) SHA1(6590b6815a0cb19b800bce0f504494217977ae44) )
	ROM_LOAD( "c-2j.ch",        0x0100, 0x0100, CRC(1f64ac3d) SHA1(0591495a75a301772856c121f34299da4f9df341) )
	ROM_LOAD( "v-5e.ch",        0x0200, 0x0100, CRC(5a8ca805) SHA1(8e711af73ddb20ed62a9a8b53f1150feab1dc051) )
ROM_END


ROM_START( dkremix )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",    0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x10000, "braze", 0 )
	ROM_LOAD( "dkremix.bin",    0x0000, 0x10000, CRC(f47c13aa) SHA1(c8516e27028d371a1f7b198f6d91f6a10bf99d3f) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkremix.5h",     0x0000, 0x0800, CRC(fc82b069) SHA1(ae78e6de0b50149a55f10f480c522f7a147ea106) )
	ROM_LOAD( "dkremix.3pt",    0x0800, 0x0800, CRC(fe32ee33) SHA1(6723190916e1eab713ad945fc942f47e2c6a6892) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkremix.4m",     0x0000, 0x0800, CRC(3d9784d7) SHA1(98958b27d7be8c2df1e0dc882930aada457fb788) )
	ROM_LOAD( "dkremix.4n",     0x0800, 0x0800, CRC(084c960a) SHA1(f5f5f0c4da2bd3a0c07dafadf4649d505b24c98e) )
	ROM_LOAD( "dkremix.4r",     0x1000, 0x0800, CRC(9ac5d874) SHA1(3064434d8ee154feba89006c7ac28a3816524509) )
	ROM_LOAD( "dkremix.4s",     0x1800, 0x0800, CRC(74a5d517) SHA1(0d9830e49488f85be43a9c8f8c60bcb7f9f46baf) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkchrte )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",    0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x10000, "braze", 0 )
	ROM_LOAD( "dkchrte.bin",    0x0000, 0x10000, CRC(3d6b05f6) SHA1(2fcfbe81f00ee8c672edaf869b28620fb2ab2944) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkchrte.5h",     0x0000, 0x0800, CRC(0bdb6d28) SHA1(f95394d1b9a18dbda25af0e56f3f7c7ad3d37799) )
	ROM_LOAD( "dkchrte.3pt",    0x0800, 0x0800, CRC(6bb0affb) SHA1(ca72ee4435f34c656963f712d5dee5ba865e0c85) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkchrte.4m",     0x0000, 0x0800, CRC(3282f0a1) SHA1(c8034fdc3acc013e3f497c14f26a3800e507dee8) )
	ROM_LOAD( "dkchrte.4n",     0x0800, 0x0800, CRC(89ebf388) SHA1(c567ee4ac9e5bcf32d12eef7319dc30ca2d093d0) )
	ROM_LOAD( "dkchrte.4r",     0x1000, 0x0800, CRC(fe8b84a8) SHA1(0a43cadbda6e91ddf937561622c63faa0ff7fab6) )
	ROM_LOAD( "dkchrte.4s",     0x1800, 0x0800, CRC(3b18ae70) SHA1(5a4b485a379d8282dab033dc77fa361f6fef5e51) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.ch",        0x0000, 0x0100, CRC(c6cee97e) SHA1(6590b6815a0cb19b800bce0f504494217977ae44) )
	ROM_LOAD( "c-2j.ch",        0x0100, 0x0100, CRC(1f64ac3d) SHA1(0591495a75a301772856c121f34299da4f9df341) )
	ROM_LOAD( "v-5e.ch",        0x0200, 0x0100, CRC(5a8ca805) SHA1(8e711af73ddb20ed62a9a8b53f1150feab1dc051) )
ROM_END


ROM_START( dkspkyrmx )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",    0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",    0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",    0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x10000, "braze", 0 )
	ROM_LOAD( "dkspkyrmx.bin",  0x0000, 0x8000, CRC(e68c6bfc) SHA1(e68442aadf89d2a783083d0648c95252b6a7ede1) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.sp",      0x0000, 0x0800, CRC(b70b0904) SHA1(ee06b0fd5d6a212e688ef83d04f5529b55cd1245) )
	ROM_LOAD( "v_3pt.sp",       0x0800, 0x0800, CRC(be8c92c3) SHA1(33b2740cda696dc24f47b33b6427438b31e38125) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.sp",      0x0000, 0x0800, CRC(1d0b3b77) SHA1(4f74cf19e6f74a5686482fde766a5ad45a86af68) )
	ROM_LOAD( "l_4n_b.sp",      0x0800, 0x0800, CRC(cd717e7c) SHA1(e813c3714abf737e6a9f8d6ec87ec0de85306dc1) )
	ROM_LOAD( "l_4r_b.sp",      0x1000, 0x0800, CRC(d019732b) SHA1(44f695103579b1583942627434d6f5801f504cb5) )
	ROM_LOAD( "l_4s_b.sp",      0x1800, 0x0800, CRC(04272273) SHA1(4d66296f228cfc07f12ab7cfd1b7af99bd54e574) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.sp",        0x0000, 0x0100, CRC(a837a227) SHA1(f5ebbedbc86153864b1bcfa26ab35eeb8856c7e0) )
	ROM_LOAD( "c-2j.sp",        0x0100, 0x0100, CRC(244a89f9) SHA1(4a59233a4bad4c941aa3aad85d895e8c04d34436) )
	ROM_LOAD( "v-5e.sp",        0x0200, 0x0100, CRC(c70b6f9b) SHA1(e9f465de5e990478e96be1501cb8c5fc16b3c86e) )
ROM_END


ROM_START( dkongte )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",  0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",  0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",  0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",  0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x10000, "braze", 0 )
	ROM_LOAD( "d2k11.te",     0x00000, 0x10000, CRC(55fc9018) SHA1(48a53e9504c1d4b37ed79e06f59da5e96c1a3524) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",   0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",    0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",   0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",   0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",   0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",   0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",     0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkspkyte )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "c_5et_g.bin",  0x0000, 0x1000, CRC(ba70b88b) SHA1(d76ebecfea1af098d843ee7e578e480cd658ac1a) )
	ROM_LOAD( "c_5ct_g.bin",  0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "c_5bt_g.bin",  0x2000, 0x1000, CRC(1c97d324) SHA1(c7966261f3a1d3296927e0b6ee1c58039fc53c1f) )
	ROM_LOAD( "c_5at_g.bin",  0x3000, 0x1000, CRC(b9005ac0) SHA1(3fe3599f6fa7c496f782053ddf7bacb453d197c4) )

	ROM_REGION( 0x10000, "braze", 0 )
	ROM_LOAD( "d2k11.spte",   0x00000, 0x10000, CRC(2bb8d91e) SHA1(1b5246944c715ffd190addd5003bdd27577fae2e) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.spte",  0x0000, 0x0800, CRC(ebc5d9cc) SHA1(f4b0bcf3d48dd2d92d7bbb25c711ac0820c30142) )
	ROM_LOAD( "v_3pt.spte",   0x0800, 0x0800, CRC(9d881b5f) SHA1(42c8070250a356db452e4d008875d20b61082194) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.sp",    0x0000, 0x0800, CRC(1d0b3b77) SHA1(4f74cf19e6f74a5686482fde766a5ad45a86af68) )
	ROM_LOAD( "l_4n_b.sp",    0x0800, 0x0800, CRC(cd717e7c) SHA1(e813c3714abf737e6a9f8d6ec87ec0de85306dc1) )
	ROM_LOAD( "l_4r_b.sp",    0x1000, 0x0800, CRC(d019732b) SHA1(44f695103579b1583942627434d6f5801f504cb5) )
	ROM_LOAD( "l_4s_b.sp",    0x1800, 0x0800, CRC(04272273) SHA1(4d66296f228cfc07f12ab7cfd1b7af99bd54e574) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.sp",      0x0000, 0x0100, CRC(a837a227) SHA1(f5ebbedbc86153864b1bcfa26ab35eeb8856c7e0) )
	ROM_LOAD( "c-2j.sp",      0x0100, 0x0100, CRC(244a89f9) SHA1(4a59233a4bad4c941aa3aad85d895e8c04d34436) )
	ROM_LOAD( "v-5e.sp",      0x0200, 0x0100, CRC(c70b6f9b) SHA1(e9f465de5e990478e96be1501cb8c5fc16b3c86e) )
ROM_END


ROM_START( dktrain )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkt.5et",        0x0000, 0x1000, CRC(7ed5a945) SHA1(27ea2b9ca8e03a660943b043a2880c95a4f92de8) )
	ROM_LOAD( "dkt.5ct",        0x1000, 0x1000, CRC(98e2caa8) SHA1(5289f2268bac39bd04da8b9b94e25e55e4ea8e04) )
	ROM_LOAD( "dkt.5bt",        0x2000, 0x1000, CRC(098a840a) SHA1(05ea657be2de863fb8a42bf1e173a6a80fb16cc7) )
	ROM_LOAD( "dkt.5at",        0x3000, 0x1000, CRC(dd092591) SHA1(36455e5a689a926b79be79e38d96ad8fe2ce7417) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dktrain2 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkt2.5et",       0x0000, 0x1000, CRC(c7dc68c4) SHA1(5cc76f41e09132143620230ed9f63cc7621203c9) )
	ROM_LOAD( "dkt2.5ct",       0x1000, 0x1000, CRC(1a7c2bb8) SHA1(e6b6d17331e3fc74d83285b74563955f8e97ee66) )
	ROM_LOAD( "dkt2.5bt",       0x2000, 0x1000, CRC(dc4cbd2f) SHA1(eaf87adb9252b6bbdceaee9f7c5e791e939cc25f) )
	ROM_LOAD( "dkt2.5at",       0x3000, 0x1000, CRC(36e333d2) SHA1(207f51d7ef53e7c6d9db2b7cb7a2ded49ffa2db5) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkpace )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkp.5et",        0x0000, 0x1000, CRC(e05563d5) SHA1(db17bf866e223a5b57e3fdd23f79f1f8ca67f697) )
	ROM_LOAD( "dkp.5ct",        0x1000, 0x1000, CRC(88aa1ddf) SHA1(d1582ba10cf15b24286524fa494279a4d25adfbb) )
	ROM_LOAD( "dkp.5bt",        0x2000, 0x1000, CRC(8ee0b1d2) SHA1(7cae6b1b3143fbf1c2ad0cbfa7855eb1c9519fde) )
	ROM_LOAD( "dkp.5at",        0x3000, 0x1000, CRC(0bc9c8db) SHA1(8e51b4d6905d8321c9d29e51d830c8554a94f664) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongbcc )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkbcc.5et",      0x0000, 0x1000, CRC(eec71586) SHA1(8c9c05c919265d6b930e5088e869c4b44264ded4) )
	ROM_LOAD( "dkbcc.5ct",      0x1000, 0x1000, CRC(49200edb) SHA1(e40a19700196dc7b2ae766cbef51867856c986aa) )
	ROM_LOAD( "dkbcc.5bt",      0x2000, 0x1000, CRC(56f7c409) SHA1(265817ce17951d49b95a2361c5cc3032620aae96) )
	ROM_LOAD( "dkbcc.5at",      0x3000, 0x1000, CRC(03b56372) SHA1(fea19bb4c46c88c26943ccd910b560cecd5dc44c) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkcbarrel )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkcbarrel.5et",  0x0000, 0x1000, CRC(78e37c41) SHA1(1a30f11d6c49f168da9ccb7bda44e2d001544177) )
	ROM_LOAD( "dkcbarrel.5ct",  0x1000, 0x1000, CRC(a46cbb85) SHA1(f19a397b0556676dbc854b3072a0f48660759d8a) )
	ROM_LOAD( "dkcbarrel.5bt",  0x2000, 0x1000, CRC(07da5b15) SHA1(14f0a510783ce618c1acdcef35837f0dc3fbd370) )
	ROM_LOAD( "dkcbarrel.5at",  0x3000, 0x1000, CRC(515e0639) SHA1(c556cc9aa67cb36fa3aad6b4ad4d5e726b35378a) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkfreerun )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkfreerun.5et",  0x0000, 0x1000, CRC(2b85ddf0) SHA1(61a0cb413e4ec794ee5997f7b67f36645f9af03b) )
	ROM_LOAD( "dkfreerun.5ct",  0x1000, 0x1000, CRC(ef7e15d7) SHA1(22a8c25eed51b7fc4bbcc09ae87fc24baf688983) )
	ROM_LOAD( "dkfreerun.5bt",  0x2000, 0x1000, CRC(cb390d7c) SHA1(13dc382a543d216772858451be749534337c5163) )
	ROM_LOAD( "dkfreerun.5at",  0x3000, 0x1000, CRC(76fb86ba) SHA1(9934df182b54fdc7f5e551eb07e236550308ec73) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongrev )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongrev.5et",   0x0000, 0x1000, CRC(ee02057e) SHA1(4d035ed48d8ff6f602cc8892033c28a784242787) )
	ROM_LOAD( "dkongrev.5ct",   0x1000, 0x1000, CRC(e6fabd0f) SHA1(53782655b5cbdeb78abff9a5194467c82ff8f48e) )
	ROM_LOAD( "dkongrev.5bt",   0x2000, 0x1000, CRC(31c5bea3) SHA1(d92c86ef55c09d9e038551f8c69c7777fd71c11a) )
	ROM_LOAD( "dkongrev.5at",   0x3000, 0x1000, CRC(c7d04ef3) SHA1(33224c6c869a898212a4b3b5f56bd80b3dbd4bac) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongrnd0 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongrnd0.5at",  0x3000, 0x1000, CRC(71356cfe) SHA1(8f426c8d80523e3dcd4cdf3dec544e09eda5d980) )
	ROM_LOAD( "dkongchm.5bt",   0x2000, 0x1000, CRC(fce41e06) SHA1(fdab4f37f914d56a28092592f9cbb3d2502c925e) )
	ROM_LOAD( "dkongrnd0.5ct",  0x1000, 0x1000, CRC(e25eccf8) SHA1(9fe57daf894d78f07092262682a78b22360d8b57) )
	ROM_LOAD( "dkongrnd0.5et",  0x0000, 0x1000, CRC(c450e88c) SHA1(d4de8bf551e8416329771a7c68c4eb79b4ea1bb0) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongrnd.5h",    0x0000, 0x0800, CRC(17ef76ad) SHA1(ca58ae7de241417f05a510b459db16f1f2120cd0) )
	ROM_LOAD( "dkongrnd.3pt",   0x0800, 0x0800, CRC(49d408cd) SHA1(562751627dc050a13552f401221806b30797afd4) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongrnd ) // some sound issues
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongrnd.5et",   0x0000, 0x1000, CRC(fc29f234) SHA1(6e55ca043699ed12b08cd0658bdd98a195c89380) )
	ROM_LOAD( "dkongrnd.5ct",   0x1000, 0x1000, CRC(49e16508) SHA1(b67d5b94685a7193ae674f2a78f69bf7d678d707) )
	ROM_LOAD( "dkongchm.5bt",   0x2000, 0x1000, CRC(fce41e06) SHA1(fdab4f37f914d56a28092592f9cbb3d2502c925e) )
	ROM_LOAD( "dkongrnd.5at",   0x3000, 0x1000, CRC(86723e5d) SHA1(88e8b4209eaad14902cb2aaf9886727007e9b0ed) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongrnd.5h",    0x0000, 0x0800, CRC(17ef76ad) SHA1(ca58ae7de241417f05a510b459db16f1f2120cd0) )
	ROM_LOAD( "dkongrnd.3pt",   0x0800, 0x0800, CRC(49d408cd) SHA1(562751627dc050a13552f401221806b30797afd4) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkrndmzr )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkrndmzr.5et",   0x0000, 0x1000, CRC(281b9bb6) SHA1(b8602325070ace94928c0431c5ecb55e22c55c97) )
	ROM_LOAD( "dkrndmzr.5ct",   0x1000, 0x1000, CRC(7fa1be23) SHA1(3c79c2a5df44b60ccf9c46ffdef65d1f02f738bc) )
	ROM_LOAD( "dkrndmzr.5bt",   0x2000, 0x1000, CRC(50ad6d22) SHA1(b3187bc24245740e0c617d35b968fe5371492cf8) )
	ROM_LOAD( "dkrndmzr.5at",   0x3000, 0x1000, CRC(4c9e7085) SHA1(6b8fefd44426848407e8a2f4f7010751dcf8cf39) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkrndmzr.5h",    0x0000, 0x0800, CRC(c77456de) SHA1(130ad5ea31a485169dcbdd719ec9753f4f125567) )
	ROM_LOAD( "dkrndmzr.3pt",   0x0800, 0x0800, CRC(994f28be) SHA1(dd21af28b39b8b7963b083556abc5565213621ea) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongklc )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongchm.5et",   0x0000, 0x1000, CRC(26890d72) SHA1(3d32d8d892ea7256882528f07236db4c0c225220) )
	ROM_LOAD( "dkongchm.5ct",   0x1000, 0x1000, CRC(d5965c23) SHA1(266f8864b3e27cb4327e17eaf122e21b3b8909b8) )
	ROM_LOAD( "dkongchm.5bt",   0x2000, 0x1000, CRC(fce41e06) SHA1(fdab4f37f914d56a28092592f9cbb3d2502c925e) )
	ROM_LOAD( "dkongchm.5at",   0x3000, 0x1000, CRC(c48a4053) SHA1(a0a4282e75b6e44e2ce9162329a568c5d1676944) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.chm",     0x0000, 0x0800, CRC(a7a3772b) SHA1(09cff96e166794154aca8f6899a08d1637827cc0) )
	ROM_LOAD( "v_3pt.chm",      0x0800, 0x0800, CRC(72b0b861) SHA1(6517b7a4f8d4f9db483ea2b72ebb9e45cebb4cd5) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongce )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongchm.5et",   0x0000, 0x1000, CRC(26890d72) SHA1(3d32d8d892ea7256882528f07236db4c0c225220) )
	ROM_LOAD( "dkongchm.5ct",   0x1000, 0x1000, CRC(d5965c23) SHA1(266f8864b3e27cb4327e17eaf122e21b3b8909b8) )
	ROM_LOAD( "dkongchm.5bt",   0x2000, 0x1000, CRC(fce41e06) SHA1(fdab4f37f914d56a28092592f9cbb3d2502c925e) )
	ROM_LOAD( "dkongchm1.5at",  0x3000, 0x1000, CRC(458ff9b9) SHA1(81c5874fd03fbd32f9c83ca5534f66a41ffc1fe4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongst )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongst.5et",    0x0000, 0x1000, CRC(8fb6e908) SHA1(f361699ef3ba76e3734dfe31dedeb4363ac7f837) )
	ROM_LOAD( "dkongst.5ct",    0x1000, 0x1000, CRC(c9d766ea) SHA1(0e4d6fc04e88c4622a63fccf49cdfa2e008210cf) )
	ROM_LOAD( "dkongst.5bt",    0x2000, 0x1000, CRC(aef88ff5) SHA1(621300c9a43c000958aa8a11e7ff0cf2d14a2d32) )
	ROM_LOAD( "dkongst.5at",    0x3000, 0x1000, CRC(5cf3774b) SHA1(7061fb739b03d947a320a2ce3a11598ef520d586) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongst2 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongst2.5et",   0x0000, 0x1000, CRC(21ddc6cc) SHA1(4473f7656462bc3bc319d0f01c1742003d27cbb0) )
	ROM_LOAD( "dkongst2.5ct",   0x1000, 0x1000, CRC(fa14da2c) SHA1(3011062ee771f621f359f0fa68bf85ccb76e2989) )
	ROM_LOAD( "dkongst2.5bt",   0x2000, 0x1000, CRC(32a8f924) SHA1(540de355eab7ca7068e655de72dfbdb4015098ee) )
	ROM_LOAD( "dkongst2.5at",   0x3000, 0x0f00, CRC(27b9c90d) SHA1(5b5e92d35a0b487cd1b618ddded80a9e33ee2ca9) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongss )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongss.5et",    0x0000, 0x1000, CRC(87c65c59) SHA1(51f3d6160f58449ff9a8a5374ced4fe5b5af86b4) )
	ROM_LOAD( "c_5ct_g.bin",    0x1000, 0x1000, CRC(5ec461ec) SHA1(acb11a8fbdbb3ab46068385fe465f681e3c824bd) )
	ROM_LOAD( "dkongss.5bt",    0x2000, 0x1000, CRC(f31c0c47) SHA1(1cd546e4e1924fedcb44894c43345fe2680d6f8a) )
	ROM_LOAD( "dkongss.5at",    0x3000, 0x1000, CRC(87d58e2e) SHA1(46c940a0fd0c15bfa6c304699bef29542aabab32) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongotr6 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongotr6.5at",  0x3000, 0x1000, CRC(6d9b3599) SHA1(2858e01ee7d5625a4b62a72a3d375e033a297e81) )
	ROM_LOAD( "dkongotr6.5bt",  0x2000, 0x1000, CRC(942efe0d) SHA1(0bc648452c1f9845a527d457a78aa5b8b9218c9c) )
	ROM_LOAD( "dkongotr6.5ct",  0x1000, 0x1000, CRC(1f669217) SHA1(e9efcbf407a98ed2be44f4a35cc24fff2fbd12e9) )
	ROM_LOAD( "dkongotr6.5et",  0x0000, 0x1000, CRC(3f5e2a9b) SHA1(e84005f6ce07310e306bfc27559389ce90cf4233) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongotr6.3pt",  0x0800, 0x0800, CRC(afbbd1e3) SHA1(55f06467c0aa5e99572f6083d3b7719c7e7155ae) )
	ROM_LOAD( "dkongotr6.5h",   0x0000, 0x0800, CRC(4754cb2d) SHA1(d7079408aedd5fb06fa6eb7557ce9ceb0dfd82d3) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkongotr6.4m",   0x0000, 0x0800, CRC(f224b2bc) SHA1(718368f6cfa41b73365e9da0705774fe41ca20bb) )
	ROM_LOAD( "dkongotr6.4n",   0x0800, 0x0800, CRC(def8bca4) SHA1(bd39b9a9fa0577fe38abf2576de2be43e792e513) )
	ROM_LOAD( "dkongotr6.4r",   0x1000, 0x0800, CRC(59e3e846) SHA1(444af5f47f7abd971a17313947500c083dc8caa1) )
	ROM_LOAD( "dkongotr6.4s",   0x1800, 0x0800, CRC(b5a2e920) SHA1(1ff2143539410b83139fccab0c799d39f61bf76c) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongotr7 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongotr7.5at",  0x3000, 0x1000, CRC(ec18bc3c) SHA1(b0ad1f15ec4b07718e20f022030878446cb5ce4a) )
	ROM_LOAD( "dkongotr7.5bt",  0x2000, 0x1000, CRC(482f4a98) SHA1(24520e5462be8f4e603dad2446c219ce2fbee805) )
	ROM_LOAD( "dkongotr6.5ct",  0x1000, 0x1000, CRC(1f669217) SHA1(e9efcbf407a98ed2be44f4a35cc24fff2fbd12e9) )
	ROM_LOAD( "dkongotr7.5et",  0x0000, 0x1000, CRC(6a52532c) SHA1(7d612b87ad85d4d533c2ce049ca67b0ed1a141fe) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongotr7.3pt",  0x0800, 0x0800, CRC(bfb2c04f) SHA1(85b32c16537f53348489c6b9224822090a6b9789) )
	ROM_LOAD( "dkongotr7.5h",   0x0000, 0x0800, CRC(0d588de5) SHA1(17f133823dba09969d035907f4de154a0b859dc7) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkongotr6.4m",   0x0000, 0x0800, CRC(f224b2bc) SHA1(718368f6cfa41b73365e9da0705774fe41ca20bb) )
	ROM_LOAD( "dkongotr6.4n",   0x0800, 0x0800, CRC(def8bca4) SHA1(bd39b9a9fa0577fe38abf2576de2be43e792e513) )
	ROM_LOAD( "dkongotr6.4r",   0x1000, 0x0800, CRC(59e3e846) SHA1(444af5f47f7abd971a17313947500c083dc8caa1) )
	ROM_LOAD( "dkongotr6.4s",   0x1800, 0x0800, CRC(b5a2e920) SHA1(1ff2143539410b83139fccab0c799d39f61bf76c) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongotr8 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongotr8.5at",  0x3000, 0x1000, CRC(83f713d8) SHA1(f9e4e14b64e0c7f851b72e9b8ac8600429a13548) )
	ROM_LOAD( "dkongotr8.5bt",  0x2000, 0x1000, CRC(d029c495) SHA1(3fc4a883ff7028a399a3452dcacee74fa50cc3db) )
	ROM_LOAD( "dkongotr8.5ct",  0x1000, 0x1000, CRC(6d692d1b) SHA1(d6eff5b4718301ee425384a5ad9f286b3683c892) )
	ROM_LOAD( "dkongotr8.5et",  0x0000, 0x1000, CRC(243cb649) SHA1(5585c1d35863a290606345dfcd0e6190372c9a56) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongotr7.3pt",  0x0800, 0x0800, CRC(bfb2c04f) SHA1(85b32c16537f53348489c6b9224822090a6b9789) )
	ROM_LOAD( "dkongotr7.5h",   0x0000, 0x0800, CRC(0d588de5) SHA1(17f133823dba09969d035907f4de154a0b859dc7) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkongotr6.4m",   0x0000, 0x0800, CRC(f224b2bc) SHA1(718368f6cfa41b73365e9da0705774fe41ca20bb) )
	ROM_LOAD( "dkongotr6.4n",   0x0800, 0x0800, CRC(def8bca4) SHA1(bd39b9a9fa0577fe38abf2576de2be43e792e513) )
	ROM_LOAD( "dkongotr6.4r",   0x1000, 0x0800, CRC(59e3e846) SHA1(444af5f47f7abd971a17313947500c083dc8caa1) )
	ROM_LOAD( "dkongotr6.4s",   0x1800, 0x0800, CRC(b5a2e920) SHA1(1ff2143539410b83139fccab0c799d39f61bf76c) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongotr9 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongotr9.5at",  0x3000, 0x1000, CRC(e380a2fb) SHA1(7b40d9ff32c22cb4209469d039ce89e399bf3a7e) )
	ROM_LOAD( "dkongotr8.5bt",  0x2000, 0x1000, CRC(d029c495) SHA1(3fc4a883ff7028a399a3452dcacee74fa50cc3db) )
	ROM_LOAD( "dkongotr8.5ct",  0x1000, 0x1000, CRC(6d692d1b) SHA1(d6eff5b4718301ee425384a5ad9f286b3683c892) )
	ROM_LOAD( "dkongotr9.5et",  0x0000, 0x1000, CRC(9ef703dd) SHA1(ada898fcc900581c0a55e6ed58598960ce98f12f) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongotr7.3pt",  0x0800, 0x0800, CRC(bfb2c04f) SHA1(85b32c16537f53348489c6b9224822090a6b9789) )
	ROM_LOAD( "dkongotr7.5h",   0x0000, 0x0800, CRC(0d588de5) SHA1(17f133823dba09969d035907f4de154a0b859dc7) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkongotr6.4m",   0x0000, 0x0800, CRC(f224b2bc) SHA1(718368f6cfa41b73365e9da0705774fe41ca20bb) )
	ROM_LOAD( "dkongotr6.4n",   0x0800, 0x0800, CRC(def8bca4) SHA1(bd39b9a9fa0577fe38abf2576de2be43e792e513) )
	ROM_LOAD( "dkongotr6.4r",   0x1000, 0x0800, CRC(59e3e846) SHA1(444af5f47f7abd971a17313947500c083dc8caa1) )
	ROM_LOAD( "dkongotr6.4s",   0x1800, 0x0800, CRC(b5a2e920) SHA1(1ff2143539410b83139fccab0c799d39f61bf76c) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongotr )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongotr.5et",   0x0000, 0x1000, CRC(fd64526a) SHA1(73e0cd21eb6befd5f370267811e83b4326dd4046) )
	ROM_LOAD( "dkongotr8.5ct",  0x1000, 0x1000, CRC(6d692d1b) SHA1(d6eff5b4718301ee425384a5ad9f286b3683c892) )
	ROM_LOAD( "dkongotr8.5bt",  0x2000, 0x1000, CRC(d029c495) SHA1(3fc4a883ff7028a399a3452dcacee74fa50cc3db) )
	ROM_LOAD( "dkongotr.5at",   0x3000, 0x1000, CRC(9b58b813) SHA1(72fd12e0ed25dfb3d9084666ea61b472d117e76e) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongotr7.5h",   0x0000, 0x0800, CRC(0d588de5) SHA1(17f133823dba09969d035907f4de154a0b859dc7) )
	ROM_LOAD( "dkongotr7.3pt",  0x0800, 0x0800, CRC(bfb2c04f) SHA1(85b32c16537f53348489c6b9224822090a6b9789) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkongotr6.4m",   0x0000, 0x0800, CRC(f224b2bc) SHA1(718368f6cfa41b73365e9da0705774fe41ca20bb) )
	ROM_LOAD( "dkongotr6.4n",   0x0800, 0x0800, CRC(def8bca4) SHA1(bd39b9a9fa0577fe38abf2576de2be43e792e513) )
	ROM_LOAD( "dkongotr6.4r",   0x1000, 0x0800, CRC(59e3e846) SHA1(444af5f47f7abd971a17313947500c083dc8caa1) )
	ROM_LOAD( "dkongotr6.4s",   0x1800, 0x0800, CRC(b5a2e920) SHA1(1ff2143539410b83139fccab0c799d39f61bf76c) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongitd )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongitd.5et",   0x0000, 0x1000, CRC(abddd83e) SHA1(37b4926f5bde6aba40c638884b3aa0e0a866d16a) )
	ROM_LOAD( "dkongitd.5ct",   0x1000, 0x1000, CRC(ee146d99) SHA1(67f1e176d5b189b25f3a99c9072752cb0b7122b9) )
	ROM_LOAD( "dkongchm.5bt",   0x2000, 0x1000, CRC(fce41e06) SHA1(fdab4f37f914d56a28092592f9cbb3d2502c925e) )
	ROM_LOAD( "dkongitd.5at",   0x3000, 0x1000, CRC(6b8d5524) SHA1(88ea04ae7ae3ba89c55a00ec1a23b7515225f9e9) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongitd.5h",    0x0000, 0x0800, CRC(3d4ea8f8) SHA1(1726ad8de28e71c823b20296915623c8123f6165) )
	ROM_LOAD( "dkongitd.3pt",   0x0800, 0x0800, CRC(0979cf74) SHA1(6bce6b924a64b1e9260c228f538fc16ab380a87c) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkongitd.4m",    0x0000, 0x0800, CRC(21a04aa5) SHA1(65333757f6c640a32fffa5fef5fb26ed33579857) )
	ROM_LOAD( "dkongitd.4n",    0x0800, 0x0800, CRC(27ddec12) SHA1(c863b9c79510f20506865f9baadb9b6db43ba7dd) )
	ROM_LOAD( "dkongitd.4r",    0x1000, 0x0800, CRC(ddfee3e1) SHA1(8b6c27a71a749e329545b409692d735353e4f193) )
	ROM_LOAD( "dkongitd.4s",    0x1800, 0x0800, CRC(42d26b1b) SHA1(4b4b0f891865f009763e8d447f57fde5c0dd37ff) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkongitd.2k",    0x0000, 0x0100, CRC(8d918467) SHA1(a2e51ac14a4a6a1089a638c4c19c335be6b5a2a8) )
	ROM_LOAD( "dkongitd.2j",    0x0100, 0x0100, CRC(9aadf04a) SHA1(d88b624af808bd007e9ed05ba3e3d7f67e716da1) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dktwist0 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dktwist0.5at",   0x3000, 0x1000, CRC(efa40f57) SHA1(61899f16af335158c08bd847c692496e252c85b2) )
	ROM_LOAD( "dktwist0.5bt",   0x2000, 0x1000, CRC(efbe0c5e) SHA1(6961f773556fdc115b86e28c484feed5ce024f7d) )
	ROM_LOAD( "dktwist0.5ct",   0x1000, 0x1000, CRC(e8a247f7) SHA1(f96d50e6306c6cfc8fe05e77936f90ac1f5d2f85) )
	ROM_LOAD( "dktwist0.5et",   0x0000, 0x1000, CRC(83059998) SHA1(4ea321991afc8a6e280c0e4ab29393af4dcced12) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dktwist0.4m",    0x0000, 0x0800, CRC(95cbe0dc) SHA1(094479bd7ba8b56e2cb218b96110cdb318e473ac) )
	ROM_LOAD( "dktwist0.4n",    0x0800, 0x0800, CRC(72095b51) SHA1(955d168fa02b3cbddc43ca8ecc540bface695195) )
	ROM_LOAD( "dktwist0.4r",    0x1000, 0x0800, CRC(36d605e7) SHA1(0521d1ccf200ebe6f7f9a1d7d3041086f26cc085) )
	ROM_LOAD( "dktwist0.4s",    0x1800, 0x0800, CRC(9d0796a5) SHA1(b26f08070e5d912d1dd93b7f5f06bf1580aaf0f1) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dktwist )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dktwist.5at",    0x3000, 0x1000, CRC(a5eaceee) SHA1(ad936386642118afb40b1175c8830a3ed43612f3) )
	ROM_LOAD( "dktwist.5bt",    0x2000, 0x1000, CRC(1cbdd0a6) SHA1(cb0bde4db4dcfce5ba386061f1449b3647b36c76) )
	ROM_LOAD( "dktwist0.5ct",   0x1000, 0x1000, CRC(e8a247f7) SHA1(f96d50e6306c6cfc8fe05e77936f90ac1f5d2f85) )
	ROM_LOAD( "dktwist.5et",    0x0000, 0x1000, CRC(3b618106) SHA1(efe1c39f959665e8211285b8355200abade3f412) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "v_3pt.bin",      0x0800, 0x0800, CRC(15e9c5e9) SHA1(976eb1e18c74018193a35aa86cff482ebfc5cc4e) )
	ROM_LOAD( "v_5h_b.bin",     0x0000, 0x0800, CRC(12c8c95d) SHA1(a57ff5a231c45252a63b354137c920a1379b70a3) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dktwist0.4m",    0x0000, 0x0800, CRC(95cbe0dc) SHA1(094479bd7ba8b56e2cb218b96110cdb318e473ac) )
	ROM_LOAD( "dktwist0.4n",    0x0800, 0x0800, CRC(72095b51) SHA1(955d168fa02b3cbddc43ca8ecc540bface695195) )
	ROM_LOAD( "dktwist0.4r",    0x1000, 0x0800, CRC(36d605e7) SHA1(0521d1ccf200ebe6f7f9a1d7d3041086f26cc085) )
	ROM_LOAD( "dktwist0.4s",    0x1800, 0x0800, CRC(9d0796a5) SHA1(b26f08070e5d912d1dd93b7f5f06bf1580aaf0f1) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkjungle0 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkjungle0.5at",  0x3000, 0x1000, CRC(6e120e2b) SHA1(4d1dd8a653afbde974ad72c06f64cd1a783b0d26) )
	ROM_LOAD( "dkjungle0.5bt",  0x2000, 0x1000, CRC(6f7158a3) SHA1(450925dfb2238b891c8b0693eb3fa38d5353eaff) )
	ROM_LOAD( "dktwist0.5ct",   0x1000, 0x1000, CRC(e8a247f7) SHA1(f96d50e6306c6cfc8fe05e77936f90ac1f5d2f85) )
	ROM_LOAD( "dkjungle0.5et",  0x0000, 0x1000, CRC(8012acdd) SHA1(49d3895f68724cb221811854d6f251aa7f3173a9) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkjungle0.3pt",  0x0800, 0x0800, CRC(95408f9f) SHA1(2783148806531d427c40b45bf568b45fdd9d3d79) )
	ROM_LOAD( "dkjungle0.5h",   0x0000, 0x0800, CRC(fccb93d6) SHA1(152e83a2e3002835f260f55adb53079bb502ae6d) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkjungle0.4m",   0x0000, 0x0800, CRC(3ee61846) SHA1(9c52912911878be0eb196612b9f328b2e40f475a) )
	ROM_LOAD( "dkjungle0.4n",   0x0800, 0x0800, CRC(d928f7a8) SHA1(fa4d6896cbe6b3178e81488a0ededa921aad0238) )
	ROM_LOAD( "dkjungle0.4r",   0x1000, 0x0800, CRC(12468998) SHA1(3ff1168936ff8e034524e09f737f4f33ed7bdb91) )
	ROM_LOAD( "dkjungle0.4s",   0x1800, 0x0800, CRC(d4cba860) SHA1(4afd92bad6136f9c674e96eb16b6f07a91deb937) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkjungle0.2j",   0x0100, 0x0100, CRC(a81ca93c) SHA1(349cdb6348cbe1773f217ebacb1f0ece144fa8fd) )
	ROM_LOAD( "dkjungle0.2k",   0x0000, 0x0100, CRC(84be5373) SHA1(5d091cbe4002c7f9adbab24b7e4c31409de4be32) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkjungle )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkjungle.5at",   0x3000, 0x1000, CRC(6d1ea836) SHA1(2f59ce4b522b9c5aa1966b904a6089dfb9f9a89e) )
	ROM_LOAD( "dkjungle.5bt",   0x2000, 0x1000, CRC(b1990430) SHA1(7a99f07b95f1fb2f7ef0f443f74737153ec446ba) )
	ROM_LOAD( "dkjungle.5ct",   0x1000, 0x1000, CRC(ed5c7b13) SHA1(5c3865d50750eb4fd0fc36cccd1fbe3d7e59b29b) )
	ROM_LOAD( "dkjungle.5et",   0x0000, 0x1000, CRC(4ebc7956) SHA1(04a58199de5e247fe4335f8f1c54e5083f78934c) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkjungle0.3pt",  0x0800, 0x0800, CRC(95408f9f) SHA1(2783148806531d427c40b45bf568b45fdd9d3d79) )
	ROM_LOAD( "dkjungle0.5h",   0x0000, 0x0800, CRC(fccb93d6) SHA1(152e83a2e3002835f260f55adb53079bb502ae6d) )
 
	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkjungle.4m",    0x0000, 0x0800, CRC(5e77597e) SHA1(8b241f32bb1fec2c2a00ad75cb650c5eadc37bd3) )
	ROM_LOAD( "dkjungle.4n",    0x0800, 0x0800, CRC(715c29ff) SHA1(b5e544ebdc23b8ae236705f3f128261bb0f61ff6) )
	ROM_LOAD( "dkjungle.4r",    0x1000, 0x0800, CRC(7b24438d) SHA1(f34d532a11d0bcdd6e28cf0f4d4700e38228ff25) )
	ROM_LOAD( "dkjungle.4s",    0x1800, 0x0800, CRC(57d3989a) SHA1(3e17f2c197790a1985836ee5652288ce3bd5735d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkjungle0.2j",   0x0100, 0x0100, CRC(a81ca93c) SHA1(349cdb6348cbe1773f217ebacb1f0ece144fa8fd) )
	ROM_LOAD( "dkjungle0.2k",   0x0000, 0x0100, CRC(84be5373) SHA1(5d091cbe4002c7f9adbab24b7e4c31409de4be32) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongtj )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongtj.5et",    0x0000, 0x1000, CRC(63e2a483) SHA1(1e07674b77c51e5a50b5d7bd3bc7a77933e31d94) )
	ROM_LOAD( "dkjungle.5ct",   0x1000, 0x1000, CRC(ed5c7b13) SHA1(5c3865d50750eb4fd0fc36cccd1fbe3d7e59b29b) )
	ROM_LOAD( "dkjungle.5bt",   0x2000, 0x1000, CRC(b1990430) SHA1(7a99f07b95f1fb2f7ef0f443f74737153ec446ba) )
	ROM_LOAD( "dkongtj.5at",    0x3000, 0x1000, CRC(b4e0240a) SHA1(432a73d5f49ccd1c13402c5aac0bb64584de77ce) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkjungle0.3pt",  0x0800, 0x0800, CRC(95408f9f) SHA1(2783148806531d427c40b45bf568b45fdd9d3d79) )
	ROM_LOAD( "dkjungle0.5h",   0x0000, 0x0800, CRC(fccb93d6) SHA1(152e83a2e3002835f260f55adb53079bb502ae6d) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkjungle.4m",    0x0000, 0x0800, CRC(5e77597e) SHA1(8b241f32bb1fec2c2a00ad75cb650c5eadc37bd3) )
	ROM_LOAD( "dkjungle.4n",    0x0800, 0x0800, CRC(715c29ff) SHA1(b5e544ebdc23b8ae236705f3f128261bb0f61ff6) )
	ROM_LOAD( "dkjungle.4r",    0x1000, 0x0800, CRC(7b24438d) SHA1(f34d532a11d0bcdd6e28cf0f4d4700e38228ff25) )
	ROM_LOAD( "dkjungle.4s",    0x1800, 0x0800, CRC(57d3989a) SHA1(3e17f2c197790a1985836ee5652288ce3bd5735d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkjungle0.2k",   0x0000, 0x0100, CRC(84be5373) SHA1(5d091cbe4002c7f9adbab24b7e4c31409de4be32) )
	ROM_LOAD( "dkjungle0.2j",   0x0100, 0x0100, CRC(a81ca93c) SHA1(349cdb6348cbe1773f217ebacb1f0ece144fa8fd) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkbarpal2 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkbarpal2.5at",  0x3000, 0x1000, CRC(c216f65b) SHA1(96910744a61b5dd85814af56673cc7ffa3443b15) )
	ROM_LOAD( "dkbarpal2.5bt",  0x2000, 0x1000, CRC(ae1057f2) SHA1(2665c1a5ba2a85832ebbf06ab0893192eb858473) )
	ROM_LOAD( "dkbarpal2.5ct",  0x1000, 0x1000, CRC(bb94a16b) SHA1(433d6f3a42c766cbf478c297c7d6025c738ffda6) )
	ROM_LOAD( "dkbarpal2.5et",  0x0000, 0x1000, CRC(4621e696) SHA1(bb61a347a157a668950fbf2f61950717ac1cc77a) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkbarpal2.3pt",  0x0800, 0x0800, CRC(b0cd1e84) SHA1(16f8404114e3f62e0789819f6a65f34189b595bc) )
	ROM_LOAD( "dkbarpal2.5h",   0x0000, 0x0800, CRC(caf8820b) SHA1(b3e5768bd19c16510d05cd9d5d7ad72e05d08a8c) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkbarpal2.4m",   0x0000, 0x0800, CRC(1b46aae1) SHA1(f08c57f2c85df81180444cab76acb4f367d71619) )
	ROM_LOAD( "dkbarpal2.4n",   0x0800, 0x0800, CRC(fbaaa6f0) SHA1(e61e92418270fb81d9fd33da0a92970d458f69e4) )
	ROM_LOAD( "dkbarpal2.4r",   0x1000, 0x0800, CRC(919362a0) SHA1(5df953cded45ad55ba2bbd5f6d5c7e4577dcaa5f) )
	ROM_LOAD( "dkbarpal2.4s",   0x1800, 0x0800, CRC(d57098ca) SHA1(b746b0e137844e0e1cb715df065bbf7a3246f2e9) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkbarpal2.2j",   0x0100, 0x0100, CRC(4a7a511b) SHA1(c0d3ee62e5f6e22d24603ab24403b206d043956f) )
	ROM_LOAD( "dkbarpal2.2k",   0x0000, 0x0100, CRC(4826ce71) SHA1(5fe7d63ce7adece81ab8930196434410fbe4e241) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkbarpal3 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkbarpal3.5at",  0x3000, 0x1000, CRC(d6d14fc3) SHA1(9e901825ed1c8dae40f5a9b6db804675b6c5ec70) )
	ROM_LOAD( "dkbarpal3.5bt",  0x2000, 0x1000, CRC(b526e924) SHA1(280c54d212f0d1c86a351277540570420ad73bff) )
	ROM_LOAD( "dkbarpal2.5ct",  0x1000, 0x1000, CRC(bb94a16b) SHA1(433d6f3a42c766cbf478c297c7d6025c738ffda6) )
	ROM_LOAD( "dkbarpal3.5et",  0x0000, 0x1000, CRC(3a79f8ad) SHA1(ef26bf95a8a9c37bced4e8172522dc34b5ca0ab4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkbarpal2.3pt",  0x0800, 0x0800, CRC(b0cd1e84) SHA1(16f8404114e3f62e0789819f6a65f34189b595bc) )
	ROM_LOAD( "dkbarpal2.5h",   0x0000, 0x0800, CRC(caf8820b) SHA1(b3e5768bd19c16510d05cd9d5d7ad72e05d08a8c) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkbarpal2.4m",   0x0000, 0x0800, CRC(1b46aae1) SHA1(f08c57f2c85df81180444cab76acb4f367d71619) )
	ROM_LOAD( "dkbarpal2.4n",   0x0800, 0x0800, CRC(fbaaa6f0) SHA1(e61e92418270fb81d9fd33da0a92970d458f69e4) )
	ROM_LOAD( "dkbarpal2.4r",   0x1000, 0x0800, CRC(919362a0) SHA1(5df953cded45ad55ba2bbd5f6d5c7e4577dcaa5f) )
	ROM_LOAD( "dkbarpal2.4s",   0x1800, 0x0800, CRC(d57098ca) SHA1(b746b0e137844e0e1cb715df065bbf7a3246f2e9) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkbarpal2.2j",   0x0100, 0x0100, CRC(4a7a511b) SHA1(c0d3ee62e5f6e22d24603ab24403b206d043956f) )
	ROM_LOAD( "dkbarpal2.2k",   0x0000, 0x0100, CRC(4826ce71) SHA1(5fe7d63ce7adece81ab8930196434410fbe4e241) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkbarpal4 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkbarpal4.5at",  0x3000, 0x1000, CRC(f162e9ef) SHA1(674a005139255c454a09df7701eda2e29868f97a) )
	ROM_LOAD( "dkbarpal4.5bt",  0x2000, 0x1000, CRC(dbf5b518) SHA1(fe4f1fe9baeb588941fe991541f3a5197a0ca860) )
	ROM_LOAD( "dkbarpal2.5ct",  0x1000, 0x1000, CRC(bb94a16b) SHA1(433d6f3a42c766cbf478c297c7d6025c738ffda6) )
	ROM_LOAD( "dkbarpal4.5et",  0x0000, 0x1000, CRC(bb5c7dca) SHA1(f4bab16cb33ecca302fa6dd39b718a292958c691) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "dkbarpal.3i",    0x0000, 0x0800, CRC(7590f5ee) SHA1(b08245ce86d2c2de1b0d000743b7e9fcdf2ee215) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkbarpal2.3pt",  0x0800, 0x0800, CRC(b0cd1e84) SHA1(16f8404114e3f62e0789819f6a65f34189b595bc) )
	ROM_LOAD( "dkbarpal2.5h",   0x0000, 0x0800, CRC(caf8820b) SHA1(b3e5768bd19c16510d05cd9d5d7ad72e05d08a8c) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkbarpal2.4m",   0x0000, 0x0800, CRC(1b46aae1) SHA1(f08c57f2c85df81180444cab76acb4f367d71619) )
	ROM_LOAD( "dkbarpal2.4n",   0x0800, 0x0800, CRC(fbaaa6f0) SHA1(e61e92418270fb81d9fd33da0a92970d458f69e4) )
	ROM_LOAD( "dkbarpal2.4r",   0x1000, 0x0800, CRC(919362a0) SHA1(5df953cded45ad55ba2bbd5f6d5c7e4577dcaa5f) )
	ROM_LOAD( "dkbarpal2.4s",   0x1800, 0x0800, CRC(d57098ca) SHA1(b746b0e137844e0e1cb715df065bbf7a3246f2e9) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkbarpal2.2j",   0x0100, 0x0100, CRC(4a7a511b) SHA1(c0d3ee62e5f6e22d24603ab24403b206d043956f) )
	ROM_LOAD( "dkbarpal2.2k",   0x0000, 0x0100, CRC(4826ce71) SHA1(5fe7d63ce7adece81ab8930196434410fbe4e241) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkbarpal5 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkbarpal5.5at",  0x3000, 0x1000, CRC(0791b6e1) SHA1(6feeb6cd3b2b498e9ab3d2f9e548b54b2578af81) )
	ROM_LOAD( "dkbarpal4.5bt",  0x2000, 0x1000, CRC(dbf5b518) SHA1(fe4f1fe9baeb588941fe991541f3a5197a0ca860) )
	ROM_LOAD( "dkbarpal5.5ct",  0x1000, 0x1000, CRC(b543574d) SHA1(dd8b260c8671cf560fa1348075f535aedfd8b418) )
	ROM_LOAD( "dkbarpal4.5et",  0x0000, 0x1000, CRC(bb5c7dca) SHA1(f4bab16cb33ecca302fa6dd39b718a292958c691) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "dkbarpal.3i",    0x0000, 0x0800, CRC(7590f5ee) SHA1(b08245ce86d2c2de1b0d000743b7e9fcdf2ee215) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkbarpal2.3pt",  0x0800, 0x0800, CRC(b0cd1e84) SHA1(16f8404114e3f62e0789819f6a65f34189b595bc) )
	ROM_LOAD( "dkbarpal2.5h",   0x0000, 0x0800, CRC(caf8820b) SHA1(b3e5768bd19c16510d05cd9d5d7ad72e05d08a8c) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkbarpal2.4m",   0x0000, 0x0800, CRC(1b46aae1) SHA1(f08c57f2c85df81180444cab76acb4f367d71619) )
	ROM_LOAD( "dkbarpal2.4n",   0x0800, 0x0800, CRC(fbaaa6f0) SHA1(e61e92418270fb81d9fd33da0a92970d458f69e4) )
	ROM_LOAD( "dkbarpal2.4r",   0x1000, 0x0800, CRC(919362a0) SHA1(5df953cded45ad55ba2bbd5f6d5c7e4577dcaa5f) )
	ROM_LOAD( "dkbarpal2.4s",   0x1800, 0x0800, CRC(d57098ca) SHA1(b746b0e137844e0e1cb715df065bbf7a3246f2e9) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkbarpal2.2j",   0x0100, 0x0100, CRC(4a7a511b) SHA1(c0d3ee62e5f6e22d24603ab24403b206d043956f) )
	ROM_LOAD( "dkbarpal2.2k",   0x0000, 0x0100, CRC(4826ce71) SHA1(5fe7d63ce7adece81ab8930196434410fbe4e241) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkbarpal6 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkbarpal4.5et",  0x0000, 0x1000, CRC(bb5c7dca) SHA1(f4bab16cb33ecca302fa6dd39b718a292958c691) )
	ROM_LOAD( "dkbarpal6.5ct",  0x1000, 0x1000, CRC(c742739c) SHA1(a143af813f7c23b6bab483ad2610e686ebc568da) )
	ROM_LOAD( "dkbarpal6.5bt",  0x2000, 0x1000, CRC(a46859ec) SHA1(bbe8a32b7396f6347ce8b4a77b760277fb965551) )
	ROM_LOAD( "dkbarpal6.5at",  0x3000, 0x1000, CRC(eafd7c54) SHA1(1b44ac9c90621a8aeda00ef2677e9ad00d475467) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "dkbarpal.3i",    0x0000, 0x0800, CRC(7590f5ee) SHA1(b08245ce86d2c2de1b0d000743b7e9fcdf2ee215) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkbarpal2.5h",   0x0000, 0x0800, CRC(caf8820b) SHA1(b3e5768bd19c16510d05cd9d5d7ad72e05d08a8c) )
	ROM_LOAD( "dkbarpal2.3pt",  0x0800, 0x0800, CRC(b0cd1e84) SHA1(16f8404114e3f62e0789819f6a65f34189b595bc) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkbarpal2.4m",   0x0000, 0x0800, CRC(1b46aae1) SHA1(f08c57f2c85df81180444cab76acb4f367d71619) )
	ROM_LOAD( "dkbarpal2.4n",   0x0800, 0x0800, CRC(fbaaa6f0) SHA1(e61e92418270fb81d9fd33da0a92970d458f69e4) )
	ROM_LOAD( "dkbarpal2.4r",   0x1000, 0x0800, CRC(919362a0) SHA1(5df953cded45ad55ba2bbd5f6d5c7e4577dcaa5f) )
	ROM_LOAD( "dkbarpal2.4s",   0x1800, 0x0800, CRC(d57098ca) SHA1(b746b0e137844e0e1cb715df065bbf7a3246f2e9) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkbarpal2.2k",   0x0000, 0x0100, CRC(4826ce71) SHA1(5fe7d63ce7adece81ab8930196434410fbe4e241) )
	ROM_LOAD( "dkbarpal2.2j",   0x0100, 0x0100, CRC(4a7a511b) SHA1(c0d3ee62e5f6e22d24603ab24403b206d043956f) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkbarpal )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkbarpal.5et",   0x0000, 0x1000, CRC(c80c0431) SHA1(446e897150d027f797edbe30d0502f5f5a652ba7) )
	ROM_LOAD( "dkbarpal6.5ct",  0x1000, 0x1000, CRC(c742739c) SHA1(a143af813f7c23b6bab483ad2610e686ebc568da) )
	ROM_LOAD( "dkbarpal6.5bt",  0x2000, 0x1000, CRC(a46859ec) SHA1(bbe8a32b7396f6347ce8b4a77b760277fb965551) )
	ROM_LOAD( "dkbarpal.5at",   0x3000, 0x1000, CRC(4742a48e) SHA1(ddef0c7e25cbeba37a387de1d72583a2861dbbf4) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "dkbarpal.3i",    0x0000, 0x0800, CRC(7590f5ee) SHA1(b08245ce86d2c2de1b0d000743b7e9fcdf2ee215) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkbarpal2.5h",   0x0000, 0x0800, CRC(caf8820b) SHA1(b3e5768bd19c16510d05cd9d5d7ad72e05d08a8c) )
	ROM_LOAD( "dkbarpal2.3pt",  0x0800, 0x0800, CRC(b0cd1e84) SHA1(16f8404114e3f62e0789819f6a65f34189b595bc) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkbarpal2.4m",   0x0000, 0x0800, CRC(1b46aae1) SHA1(f08c57f2c85df81180444cab76acb4f367d71619) )
	ROM_LOAD( "dkbarpal2.4n",   0x0800, 0x0800, CRC(fbaaa6f0) SHA1(e61e92418270fb81d9fd33da0a92970d458f69e4) )
	ROM_LOAD( "dkbarpal2.4r",   0x1000, 0x0800, CRC(919362a0) SHA1(5df953cded45ad55ba2bbd5f6d5c7e4577dcaa5f) )
	ROM_LOAD( "dkbarpal2.4s",   0x1800, 0x0800, CRC(d57098ca) SHA1(b746b0e137844e0e1cb715df065bbf7a3246f2e9) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkbarpal2.2k",   0x0000, 0x0100, CRC(4826ce71) SHA1(5fe7d63ce7adece81ab8930196434410fbe4e241) )
	ROM_LOAD( "dkbarpal2.2j",   0x0100, 0x0100, CRC(4a7a511b) SHA1(c0d3ee62e5f6e22d24603ab24403b206d043956f) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongan0 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongan0.5at",   0x3000, 0x1000, CRC(56ef8519) SHA1(6dab077e190da06d79496cb6b92cbd34ea36e935) )
	ROM_LOAD( "dkongan0.5bt",   0x2000, 0x1000, CRC(6c5614e5) SHA1(cf8a31c303eb18260cc328593f365ebd9d81fb5c) )
	ROM_LOAD( "dkongan0.5ct",   0x1000, 0x1000, CRC(34238a95) SHA1(a997989a33d5ad8dc77483781de12fd161e57f39) )
	ROM_LOAD( "dkongan0.5et",   0x0000, 0x1000, CRC(c3f2ed18) SHA1(e598f85c6c375a9202e8628b390165186d287f55) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "dkongan.3i",     0x0000, 0x0800, CRC(44993c29) SHA1(7beeae49df5126bbf268dc66bb61e6a8b832fa31) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongan0.3pt",   0x0800, 0x0800, CRC(25cc07d4) SHA1(62374e89c79527cb78a70f83781299d4786bcec0) )
	ROM_LOAD( "dkongan0.5h",    0x0000, 0x0800, CRC(ae4c3990) SHA1(20db41211bfdc6b79198fc8cd022465468430059) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkongan0.4m",     0x0000, 0x0800, CRC(410ab9a2) SHA1(c98f2053bc2f2140209ac2d8d0a7c1f489ec429c) )
	ROM_LOAD( "dkongan0.4n",     0x0800, 0x0800, CRC(4f7e8fd4) SHA1(b031f512a40d6cdd430cc57f470efe53e55fbad7) )
	ROM_LOAD( "dkongan0.4r",     0x1000, 0x0800, CRC(9eb470c0) SHA1(58644eed4c4f0b714f51147fbf77b9c2ee18ad2c) )
	ROM_LOAD( "dkongan0.4s",     0x1800, 0x0800, CRC(73ef61cc) SHA1(7736e1451a36f1b9b20108c0d5f6ba861602d307) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongan )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongan.5et",    0x0000, 0x1000, CRC(cf44c2dd) SHA1(26776fa00250fbffdc1cb2ef012f851cffd67b3d) )
	ROM_LOAD( "dkongan0.5ct",   0x1000, 0x1000, CRC(34238a95) SHA1(a997989a33d5ad8dc77483781de12fd161e57f39) )
	ROM_LOAD( "dkongan0.5bt",   0x2000, 0x1000, CRC(6c5614e5) SHA1(cf8a31c303eb18260cc328593f365ebd9d81fb5c) )
	ROM_LOAD( "dkongan.5at",    0x3000, 0x1000, CRC(0b92803c) SHA1(01bb401837ddeeb5ff36d98eebde9a5819ac19e8) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "dkongan.3i",     0x0000, 0x0800, CRC(44993c29) SHA1(7beeae49df5126bbf268dc66bb61e6a8b832fa31) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongan0.5h",    0x0000, 0x0800, CRC(ae4c3990) SHA1(20db41211bfdc6b79198fc8cd022465468430059) )
	ROM_LOAD( "dkongan0.3pt",   0x0800, 0x0800, CRC(25cc07d4) SHA1(62374e89c79527cb78a70f83781299d4786bcec0) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkongan0.4m",    0x0000, 0x0800, CRC(410ab9a2) SHA1(c98f2053bc2f2140209ac2d8d0a7c1f489ec429c) )
	ROM_LOAD( "dkongan0.4n",    0x0800, 0x0800, CRC(4f7e8fd4) SHA1(b031f512a40d6cdd430cc57f470efe53e55fbad7) )
	ROM_LOAD( "dkongan0.4r",    0x1000, 0x0800, CRC(9eb470c0) SHA1(58644eed4c4f0b714f51147fbf77b9c2ee18ad2c) )
	ROM_LOAD( "dkongan0.4s",    0x1800, 0x0800, CRC(73ef61cc) SHA1(7736e1451a36f1b9b20108c0d5f6ba861602d307) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",       0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",       0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkongdu0 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongdu0.5at",   0x3000, 0x1000, CRC(5e7fff6a) SHA1(6538160a1ed8c583dc5e0525ed85da7e144dc887) )
	ROM_LOAD( "dkongchm.5bt",   0x2000, 0x1000, CRC(fce41e06) SHA1(fdab4f37f914d56a28092592f9cbb3d2502c925e) )
	ROM_LOAD( "dkongdu0.5ct",   0x1000, 0x1000, CRC(fc9cdaa0) SHA1(964ac1d908c5abfaa4aa459f52f4ead133d41346) )
	ROM_LOAD( "dkongdu0.5et",   0x0000, 0x1000, CRC(87a4912f) SHA1(bca9f1c489c193f4cd15a108dd4dd2d99aa89c35) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "dkongdu0.3i",    0x0000, 0x0800, CRC(cc9aea3b) SHA1(e5b985efc1447ad04cfe347a7b761c9e5ff8ea5c) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongdu0.5h",    0x0000, 0x0800, CRC(3cf6ef8b) SHA1(d4f1ac5dfa93b7073d9b441f05b24077c0d22924) )
	ROM_LOAD( "dkongdu0.3pt",   0x0800, 0x0800, CRC(3775dd7b) SHA1(0e73e1e64673140e8e5fd318cc679c64812608a7) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkongdu0.2k",    0x0000, 0x0100, CRC(02e1f91b) SHA1(fadb853a060db98ea13d67059fda91e7095b0050) )
	ROM_LOAD( "dkongdu0.2j",    0x0100, 0x0100, CRC(4176057f) SHA1(ccb7d553f6aa82bff4d30da9b97d107684f329ca) )
	ROM_LOAD( "dkongdu0.5e",    0x0200, 0x0100, CRC(94695888) SHA1(fc0167730b303c9743d24dba577b6a72ffc07c15) )
ROM_END


ROM_START( dkongdu1 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongdu0.5et",   0x0000, 0x1000, CRC(87a4912f) SHA1(bca9f1c489c193f4cd15a108dd4dd2d99aa89c35) )
	ROM_LOAD( "dkongdu1.5ct",   0x1000, 0x1000, CRC(1f574afa) SHA1(5fe8291bc14539cf25db245e05d90f35e96674dc) )
	ROM_LOAD( "dkongchm.5bt",   0x2000, 0x1000, CRC(fce41e06) SHA1(fdab4f37f914d56a28092592f9cbb3d2502c925e) )
	ROM_LOAD( "dkongdu1.5at",   0x3000, 0x1000, CRC(11b03279) SHA1(412e5036db0b39e318f97736665e15cbd5690cb0) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "dkongdu0.3i",    0x0000, 0x0800, CRC(cc9aea3b) SHA1(e5b985efc1447ad04cfe347a7b761c9e5ff8ea5c) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongdu0.5h",    0x0000, 0x0800, CRC(3cf6ef8b) SHA1(d4f1ac5dfa93b7073d9b441f05b24077c0d22924) )
	ROM_LOAD( "dkongdu0.3pt",   0x0800, 0x0800, CRC(3775dd7b) SHA1(0e73e1e64673140e8e5fd318cc679c64812608a7) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkongdu0.2k",    0x0000, 0x0100, CRC(02e1f91b) SHA1(fadb853a060db98ea13d67059fda91e7095b0050) )
	ROM_LOAD( "dkongdu0.2j",    0x0100, 0x0100, CRC(4176057f) SHA1(ccb7d553f6aa82bff4d30da9b97d107684f329ca) )
	ROM_LOAD( "dkongdu0.5e",    0x0200, 0x0100, CRC(94695888) SHA1(fc0167730b303c9743d24dba577b6a72ffc07c15) )
ROM_END


ROM_START( dkongdu )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongdu0.5et",   0x0000, 0x1000, CRC(87a4912f) SHA1(bca9f1c489c193f4cd15a108dd4dd2d99aa89c35) )
	ROM_LOAD( "dkongdu.5ct",    0x1000, 0x1000, CRC(1c547c2b) SHA1(d5373bae4e3a067821253ec6e0e5169a2bfd9dfe) )
	ROM_LOAD( "dkongchm.5bt",   0x2000, 0x1000, CRC(fce41e06) SHA1(fdab4f37f914d56a28092592f9cbb3d2502c925e) )
	ROM_LOAD( "dkongdu.5at",    0x3000, 0x1000, CRC(c1e0654c) SHA1(decf2a73730b117d977ca90039a9b93651883f8d) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "dkongdu0.3i",    0x0000, 0x0800, CRC(cc9aea3b) SHA1(e5b985efc1447ad04cfe347a7b761c9e5ff8ea5c) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongdu0.5h",    0x0000, 0x0800, CRC(3cf6ef8b) SHA1(d4f1ac5dfa93b7073d9b441f05b24077c0d22924) )
	ROM_LOAD( "dkongdu0.3pt",   0x0800, 0x0800, CRC(3775dd7b) SHA1(0e73e1e64673140e8e5fd318cc679c64812608a7) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkongdu0.2k",    0x0000, 0x0100, CRC(02e1f91b) SHA1(fadb853a060db98ea13d67059fda91e7095b0050) )
	ROM_LOAD( "dkongdu0.2j",    0x0100, 0x0100, CRC(4176057f) SHA1(ccb7d553f6aa82bff4d30da9b97d107684f329ca) )
	ROM_LOAD( "dkongdu0.5e",    0x0200, 0x0100, CRC(94695888) SHA1(fc0167730b303c9743d24dba577b6a72ffc07c15) )
ROM_END


ROM_START( dkwizard0 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkwizard0.5at",  0x3000, 0x1000, CRC(934e1f36) SHA1(7f1116f0f7b459578931e69cd88bdc78986bcf73) )
	ROM_LOAD( "dkwizard0.5bt",  0x2000, 0x1000, CRC(8d5bda23) SHA1(ca2d1f9a7d8abc56c583cb510075fd2e4cee2d85) )
	ROM_LOAD( "dkwizard0.5ct",  0x1000, 0x1000, CRC(9d276435) SHA1(8ef89c3bb10a01c4a438918a4f777eb4ea5b08bb) )
	ROM_LOAD( "dkwizard0.5et",  0x0000, 0x1000, CRC(95dd923b) SHA1(3704da244d7ade149a9a22060a95d64ce2e47571) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkwizard0.3pt",  0x0800, 0x0800, CRC(8f6e6c62) SHA1(53cac9a77cbd068d775541a876e7f5f450d03a81) )
	ROM_LOAD( "dkwizard0.5h",   0x0000, 0x0800, CRC(8d54ad8d) SHA1(58ef5d7a9d7a45473b7724e216a0a4027562049b) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkwizard0.4m",   0x0000, 0x0800, CRC(700944c8) SHA1(7915bae6c9d062ef5b13d7bc43297785692e9115) )
	ROM_LOAD( "dkwizard0.4n",   0x0800, 0x0800, CRC(cf3cdb75) SHA1(9ac98e0cfada360b9615af1c14c2d5e27129f328) )
	ROM_LOAD( "dkwizard0.4r",   0x1000, 0x0800, CRC(e6e9b11e) SHA1(86cda6de37c1da0476223138a56449f36f1e2b14) )
	ROM_LOAD( "dkwizard0.4s",   0x1800, 0x0800, CRC(dd1432a0) SHA1(18ef383485a77866b29c05b66992c3cc6cc4f5ea) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkwizard0.2k",   0x0000, 0x0100, CRC(6a3503a9) SHA1(10f416c915219ea7303f4e4b31cb6f499a04154d) )
	ROM_LOAD( "dkwizard0.2j",   0x0100, 0x0100, CRC(c5e5326c) SHA1(5d809737ed4ab9242d310f4cbe46636d3570d873) )
	ROM_LOAD( "dkwizard0.5e",   0x0200, 0x0100, CRC(c24f2312) SHA1(61dfcec8ecaa7a38ed222f2d3c4d6695db6f33b1) )
ROM_END


ROM_START( dkwizard1 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkwizard1.5at",  0x3000, 0x1000, CRC(277e3f4b) SHA1(66db4fe02ef7d6860b45f4222793f0d8e1a3e1f8) )
	ROM_LOAD( "dkwizard0.5bt",  0x2000, 0x1000, CRC(8d5bda23) SHA1(ca2d1f9a7d8abc56c583cb510075fd2e4cee2d85) )
	ROM_LOAD( "dkwizard1.5ct",  0x1000, 0x1000, CRC(1ba39916) SHA1(9c0b7d178134fbf2b6a55dc4e1e40011d9464c45) )
	ROM_LOAD( "dkwizard0.5et",  0x0000, 0x1000, CRC(95dd923b) SHA1(3704da244d7ade149a9a22060a95d64ce2e47571) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkwizard1.5h",   0x0000, 0x0800, CRC(39736a8a) SHA1(8825f1473415fc588a189887f4aa302313bfcec8) )
	ROM_LOAD( "dkwizard1.3pt",  0x0800, 0x0800, CRC(c94468a9) SHA1(136b204735223c5e3f94340db5f6b7cfd0ad2666) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkwizard1.4m",   0x0000, 0x0800, CRC(f98da4c5) SHA1(362c2083b0bad94174c3bd2e77b52dee18069d00) )
	ROM_LOAD( "dkwizard0.4n",   0x0800, 0x0800, CRC(cf3cdb75) SHA1(9ac98e0cfada360b9615af1c14c2d5e27129f328) )
	ROM_LOAD( "dkwizard1.4r",   0x1000, 0x0800, CRC(7e2d1ef4) SHA1(2f6d2d7afd4b595b2e24e31263433611e9761c86) )
	ROM_LOAD( "dkwizard1.4s",   0x1800, 0x0800, CRC(cc547d47) SHA1(087f9c5da33831d2a7a9f5f86d9da1d7f1cf15b6) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkwizard1.2k",   0x0000, 0x0100, CRC(193134e9) SHA1(6101bbdff23f0a1ccaba99cdbd966bcf780751bd) )
	ROM_LOAD( "dkwizard1.2j",   0x0100, 0x0100, CRC(dcbba451) SHA1(31bf6bc17f790d4a61392ca1fd68361698ac9338) )
	ROM_LOAD( "dkwizard0.5e",   0x0200, 0x0100, CRC(c24f2312) SHA1(61dfcec8ecaa7a38ed222f2d3c4d6695db6f33b1) )
ROM_END


ROM_START( dkwizard2 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkwizard2.5et",  0x0000, 0x1000, CRC(f42bb2e5) SHA1(2bd74d51d9ce43207f2ec879746ec44bdd13aef1) )
	ROM_LOAD( "dkwizard2.5ct",  0x1000, 0x1000, CRC(85cf6e4c) SHA1(4140865b1dabee98346f4217e9b7b355d177ebc7) )
	ROM_LOAD( "dkwizard0.5bt",  0x2000, 0x1000, CRC(8d5bda23) SHA1(ca2d1f9a7d8abc56c583cb510075fd2e4cee2d85) )
	ROM_LOAD( "dkwizard2.5at",  0x3000, 0x1000, CRC(f72e687e) SHA1(e2575f6e0f9d3ae1d40fbb22084439a84d103e30) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkwizard1.5h",   0x0000, 0x0800, CRC(39736a8a) SHA1(8825f1473415fc588a189887f4aa302313bfcec8) )
	ROM_LOAD( "dkwizard1.3pt",  0x0800, 0x0800, CRC(c94468a9) SHA1(136b204735223c5e3f94340db5f6b7cfd0ad2666) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkwizard1.4m",   0x0000, 0x0800, CRC(f98da4c5) SHA1(362c2083b0bad94174c3bd2e77b52dee18069d00) )
	ROM_LOAD( "dkwizard0.4n",   0x0800, 0x0800, CRC(cf3cdb75) SHA1(9ac98e0cfada360b9615af1c14c2d5e27129f328) )
	ROM_LOAD( "dkwizard1.4r",   0x1000, 0x0800, CRC(7e2d1ef4) SHA1(2f6d2d7afd4b595b2e24e31263433611e9761c86) )
	ROM_LOAD( "dkwizard1.4s",   0x1800, 0x0800, CRC(cc547d47) SHA1(087f9c5da33831d2a7a9f5f86d9da1d7f1cf15b6) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkwizard1.2k",   0x0000, 0x0100, CRC(193134e9) SHA1(6101bbdff23f0a1ccaba99cdbd966bcf780751bd) )
	ROM_LOAD( "dkwizard1.2j",   0x0100, 0x0100, CRC(dcbba451) SHA1(31bf6bc17f790d4a61392ca1fd68361698ac9338) )
	ROM_LOAD( "dkwizard0.5e",   0x0200, 0x0100, CRC(c24f2312) SHA1(61dfcec8ecaa7a38ed222f2d3c4d6695db6f33b1) )
ROM_END


ROM_START( dkwizard )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkwizard2.5et",  0x0000, 0x1000, CRC(f42bb2e5) SHA1(2bd74d51d9ce43207f2ec879746ec44bdd13aef1) )
	ROM_LOAD( "dkwizard2.5ct",  0x1000, 0x1000, CRC(85cf6e4c) SHA1(4140865b1dabee98346f4217e9b7b355d177ebc7) )
	ROM_LOAD( "dkwizard.5bt",   0x2000, 0x1000, CRC(6e888d7b) SHA1(58d164193d95a9a93238a06ab1338e14b448f3f7) )
	ROM_LOAD( "dkwizard.5at",   0x3000, 0x1000, CRC(b8e1a56d) SHA1(5551faf1477492c570b5d58c8bc2359b83520186) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkwizard1.5h",   0x0000, 0x0800, CRC(39736a8a) SHA1(8825f1473415fc588a189887f4aa302313bfcec8) )
	ROM_LOAD( "dkwizard1.3pt",  0x0800, 0x0800, CRC(c94468a9) SHA1(136b204735223c5e3f94340db5f6b7cfd0ad2666) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkwizard1.4m",   0x0000, 0x0800, CRC(f98da4c5) SHA1(362c2083b0bad94174c3bd2e77b52dee18069d00) )
	ROM_LOAD( "dkwizard0.4n",   0x0800, 0x0800, CRC(cf3cdb75) SHA1(9ac98e0cfada360b9615af1c14c2d5e27129f328) )
	ROM_LOAD( "dkwizard1.4r",   0x1000, 0x0800, CRC(7e2d1ef4) SHA1(2f6d2d7afd4b595b2e24e31263433611e9761c86) )
	ROM_LOAD( "dkwizard1.4s",   0x1800, 0x0800, CRC(cc547d47) SHA1(087f9c5da33831d2a7a9f5f86d9da1d7f1cf15b6) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkwizard1.2k",   0x0000, 0x0100, CRC(193134e9) SHA1(6101bbdff23f0a1ccaba99cdbd966bcf780751bd) )
	ROM_LOAD( "dkwizard1.2j",   0x0100, 0x0100, CRC(dcbba451) SHA1(31bf6bc17f790d4a61392ca1fd68361698ac9338) )
	ROM_LOAD( "dkwizard0.5e",   0x0200, 0x0100, CRC(c24f2312) SHA1(61dfcec8ecaa7a38ed222f2d3c4d6695db6f33b1) )
ROM_END


ROM_START( dksprfin ) // v1.01
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dksprfin.5et",   0x0000, 0x1000, CRC(fd23db80) SHA1(2188bf0c8943e9c4771c3f9ff3bd1cfcc14a5ba4) )
	ROM_LOAD( "dksprfin.5ct",   0x1000, 0x1000, CRC(3ee5db14) SHA1(ff984eb269064f10305bbeeaa68a1d3160e0b1fa) )
	ROM_LOAD( "dksprfin.5bt",   0x2000, 0x1000, CRC(50772c6c) SHA1(4368d4501e3d971929015c545aef88d9c06e0604) )
	ROM_LOAD( "dksprfin.5at",   0x3000, 0x1000, CRC(5a31dc81) SHA1(44015be4a70dc75035edfe4b7ba19bbfed6c249a) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dksprfin.5h",    0x0000, 0x0800, CRC(b41e2713) SHA1(2a4e37e5bb997b0a6a0d8aef61fd8f89d97d8213) )
	ROM_LOAD( "dksprfin.3pt",   0x0800, 0x0800, CRC(b33f2ba7) SHA1(900ff22f44b4504da4f3b8fe9dcdf7f5b88ea597) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dksprfin.2k",    0x0000, 0x0100, CRC(6baa5ba0) SHA1(2c0e9f4b4ac2d14aeeeba9afa9bf675337650276) )
	ROM_LOAD( "dksprfin.2j",    0x0100, 0x0100, CRC(1a144a25) SHA1(6e73470b7589ea5f14cf0dd9a9fbfd176e5e1c36) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dksprfin2 ) // v1.02
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dksprfin.5et",   0x0000, 0x1000, CRC(fd23db80) SHA1(2188bf0c8943e9c4771c3f9ff3bd1cfcc14a5ba4) )
	ROM_LOAD( "dksprfin2.5ct",  0x1000, 0x1000, CRC(257fee24) SHA1(284c7b73c1f08b5161582807d218e901da61aeda) )
	ROM_LOAD( "dksprfin2.5bt",  0x2000, 0x1000, CRC(5237ac87) SHA1(19f7563315311b88d4fed80fff886a0b585c351e) )
	ROM_LOAD( "dksprfin2.5at",  0x3000, 0x1000, CRC(ce0a0a63) SHA1(170fa312f65a87fced6ba54a648c9d653436b37d) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dksprfin.5h",    0x0000, 0x0800, CRC(b41e2713) SHA1(2a4e37e5bb997b0a6a0d8aef61fd8f89d97d8213) )
	ROM_LOAD( "dksprfin.3pt",   0x0800, 0x0800, CRC(b33f2ba7) SHA1(900ff22f44b4504da4f3b8fe9dcdf7f5b88ea597) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dksprfin.2k",    0x0000, 0x0100, CRC(6baa5ba0) SHA1(2c0e9f4b4ac2d14aeeeba9afa9bf675337650276) )
	ROM_LOAD( "dksprfin.2j",    0x0100, 0x0100, CRC(1a144a25) SHA1(6e73470b7589ea5f14cf0dd9a9fbfd176e5e1c36) )
	ROM_LOAD( "v-5e.bpr",       0x0200, 0x0100, CRC(b869b8f5) SHA1(c2bdccbf2654b64ea55cd589fd21323a9178a660) )
ROM_END


ROM_START( dkbrlbss )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkbrlbss.5et",   0x0000, 0x1000, CRC(1b7fcbdb) SHA1(4a00b135bc0cef9424a093ad92573aa29e50d08d) )
	ROM_LOAD( "dkbrlbss.5ct",   0x1000, 0x1000, CRC(27a23476) SHA1(78b97b56c8a3971b81d637b1d5e06f2303252775) )
	ROM_LOAD( "dkbrlbss.5bt",   0x2000, 0x1000, CRC(146e3c1b) SHA1(6d9248a1cf016dea8cb2b1f02ffd5ac973f5f0e0) )
	ROM_LOAD( "dkbrlbss.5at",   0x3000, 0x1000, CRC(1ac59880) SHA1(1b4584074ad1b7832ddfab88541ff658c69214bc) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",     0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(                 0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",     0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dksprfin.5h",    0x0000, 0x0800, CRC(b41e2713) SHA1(2a4e37e5bb997b0a6a0d8aef61fd8f89d97d8213) )
	ROM_LOAD( "dksprfin.3pt",   0x0800, 0x0800, CRC(b33f2ba7) SHA1(900ff22f44b4504da4f3b8fe9dcdf7f5b88ea597) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",     0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",     0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",     0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",     0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dksprfin.2k",    0x0000, 0x0100, CRC(6baa5ba0) SHA1(2c0e9f4b4ac2d14aeeeba9afa9bf675337650276) )
	ROM_LOAD( "dksprfin.2j",    0x0100, 0x0100, CRC(1a144a25) SHA1(6e73470b7589ea5f14cf0dd9a9fbfd176e5e1c36) )
	ROM_LOAD( "dkbrlbss.5e",    0x0200, 0x0100, CRC(b8bce45e) SHA1(a25651f493d03c2bdccfb5ac338972e9830c0e97) )
ROM_END


ROM_START( dkonghh )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkonghh.5et",  0x0000, 0x1000, CRC(c9a84bae) SHA1(209263a6cb4191151d93f6461df1b8ffc7b4818b) )
	ROM_LOAD( "dkonghh.5ct",  0x1000, 0x1000, CRC(e55daf9e) SHA1(847fce74dace325e83c625c2ebae71e8b67ba576) )
	ROM_LOAD( "dkonghh.5bt",  0x2000, 0x1000, CRC(34466de4) SHA1(46a097614b31e470791d5acb73eec3efd0d1551f) )
	ROM_LOAD( "dkonghh.5at",  0x3000, 0x1000, CRC(d51b8307) SHA1(5dc6212298f055e3a39a4e0f1c86217ae4b43443) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkonghh.5h",   0x0000, 0x0800, CRC(c52ec836) SHA1(3b4da038ebadd3b524aa344e5d95163415704cff) )
	ROM_LOAD( "dkonghh.3pt",  0x0800, 0x0800, CRC(655b1313) SHA1(94cc77d8a6ee8efbf961028afc6ed4d629f7a62e) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "l_4m_b.bin",   0x0000, 0x0800, CRC(59f8054d) SHA1(793dba9bf5a5fe76328acdfb90815c243d2a65f1) )
	ROM_LOAD( "l_4n_b.bin",   0x0800, 0x0800, CRC(672e4714) SHA1(92e5d379f4838ac1fa44d448ce7d142dae42102f) )
	ROM_LOAD( "l_4r_b.bin",   0x1000, 0x0800, CRC(feaa59ee) SHA1(ecf95db5a20098804fc8bd59232c66e2e0ed3db4) )
	ROM_LOAD( "l_4s_b.bin",   0x1800, 0x0800, CRC(20f2ef7e) SHA1(3bc482a38bf579033f50082748ee95205b0f673d) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "c-2k.bpr",     0x0000, 0x0100, CRC(e273ede5) SHA1(b50ec9e1837c00c20fb2a4369ec7dd0358321127) )
	ROM_LOAD( "c-2j.bpr",     0x0100, 0x0100, CRC(d6412358) SHA1(f9c872da2fe8e800574ae3bf483fb3ccacc92eb3) )
	ROM_LOAD( "dkonghh.5e",   0x0200, 0x0100, CRC(15ea25d5) SHA1(0ac15a8399967fa8079b3de0c312f63aa537db75) )
ROM_END


ROM_START( dkongacc )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "dkongacc.5et",  0x0000, 0x1000, CRC(cfb3a3be) SHA1(a5cfcdc4c2a66cf0c48adad4a15ce74cfd6de2d7) )
	ROM_LOAD( "dkongacc.5ct",  0x1000, 0x1000, CRC(9a527b63) SHA1(b0a4680887539b81e1c2cee23b42303b6adcf182) )
	ROM_LOAD( "dkongacc.5bt",  0x2000, 0x1000, CRC(107b677c) SHA1(d9519a7a8617528ded4addb65ad419fb1e552e1f) )
	ROM_LOAD( "dkongacc.5at",  0x3000, 0x1000, CRC(622b283f) SHA1(e883070b9a18c9d22b9e1c03eaf79f6fc1c6673c) )

	ROM_REGION( 0x1800, "soundcpu", 0 )
	ROM_LOAD( "s_3i_b.bin",   0x0000, 0x0800, CRC(45a4ed06) SHA1(144d24464c1f9f01894eb12f846952290e6e32ef) )
	ROM_RELOAD(               0x0800, 0x0800 )
	ROM_LOAD( "s_3j_b.bin",   0x1000, 0x0800, CRC(4743fe92) SHA1(6c82b57637c0212a580591397e6a5a1718f19fd2) )

	ROM_REGION( 0x1000, "gfx1", 0 )
	ROM_LOAD( "dkongacc.5h",   0x0000, 0x0800, CRC(b3a5f655) SHA1(2eaba75655b9ae4e5a55a79f3e037ece4bf571b7) )
	ROM_LOAD( "dkongacc.3pt",  0x0800, 0x0800, CRC(0bebf954) SHA1(f6ad0e083f58bcf1f617a29f4af0aab9a64b2f10) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "dkongacc.4m",   0x0000, 0x0800, CRC(3c7c711e) SHA1(2385962c4da66dd30b553f9a683b7c5799d6d4f4) )
	ROM_LOAD( "dkongacc.4n",   0x0800, 0x0800, CRC(7f0e788f) SHA1(4c4b1fc8b2481b376fb6b49c1d1ef9156c8c7cc7) )
	ROM_LOAD( "dkongacc.4r",   0x1000, 0x0800, CRC(89129b53) SHA1(7d52ee4925a54124d8063151badc71812d5b5c64) )
	ROM_LOAD( "dkongacc.4s",   0x1800, 0x0800, CRC(df2aa287) SHA1(be41a3f2d87905e056666f31a9051a065eb91f29) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "dkongacc.2k",   0x0000, 0x0100, CRC(d46f27e1) SHA1(e818e6953e9716c0bebeeb29bb1e152dfbc68a88) )
	ROM_LOAD( "dkongacc.2j",   0x0100, 0x0100, CRC(9e4af035) SHA1(3d727fb90ecec3d9b57df5e9cae6fafe8b93adb2) )
	ROM_LOAD( "dkongacc.5e",   0x0200, 0x0100, CRC(ece3b0f2) SHA1(3b13cf44164849a9854f2efa918a36d747e91341) )
ROM_END

/*******************
 Donkey Kong Junior
*******************/
ROM_START( dkongjr01 )
	ROM_REGION( 0x10000, "maincpu", 0 )
	ROM_LOAD( "s01.5b", 0x0000, 0x1000, CRC(50c2a9a0) SHA1(84fc30dd6e0a5a5376482a0c80f02b7f69945c1c) )
	ROM_CONTINUE(       0x3000, 0x1000 )
	ROM_LOAD( "s01.5c", 0x2000, 0x0800, CRC(dd65bd02) SHA1(f1f7feb3e727e2a938dd6639a588219d131a256d) )
	ROM_CONTINUE(       0x4800, 0x0800 )
	ROM_CONTINUE(       0x1000, 0x0800 )
	ROM_CONTINUE(       0x5800, 0x0800 )
	ROM_LOAD( "s01.5e", 0x4000, 0x0800, CRC(1fa0d992) SHA1(636fd28bb05296937945adc7c63da04bd7adbb44) )
	ROM_CONTINUE(       0x2800, 0x0800 )
	ROM_CONTINUE(       0x5000, 0x0800 )
	ROM_CONTINUE(       0x1800, 0x0800 )

	ROM_REGION( 0x1000, "soundcpu", 0 )
	ROM_LOAD( "djr1-c_3h.3h",     0x0000, 0x1000, CRC(715da5f8) SHA1(f708c3fd374da65cbd9fe2e191152f5d865414a0) )

	ROM_REGION( 0x2000, "gfx1", 0 )
	ROM_LOAD( "djr1-v.3n",        0x0000, 0x1000, CRC(8d51aca9) SHA1(64887564b079d98e98aafa53835e398f34fe4e3f) )
	ROM_LOAD( "djr1-v.3p",        0x1000, 0x1000, CRC(4ef64ba5) SHA1(41a7a4005087951f57f62c9751d62a8c495e6bb3) )

	ROM_REGION( 0x2000, "gfx2", 0 )
	ROM_LOAD( "djr1-v_7c.7c",     0x0000, 0x0800, CRC(dc7f4164) SHA1(07a6242e95b5c3b8dfdcd4b4950f463dba16dd77) )
	ROM_LOAD( "djr1-v_7d.7d",     0x0800, 0x0800, CRC(0ce7dcf6) SHA1(0654b77526c49f0dfa077ac4f1f69cf5cb2e2f64) )
	ROM_LOAD( "djr1-v_7e.7e",     0x1000, 0x0800, CRC(24d1ff17) SHA1(696854bf3dc5447d33b4815db357e6ce3834d867) )
	ROM_LOAD( "djr1-v_7f.7f",     0x1800, 0x0800, CRC(0f8c083f) SHA1(0b688ae9da296b2447fffa5e135fd6a56ec3e790) )

	ROM_REGION( 0x0300, "proms", 0 )
	ROM_LOAD( "djr1-c-2e.2e",     0x0000, 0x0100, CRC(463dc7ad) SHA1(b2c9f22facc8885be2d953b056eb8dcddd4f34cb) )
	ROM_LOAD( "djr1-c-2f.2f",     0x0100, 0x0100, CRC(47ba0042) SHA1(dbec3f4b8013628c5b8f83162e5f8b1f82f6ee5f) )
	ROM_LOAD( "djr1-v-2n.2n",     0x0200, 0x0100, CRC(dbf185bf) SHA1(2697a991a4afdf079dd0b7e732f71c7618f43b70) )
ROM_END



// Donkey Kong
GAME( 1981, dkongbcc,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jeff Kulczycki", "Donkey Kong (Barrel control coloring)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong01,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "2nut Kong (2022-08-17, set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong02,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "2nut Kong (2022-08-17, set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong03,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "2nut Kong (2022-08-17, set 3)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkong04,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong Fireballs (2021-06-07)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong05,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (Barreling)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong06,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (Half Kong)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong07,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Kirai Shouen, 125scratch", "Donkey Kong (Kana Kong)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong08,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Konkey Dong", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong09,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (DK Lava Panic!)", MACHINE_NOT_WORKING | MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong10,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (NoLuck Kong)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong11,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (Octo Monkey)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong12,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (Pies only)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong13,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (Quarter)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong14,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (Riveting)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong15,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (Springy)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong16,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (Wild Barrel hack)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkong17,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Jon Wilson", "Donkey Kong (DK Who and the Daleks)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, dkong19,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Vic Twenty George", "Donkey Kong (2600 graphics, set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, dkong20,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Vic Twenty George", "Donkey Kong (2600 graphics, set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 2024, dkong21,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Pacman Crossover v1.00 (2024-01-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2024, dkong22,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong (hitboxes)", MACHINE_SUPPORTS_SAVE )
GAME( 2024, dkong23,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong (hitboxes and sprites)", MACHINE_SUPPORTS_SAVE )
GAME( 2001, dkongpac,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Tim Appleton", "Donkey Kong (Pac-man graphics)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, nadkong,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "hack", "Naked Donkey Kong", MACHINE_SUPPORTS_SAVE )
GAME( 2005, dkongex,   dkong, dkong2b,   dkongex, dkong_state,  empty_init,  ROT270, "Jeff Kulczycki", "Donkey Kong Foundry", MACHINE_SUPPORTS_SAVE )
GAME( 2007, dkongp,    dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Don Hodges", "Donkey Kong (patched)", MACHINE_SUPPORTS_SAVE )
GAME( 2013, dkong2m,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "hack", "Donkey Kong (2 marios)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, dkrainbow, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "John Kowalski", "Rainbow Donkey Kong", MACHINE_SUPPORTS_SAVE )
GAME( 2015, dkrdemo,   dkong, dkong2b,   dkrdemo, dkong_state,  empty_init,  ROT270, "John Kowalski", "Donkey Kong Remix demo 1.8", MACHINE_SUPPORTS_SAVE )
GAME( 2016, dktrain,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "John Kowalski", "Donkey Kong Trainer 1.01", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dktrain2,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "John Kowalski", "Donkey Kong Trainer 1.01 (bugfix)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, dkpace,    dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "John Kowalski", "Donkey Kong Pace", MACHINE_SUPPORTS_SAVE )
GAME( 2017, dkchrmx,   dkong, dk_braze,  dkongx,  dkong_state,  init_dkongx, ROT270, "John Kowalski", "Donkey Kong Christmas Remix", MACHINE_SUPPORTS_SAVE )
GAME( 2023, dkremix,   dkong, dk_braze,  dkongx,  dkong_state,  init_dkongx, ROT270, "hack", "Donkey Kong Remix", MACHINE_SUPPORTS_SAVE )
GAME( 2018, dkspkyrmx, dkong, dk_braze,  dkongx,  dkong_state,  init_dkongx, ROT270, "John Kowalski", "Donkey Kong Spooky Remix", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkchrte,   dkong, dk_braze,  dkongx,  dkong_state,  init_dkongx, ROT270, "John Kowalski", "Donkey Kong Christmas Tournament Edition", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkongte,   dkong, dk_braze,  dkongx,  dkong_state,  init_dkongx, ROT270, "John Kowalski", "Donkey Kong Tournament Edition", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkspkyte,  dkong, dk_braze,  dkongx,  dkong_state,  init_dkongx, ROT270, "John Kowalski", "Donkey Kong Spooky Tournament Edition", MACHINE_SUPPORTS_SAVE )
GAME( 2019, dkongst,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "John Kowalski", "Donkey Kong Springs Trainer", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongst2,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "John Kowalski", "Donkey Kong Springs Trainer 2", MACHINE_SUPPORTS_SAVE )
GAME( 2019, dkongrev,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Reverse (2019-08-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, dkfreerun, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Freerun Edition (2019-06-20)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, dkcbarrel, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Crazy Barrels Edition (2019-10-04)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongklc,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong League Championship v1.00 (2020-02-28)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongce,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Championship Edition v1.01 (2020-03-06)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongrnd0, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Randomized Edition (2020-03-14)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongrnd,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Randomized Edition v1.01 (2020-05-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkrndmzr,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong RNDMZR v1.00 (2022-05-22)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongss,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Skip Start v1.00 (2020-05-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongotr6, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong On the Run (2020-04-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongotr7, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong On the Run (2020-05-25)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongotr8, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong On the Run (2020-05-26)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongotr9, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong On the Run (2020-05-26a)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongotr,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong On the Run v1.02 (2020-05-26)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongitd,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Into the Dark v1.02 (2020-04-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkongtj,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Twisted Jungle v1.05 (2020-12-12)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkjungle0, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Jungle (2020-07-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkjungle,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Jungle (2020-09-22)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dktwist0,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Twisted (2020-05-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dktwist,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Twisted (2020-08-21)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, dkbarpal2, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Barrelpalooza (2020-11-03)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkbarpal3, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Barrelpalooza v1.03 (2021-03-02)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkbarpal4, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Barrelpalooza v1.04 (2021-04-06)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkbarpal5, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Barrelpalooza v1.05 (2021-04-12)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkbarpal6, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Barrelpalooza v1.06 (2021-05-13)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkbarpal,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Barrelpalooza v1.07 (2021-06-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkongan0,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong 40th Anniversary Edition (2021-01-20)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkongan,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong 40th Anniversary Edition (2021-03-02)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkongdu0,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Duel v1.00 (2021-11-04)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkongdu1,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Duel v1.01 (2021-11-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, dkongdu,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Duel v1.02 (2021-11-10)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkwizard0, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Wizardry v1.00 (2022-02-09)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkwizard1, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Wizardry v1.01 (2022-02-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkwizard2, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Wizardry v1.02 (2022-02-13)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkwizard,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Wizardry v1.03 (2022-05-22)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, dksprfin,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Springfinity v1.01 (2022-04-29)", MACHINE_IS_INCOMPLETE | MACHINE_SUPPORTS_SAVE )
GAME( 2023, dksprfin2, dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Springfinity v1.02 (2023-08-15)", MACHINE_IS_INCOMPLETE | MACHINE_SUPPORTS_SAVE )
GAME( 2022, dkonghh,   dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong HeartHunt v1.01 (2022-10-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2023, dkbrlbss,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Barrel Boss v1.01 (2023-08-16)", MACHINE_IS_INCOMPLETE | MACHINE_SUPPORTS_SAVE )
GAME( 2023, dkongacc,  dkong, dkong2b,   dkong,   dkong_state,  empty_init,  ROT270, "Paul Goes", "Donkey Kong Accelerate v1.01 (2023-09-05)", MACHINE_SUPPORTS_SAVE )
// Donkey Kong Junior
GAME( 1982, dkongjr01, dkongjr,  dkongjr,   dkongjr,  dkong_state, empty_init,    ROT270, "John Kowalski", "Donkey Kong Junior (bugfixed)", MACHINE_SUPPORTS_SAVE )

