// license:GPL_2.0
// copyright-holders:Robbbert
#include "../mame/drivers/twin16.cpp"

ROM_START( gradius2s01 )
	ROM_REGION( 0x40000, "maincpu", 0 )
	ROM_LOAD16_BYTE( "785_w05.6n",  0x00000, 0x10000, CRC(956f2ea8) SHA1(8200378b62592685f6123bc39eb9e523b8c01702) ) // s01
	ROM_LOAD16_BYTE( "785_w04.4n",  0x00001, 0x10000, CRC(dfd4fbf2) SHA1(c077c9d0614bd71131265a319bf73890a4f92b55) ) // s01
	ROM_LOAD16_BYTE( "785_w09.6r",  0x20000, 0x10000, CRC(9142ae6e) SHA1(3595a4056964e487d57e9f95a608bc988c2a1b75) ) // s01
	ROM_LOAD16_BYTE( "785_w08.4r",  0x20001, 0x10000, CRC(065f3167) SHA1(60ee344d2390ed69f32f51fe7033e4ed2b2118a2) ) // s01

	ROM_REGION( 0x40000, "sub", 0 )
	ROM_LOAD16_BYTE( "785_p07.10n", 0x00000, 0x10000, CRC(686d549d) SHA1(9687be801c4fb963bf6b0199e2ae9f5051213f7a) )
	ROM_LOAD16_BYTE( "785_p06.8n",  0x00001, 0x10000, CRC(70c94bee) SHA1(951e00ca4d3a47a21b4db05bcdc8ead45b42c3f1) )
	ROM_LOAD16_BYTE( "785_p13.10s", 0x20000, 0x10000, CRC(478fdb0a) SHA1(2e285ad6dcfc67f3e24d231e0e1be19036ce64d2) )
	ROM_LOAD16_BYTE( "785_p12.8s",  0x20001, 0x10000, CRC(38ea402a) SHA1(90ff2bd71435988cde967704ce3b1401de206683) )

	ROM_REGION( 0x8000, "audiocpu", 0 )
	ROM_LOAD( "785_g03.10a", 0x00000,  0x8000, CRC(67a3b50d) SHA1(3c83f3b0df73d9361ec3cda26a6c4c603a088419) )

	ROM_REGION( 0x4000, "fixed", 0 )
	ROM_LOAD( "785_h14.d8", 0x0000, 0x4000, CRC(f48979a3) SHA1(74bbb394ea6b5feb091306f10d16e09989a9ab51) ) // s01

	ROM_REGION16_BE( 0x200000, "gfxrom", 0 )
	ROM_LOAD32_WORD_SWAP( "785f15.p13", 0x000000, 0x80000, CRC(5bd239ac) SHA1(9c96f6069d06a1d80c04650ed56bc5e1508db657) )
	ROM_LOAD32_WORD_SWAP( "785f17.p16", 0x000002, 0x80000, CRC(4e7a7b82) SHA1(520b5ebd400954042d55cf243842a6d6b6d10210) )
	ROM_LOAD32_WORD_SWAP( "785f16.p15", 0x100000, 0x80000, CRC(95c6b8a3) SHA1(0a906af72d08993fd83f23d72ffb919801aa17af) )
	ROM_LOAD32_WORD_SWAP( "785f18.p18", 0x100002, 0x80000, CRC(3f604e9a) SHA1(c5e0b6f6dd506209e8c07cbae89c821828f488ff) )

	ROM_REGION16_BE( 0x20000, "data", ROMREGION_ERASE00 )

	ROM_REGION( 0x20000, "k007232", 0 )
	ROM_LOAD( "785_f01.5a", 0x00000, 0x20000, CRC(a0d8d69e) SHA1(2994e5740b7c099d55fb162a363a26ef1995c756) )

	ROM_REGION( 0x20000, "upd", 0 )
	ROM_LOAD( "785_f02.7c", 0x00000, 0x20000, CRC(c39f5ca4) SHA1(92ebea11b7d3a72d0f58c456f16a6ff36d6b3062) )
ROM_END


GAME( 2008, gradius2s01, vulcan, twin16, gradius2, twin16_state, init_twin16, ROT0, "hack", "Gradius II - GOFER no Yabou (Ver xH, 2008-08-28)", MACHINE_SUPPORTS_SAVE )

