#ifndef NALL_BIT_HPP
#define NALL_BIT_HPP

namespace nall {
  template<int bits> constexpr inline unsigned uclamp(const unsigned x) {
    enum { y = (1U << (bits - 1)) + ((1U << (bits - 1)) - 1) };
    return y + ((x - y) & -(x < y));  //min(x, y);
  }

  template<int bits> constexpr inline unsigned uclip(const unsigned x) {
    return x & ((1U << (bits - 1)) + ((1U << (bits - 1)) - 1));
  }

  template<int bits> constexpr inline signed sclamp_b() {
    return 1U << (bits - 1);
  }

  template<int bits> constexpr inline signed sclamp_m() {
    return (1U << (bits - 1)) - 1;
  }

  template<int bits> constexpr inline signed sclamp(const signed x) {
    return (x > sclamp_m<bits>()) ? sclamp_m<bits>() : (x < -sclamp_b<bits>()) ? -sclamp_b<bits>() : x;
  }

  template<int bits> constexpr inline signed sclip_m() {
    return (1U << (bits)) - 1;
  }

  template<int bits> constexpr inline signed sclip(const signed x) {
    return ((x & sclip_m<bits>()) ^ sclamp_b<bits>()) - sclamp_b<bits>();
  }

  namespace bit {
    //lowest(0b1110) == 0b0010
    template<typename T> constexpr inline T lowest(const T x) {
      return x & -x;
    }

    //clear_lowest(0b1110) == 0b1100
    template<typename T> constexpr inline T clear_lowest(const T x) {
      return x & (x - 1);
    }

    //set_lowest(0b0101) == 0b0111
    template<typename T> constexpr inline T set_lowest(const T x) {
      return x | (x + 1);
    }

    //round up to next highest single bit:
    //round(15) == 16, round(16) == 16, round(17) == 32
    inline unsigned round(unsigned x) {
      if((x & (x - 1)) == 0) return x;
      while(x & (x - 1)) x &= x - 1;
      return x << 1;
    }
  }
}

#endif
