static void skein256_compress(uint64_t* out, const uint64_t* in, const uint64_t* key, const uint64_t* tweak)
{
	uint64_t k=key[0]^key[1]^key[2]^key[3]^0x1BD11BDAA9FC1A22ULL;
	uint64_t t=tweak[0]^tweak[1];
	out[0]=in[0];
	out[1]=in[1];
	out[2]=in[2];
	out[3]=in[3];
	out[0]+=key[0];
	out[1]+=key[1]+tweak[0];
	out[2]+=key[2]+tweak[1];
	out[3]+=key[3]+0;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 14)|(out[1] >> 50);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 52)|(out[3] >> 12);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 57)|(out[1] >> 7);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 40)|(out[3] >> 24);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 5)|(out[3] >> 59);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 37)|(out[1] >> 27);
	out[1]=out[2]^out[1];
	out[0]+=key[1];
	out[1]+=key[2]+tweak[1];
	out[2]+=key[3]+t;
	out[3]+=k+1;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 33)|(out[3] >> 31);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 46)|(out[3] >> 18);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 12)|(out[1] >> 52);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 58)|(out[1] >> 6);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 32)|(out[3] >> 32);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 32)|(out[1] >> 32);
	out[1]=out[2]^out[1];
	out[0]+=key[2];
	out[1]+=key[3]+t;
	out[2]+=k+tweak[0];
	out[3]+=key[0]+2;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 14)|(out[1] >> 50);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 52)|(out[3] >> 12);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 57)|(out[1] >> 7);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 40)|(out[3] >> 24);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 5)|(out[3] >> 59);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 37)|(out[1] >> 27);
	out[1]=out[2]^out[1];
	out[0]+=key[3];
	out[1]+=k+tweak[0];
	out[2]+=key[0]+tweak[1];
	out[3]+=key[1]+3;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 33)|(out[3] >> 31);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 46)|(out[3] >> 18);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 12)|(out[1] >> 52);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 58)|(out[1] >> 6);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 32)|(out[3] >> 32);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 32)|(out[1] >> 32);
	out[1]=out[2]^out[1];
	out[0]+=k;
	out[1]+=key[0]+tweak[1];
	out[2]+=key[1]+t;
	out[3]+=key[2]+4;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 14)|(out[1] >> 50);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 52)|(out[3] >> 12);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 57)|(out[1] >> 7);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 40)|(out[3] >> 24);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 5)|(out[3] >> 59);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 37)|(out[1] >> 27);
	out[1]=out[2]^out[1];
	out[0]+=key[0];
	out[1]+=key[1]+t;
	out[2]+=key[2]+tweak[0];
	out[3]+=key[3]+5;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 33)|(out[3] >> 31);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 46)|(out[3] >> 18);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 12)|(out[1] >> 52);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 58)|(out[1] >> 6);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 32)|(out[3] >> 32);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 32)|(out[1] >> 32);
	out[1]=out[2]^out[1];
	out[0]+=key[1];
	out[1]+=key[2]+tweak[0];
	out[2]+=key[3]+tweak[1];
	out[3]+=k+6;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 14)|(out[1] >> 50);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 52)|(out[3] >> 12);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 57)|(out[1] >> 7);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 40)|(out[3] >> 24);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 5)|(out[3] >> 59);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 37)|(out[1] >> 27);
	out[1]=out[2]^out[1];
	out[0]+=key[2];
	out[1]+=key[3]+tweak[1];
	out[2]+=k+t;
	out[3]+=key[0]+7;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 33)|(out[3] >> 31);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 46)|(out[3] >> 18);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 12)|(out[1] >> 52);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 58)|(out[1] >> 6);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 32)|(out[3] >> 32);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 32)|(out[1] >> 32);
	out[1]=out[2]^out[1];
	out[0]+=key[3];
	out[1]+=k+t;
	out[2]+=key[0]+tweak[0];
	out[3]+=key[1]+8;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 14)|(out[1] >> 50);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 52)|(out[3] >> 12);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 57)|(out[1] >> 7);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 40)|(out[3] >> 24);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 5)|(out[3] >> 59);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 37)|(out[1] >> 27);
	out[1]=out[2]^out[1];
	out[0]+=k;
	out[1]+=key[0]+tweak[0];
	out[2]+=key[1]+tweak[1];
	out[3]+=key[2]+9;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 33)|(out[3] >> 31);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 46)|(out[3] >> 18);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 12)|(out[1] >> 52);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 58)|(out[1] >> 6);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 32)|(out[3] >> 32);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 32)|(out[1] >> 32);
	out[1]=out[2]^out[1];
	out[0]+=key[0];
	out[1]+=key[1]+tweak[1];
	out[2]+=key[2]+t;
	out[3]+=key[3]+10;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 14)|(out[1] >> 50);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 52)|(out[3] >> 12);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 57)|(out[1] >> 7);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 40)|(out[3] >> 24);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 5)|(out[3] >> 59);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 37)|(out[1] >> 27);
	out[1]=out[2]^out[1];
	out[0]+=key[1];
	out[1]+=key[2]+t;
	out[2]+=key[3]+tweak[0];
	out[3]+=k+11;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 33)|(out[3] >> 31);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 46)|(out[3] >> 18);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 12)|(out[1] >> 52);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 58)|(out[1] >> 6);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 32)|(out[3] >> 32);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 32)|(out[1] >> 32);
	out[1]=out[2]^out[1];
	out[0]+=key[2];
	out[1]+=key[3]+tweak[0];
	out[2]+=k+tweak[1];
	out[3]+=key[0]+12;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 14)|(out[1] >> 50);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 52)|(out[3] >> 12);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 57)|(out[1] >> 7);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 40)|(out[3] >> 24);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 5)|(out[3] >> 59);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 37)|(out[1] >> 27);
	out[1]=out[2]^out[1];
	out[0]+=key[3];
	out[1]+=k+tweak[1];
	out[2]+=key[0]+t;
	out[3]+=key[1]+13;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 33)|(out[3] >> 31);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 46)|(out[3] >> 18);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 12)|(out[1] >> 52);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 58)|(out[1] >> 6);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 32)|(out[3] >> 32);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 32)|(out[1] >> 32);
	out[1]=out[2]^out[1];
	out[0]+=k;
	out[1]+=key[0]+t;
	out[2]+=key[1]+tweak[0];
	out[3]+=key[2]+14;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 14)|(out[1] >> 50);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 52)|(out[3] >> 12);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 57)|(out[1] >> 7);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 40)|(out[3] >> 24);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 5)|(out[3] >> 59);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 37)|(out[1] >> 27);
	out[1]=out[2]^out[1];
	out[0]+=key[0];
	out[1]+=key[1]+tweak[0];
	out[2]+=key[2]+tweak[1];
	out[3]+=key[3]+15;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 33)|(out[3] >> 31);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 46)|(out[3] >> 18);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 12)|(out[1] >> 52);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 58)|(out[1] >> 6);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 32)|(out[3] >> 32);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 32)|(out[1] >> 32);
	out[1]=out[2]^out[1];
	out[0]+=key[1];
	out[1]+=key[2]+tweak[1];
	out[2]+=key[3]+t;
	out[3]+=k+16;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 14)|(out[1] >> 50);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 52)|(out[3] >> 12);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 57)|(out[1] >> 7);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 40)|(out[3] >> 24);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 5)|(out[3] >> 59);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 37)|(out[1] >> 27);
	out[1]=out[2]^out[1];
	out[0]+=key[2];
	out[1]+=key[3]+t;
	out[2]+=k+tweak[0];
	out[3]+=key[0]+17;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 33)|(out[3] >> 31);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 46)|(out[3] >> 18);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 12)|(out[1] >> 52);
	out[1]=out[2]^out[1];
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 58)|(out[1] >> 6);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[2]^out[3];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 32)|(out[3] >> 32);
	out[3]=out[0]^out[3];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 32)|(out[1] >> 32);
	out[1]=out[2]^out[1];
	out[0]+=key[3];
	out[1]+=k+tweak[0];
	out[2]+=key[0]+tweak[1];
	out[3]+=key[1]+18;
	out[0]=in[0]^out[0];
	out[1]=in[1]^out[1];
	out[2]=in[2]^out[2];
	out[3]=in[3]^out[3];
	k = 0;
	t = 0;
	asm volatile("" : : "r"(&k) : "memory");
	asm volatile("" : : "r"(&t) : "memory");
}
static void skein512_compress(uint64_t* out, const uint64_t* in, const uint64_t* key, const uint64_t* tweak)
{
	uint64_t k=key[0]^key[1]^key[2]^key[3]^key[4]^key[5]^key[6]^key[7]^0x1BD11BDAA9FC1A22ULL;
	uint64_t t=tweak[0]^tweak[1];
	out[0]=in[0];
	out[1]=in[1];
	out[2]=in[2];
	out[3]=in[3];
	out[4]=in[4];
	out[5]=in[5];
	out[6]=in[6];
	out[7]=in[7];
	out[0]+=key[0];
	out[1]+=key[1];
	out[2]+=key[2];
	out[3]+=key[3];
	out[4]+=key[4];
	out[5]+=key[5]+tweak[0];
	out[6]+=key[6]+tweak[1];
	out[7]+=key[7]+0;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 36)|(out[3] >> 28);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 19)|(out[5] >> 45);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 37)|(out[7] >> 27);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 33)|(out[1] >> 31);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 27)|(out[7] >> 37);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 14)|(out[5] >> 50);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 42)|(out[3] >> 22);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 17)|(out[1] >> 47);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 49)|(out[3] >> 15);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 36)|(out[5] >> 28);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 39)|(out[7] >> 25);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 44)|(out[1] >> 20);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 9)|(out[7] >> 55);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 54)|(out[5] >> 10);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 56)|(out[3] >> 8);
	out[3]=out[4]^out[3];
	out[0]+=key[1];
	out[1]+=key[2];
	out[2]+=key[3];
	out[3]+=key[4];
	out[4]+=key[5];
	out[5]+=key[6]+tweak[1];
	out[6]+=key[7]+t;
	out[7]+=k+1;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 39)|(out[1] >> 25);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 30)|(out[3] >> 34);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 34)|(out[5] >> 30);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 24)|(out[7] >> 40);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 50)|(out[7] >> 14);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 10)|(out[5] >> 54);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 17)|(out[3] >> 47);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 29)|(out[3] >> 35);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 39)|(out[5] >> 25);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 43)|(out[7] >> 21);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 8)|(out[1] >> 56);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 35)|(out[7] >> 29);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 56)|(out[5] >> 8);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[4]^out[3];
	out[0]+=key[2];
	out[1]+=key[3];
	out[2]+=key[4];
	out[3]+=key[5];
	out[4]+=key[6];
	out[5]+=key[7]+t;
	out[6]+=k+tweak[0];
	out[7]+=key[0]+2;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 36)|(out[3] >> 28);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 19)|(out[5] >> 45);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 37)|(out[7] >> 27);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 33)|(out[1] >> 31);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 27)|(out[7] >> 37);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 14)|(out[5] >> 50);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 42)|(out[3] >> 22);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 17)|(out[1] >> 47);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 49)|(out[3] >> 15);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 36)|(out[5] >> 28);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 39)|(out[7] >> 25);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 44)|(out[1] >> 20);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 9)|(out[7] >> 55);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 54)|(out[5] >> 10);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 56)|(out[3] >> 8);
	out[3]=out[4]^out[3];
	out[0]+=key[3];
	out[1]+=key[4];
	out[2]+=key[5];
	out[3]+=key[6];
	out[4]+=key[7];
	out[5]+=k+tweak[0];
	out[6]+=key[0]+tweak[1];
	out[7]+=key[1]+3;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 39)|(out[1] >> 25);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 30)|(out[3] >> 34);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 34)|(out[5] >> 30);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 24)|(out[7] >> 40);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 50)|(out[7] >> 14);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 10)|(out[5] >> 54);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 17)|(out[3] >> 47);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 29)|(out[3] >> 35);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 39)|(out[5] >> 25);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 43)|(out[7] >> 21);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 8)|(out[1] >> 56);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 35)|(out[7] >> 29);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 56)|(out[5] >> 8);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[4]^out[3];
	out[0]+=key[4];
	out[1]+=key[5];
	out[2]+=key[6];
	out[3]+=key[7];
	out[4]+=k;
	out[5]+=key[0]+tweak[1];
	out[6]+=key[1]+t;
	out[7]+=key[2]+4;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 36)|(out[3] >> 28);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 19)|(out[5] >> 45);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 37)|(out[7] >> 27);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 33)|(out[1] >> 31);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 27)|(out[7] >> 37);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 14)|(out[5] >> 50);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 42)|(out[3] >> 22);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 17)|(out[1] >> 47);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 49)|(out[3] >> 15);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 36)|(out[5] >> 28);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 39)|(out[7] >> 25);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 44)|(out[1] >> 20);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 9)|(out[7] >> 55);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 54)|(out[5] >> 10);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 56)|(out[3] >> 8);
	out[3]=out[4]^out[3];
	out[0]+=key[5];
	out[1]+=key[6];
	out[2]+=key[7];
	out[3]+=k;
	out[4]+=key[0];
	out[5]+=key[1]+t;
	out[6]+=key[2]+tweak[0];
	out[7]+=key[3]+5;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 39)|(out[1] >> 25);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 30)|(out[3] >> 34);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 34)|(out[5] >> 30);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 24)|(out[7] >> 40);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 50)|(out[7] >> 14);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 10)|(out[5] >> 54);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 17)|(out[3] >> 47);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 29)|(out[3] >> 35);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 39)|(out[5] >> 25);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 43)|(out[7] >> 21);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 8)|(out[1] >> 56);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 35)|(out[7] >> 29);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 56)|(out[5] >> 8);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[4]^out[3];
	out[0]+=key[6];
	out[1]+=key[7];
	out[2]+=k;
	out[3]+=key[0];
	out[4]+=key[1];
	out[5]+=key[2]+tweak[0];
	out[6]+=key[3]+tweak[1];
	out[7]+=key[4]+6;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 36)|(out[3] >> 28);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 19)|(out[5] >> 45);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 37)|(out[7] >> 27);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 33)|(out[1] >> 31);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 27)|(out[7] >> 37);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 14)|(out[5] >> 50);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 42)|(out[3] >> 22);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 17)|(out[1] >> 47);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 49)|(out[3] >> 15);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 36)|(out[5] >> 28);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 39)|(out[7] >> 25);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 44)|(out[1] >> 20);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 9)|(out[7] >> 55);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 54)|(out[5] >> 10);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 56)|(out[3] >> 8);
	out[3]=out[4]^out[3];
	out[0]+=key[7];
	out[1]+=k;
	out[2]+=key[0];
	out[3]+=key[1];
	out[4]+=key[2];
	out[5]+=key[3]+tweak[1];
	out[6]+=key[4]+t;
	out[7]+=key[5]+7;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 39)|(out[1] >> 25);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 30)|(out[3] >> 34);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 34)|(out[5] >> 30);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 24)|(out[7] >> 40);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 50)|(out[7] >> 14);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 10)|(out[5] >> 54);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 17)|(out[3] >> 47);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 29)|(out[3] >> 35);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 39)|(out[5] >> 25);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 43)|(out[7] >> 21);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 8)|(out[1] >> 56);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 35)|(out[7] >> 29);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 56)|(out[5] >> 8);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[4]^out[3];
	out[0]+=k;
	out[1]+=key[0];
	out[2]+=key[1];
	out[3]+=key[2];
	out[4]+=key[3];
	out[5]+=key[4]+t;
	out[6]+=key[5]+tweak[0];
	out[7]+=key[6]+8;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 36)|(out[3] >> 28);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 19)|(out[5] >> 45);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 37)|(out[7] >> 27);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 33)|(out[1] >> 31);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 27)|(out[7] >> 37);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 14)|(out[5] >> 50);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 42)|(out[3] >> 22);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 17)|(out[1] >> 47);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 49)|(out[3] >> 15);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 36)|(out[5] >> 28);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 39)|(out[7] >> 25);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 44)|(out[1] >> 20);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 9)|(out[7] >> 55);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 54)|(out[5] >> 10);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 56)|(out[3] >> 8);
	out[3]=out[4]^out[3];
	out[0]+=key[0];
	out[1]+=key[1];
	out[2]+=key[2];
	out[3]+=key[3];
	out[4]+=key[4];
	out[5]+=key[5]+tweak[0];
	out[6]+=key[6]+tweak[1];
	out[7]+=key[7]+9;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 39)|(out[1] >> 25);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 30)|(out[3] >> 34);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 34)|(out[5] >> 30);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 24)|(out[7] >> 40);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 50)|(out[7] >> 14);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 10)|(out[5] >> 54);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 17)|(out[3] >> 47);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 29)|(out[3] >> 35);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 39)|(out[5] >> 25);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 43)|(out[7] >> 21);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 8)|(out[1] >> 56);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 35)|(out[7] >> 29);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 56)|(out[5] >> 8);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[4]^out[3];
	out[0]+=key[1];
	out[1]+=key[2];
	out[2]+=key[3];
	out[3]+=key[4];
	out[4]+=key[5];
	out[5]+=key[6]+tweak[1];
	out[6]+=key[7]+t;
	out[7]+=k+10;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 36)|(out[3] >> 28);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 19)|(out[5] >> 45);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 37)|(out[7] >> 27);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 33)|(out[1] >> 31);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 27)|(out[7] >> 37);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 14)|(out[5] >> 50);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 42)|(out[3] >> 22);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 17)|(out[1] >> 47);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 49)|(out[3] >> 15);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 36)|(out[5] >> 28);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 39)|(out[7] >> 25);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 44)|(out[1] >> 20);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 9)|(out[7] >> 55);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 54)|(out[5] >> 10);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 56)|(out[3] >> 8);
	out[3]=out[4]^out[3];
	out[0]+=key[2];
	out[1]+=key[3];
	out[2]+=key[4];
	out[3]+=key[5];
	out[4]+=key[6];
	out[5]+=key[7]+t;
	out[6]+=k+tweak[0];
	out[7]+=key[0]+11;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 39)|(out[1] >> 25);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 30)|(out[3] >> 34);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 34)|(out[5] >> 30);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 24)|(out[7] >> 40);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 50)|(out[7] >> 14);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 10)|(out[5] >> 54);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 17)|(out[3] >> 47);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 29)|(out[3] >> 35);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 39)|(out[5] >> 25);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 43)|(out[7] >> 21);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 8)|(out[1] >> 56);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 35)|(out[7] >> 29);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 56)|(out[5] >> 8);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[4]^out[3];
	out[0]+=key[3];
	out[1]+=key[4];
	out[2]+=key[5];
	out[3]+=key[6];
	out[4]+=key[7];
	out[5]+=k+tweak[0];
	out[6]+=key[0]+tweak[1];
	out[7]+=key[1]+12;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 36)|(out[3] >> 28);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 19)|(out[5] >> 45);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 37)|(out[7] >> 27);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 33)|(out[1] >> 31);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 27)|(out[7] >> 37);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 14)|(out[5] >> 50);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 42)|(out[3] >> 22);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 17)|(out[1] >> 47);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 49)|(out[3] >> 15);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 36)|(out[5] >> 28);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 39)|(out[7] >> 25);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 44)|(out[1] >> 20);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 9)|(out[7] >> 55);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 54)|(out[5] >> 10);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 56)|(out[3] >> 8);
	out[3]=out[4]^out[3];
	out[0]+=key[4];
	out[1]+=key[5];
	out[2]+=key[6];
	out[3]+=key[7];
	out[4]+=k;
	out[5]+=key[0]+tweak[1];
	out[6]+=key[1]+t;
	out[7]+=key[2]+13;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 39)|(out[1] >> 25);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 30)|(out[3] >> 34);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 34)|(out[5] >> 30);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 24)|(out[7] >> 40);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 50)|(out[7] >> 14);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 10)|(out[5] >> 54);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 17)|(out[3] >> 47);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 29)|(out[3] >> 35);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 39)|(out[5] >> 25);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 43)|(out[7] >> 21);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 8)|(out[1] >> 56);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 35)|(out[7] >> 29);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 56)|(out[5] >> 8);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[4]^out[3];
	out[0]+=key[5];
	out[1]+=key[6];
	out[2]+=key[7];
	out[3]+=k;
	out[4]+=key[0];
	out[5]+=key[1]+t;
	out[6]+=key[2]+tweak[0];
	out[7]+=key[3]+14;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 36)|(out[3] >> 28);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 19)|(out[5] >> 45);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 37)|(out[7] >> 27);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 33)|(out[1] >> 31);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 27)|(out[7] >> 37);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 14)|(out[5] >> 50);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 42)|(out[3] >> 22);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 17)|(out[1] >> 47);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 49)|(out[3] >> 15);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 36)|(out[5] >> 28);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 39)|(out[7] >> 25);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 44)|(out[1] >> 20);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 9)|(out[7] >> 55);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 54)|(out[5] >> 10);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 56)|(out[3] >> 8);
	out[3]=out[4]^out[3];
	out[0]+=key[6];
	out[1]+=key[7];
	out[2]+=k;
	out[3]+=key[0];
	out[4]+=key[1];
	out[5]+=key[2]+tweak[0];
	out[6]+=key[3]+tweak[1];
	out[7]+=key[4]+15;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 39)|(out[1] >> 25);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 30)|(out[3] >> 34);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 34)|(out[5] >> 30);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 24)|(out[7] >> 40);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 50)|(out[7] >> 14);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 10)|(out[5] >> 54);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 17)|(out[3] >> 47);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 29)|(out[3] >> 35);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 39)|(out[5] >> 25);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 43)|(out[7] >> 21);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 8)|(out[1] >> 56);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 35)|(out[7] >> 29);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 56)|(out[5] >> 8);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[4]^out[3];
	out[0]+=key[7];
	out[1]+=k;
	out[2]+=key[0];
	out[3]+=key[1];
	out[4]+=key[2];
	out[5]+=key[3]+tweak[1];
	out[6]+=key[4]+t;
	out[7]+=key[5]+16;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 36)|(out[3] >> 28);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 19)|(out[5] >> 45);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 37)|(out[7] >> 27);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 33)|(out[1] >> 31);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 27)|(out[7] >> 37);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 14)|(out[5] >> 50);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 42)|(out[3] >> 22);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 17)|(out[1] >> 47);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 49)|(out[3] >> 15);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 36)|(out[5] >> 28);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 39)|(out[7] >> 25);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 44)|(out[1] >> 20);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 9)|(out[7] >> 55);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 54)|(out[5] >> 10);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 56)|(out[3] >> 8);
	out[3]=out[4]^out[3];
	out[0]+=k;
	out[1]+=key[0];
	out[2]+=key[1];
	out[3]+=key[2];
	out[4]+=key[3];
	out[5]+=key[4]+t;
	out[6]+=key[5]+tweak[0];
	out[7]+=key[6]+17;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 39)|(out[1] >> 25);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 30)|(out[3] >> 34);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 34)|(out[5] >> 30);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 24)|(out[7] >> 40);
	out[7]=out[6]^out[7];
	out[2]=out[2]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[2]^out[1];
	out[4]=out[4]+out[7];
	out[7]=(out[7] << 50)|(out[7] >> 14);
	out[7]=out[4]^out[7];
	out[6]=out[6]+out[5];
	out[5]=(out[5] << 10)|(out[5] >> 54);
	out[5]=out[6]^out[5];
	out[0]=out[0]+out[3];
	out[3]=(out[3] << 17)|(out[3] >> 47);
	out[3]=out[0]^out[3];
	out[4]=out[4]+out[1];
	out[1]=(out[1] << 25)|(out[1] >> 39);
	out[1]=out[4]^out[1];
	out[6]=out[6]+out[3];
	out[3]=(out[3] << 29)|(out[3] >> 35);
	out[3]=out[6]^out[3];
	out[0]=out[0]+out[5];
	out[5]=(out[5] << 39)|(out[5] >> 25);
	out[5]=out[0]^out[5];
	out[2]=out[2]+out[7];
	out[7]=(out[7] << 43)|(out[7] >> 21);
	out[7]=out[2]^out[7];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 8)|(out[1] >> 56);
	out[1]=out[6]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 35)|(out[7] >> 29);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 56)|(out[5] >> 8);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 22)|(out[3] >> 42);
	out[3]=out[4]^out[3];
	out[0]+=key[0];
	out[1]+=key[1];
	out[2]+=key[2];
	out[3]+=key[3];
	out[4]+=key[4];
	out[5]+=key[5]+tweak[0];
	out[6]+=key[6]+tweak[1];
	out[7]+=key[7]+18;
	out[0]=in[0]^out[0];
	out[1]=in[1]^out[1];
	out[2]=in[2]^out[2];
	out[3]=in[3]^out[3];
	out[4]=in[4]^out[4];
	out[5]=in[5]^out[5];
	out[6]=in[6]^out[6];
	out[7]=in[7]^out[7];
	k = 0;
	t = 0;
	asm volatile("" : : "r"(&k) : "memory");
	asm volatile("" : : "r"(&t) : "memory");
}
static void skein1024_compress(uint64_t* out, const uint64_t* in, const uint64_t* key, const uint64_t* tweak)
{
	uint64_t k=key[0]^key[1]^key[2]^key[3]^key[4]^key[5]^key[6]^key[7]^key[8]^key[9]^key[10]^key[11]^key[12]^key[13]^key[14]^key[15]^0x1BD11BDAA9FC1A22ULL;
	uint64_t t=tweak[0]^tweak[1];
	out[0]=in[0];
	out[1]=in[1];
	out[2]=in[2];
	out[3]=in[3];
	out[4]=in[4];
	out[5]=in[5];
	out[6]=in[6];
	out[7]=in[7];
	out[8]=in[8];
	out[9]=in[9];
	out[10]=in[10];
	out[11]=in[11];
	out[12]=in[12];
	out[13]=in[13];
	out[14]=in[14];
	out[15]=in[15];
	out[0]+=key[0];
	out[1]+=key[1];
	out[2]+=key[2];
	out[3]+=key[3];
	out[4]+=key[4];
	out[5]+=key[5];
	out[6]+=key[6];
	out[7]+=key[7];
	out[8]+=key[8];
	out[9]+=key[9];
	out[10]+=key[10];
	out[11]+=key[11];
	out[12]+=key[12];
	out[13]+=key[13]+tweak[0];
	out[14]+=key[14]+tweak[1];
	out[15]+=key[15]+0;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 24)|(out[1] >> 40);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 13)|(out[3] >> 51);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 8)|(out[5] >> 56);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 47)|(out[7] >> 17);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 8)|(out[9] >> 56);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 17)|(out[11] >> 47);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 22)|(out[13] >> 42);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 37)|(out[15] >> 27);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 38)|(out[9] >> 26);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 19)|(out[13] >> 45);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 10)|(out[11] >> 54);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 55)|(out[15] >> 9);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 49)|(out[7] >> 15);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 18)|(out[3] >> 46);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 23)|(out[5] >> 41);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 52)|(out[1] >> 12);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 33)|(out[7] >> 31);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 4)|(out[5] >> 60);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 51)|(out[3] >> 13);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 34)|(out[15] >> 30);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 41)|(out[13] >> 23);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 59)|(out[11] >> 5);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 17)|(out[9] >> 47);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 5)|(out[15] >> 59);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 20)|(out[11] >> 44);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 48)|(out[13] >> 16);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 41)|(out[9] >> 23);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 47)|(out[1] >> 17);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 28)|(out[5] >> 36);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 25)|(out[7] >> 39);
	out[7]=out[12]^out[7];
	out[0]+=key[1];
	out[1]+=key[2];
	out[2]+=key[3];
	out[3]+=key[4];
	out[4]+=key[5];
	out[5]+=key[6];
	out[6]+=key[7];
	out[7]+=key[8];
	out[8]+=key[9];
	out[9]+=key[10];
	out[10]+=key[11];
	out[11]+=key[12];
	out[12]+=key[13];
	out[13]+=key[14]+tweak[1];
	out[14]+=key[15]+t;
	out[15]+=k+1;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 9)|(out[3] >> 55);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 37)|(out[5] >> 27);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 12)|(out[9] >> 52);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 47)|(out[11] >> 17);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 44)|(out[13] >> 20);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 30)|(out[15] >> 34);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 16)|(out[9] >> 48);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 34)|(out[13] >> 30);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 56)|(out[11] >> 8);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 51)|(out[15] >> 13);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 4)|(out[7] >> 60);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 53)|(out[3] >> 11);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 42)|(out[5] >> 22);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 44)|(out[5] >> 20);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 47)|(out[3] >> 17);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 19)|(out[15] >> 45);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 42)|(out[13] >> 22);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 44)|(out[11] >> 20);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 25)|(out[9] >> 39);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 9)|(out[15] >> 55);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 48)|(out[11] >> 16);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 35)|(out[13] >> 29);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 52)|(out[9] >> 12);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 31)|(out[5] >> 33);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 37)|(out[3] >> 27);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 20)|(out[7] >> 44);
	out[7]=out[12]^out[7];
	out[0]+=key[2];
	out[1]+=key[3];
	out[2]+=key[4];
	out[3]+=key[5];
	out[4]+=key[6];
	out[5]+=key[7];
	out[6]+=key[8];
	out[7]+=key[9];
	out[8]+=key[10];
	out[9]+=key[11];
	out[10]+=key[12];
	out[11]+=key[13];
	out[12]+=key[14];
	out[13]+=key[15]+t;
	out[14]+=k+tweak[0];
	out[15]+=key[0]+2;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 24)|(out[1] >> 40);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 13)|(out[3] >> 51);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 8)|(out[5] >> 56);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 47)|(out[7] >> 17);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 8)|(out[9] >> 56);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 17)|(out[11] >> 47);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 22)|(out[13] >> 42);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 37)|(out[15] >> 27);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 38)|(out[9] >> 26);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 19)|(out[13] >> 45);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 10)|(out[11] >> 54);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 55)|(out[15] >> 9);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 49)|(out[7] >> 15);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 18)|(out[3] >> 46);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 23)|(out[5] >> 41);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 52)|(out[1] >> 12);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 33)|(out[7] >> 31);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 4)|(out[5] >> 60);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 51)|(out[3] >> 13);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 34)|(out[15] >> 30);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 41)|(out[13] >> 23);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 59)|(out[11] >> 5);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 17)|(out[9] >> 47);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 5)|(out[15] >> 59);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 20)|(out[11] >> 44);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 48)|(out[13] >> 16);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 41)|(out[9] >> 23);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 47)|(out[1] >> 17);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 28)|(out[5] >> 36);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 25)|(out[7] >> 39);
	out[7]=out[12]^out[7];
	out[0]+=key[3];
	out[1]+=key[4];
	out[2]+=key[5];
	out[3]+=key[6];
	out[4]+=key[7];
	out[5]+=key[8];
	out[6]+=key[9];
	out[7]+=key[10];
	out[8]+=key[11];
	out[9]+=key[12];
	out[10]+=key[13];
	out[11]+=key[14];
	out[12]+=key[15];
	out[13]+=k+tweak[0];
	out[14]+=key[0]+tweak[1];
	out[15]+=key[1]+3;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 9)|(out[3] >> 55);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 37)|(out[5] >> 27);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 12)|(out[9] >> 52);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 47)|(out[11] >> 17);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 44)|(out[13] >> 20);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 30)|(out[15] >> 34);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 16)|(out[9] >> 48);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 34)|(out[13] >> 30);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 56)|(out[11] >> 8);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 51)|(out[15] >> 13);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 4)|(out[7] >> 60);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 53)|(out[3] >> 11);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 42)|(out[5] >> 22);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 44)|(out[5] >> 20);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 47)|(out[3] >> 17);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 19)|(out[15] >> 45);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 42)|(out[13] >> 22);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 44)|(out[11] >> 20);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 25)|(out[9] >> 39);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 9)|(out[15] >> 55);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 48)|(out[11] >> 16);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 35)|(out[13] >> 29);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 52)|(out[9] >> 12);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 31)|(out[5] >> 33);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 37)|(out[3] >> 27);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 20)|(out[7] >> 44);
	out[7]=out[12]^out[7];
	out[0]+=key[4];
	out[1]+=key[5];
	out[2]+=key[6];
	out[3]+=key[7];
	out[4]+=key[8];
	out[5]+=key[9];
	out[6]+=key[10];
	out[7]+=key[11];
	out[8]+=key[12];
	out[9]+=key[13];
	out[10]+=key[14];
	out[11]+=key[15];
	out[12]+=k;
	out[13]+=key[0]+tweak[1];
	out[14]+=key[1]+t;
	out[15]+=key[2]+4;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 24)|(out[1] >> 40);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 13)|(out[3] >> 51);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 8)|(out[5] >> 56);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 47)|(out[7] >> 17);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 8)|(out[9] >> 56);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 17)|(out[11] >> 47);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 22)|(out[13] >> 42);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 37)|(out[15] >> 27);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 38)|(out[9] >> 26);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 19)|(out[13] >> 45);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 10)|(out[11] >> 54);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 55)|(out[15] >> 9);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 49)|(out[7] >> 15);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 18)|(out[3] >> 46);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 23)|(out[5] >> 41);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 52)|(out[1] >> 12);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 33)|(out[7] >> 31);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 4)|(out[5] >> 60);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 51)|(out[3] >> 13);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 34)|(out[15] >> 30);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 41)|(out[13] >> 23);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 59)|(out[11] >> 5);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 17)|(out[9] >> 47);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 5)|(out[15] >> 59);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 20)|(out[11] >> 44);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 48)|(out[13] >> 16);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 41)|(out[9] >> 23);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 47)|(out[1] >> 17);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 28)|(out[5] >> 36);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 25)|(out[7] >> 39);
	out[7]=out[12]^out[7];
	out[0]+=key[5];
	out[1]+=key[6];
	out[2]+=key[7];
	out[3]+=key[8];
	out[4]+=key[9];
	out[5]+=key[10];
	out[6]+=key[11];
	out[7]+=key[12];
	out[8]+=key[13];
	out[9]+=key[14];
	out[10]+=key[15];
	out[11]+=k;
	out[12]+=key[0];
	out[13]+=key[1]+t;
	out[14]+=key[2]+tweak[0];
	out[15]+=key[3]+5;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 9)|(out[3] >> 55);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 37)|(out[5] >> 27);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 12)|(out[9] >> 52);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 47)|(out[11] >> 17);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 44)|(out[13] >> 20);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 30)|(out[15] >> 34);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 16)|(out[9] >> 48);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 34)|(out[13] >> 30);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 56)|(out[11] >> 8);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 51)|(out[15] >> 13);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 4)|(out[7] >> 60);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 53)|(out[3] >> 11);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 42)|(out[5] >> 22);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 44)|(out[5] >> 20);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 47)|(out[3] >> 17);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 19)|(out[15] >> 45);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 42)|(out[13] >> 22);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 44)|(out[11] >> 20);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 25)|(out[9] >> 39);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 9)|(out[15] >> 55);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 48)|(out[11] >> 16);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 35)|(out[13] >> 29);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 52)|(out[9] >> 12);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 31)|(out[5] >> 33);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 37)|(out[3] >> 27);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 20)|(out[7] >> 44);
	out[7]=out[12]^out[7];
	out[0]+=key[6];
	out[1]+=key[7];
	out[2]+=key[8];
	out[3]+=key[9];
	out[4]+=key[10];
	out[5]+=key[11];
	out[6]+=key[12];
	out[7]+=key[13];
	out[8]+=key[14];
	out[9]+=key[15];
	out[10]+=k;
	out[11]+=key[0];
	out[12]+=key[1];
	out[13]+=key[2]+tweak[0];
	out[14]+=key[3]+tweak[1];
	out[15]+=key[4]+6;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 24)|(out[1] >> 40);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 13)|(out[3] >> 51);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 8)|(out[5] >> 56);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 47)|(out[7] >> 17);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 8)|(out[9] >> 56);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 17)|(out[11] >> 47);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 22)|(out[13] >> 42);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 37)|(out[15] >> 27);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 38)|(out[9] >> 26);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 19)|(out[13] >> 45);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 10)|(out[11] >> 54);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 55)|(out[15] >> 9);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 49)|(out[7] >> 15);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 18)|(out[3] >> 46);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 23)|(out[5] >> 41);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 52)|(out[1] >> 12);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 33)|(out[7] >> 31);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 4)|(out[5] >> 60);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 51)|(out[3] >> 13);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 34)|(out[15] >> 30);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 41)|(out[13] >> 23);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 59)|(out[11] >> 5);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 17)|(out[9] >> 47);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 5)|(out[15] >> 59);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 20)|(out[11] >> 44);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 48)|(out[13] >> 16);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 41)|(out[9] >> 23);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 47)|(out[1] >> 17);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 28)|(out[5] >> 36);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 25)|(out[7] >> 39);
	out[7]=out[12]^out[7];
	out[0]+=key[7];
	out[1]+=key[8];
	out[2]+=key[9];
	out[3]+=key[10];
	out[4]+=key[11];
	out[5]+=key[12];
	out[6]+=key[13];
	out[7]+=key[14];
	out[8]+=key[15];
	out[9]+=k;
	out[10]+=key[0];
	out[11]+=key[1];
	out[12]+=key[2];
	out[13]+=key[3]+tweak[1];
	out[14]+=key[4]+t;
	out[15]+=key[5]+7;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 9)|(out[3] >> 55);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 37)|(out[5] >> 27);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 12)|(out[9] >> 52);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 47)|(out[11] >> 17);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 44)|(out[13] >> 20);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 30)|(out[15] >> 34);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 16)|(out[9] >> 48);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 34)|(out[13] >> 30);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 56)|(out[11] >> 8);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 51)|(out[15] >> 13);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 4)|(out[7] >> 60);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 53)|(out[3] >> 11);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 42)|(out[5] >> 22);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 44)|(out[5] >> 20);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 47)|(out[3] >> 17);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 19)|(out[15] >> 45);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 42)|(out[13] >> 22);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 44)|(out[11] >> 20);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 25)|(out[9] >> 39);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 9)|(out[15] >> 55);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 48)|(out[11] >> 16);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 35)|(out[13] >> 29);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 52)|(out[9] >> 12);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 31)|(out[5] >> 33);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 37)|(out[3] >> 27);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 20)|(out[7] >> 44);
	out[7]=out[12]^out[7];
	out[0]+=key[8];
	out[1]+=key[9];
	out[2]+=key[10];
	out[3]+=key[11];
	out[4]+=key[12];
	out[5]+=key[13];
	out[6]+=key[14];
	out[7]+=key[15];
	out[8]+=k;
	out[9]+=key[0];
	out[10]+=key[1];
	out[11]+=key[2];
	out[12]+=key[3];
	out[13]+=key[4]+t;
	out[14]+=key[5]+tweak[0];
	out[15]+=key[6]+8;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 24)|(out[1] >> 40);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 13)|(out[3] >> 51);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 8)|(out[5] >> 56);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 47)|(out[7] >> 17);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 8)|(out[9] >> 56);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 17)|(out[11] >> 47);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 22)|(out[13] >> 42);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 37)|(out[15] >> 27);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 38)|(out[9] >> 26);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 19)|(out[13] >> 45);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 10)|(out[11] >> 54);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 55)|(out[15] >> 9);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 49)|(out[7] >> 15);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 18)|(out[3] >> 46);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 23)|(out[5] >> 41);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 52)|(out[1] >> 12);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 33)|(out[7] >> 31);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 4)|(out[5] >> 60);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 51)|(out[3] >> 13);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 34)|(out[15] >> 30);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 41)|(out[13] >> 23);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 59)|(out[11] >> 5);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 17)|(out[9] >> 47);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 5)|(out[15] >> 59);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 20)|(out[11] >> 44);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 48)|(out[13] >> 16);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 41)|(out[9] >> 23);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 47)|(out[1] >> 17);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 28)|(out[5] >> 36);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 25)|(out[7] >> 39);
	out[7]=out[12]^out[7];
	out[0]+=key[9];
	out[1]+=key[10];
	out[2]+=key[11];
	out[3]+=key[12];
	out[4]+=key[13];
	out[5]+=key[14];
	out[6]+=key[15];
	out[7]+=k;
	out[8]+=key[0];
	out[9]+=key[1];
	out[10]+=key[2];
	out[11]+=key[3];
	out[12]+=key[4];
	out[13]+=key[5]+tweak[0];
	out[14]+=key[6]+tweak[1];
	out[15]+=key[7]+9;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 9)|(out[3] >> 55);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 37)|(out[5] >> 27);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 12)|(out[9] >> 52);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 47)|(out[11] >> 17);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 44)|(out[13] >> 20);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 30)|(out[15] >> 34);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 16)|(out[9] >> 48);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 34)|(out[13] >> 30);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 56)|(out[11] >> 8);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 51)|(out[15] >> 13);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 4)|(out[7] >> 60);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 53)|(out[3] >> 11);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 42)|(out[5] >> 22);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 44)|(out[5] >> 20);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 47)|(out[3] >> 17);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 19)|(out[15] >> 45);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 42)|(out[13] >> 22);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 44)|(out[11] >> 20);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 25)|(out[9] >> 39);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 9)|(out[15] >> 55);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 48)|(out[11] >> 16);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 35)|(out[13] >> 29);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 52)|(out[9] >> 12);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 31)|(out[5] >> 33);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 37)|(out[3] >> 27);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 20)|(out[7] >> 44);
	out[7]=out[12]^out[7];
	out[0]+=key[10];
	out[1]+=key[11];
	out[2]+=key[12];
	out[3]+=key[13];
	out[4]+=key[14];
	out[5]+=key[15];
	out[6]+=k;
	out[7]+=key[0];
	out[8]+=key[1];
	out[9]+=key[2];
	out[10]+=key[3];
	out[11]+=key[4];
	out[12]+=key[5];
	out[13]+=key[6]+tweak[1];
	out[14]+=key[7]+t;
	out[15]+=key[8]+10;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 24)|(out[1] >> 40);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 13)|(out[3] >> 51);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 8)|(out[5] >> 56);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 47)|(out[7] >> 17);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 8)|(out[9] >> 56);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 17)|(out[11] >> 47);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 22)|(out[13] >> 42);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 37)|(out[15] >> 27);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 38)|(out[9] >> 26);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 19)|(out[13] >> 45);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 10)|(out[11] >> 54);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 55)|(out[15] >> 9);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 49)|(out[7] >> 15);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 18)|(out[3] >> 46);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 23)|(out[5] >> 41);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 52)|(out[1] >> 12);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 33)|(out[7] >> 31);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 4)|(out[5] >> 60);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 51)|(out[3] >> 13);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 34)|(out[15] >> 30);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 41)|(out[13] >> 23);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 59)|(out[11] >> 5);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 17)|(out[9] >> 47);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 5)|(out[15] >> 59);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 20)|(out[11] >> 44);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 48)|(out[13] >> 16);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 41)|(out[9] >> 23);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 47)|(out[1] >> 17);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 28)|(out[5] >> 36);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 25)|(out[7] >> 39);
	out[7]=out[12]^out[7];
	out[0]+=key[11];
	out[1]+=key[12];
	out[2]+=key[13];
	out[3]+=key[14];
	out[4]+=key[15];
	out[5]+=k;
	out[6]+=key[0];
	out[7]+=key[1];
	out[8]+=key[2];
	out[9]+=key[3];
	out[10]+=key[4];
	out[11]+=key[5];
	out[12]+=key[6];
	out[13]+=key[7]+t;
	out[14]+=key[8]+tweak[0];
	out[15]+=key[9]+11;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 9)|(out[3] >> 55);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 37)|(out[5] >> 27);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 12)|(out[9] >> 52);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 47)|(out[11] >> 17);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 44)|(out[13] >> 20);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 30)|(out[15] >> 34);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 16)|(out[9] >> 48);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 34)|(out[13] >> 30);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 56)|(out[11] >> 8);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 51)|(out[15] >> 13);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 4)|(out[7] >> 60);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 53)|(out[3] >> 11);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 42)|(out[5] >> 22);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 44)|(out[5] >> 20);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 47)|(out[3] >> 17);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 19)|(out[15] >> 45);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 42)|(out[13] >> 22);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 44)|(out[11] >> 20);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 25)|(out[9] >> 39);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 9)|(out[15] >> 55);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 48)|(out[11] >> 16);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 35)|(out[13] >> 29);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 52)|(out[9] >> 12);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 31)|(out[5] >> 33);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 37)|(out[3] >> 27);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 20)|(out[7] >> 44);
	out[7]=out[12]^out[7];
	out[0]+=key[12];
	out[1]+=key[13];
	out[2]+=key[14];
	out[3]+=key[15];
	out[4]+=k;
	out[5]+=key[0];
	out[6]+=key[1];
	out[7]+=key[2];
	out[8]+=key[3];
	out[9]+=key[4];
	out[10]+=key[5];
	out[11]+=key[6];
	out[12]+=key[7];
	out[13]+=key[8]+tweak[0];
	out[14]+=key[9]+tweak[1];
	out[15]+=key[10]+12;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 24)|(out[1] >> 40);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 13)|(out[3] >> 51);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 8)|(out[5] >> 56);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 47)|(out[7] >> 17);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 8)|(out[9] >> 56);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 17)|(out[11] >> 47);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 22)|(out[13] >> 42);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 37)|(out[15] >> 27);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 38)|(out[9] >> 26);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 19)|(out[13] >> 45);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 10)|(out[11] >> 54);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 55)|(out[15] >> 9);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 49)|(out[7] >> 15);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 18)|(out[3] >> 46);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 23)|(out[5] >> 41);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 52)|(out[1] >> 12);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 33)|(out[7] >> 31);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 4)|(out[5] >> 60);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 51)|(out[3] >> 13);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 34)|(out[15] >> 30);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 41)|(out[13] >> 23);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 59)|(out[11] >> 5);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 17)|(out[9] >> 47);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 5)|(out[15] >> 59);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 20)|(out[11] >> 44);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 48)|(out[13] >> 16);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 41)|(out[9] >> 23);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 47)|(out[1] >> 17);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 28)|(out[5] >> 36);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 25)|(out[7] >> 39);
	out[7]=out[12]^out[7];
	out[0]+=key[13];
	out[1]+=key[14];
	out[2]+=key[15];
	out[3]+=k;
	out[4]+=key[0];
	out[5]+=key[1];
	out[6]+=key[2];
	out[7]+=key[3];
	out[8]+=key[4];
	out[9]+=key[5];
	out[10]+=key[6];
	out[11]+=key[7];
	out[12]+=key[8];
	out[13]+=key[9]+tweak[1];
	out[14]+=key[10]+t;
	out[15]+=key[11]+13;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 9)|(out[3] >> 55);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 37)|(out[5] >> 27);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 12)|(out[9] >> 52);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 47)|(out[11] >> 17);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 44)|(out[13] >> 20);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 30)|(out[15] >> 34);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 16)|(out[9] >> 48);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 34)|(out[13] >> 30);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 56)|(out[11] >> 8);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 51)|(out[15] >> 13);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 4)|(out[7] >> 60);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 53)|(out[3] >> 11);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 42)|(out[5] >> 22);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 44)|(out[5] >> 20);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 47)|(out[3] >> 17);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 19)|(out[15] >> 45);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 42)|(out[13] >> 22);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 44)|(out[11] >> 20);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 25)|(out[9] >> 39);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 9)|(out[15] >> 55);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 48)|(out[11] >> 16);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 35)|(out[13] >> 29);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 52)|(out[9] >> 12);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 31)|(out[5] >> 33);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 37)|(out[3] >> 27);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 20)|(out[7] >> 44);
	out[7]=out[12]^out[7];
	out[0]+=key[14];
	out[1]+=key[15];
	out[2]+=k;
	out[3]+=key[0];
	out[4]+=key[1];
	out[5]+=key[2];
	out[6]+=key[3];
	out[7]+=key[4];
	out[8]+=key[5];
	out[9]+=key[6];
	out[10]+=key[7];
	out[11]+=key[8];
	out[12]+=key[9];
	out[13]+=key[10]+t;
	out[14]+=key[11]+tweak[0];
	out[15]+=key[12]+14;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 24)|(out[1] >> 40);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 13)|(out[3] >> 51);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 8)|(out[5] >> 56);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 47)|(out[7] >> 17);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 8)|(out[9] >> 56);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 17)|(out[11] >> 47);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 22)|(out[13] >> 42);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 37)|(out[15] >> 27);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 38)|(out[9] >> 26);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 19)|(out[13] >> 45);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 10)|(out[11] >> 54);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 55)|(out[15] >> 9);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 49)|(out[7] >> 15);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 18)|(out[3] >> 46);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 23)|(out[5] >> 41);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 52)|(out[1] >> 12);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 33)|(out[7] >> 31);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 4)|(out[5] >> 60);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 51)|(out[3] >> 13);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 34)|(out[15] >> 30);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 41)|(out[13] >> 23);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 59)|(out[11] >> 5);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 17)|(out[9] >> 47);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 5)|(out[15] >> 59);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 20)|(out[11] >> 44);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 48)|(out[13] >> 16);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 41)|(out[9] >> 23);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 47)|(out[1] >> 17);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 28)|(out[5] >> 36);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 25)|(out[7] >> 39);
	out[7]=out[12]^out[7];
	out[0]+=key[15];
	out[1]+=k;
	out[2]+=key[0];
	out[3]+=key[1];
	out[4]+=key[2];
	out[5]+=key[3];
	out[6]+=key[4];
	out[7]+=key[5];
	out[8]+=key[6];
	out[9]+=key[7];
	out[10]+=key[8];
	out[11]+=key[9];
	out[12]+=key[10];
	out[13]+=key[11]+tweak[0];
	out[14]+=key[12]+tweak[1];
	out[15]+=key[13]+15;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 9)|(out[3] >> 55);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 37)|(out[5] >> 27);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 12)|(out[9] >> 52);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 47)|(out[11] >> 17);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 44)|(out[13] >> 20);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 30)|(out[15] >> 34);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 16)|(out[9] >> 48);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 34)|(out[13] >> 30);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 56)|(out[11] >> 8);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 51)|(out[15] >> 13);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 4)|(out[7] >> 60);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 53)|(out[3] >> 11);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 42)|(out[5] >> 22);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 44)|(out[5] >> 20);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 47)|(out[3] >> 17);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 19)|(out[15] >> 45);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 42)|(out[13] >> 22);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 44)|(out[11] >> 20);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 25)|(out[9] >> 39);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 9)|(out[15] >> 55);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 48)|(out[11] >> 16);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 35)|(out[13] >> 29);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 52)|(out[9] >> 12);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 31)|(out[5] >> 33);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 37)|(out[3] >> 27);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 20)|(out[7] >> 44);
	out[7]=out[12]^out[7];
	out[0]+=k;
	out[1]+=key[0];
	out[2]+=key[1];
	out[3]+=key[2];
	out[4]+=key[3];
	out[5]+=key[4];
	out[6]+=key[5];
	out[7]+=key[6];
	out[8]+=key[7];
	out[9]+=key[8];
	out[10]+=key[9];
	out[11]+=key[10];
	out[12]+=key[11];
	out[13]+=key[12]+tweak[1];
	out[14]+=key[13]+t;
	out[15]+=key[14]+16;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 24)|(out[1] >> 40);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 13)|(out[3] >> 51);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 8)|(out[5] >> 56);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 47)|(out[7] >> 17);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 8)|(out[9] >> 56);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 17)|(out[11] >> 47);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 22)|(out[13] >> 42);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 37)|(out[15] >> 27);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 38)|(out[9] >> 26);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 19)|(out[13] >> 45);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 10)|(out[11] >> 54);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 55)|(out[15] >> 9);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 49)|(out[7] >> 15);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 18)|(out[3] >> 46);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 23)|(out[5] >> 41);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 52)|(out[1] >> 12);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 33)|(out[7] >> 31);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 4)|(out[5] >> 60);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 51)|(out[3] >> 13);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 34)|(out[15] >> 30);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 41)|(out[13] >> 23);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 59)|(out[11] >> 5);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 17)|(out[9] >> 47);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 5)|(out[15] >> 59);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 20)|(out[11] >> 44);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 48)|(out[13] >> 16);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 41)|(out[9] >> 23);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 47)|(out[1] >> 17);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 28)|(out[5] >> 36);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 25)|(out[7] >> 39);
	out[7]=out[12]^out[7];
	out[0]+=key[0];
	out[1]+=key[1];
	out[2]+=key[2];
	out[3]+=key[3];
	out[4]+=key[4];
	out[5]+=key[5];
	out[6]+=key[6];
	out[7]+=key[7];
	out[8]+=key[8];
	out[9]+=key[9];
	out[10]+=key[10];
	out[11]+=key[11];
	out[12]+=key[12];
	out[13]+=key[13]+t;
	out[14]+=key[14]+tweak[0];
	out[15]+=key[15]+17;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 9)|(out[3] >> 55);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 37)|(out[5] >> 27);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 12)|(out[9] >> 52);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 47)|(out[11] >> 17);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 44)|(out[13] >> 20);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 30)|(out[15] >> 34);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 16)|(out[9] >> 48);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 34)|(out[13] >> 30);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 56)|(out[11] >> 8);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 51)|(out[15] >> 13);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 4)|(out[7] >> 60);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 53)|(out[3] >> 11);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 42)|(out[5] >> 22);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 44)|(out[5] >> 20);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 47)|(out[3] >> 17);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 19)|(out[15] >> 45);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 42)|(out[13] >> 22);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 44)|(out[11] >> 20);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 25)|(out[9] >> 39);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 9)|(out[15] >> 55);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 48)|(out[11] >> 16);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 35)|(out[13] >> 29);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 52)|(out[9] >> 12);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 31)|(out[5] >> 33);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 37)|(out[3] >> 27);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 20)|(out[7] >> 44);
	out[7]=out[12]^out[7];
	out[0]+=key[1];
	out[1]+=key[2];
	out[2]+=key[3];
	out[3]+=key[4];
	out[4]+=key[5];
	out[5]+=key[6];
	out[6]+=key[7];
	out[7]+=key[8];
	out[8]+=key[9];
	out[9]+=key[10];
	out[10]+=key[11];
	out[11]+=key[12];
	out[12]+=key[13];
	out[13]+=key[14]+tweak[0];
	out[14]+=key[15]+tweak[1];
	out[15]+=k+18;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 24)|(out[1] >> 40);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 13)|(out[3] >> 51);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 8)|(out[5] >> 56);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 47)|(out[7] >> 17);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 8)|(out[9] >> 56);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 17)|(out[11] >> 47);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 22)|(out[13] >> 42);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 37)|(out[15] >> 27);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 38)|(out[9] >> 26);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 19)|(out[13] >> 45);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 10)|(out[11] >> 54);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 55)|(out[15] >> 9);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 49)|(out[7] >> 15);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 18)|(out[3] >> 46);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 23)|(out[5] >> 41);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 52)|(out[1] >> 12);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 33)|(out[7] >> 31);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 4)|(out[5] >> 60);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 51)|(out[3] >> 13);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 13)|(out[1] >> 51);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 34)|(out[15] >> 30);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 41)|(out[13] >> 23);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 59)|(out[11] >> 5);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 17)|(out[9] >> 47);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 5)|(out[15] >> 59);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 20)|(out[11] >> 44);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 48)|(out[13] >> 16);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 41)|(out[9] >> 23);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 47)|(out[1] >> 17);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 28)|(out[5] >> 36);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 16)|(out[3] >> 48);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 25)|(out[7] >> 39);
	out[7]=out[12]^out[7];
	out[0]+=key[2];
	out[1]+=key[3];
	out[2]+=key[4];
	out[3]+=key[5];
	out[4]+=key[6];
	out[5]+=key[7];
	out[6]+=key[8];
	out[7]+=key[9];
	out[8]+=key[10];
	out[9]+=key[11];
	out[10]+=key[12];
	out[11]+=key[13];
	out[12]+=key[14];
	out[13]+=key[15]+tweak[1];
	out[14]+=k+t;
	out[15]+=key[0]+19;
	out[0]=out[0]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[0]^out[1];
	out[2]=out[2]+out[3];
	out[3]=(out[3] << 9)|(out[3] >> 55);
	out[3]=out[2]^out[3];
	out[4]=out[4]+out[5];
	out[5]=(out[5] << 37)|(out[5] >> 27);
	out[5]=out[4]^out[5];
	out[6]=out[6]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[6]^out[7];
	out[8]=out[8]+out[9];
	out[9]=(out[9] << 12)|(out[9] >> 52);
	out[9]=out[8]^out[9];
	out[10]=out[10]+out[11];
	out[11]=(out[11] << 47)|(out[11] >> 17);
	out[11]=out[10]^out[11];
	out[12]=out[12]+out[13];
	out[13]=(out[13] << 44)|(out[13] >> 20);
	out[13]=out[12]^out[13];
	out[14]=out[14]+out[15];
	out[15]=(out[15] << 30)|(out[15] >> 34);
	out[15]=out[14]^out[15];
	out[0]=out[0]+out[9];
	out[9]=(out[9] << 16)|(out[9] >> 48);
	out[9]=out[0]^out[9];
	out[2]=out[2]+out[13];
	out[13]=(out[13] << 34)|(out[13] >> 30);
	out[13]=out[2]^out[13];
	out[6]=out[6]+out[11];
	out[11]=(out[11] << 56)|(out[11] >> 8);
	out[11]=out[6]^out[11];
	out[4]=out[4]+out[15];
	out[15]=(out[15] << 51)|(out[15] >> 13);
	out[15]=out[4]^out[15];
	out[10]=out[10]+out[7];
	out[7]=(out[7] << 4)|(out[7] >> 60);
	out[7]=out[10]^out[7];
	out[12]=out[12]+out[3];
	out[3]=(out[3] << 53)|(out[3] >> 11);
	out[3]=out[12]^out[3];
	out[14]=out[14]+out[5];
	out[5]=(out[5] << 42)|(out[5] >> 22);
	out[5]=out[14]^out[5];
	out[8]=out[8]+out[1];
	out[1]=(out[1] << 41)|(out[1] >> 23);
	out[1]=out[8]^out[1];
	out[0]=out[0]+out[7];
	out[7]=(out[7] << 31)|(out[7] >> 33);
	out[7]=out[0]^out[7];
	out[2]=out[2]+out[5];
	out[5]=(out[5] << 44)|(out[5] >> 20);
	out[5]=out[2]^out[5];
	out[4]=out[4]+out[3];
	out[3]=(out[3] << 47)|(out[3] >> 17);
	out[3]=out[4]^out[3];
	out[6]=out[6]+out[1];
	out[1]=(out[1] << 46)|(out[1] >> 18);
	out[1]=out[6]^out[1];
	out[12]=out[12]+out[15];
	out[15]=(out[15] << 19)|(out[15] >> 45);
	out[15]=out[12]^out[15];
	out[14]=out[14]+out[13];
	out[13]=(out[13] << 42)|(out[13] >> 22);
	out[13]=out[14]^out[13];
	out[8]=out[8]+out[11];
	out[11]=(out[11] << 44)|(out[11] >> 20);
	out[11]=out[8]^out[11];
	out[10]=out[10]+out[9];
	out[9]=(out[9] << 25)|(out[9] >> 39);
	out[9]=out[10]^out[9];
	out[0]=out[0]+out[15];
	out[15]=(out[15] << 9)|(out[15] >> 55);
	out[15]=out[0]^out[15];
	out[2]=out[2]+out[11];
	out[11]=(out[11] << 48)|(out[11] >> 16);
	out[11]=out[2]^out[11];
	out[6]=out[6]+out[13];
	out[13]=(out[13] << 35)|(out[13] >> 29);
	out[13]=out[6]^out[13];
	out[4]=out[4]+out[9];
	out[9]=(out[9] << 52)|(out[9] >> 12);
	out[9]=out[4]^out[9];
	out[14]=out[14]+out[1];
	out[1]=(out[1] << 23)|(out[1] >> 41);
	out[1]=out[14]^out[1];
	out[8]=out[8]+out[5];
	out[5]=(out[5] << 31)|(out[5] >> 33);
	out[5]=out[8]^out[5];
	out[10]=out[10]+out[3];
	out[3]=(out[3] << 37)|(out[3] >> 27);
	out[3]=out[10]^out[3];
	out[12]=out[12]+out[7];
	out[7]=(out[7] << 20)|(out[7] >> 44);
	out[7]=out[12]^out[7];
	out[0]+=key[3];
	out[1]+=key[4];
	out[2]+=key[5];
	out[3]+=key[6];
	out[4]+=key[7];
	out[5]+=key[8];
	out[6]+=key[9];
	out[7]+=key[10];
	out[8]+=key[11];
	out[9]+=key[12];
	out[10]+=key[13];
	out[11]+=key[14];
	out[12]+=key[15];
	out[13]+=k+t;
	out[14]+=key[0]+tweak[0];
	out[15]+=key[1]+20;
	out[0]=in[0]^out[0];
	out[1]=in[1]^out[1];
	out[2]=in[2]^out[2];
	out[3]=in[3]^out[3];
	out[4]=in[4]^out[4];
	out[5]=in[5]^out[5];
	out[6]=in[6]^out[6];
	out[7]=in[7]^out[7];
	out[8]=in[8]^out[8];
	out[9]=in[9]^out[9];
	out[10]=in[10]^out[10];
	out[11]=in[11]^out[11];
	out[12]=in[12]^out[12];
	out[13]=in[13]^out[13];
	out[14]=in[14]^out[14];
	out[15]=in[15]^out[15];
	k = 0;
	t = 0;
	asm volatile("" : : "r"(&k) : "memory");
	asm volatile("" : : "r"(&t) : "memory");
}
