; *****************************************************************************
; *****************************************************************************
;
;       File    : Keys.Inc
;       Purpose : Keyboard Scan Codes, TNES
;       Created : 24th September 1997
;       Modified: 1st January 1998
;
; *****************************************************************************
; *****************************************************************************

kEsc    = 01h                           ; Keyboard Scan Codes

k0      = 0Bh                           ; Number keys 0-9
k1      = 02h
k2      = 03h
k3      = 04h
k4      = 05h
k5      = 06h
k6      = 07h
k7      = 08h
k8      = 09h
k9      = 0Ah

kA      = 1Eh                           ; Letters A-F
kB      = 30h
kC      = 2Eh
kD      = 20h
kE      = 12h
kF      = 21h

kG      = 22h                           ; Letters G-Z
kH      = 23h
kI      = 17h
kJ      = 24h
kK      = 25h
kL      = 26h
kM      = 32H
kN      = 31h
kO      = 18h
kP      = 19h
kQ      = 10h
kR      = 13h
kS      = 1Fh
kT      = 14h
kU      = 16h
kV      = 2Fh
kW      = 11h
kX      = 2Dh
kY      = 15h
kZ      = 2Ch

kCtrl   = 1Dh                           ; control keys
kShiftL = 2Ah
kShiftR = 36h
KAlt    = 38h

kF1     = 3Bh                           ; function keys
kF2     = 3Ch                           ; you can't use these for game
kF3     = 3Dh                           ; keys...
kF4     = 3Eh
kF5     = 3Fh
kF6     = 40h
kF7     = 41h
kF8     = 42h
kF9     = 43h
kF10    = 44h

kSpace  = 39h                           ; space bar
kEnter  = 1Ch                           ; return key

kBackSpace = 0Eh                        ; backspace key
kUp     = 048h                          ; arrow keys
kDown   = 050h
kLeft   = 04Bh
kRight  = 04Dh
kPageUp = 049h                          ; Other Control keys
kPageDn = 051h
kHome   = 047h
kEnd    = 04Fh
kTab    = 00Fh

kSemi   = 27h                           ; Punctuation Keys
kEqual  = 0Dh
kStop   = 34h
kDiv    = 35h                           ; this is used for switch videomode
kMinus  = 0Ch
kComma  = 33h
kQuote =  28h
kXPlus =  4Eh                           ; this is used for accelerate
