/*
 * Decompiled with CFR 0.152.
 */
package machine;

import gui.Screen;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import machine.Clock;
import machine.Config;
import machine.Keyboard;
import machine.MTimer;
import machine.Memory;
import machine.Tape;
import z80core.MemIoOps;
import z80core.NotifyOps;
import z80core.Z80;

public class Ondra
extends Thread
implements MemIoOps,
NotifyOps {
    private final int T_DMAOFF = 40000;
    private final int T_DMAON = 10000;
    private Screen scr;
    private BufferedImage img = new BufferedImage(320, 256, 12);
    private byte[] px = ((DataBufferByte)this.img.getRaster().getDataBuffer()).getBankData()[0];
    private Config cfg = new Config();
    private Keyboard key;
    public Memory mem = new Memory(this, this.cfg);
    private Timer tim = new Timer("Timer");
    private MTimer task;
    public Clock clk = new Clock();
    private Z80 cpu = new Z80(this.clk, this, this);
    private Tape tap;
    public JLabel GreenLed;
    public JLabel YellowLed;
    public JLabel TapeLed;
    public JToggleButton RecButton;
    private boolean paused;
    private int[] dispAdr;
    public byte portA0;
    public byte portA1;
    public byte portA3;
    private byte[] iov;
    private int t_frame = 40000;
    private boolean tapestart;

    public Ondra() {
        this.iov = new byte[this.mem.PAGE_SIZE];
        this.mem.setIOVect(this.iov);
        this.key = new Keyboard(this.iov);
        this.dispAdr = new int[10240];
        this.genDispTables();
        this.tap = new Tape(this);
        this.paused = true;
        this.Reset(true);
    }

    public void setConfig(Config c) {
        if (!this.cfg.equals(c)) {
            this.cfg = c;
            this.Reset(false);
        }
    }

    public Config getConfig() {
        return this.cfg;
    }

    public void setScreen(Screen screen) {
        this.scr = screen;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public Keyboard getKeyboard() {
        return this.key;
    }

    public void setGreenLed(JLabel led) {
        this.GreenLed = led;
    }

    public void setYellowLed(JLabel led) {
        this.YellowLed = led;
    }

    public void setTapeLed(JLabel led) {
        this.TapeLed = led;
    }

    public void setRecButton(JToggleButton b) {
        this.RecButton = b;
    }

    public final void Reset(boolean dirty) {
        this.portA0 = 0;
        this.portA3 = 0;
        this.t_frame = 40000;
        this.mem.Reset(dirty);
        this.mem.mapRom(true);
        this.clk.reset();
        this.cpu.reset();
        this.key.Reset();
        this.tapestart = false;
        if (this.RecButton != null) {
            this.tap.tapeStop();
        }
    }

    public final void Nmi() {
        this.cpu.setNMI(true);
        this.cpu.execute(this.clk.getTstates() + 8);
        this.cpu.setNMI(false);
    }

    public void startEmulation() {
        if (!this.paused) {
            return;
        }
        this.scr.repaint();
        this.paused = false;
        this.task = new MTimer(this);
        this.tim.scheduleAtFixedRate((TimerTask)this.task, 250L, 20L);
    }

    public void stopEmulation() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        this.task.cancel();
    }

    public boolean isPaused() {
        return this.paused;
    }

    private void genDispTables() {
        for (int n = 0; n < 10240; ++n) {
            this.dispAdr[n] = -1;
        }
        int adr = 0;
        for (int y = 255; y != 0; --y) {
            for (int x = 65280; x != 55040; x -= 256) {
                int vm = y >>> 1 | (y & 1) << 7 | x;
                this.dispAdr[vm - 55296] = adr;
                this.px[adr++] = this.mem.readRam(y >>> 1 | (y & 1) << 7 | x);
            }
        }
    }

    public void ms20() {
        if (!this.paused) {
            this.scr.repaint();
            this.cpu.setINTLine(true);
            this.cpu.execute(this.clk.getTstates() + 16);
            this.cpu.setINTLine(false);
            this.cpu.execute(this.clk.getTstates() + this.t_frame);
        }
    }

    @Override
    public void run() {
        this.startEmulation();
        boolean forever = true;
        while (forever) {
            try {
                Ondra.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Ondra.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void processVram(int address, int data) {
        data &= 0xFF;
        int x = this.dispAdr[address - 55296];
        if (x != -1) {
            this.px[x] = (byte)data;
        }
    }

    @Override
    public int fetchOpcode(int address) {
        this.clk.addTstates(4);
        int opcode = this.mem.readByte(address) & 0xFF;
        return opcode;
    }

    @Override
    public int peek8(int address) {
        this.clk.addTstates(3);
        int value = this.mem.readByte(address) & 0xFF;
        return value;
    }

    @Override
    public void poke8(int address, int value) {
        this.clk.addTstates(3);
        this.mem.writeByte(address, (byte)value);
    }

    @Override
    public int peek16(int address) {
        this.clk.addTstates(6);
        int lsb = this.mem.readByte(address) & 0xFF;
        address = address + 1 & 0xFFFF;
        return this.mem.readByte(address) << 8 & 0xFF00 | lsb;
    }

    @Override
    public void poke16(int address, int word) {
        this.clk.addTstates(6);
        this.mem.writeByte(address, (byte)word);
        address = address + 1 & 0xFFFF;
        this.mem.writeByte(address, (byte)(word >>> 8));
    }

    @Override
    public int inPort(int port) {
        this.clk.addTstates(4);
        port &= 0xFF;
        return 255;
    }

    @Override
    public void outPort(int port, int value) {
        this.clk.addTstates(4);
        value &= 0xFF;
        if (((port &= 0xFF) & 8) == 0) {
            this.portA3 = (byte)value;
            this.t_frame = (this.portA3 & 1) == 0 ? 40000 : 10000;
            if ((this.portA3 & 2) == 0) {
                this.mem.mapRom(true);
            } else {
                this.mem.mapRom(false);
            }
            if ((this.portA3 & 4) == 0) {
                this.mem.mapIO(false);
            } else {
                this.mem.mapIO(true);
            }
        }
        if ((port & 1) == 0) {
            this.portA0 = (byte)value;
            if ((this.portA0 & 1) == 0) {
                this.GreenLed.setEnabled(true);
            } else {
                this.GreenLed.setEnabled(false);
            }
            if ((this.portA0 & 2) == 0) {
                this.YellowLed.setEnabled(true);
            } else {
                this.YellowLed.setEnabled(false);
            }
            if ((this.portA0 & 0x10) != 0) {
                if (!this.tapestart) {
                    this.tapestart = true;
                    this.tap.tapeStart();
                }
            } else if (this.tapestart) {
                this.tapestart = false;
                this.tap.tapeStop();
            }
        }
    }

    @Override
    public void contendedStates(int address, int tstates) {
        this.clk.addTstates(tstates);
    }

    @Override
    public int atAddress(int address, int opcode) {
        return opcode;
    }

    @Override
    public void execDone() {
    }

    public void openLoadTape(String canonicalPath) {
        this.tap.openLoadTape(canonicalPath);
    }

    public void openSaveTape(String canonicalPath) {
        this.tap.openSaveTape(canonicalPath);
    }

    public void setTapeMode(boolean rec) {
        this.tap.setTapeMode(rec);
    }

    public void closeClenaup() {
        this.tap.closeCleanup();
    }
}

