/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import machine.Config;

public class Settings
extends JDialog {
    Config cf;
    boolean ResetNeeded;
    private JRadioButton bBasic;
    private JRadioButton bCustom;
    private JButton bOk;
    private JButton bRomA;
    private JButton bRomB;
    private JRadioButton bTesla;
    private JRadioButton bVili;
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JLabel lRomA;
    private JLabel lRomB;
    private JTextField tRomA;
    private JTextField tRomB;

    public Settings() {
        this.initComponents();
        this.ResetNeeded = false;
    }

    public boolean isResetNeeded() {
        return this.ResetNeeded;
    }

    public void showDialog(Config conf) {
        this.cf = conf;
        this.setSize(414, 335);
        switch (this.cf.getRomType()) {
            case 0: {
                this.bBasic.setSelected(true);
                this.setCustom(false);
                break;
            }
            case 1: {
                this.bTesla.setSelected(true);
                this.setCustom(false);
                break;
            }
            case 2: {
                this.bVili.setSelected(true);
                this.setCustom(false);
                break;
            }
            case 3: {
                this.bCustom.setSelected(true);
                this.setCustom(true);
            }
        }
        this.tRomA.setText(this.cf.getRomA());
        this.tRomB.setText(this.cf.getRomB());
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.setModal(true);
        this.setVisible(true);
    }

    private void setCustom(boolean b) {
        this.lRomA.setEnabled(b);
        this.lRomB.setEnabled(b);
        this.tRomA.setEnabled(b);
        this.tRomB.setEnabled(b);
        this.bRomA.setEnabled(b);
        this.bRomB.setEnabled(b);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.bBasic = new JRadioButton();
        this.bTesla = new JRadioButton();
        this.bVili = new JRadioButton();
        this.bCustom = new JRadioButton();
        this.lRomA = new JLabel();
        this.tRomA = new JTextField();
        this.bRomA = new JButton();
        this.lRomB = new JLabel();
        this.tRomB = new JTextField();
        this.bRomB = new JButton();
        this.bOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Settings");
        this.setModal(true);
        this.setName("SettingsDlg");
        this.setResizable(false);
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder(0));
        this.buttonGroup1.add(this.bBasic);
        this.bBasic.setText("Basic ROM");
        this.bBasic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.bBasicActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.bTesla);
        this.bTesla.setText("Tesla ROM");
        this.bTesla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.bTeslaActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.bVili);
        this.bVili.setText("SSM (ViLi) ROM");
        this.bVili.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.bViliActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.bCustom);
        this.bCustom.setText("Custom ROM");
        this.bCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.bCustomActionPerformed(evt);
            }
        });
        this.lRomA.setText("Position A");
        this.lRomA.setEnabled(false);
        this.tRomA.setEnabled(false);
        this.tRomA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.tRomAActionPerformed(evt);
            }
        });
        this.bRomA.setText("..");
        this.bRomA.setEnabled(false);
        this.bRomA.setPreferredSize(new Dimension(25, 23));
        this.bRomA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.bRomAActionPerformed(evt);
            }
        });
        this.lRomB.setText("Position B");
        this.lRomB.setEnabled(false);
        this.tRomB.setEnabled(false);
        this.tRomB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.tRomBActionPerformed(evt);
            }
        });
        this.bRomB.setText("..");
        this.bRomB.setEnabled(false);
        this.bRomB.setPreferredSize(new Dimension(25, 23));
        this.bRomB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.bRomBActionPerformed(evt);
            }
        });
        this.bOk.setText("Ok");
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.bOkActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(179, 179, 179).addComponent(this.bOk).addGap(0, 167, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.tRomB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bRomB, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.tRomA).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bRomA, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lRomB).addComponent(this.bCustom).addComponent(this.lRomA).addComponent(this.bTesla).addComponent(this.bVili).addComponent(this.bBasic)).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.bBasic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bTesla, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bVili).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bCustom).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lRomA).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tRomA, -2, -1, -2).addComponent(this.bRomA, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lRomB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 29, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tRomB, -2, -1, -2).addComponent(this.bRomB, -2, -1, -2)).addGap(29, 29, 29).addComponent(this.bOk).addContainerGap()));
        this.getContentPane().add(this.jPanel1);
    }

    private void bBasicActionPerformed(ActionEvent evt) {
        this.cf.setRomType(this.cf.BASIC);
        this.setCustom(false);
        this.ResetNeeded = true;
    }

    private void bTeslaActionPerformed(ActionEvent evt) {
        this.cf.setRomType(this.cf.TESLA);
        this.setCustom(false);
        this.ResetNeeded = true;
    }

    private void bViliActionPerformed(ActionEvent evt) {
        this.cf.setRomType(this.cf.VILI);
        this.setCustom(false);
        this.ResetNeeded = true;
    }

    private void bCustomActionPerformed(ActionEvent evt) {
        this.cf.setRomType(this.cf.CUSTOM);
        this.setCustom(true);
        this.ResetNeeded = true;
    }

    private void bOkActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setModal(false);
    }

    private void tRomAActionPerformed(ActionEvent evt) {
        this.cf.setRomA(this.tRomA.getText());
        this.ResetNeeded = true;
    }

    private void tRomBActionPerformed(ActionEvent evt) {
        this.cf.setRomB(this.tRomB.getText());
        this.ResetNeeded = true;
    }

    private void bRomAActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Choose ROM file for slot A");
        int val = fc.showOpenDialog(this);
        if (val == 0) {
            try {
                this.tRomA.setText(fc.getSelectedFile().getCanonicalPath());
                this.cf.setRomA(fc.getSelectedFile().getCanonicalPath());
                this.ResetNeeded = true;
            }
            catch (IOException ex) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void bRomBActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Choose ROM file for slot B");
        int val = fc.showOpenDialog(this);
        if (val == 0) {
            try {
                this.tRomB.setText(fc.getSelectedFile().getCanonicalPath());
                this.cf.setRomB(fc.getSelectedFile().getCanonicalPath());
                this.ResetNeeded = true;
            }
            catch (IOException ex) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

