/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.util.ArrayList;
import machine.ClockTimeoutListener;

public class Clock {
    private int tstates;
    private long frames;
    private int timeout;
    private final ArrayList<ClockTimeoutListener> clockListeners = new ArrayList();

    public void addClockTimeoutListener(ClockTimeoutListener listener) {
        if (listener == null) {
            throw new NullPointerException("Error: Listener can't be null");
        }
        if (!this.clockListeners.contains(listener)) {
            this.clockListeners.add(listener);
        }
    }

    public void removeClockTimeoutListener(ClockTimeoutListener listener) {
        if (listener == null) {
            throw new NullPointerException("Internal Error: Listener can't be null");
        }
        if (this.clockListeners.contains(listener)) {
            this.clockListeners.remove(listener);
        }
    }

    public int getTstates() {
        return this.tstates;
    }

    public void setTstates(int states) {
        this.tstates = states;
        this.frames = 0L;
    }

    public void addTstates(int states) {
        this.tstates += states;
        if (this.timeout > 0) {
            this.timeout -= states;
            if (this.timeout < 1) {
                for (ClockTimeoutListener listener : this.clockListeners) {
                    listener.clockTimeout();
                }
            }
        }
    }

    public long getFrames() {
        return this.frames;
    }

    public void reset() {
        this.tstates = 0;
        this.frames = 0;
    }

    public void setTimeout(int ntstates) {
        this.timeout = ntstates > 0 ? ntstates : 1;
    }
}

