/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import machine.Config;
import machine.Ondra;

public final class Memory {
    public final int PAGE_SIZE = 2048;
    public final int PAGE_MASK = 2047;
    public final byte PAGE_BIT = (byte)11;
    public final byte tapes = (byte)-128;
    public final byte taper = (byte)127;
    private byte[][] Ram = new byte[32][2048];
    private byte[][] Basic = new byte[8][2048];
    private byte[][] Tesla = new byte[2][2048];
    private byte[][] Vili = new byte[2][2048];
    private byte[][] Cust = new byte[8][2048];
    private byte[][] readPages = new byte[32][];
    private byte[][] writePages = new byte[32][];
    private byte[] fakeROM = new byte[2048];
    private byte[] IOVect;
    private Ondra m;
    private Config cf;

    public Memory(Ondra machine, Config cnf) {
        this.m = machine;
        this.cf = cnf;
        this.loadRoms();
    }

    void setIOVect(byte[] iov) {
        this.IOVect = iov;
    }

    void setTapeIn(boolean x) {
        if (x) {
            int n = 0;
            while (n < 2048) {
                int n2 = n++;
                this.IOVect[n2] = (byte)(this.IOVect[n2] | 0xFFFFFF80);
            }
        } else {
            int n = 0;
            while (n < 2048) {
                int n3 = n++;
                this.IOVect[n3] = (byte)(this.IOVect[n3] & 0x7F);
            }
        }
    }

    public void Reset(boolean dirty) {
        int i;
        if (dirty) {
            int c = 0;
            int a = 0;
            for (int i2 = 0; i2 < 32; ++i2) {
                for (int j = 0; j < 2048; ++j) {
                    this.Ram[i2][j] = (byte)c;
                    if ((a = a++ & 0x7F) != 0) continue;
                    c = (char)(c ^ 0xFF);
                }
            }
        }
        if (this.cf.getRomType() == this.cf.CUSTOM) {
            for (i = 0; i < 2048; ++i) {
                this.Cust[0][i] = -1;
                this.Cust[1][i] = -1;
                this.Cust[2][i] = -1;
                this.Cust[3][i] = -1;
                this.Cust[4][i] = -1;
                this.Cust[5][i] = -1;
                this.Cust[6][i] = -1;
                this.Cust[7][i] = -1;
            }
            this.loadCustomRom(this.cf.getRomA(), 0);
            this.loadCustomRom(this.cf.getRomB(), 4);
        }
        for (i = 0; i < 32; ++i) {
            this.writePages[i] = this.Ram[i];
            this.readPages[i] = this.writePages[i];
        }
    }

    public byte readRam(int address) {
        return this.Ram[address >>> 11][address & 0x7FF];
    }

    public byte readByte(int address) {
        return this.readPages[address >>> 11][address & 0x7FF];
    }

    public void writeByte(int address, byte value) {
        this.writePages[address >>> 11][address & 0x7FF] = value;
        if (address >= 55296) {
            this.m.processVram(address, value);
        }
    }

    public void mapIO(boolean state) {
        if (!state) {
            this.writePages[28] = this.Ram[28];
            this.readPages[28] = this.writePages[28];
            this.writePages[29] = this.Ram[29];
            this.readPages[29] = this.writePages[29];
            this.writePages[30] = this.Ram[30];
            this.readPages[30] = this.writePages[30];
            this.writePages[31] = this.Ram[31];
            this.readPages[31] = this.writePages[31];
        } else {
            this.writePages[28] = this.fakeROM;
            this.writePages[29] = this.fakeROM;
            this.writePages[30] = this.fakeROM;
            this.writePages[31] = this.fakeROM;
            this.readPages[28] = this.IOVect;
            this.readPages[29] = this.IOVect;
            this.readPages[30] = this.IOVect;
            this.readPages[31] = this.IOVect;
        }
    }

    public void mapRom(boolean state) {
        if (!state) {
            this.writePages[0] = this.Ram[0];
            this.readPages[0] = this.writePages[0];
            this.writePages[1] = this.Ram[1];
            this.readPages[1] = this.writePages[1];
            this.writePages[2] = this.Ram[2];
            this.readPages[2] = this.writePages[2];
            this.writePages[3] = this.Ram[3];
            this.readPages[3] = this.writePages[3];
            this.writePages[4] = this.Ram[4];
            this.readPages[4] = this.writePages[4];
            this.writePages[5] = this.Ram[5];
            this.readPages[5] = this.writePages[5];
            this.writePages[6] = this.Ram[6];
            this.readPages[6] = this.writePages[6];
            this.writePages[7] = this.Ram[7];
            this.readPages[7] = this.writePages[7];
        } else {
            this.writePages[0] = this.fakeROM;
            this.writePages[1] = this.fakeROM;
            this.writePages[2] = this.fakeROM;
            this.writePages[3] = this.fakeROM;
            this.writePages[4] = this.fakeROM;
            this.writePages[5] = this.fakeROM;
            this.writePages[6] = this.fakeROM;
            this.writePages[7] = this.fakeROM;
            switch (this.cf.getRomType()) {
                case 0: {
                    this.readPages[0] = this.Basic[0];
                    this.readPages[1] = this.Basic[1];
                    this.readPages[2] = this.Basic[2];
                    this.readPages[3] = this.Basic[3];
                    this.readPages[4] = this.Basic[4];
                    this.readPages[5] = this.Basic[5];
                    this.readPages[6] = this.Basic[6];
                    this.readPages[7] = this.Basic[7];
                    break;
                }
                case 1: {
                    this.readPages[0] = this.Tesla[0];
                    this.readPages[1] = this.Tesla[0];
                    this.readPages[2] = this.Tesla[0];
                    this.readPages[3] = this.Tesla[0];
                    this.readPages[4] = this.Tesla[1];
                    this.readPages[5] = this.Tesla[1];
                    this.readPages[6] = this.Tesla[1];
                    this.readPages[7] = this.Tesla[1];
                    break;
                }
                case 2: {
                    this.readPages[0] = this.Vili[0];
                    this.readPages[1] = this.Vili[0];
                    this.readPages[2] = this.Vili[0];
                    this.readPages[3] = this.Vili[0];
                    this.readPages[4] = this.Vili[1];
                    this.readPages[5] = this.Vili[1];
                    this.readPages[6] = this.Vili[1];
                    this.readPages[7] = this.Vili[1];
                    break;
                }
                default: {
                    this.readPages[0] = this.Cust[0];
                    this.readPages[1] = this.Cust[1];
                    this.readPages[2] = this.Cust[2];
                    this.readPages[3] = this.Cust[3];
                    this.readPages[4] = this.Cust[4];
                    this.readPages[5] = this.Cust[5];
                    this.readPages[6] = this.Cust[6];
                    this.readPages[7] = this.Cust[7];
                }
            }
        }
    }

    private void loadCustomRom(String name, int page) {
        File f = new File(name);
        int size = (int)f.length();
        boolean res = false;
        switch (size) {
            case 2048: {
                res = this.loadRomAsFile(name, this.Cust, page + 0, 2048);
                if (!res) break;
                this.loadRomAsFile(name, this.Cust, page + 1, 2048);
                this.loadRomAsFile(name, this.Cust, page + 2, 2048);
                this.loadRomAsFile(name, this.Cust, page + 3, 2048);
                break;
            }
            case 4096: {
                res = this.loadRomAsFile(name, this.Cust, page + 0, 4096);
                if (!res) break;
                this.loadRomAsFile(name, this.Cust, page + 2, 4096);
                break;
            }
            case 8192: {
                res = this.loadRomAsFile(name, this.Cust, page + 0, 8192);
                break;
            }
            default: {
                String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_SIZE_ERROR");
                System.out.println(String.format("%s: %s", msg, name));
            }
        }
    }

    private void loadRoms() {
        String rd = this.cf.getRomsDirectory();
        if (!this.loadRomAsFile(rd + this.cf.getBasicA(), this.Basic, 0, 8192)) {
            this.loadRomAsResource("/roms/Ondra_BASICEXP_V5_a.rom", this.Basic, 0, 8192);
        }
        if (!this.loadRomAsFile(rd + this.cf.getBasicB(), this.Basic, 4, 8192)) {
            this.loadRomAsResource("/roms/Ondra_BASICEXP_V5_b.rom", this.Basic, 4, 8192);
        }
        if (!this.loadRomAsFile(rd + this.cf.getTeslaA(), this.Tesla, 0, 2048)) {
            this.loadRomAsResource("/roms/Ondra_TESLA_V5_a.rom", this.Tesla, 0, 2048);
        }
        if (!this.loadRomAsFile(rd + this.cf.getTeslaB(), this.Tesla, 1, 2048)) {
            this.loadRomAsResource("/roms/Ondra_TESLA_V5_b.rom", this.Tesla, 1, 2048);
        }
        if (!this.loadRomAsFile(rd + this.cf.getViLiA(), this.Vili, 0, 2048)) {
            this.loadRomAsResource("/roms/Ondra_ViLi_a.rom", this.Vili, 0, 2048);
        }
        if (!this.loadRomAsFile(rd + this.cf.getTeslaB(), this.Vili, 1, 2048)) {
            this.loadRomAsResource("/roms/Ondra_ViLi_b.rom", this.Vili, 1, 2048);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRomAsResource(String filename, byte[][] rom, int page, int size) {
        InputStream inRom = Ondra.class.getResourceAsStream(filename);
        boolean res = false;
        if (inRom == null) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("RESOURCE_ROM_ERROR");
            System.out.println(String.format("%s: %s", msg, filename));
            return false;
        }
        try {
            for (int frag = 0; frag < size / 2048; ++frag) {
                int count;
                for (count = 0; count != -1 && count < 2048; count += inRom.read(rom[page + frag], count, 2048 - count)) {
                }
                if (count != 2048) {
                    String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_SIZE_ERROR");
                    System.out.println(String.format("%s: %s", msg, filename));
                    continue;
                }
                res = true;
            }
        }
        catch (IOException ex) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("RESOURCE_ROM_ERROR");
            System.out.println(String.format("%s: %s", msg, filename));
            Logger.getLogger(Ondra.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                inRom.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (res) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_RESOURCE_LOADED");
            System.out.println(String.format("%s: %s", msg, filename));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRomAsFile(String filename, byte[][] rom, int page, int size) {
        BufferedInputStream fIn = null;
        boolean res = false;
        try {
            try {
                fIn = new BufferedInputStream(new FileInputStream(filename));
            }
            catch (FileNotFoundException ex) {
                String msg = ResourceBundle.getBundle("machine/Bundle").getString("FILE_ROM_ERROR");
                System.out.println(String.format("%s: %s", msg, filename));
                boolean bl = false;
                try {
                    if (fIn != null) {
                        fIn.close();
                    }
                }
                catch (IOException ex2) {
                    Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex2);
                }
                return bl;
            }
            for (int frag = 0; frag < size / 2048; ++frag) {
                int count;
                for (count = 0; count != -1 && count < 2048; count += fIn.read(rom[page + frag], count, 2048 - count)) {
                }
                if (count != 2048) {
                    String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_SIZE_ERROR");
                    System.out.println(String.format("%s: %s", msg, filename));
                    continue;
                }
                res = true;
            }
        }
        catch (IOException ex) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("FILE_ROM_ERROR");
            System.out.println(String.format("%s: %s", msg, filename));
            Logger.getLogger(Ondra.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fIn != null) {
                    fIn.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (res) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_FILE_LOADED");
            System.out.println(String.format("%s: %s", msg, filename));
        }
        return res;
    }
}

