/*
 * Decompiled with CFR 0.152.
 */
package utils;

public class TapeSignalProc {
    private final int init = 128;
    private int[] buff;
    private int buffsize;
    private int head;
    private int min;
    private int max;
    private int avg;

    public TapeSignalProc(int size) {
        this.buffsize = size;
        this.buff = new int[size];
        this.head = 0;
        for (int n = 0; n < this.buffsize; ++n) {
            this.buff[n] = 128;
        }
    }

    public boolean addSample(int sample) {
        this.buff[this.head] = sample;
        this.max = 128;
        this.min = 128;
        for (int n = 0; n < this.buffsize; ++n) {
            if (this.buff[this.head] > this.max) {
                this.max = this.buff[this.head];
            }
            if (this.buff[this.head] < this.min) {
                this.min = this.buff[this.head];
            }
            ++this.head;
            if (this.head != this.buffsize) continue;
            this.head = 0;
        }
        ++this.head;
        if (this.head == this.buffsize) {
            this.head = 0;
        }
        this.avg = (this.min + this.max) / 2;
        return sample > this.avg;
    }
}

