/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Screen;
import gui.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import machine.Ondra;

public class JOndra
extends JFrame {
    private Ondra m;
    private Screen scr;
    private JLabel GreenLed;
    private JLabel TapeLed;
    private JToolBar ToolBar;
    private JLabel YellowLed;
    private JButton bNmi;
    private JButton bOpent;
    private JToggleButton bPause;
    private JToggleButton bRec;
    private JButton bReset;
    private JButton bSavet;
    private JButton bSettings;
    private JFileChooser fc;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JSeparator jSeparator31;
    private JSeparator jSeparator32;
    private JSeparator jSeparator33;
    private JSeparator jSeparator34;
    private JSeparator jSeparator35;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JPanel statusPanel;

    public JOndra() {
        this.initComponents();
        this.initEmulator();
    }

    private void initComponents() {
        this.fc = new JFileChooser();
        this.ToolBar = new JToolBar();
        this.bOpent = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.bSavet = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.bReset = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.bNmi = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.bPause = new JToggleButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.bSettings = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.statusPanel = new JPanel();
        this.jSeparator31 = new JSeparator();
        this.GreenLed = new JLabel();
        this.jSeparator32 = new JSeparator();
        this.YellowLed = new JLabel();
        this.jSeparator33 = new JSeparator();
        this.TapeLed = new JLabel();
        this.jSeparator34 = new JSeparator();
        this.bRec = new JToggleButton();
        this.jSeparator35 = new JSeparator();
        this.setDefaultCloseOperation(3);
        this.setTitle("Ondra SPO 186");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JOndra.this.formWindowClosing(evt);
            }
        });
        this.ToolBar.setRollover(true);
        this.ToolBar.setPreferredSize(new Dimension(100, 20));
        this.bOpent.setIcon(new ImageIcon(this.getClass().getResource("/icons/open.png")));
        this.bOpent.setToolTipText("Open tape for Load");
        this.bOpent.setFocusable(false);
        this.bOpent.setHorizontalTextPosition(0);
        this.bOpent.setPreferredSize(new Dimension(20, 20));
        this.bOpent.setVerticalTextPosition(3);
        this.bOpent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOndra.this.bOpentActionPerformed(evt);
            }
        });
        this.ToolBar.add(this.bOpent);
        this.ToolBar.add(this.jSeparator1);
        this.bSavet.setIcon(new ImageIcon(this.getClass().getResource("/icons/save.png")));
        this.bSavet.setToolTipText("Open tape for Save");
        this.bSavet.setFocusable(false);
        this.bSavet.setHorizontalTextPosition(0);
        this.bSavet.setPreferredSize(new Dimension(20, 20));
        this.bSavet.setVerticalTextPosition(3);
        this.bSavet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOndra.this.bSavetActionPerformed(evt);
            }
        });
        this.ToolBar.add(this.bSavet);
        this.ToolBar.add(this.jSeparator2);
        this.bReset.setIcon(new ImageIcon(this.getClass().getResource("/icons/reset.png")));
        this.bReset.setToolTipText("Reset");
        this.bReset.setFocusable(false);
        this.bReset.setHorizontalTextPosition(0);
        this.bReset.setPreferredSize(new Dimension(20, 20));
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOndra.this.bResetActionPerformed(evt);
            }
        });
        this.ToolBar.add(this.bReset);
        this.ToolBar.add(this.jSeparator3);
        this.bNmi.setIcon(new ImageIcon(this.getClass().getResource("/icons/nmi.png")));
        this.bNmi.setToolTipText("NMI");
        this.bNmi.setFocusable(false);
        this.bNmi.setHorizontalTextPosition(0);
        this.bNmi.setPreferredSize(new Dimension(20, 20));
        this.bNmi.setVerticalTextPosition(3);
        this.bNmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOndra.this.bNmiActionPerformed(evt);
            }
        });
        this.ToolBar.add(this.bNmi);
        this.ToolBar.add(this.jSeparator4);
        this.bPause.setIcon(new ImageIcon(this.getClass().getResource("/icons/pause.png")));
        this.bPause.setSelected(true);
        this.bPause.setToolTipText("Run/Pause");
        this.bPause.setFocusable(false);
        this.bPause.setHorizontalTextPosition(0);
        this.bPause.setPreferredSize(new Dimension(16, 16));
        this.bPause.setSelectedIcon(new ImageIcon(this.getClass().getResource("/icons/run.png")));
        this.bPause.setVerticalTextPosition(3);
        this.bPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOndra.this.bPauseActionPerformed(evt);
            }
        });
        this.ToolBar.add(this.bPause);
        this.ToolBar.add(this.jSeparator5);
        this.bSettings.setIcon(new ImageIcon(this.getClass().getResource("/icons/settings.png")));
        this.bSettings.setToolTipText("Settings");
        this.bSettings.setFocusable(false);
        this.bSettings.setHorizontalTextPosition(0);
        this.bSettings.setPreferredSize(new Dimension(20, 20));
        this.bSettings.setVerticalTextPosition(3);
        this.bSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOndra.this.bSettingsActionPerformed(evt);
            }
        });
        this.ToolBar.add(this.bSettings);
        this.ToolBar.add(this.jSeparator6);
        this.getContentPane().add((Component)this.ToolBar, "First");
        this.statusPanel.setPreferredSize(new Dimension(100, 45));
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 2));
        this.jSeparator31.setOrientation(1);
        this.jSeparator31.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.jSeparator31.setMinimumSize(new Dimension(3, 16));
        this.jSeparator31.setPreferredSize(new Dimension(3, 16));
        this.jSeparator31.setRequestFocusEnabled(false);
        this.statusPanel.add(this.jSeparator31);
        this.GreenLed.setHorizontalAlignment(0);
        this.GreenLed.setIcon(new ImageIcon(this.getClass().getResource("/icons/green.png")));
        this.GreenLed.setEnabled(false);
        this.GreenLed.setHorizontalTextPosition(0);
        this.GreenLed.setPreferredSize(new Dimension(24, 24));
        this.statusPanel.add(this.GreenLed);
        this.jSeparator32.setOrientation(1);
        this.jSeparator32.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.jSeparator32.setMinimumSize(new Dimension(3, 16));
        this.jSeparator32.setPreferredSize(new Dimension(3, 16));
        this.jSeparator32.setRequestFocusEnabled(false);
        this.statusPanel.add(this.jSeparator32);
        this.YellowLed.setHorizontalAlignment(0);
        this.YellowLed.setIcon(new ImageIcon(this.getClass().getResource("/icons/yellow.png")));
        this.YellowLed.setEnabled(false);
        this.YellowLed.setHorizontalTextPosition(0);
        this.YellowLed.setPreferredSize(new Dimension(24, 24));
        this.statusPanel.add(this.YellowLed);
        this.jSeparator33.setOrientation(1);
        this.jSeparator33.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.jSeparator33.setMinimumSize(new Dimension(3, 16));
        this.jSeparator33.setPreferredSize(new Dimension(3, 16));
        this.jSeparator33.setRequestFocusEnabled(false);
        this.statusPanel.add(this.jSeparator33);
        this.TapeLed.setHorizontalAlignment(0);
        this.TapeLed.setIcon(new ImageIcon(this.getClass().getResource("/icons/tape.png")));
        this.TapeLed.setToolTipText("Tape runs");
        this.TapeLed.setEnabled(false);
        this.TapeLed.setHorizontalTextPosition(0);
        this.statusPanel.add(this.TapeLed);
        this.jSeparator34.setOrientation(1);
        this.jSeparator34.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.jSeparator34.setMinimumSize(new Dimension(3, 16));
        this.jSeparator34.setPreferredSize(new Dimension(3, 16));
        this.jSeparator34.setRequestFocusEnabled(false);
        this.statusPanel.add(this.jSeparator34);
        this.bRec.setIcon(new ImageIcon(this.getClass().getResource("/icons/player_play.png")));
        this.bRec.setToolTipText("Play - Record switch");
        this.bRec.setBorderPainted(false);
        this.bRec.setFocusPainted(false);
        this.bRec.setFocusable(false);
        this.bRec.setSelectedIcon(new ImageIcon(this.getClass().getResource("/icons/player_rec.png")));
        this.bRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOndra.this.bRecActionPerformed(evt);
            }
        });
        this.statusPanel.add(this.bRec);
        this.jSeparator35.setOrientation(1);
        this.jSeparator35.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.jSeparator35.setMinimumSize(new Dimension(3, 16));
        this.jSeparator35.setPreferredSize(new Dimension(3, 16));
        this.jSeparator35.setRequestFocusEnabled(false);
        this.statusPanel.add(this.jSeparator35);
        this.getContentPane().add((Component)this.statusPanel, "Last");
        this.pack();
    }

    private void bResetActionPerformed(ActionEvent evt) {
        this.m.Reset(false);
    }

    private void bNmiActionPerformed(ActionEvent evt) {
        this.m.Nmi();
    }

    private void bSettingsActionPerformed(ActionEvent evt) {
        boolean pau = this.m.isPaused();
        this.m.stopEmulation();
        Settings set = new Settings();
        set.showDialog(this.m.getConfig());
        if (set.isResetNeeded()) {
            this.m.Reset(false);
        }
        set.dispose();
        if (!pau) {
            this.m.startEmulation();
        }
    }

    private void bOpentActionPerformed(ActionEvent evt) {
        boolean pau = this.m.isPaused();
        this.m.stopEmulation();
        this.fc.setDialogTitle("Open tape for LOAD");
        int val = this.fc.showOpenDialog(this);
        if (val == 0) {
            try {
                this.m.openLoadTape(this.fc.getSelectedFile().getCanonicalPath());
            }
            catch (IOException ex) {
                Logger.getLogger(JOndra.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!pau) {
            this.m.startEmulation();
        }
    }

    private void bSavetActionPerformed(ActionEvent evt) {
        boolean pau = this.m.isPaused();
        this.m.stopEmulation();
        this.fc.setDialogTitle("Open tape for SAVE");
        int val = this.fc.showSaveDialog(this);
        if (val == 0) {
            try {
                this.m.openSaveTape(this.fc.getSelectedFile().getCanonicalPath());
            }
            catch (IOException ex) {
                Logger.getLogger(JOndra.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!pau) {
            this.m.startEmulation();
        }
    }

    private void bPauseActionPerformed(ActionEvent evt) {
        if (this.bPause.isSelected()) {
            this.m.startEmulation();
        } else {
            this.m.stopEmulation();
        }
    }

    private void bRecActionPerformed(ActionEvent evt) {
        this.m.setTapeMode(this.bRec.isSelected());
    }

    private void formWindowClosing(WindowEvent evt) {
        this.m.closeClenaup();
    }

    private void initEmulator() {
        this.m = new Ondra();
        this.scr = new Screen();
        this.m.setScreen(this.scr);
        this.scr.setImage(this.m.getImage());
        this.m.setGreenLed(this.GreenLed);
        this.m.setYellowLed(this.YellowLed);
        this.m.setTapeLed(this.TapeLed);
        this.m.setRecButton(this.bRec);
        this.getContentPane().add((Component)this.scr, "Center");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.setFocusTraversalKeysEnabled(false);
        this.addKeyListener(this.m.getKeyboard());
        this.m.start();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(JOndra.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(JOndra.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JOndra.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(JOndra.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JOndra().setVisible(true);
            }
        });
    }
}

