/*
 * Decompiled with CFR 0.152.
 */
package z80core;

import java.util.Arrays;
import machine.Clock;
import z80core.MemIoOps;
import z80core.NotifyOps;
import z80core.Z80State;

public class Z80 {
    private final Clock clock;
    private final MemIoOps MemIoImpl;
    private final NotifyOps NotifyImpl;
    private int opCode;
    private boolean execDone;
    private static final int CARRY_MASK = 1;
    private static final int ADDSUB_MASK = 2;
    private static final int PARITY_MASK = 4;
    private static final int OVERFLOW_MASK = 4;
    private static final int BIT3_MASK = 8;
    private static final int HALFCARRY_MASK = 16;
    private static final int BIT5_MASK = 32;
    private static final int ZERO_MASK = 64;
    private static final int SIGN_MASK = 128;
    private static final int FLAG_53_MASK = 40;
    private static final int FLAG_SZ_MASK = 192;
    private static final int FLAG_SZHN_MASK = 210;
    private static final int FLAG_SZP_MASK = 196;
    private static final int FLAG_SZHP_MASK = 212;
    private int regA;
    private int regB;
    private int regC;
    private int regD;
    private int regE;
    private int regH;
    private int regL;
    private int sz5h3pnFlags;
    private boolean carryFlag;
    private int regAx;
    private int regFx;
    private int regBx;
    private int regCx;
    private int regDx;
    private int regEx;
    private int regHx;
    private int regLx;
    private int regPC;
    private int regIX;
    private int regIY;
    private int regSP;
    private int regI;
    private int regR;
    private boolean regRbit7;
    private boolean ffIFF1 = false;
    private boolean ffIFF2 = false;
    private boolean pendingEI = false;
    private boolean activeNMI = false;
    private boolean activeINT = false;
    private IntMode modeINT = IntMode.IM0;
    private boolean halted = false;
    private boolean pinReset = false;
    private int memptr;
    private static final int[] sz53n_addTable = new int[256];
    private static final int[] sz53pn_addTable = new int[256];
    private static final int[] sz53n_subTable = new int[256];
    private static final int[] sz53pn_subTable = new int[256];
    private boolean[] breakpointAt = new boolean[65536];

    public Z80(Clock clock, MemIoOps memory, NotifyOps notify) {
        this.clock = clock;
        this.MemIoImpl = memory;
        this.NotifyImpl = notify;
        this.execDone = false;
        Arrays.fill(this.breakpointAt, false);
        this.reset();
    }

    public final int getRegA() {
        return this.regA;
    }

    public final void setRegA(int value) {
        this.regA = value & 0xFF;
    }

    public final int getRegB() {
        return this.regB;
    }

    public final void setRegB(int value) {
        this.regB = value & 0xFF;
    }

    public final int getRegC() {
        return this.regC;
    }

    public final void setRegC(int value) {
        this.regC = value & 0xFF;
    }

    public final int getRegD() {
        return this.regD;
    }

    public final void setRegD(int value) {
        this.regD = value & 0xFF;
    }

    public final int getRegE() {
        return this.regE;
    }

    public final void setRegE(int value) {
        this.regE = value & 0xFF;
    }

    public final int getRegH() {
        return this.regH;
    }

    public final void setRegH(int value) {
        this.regH = value & 0xFF;
    }

    public final int getRegL() {
        return this.regL;
    }

    public final void setRegL(int value) {
        this.regL = value & 0xFF;
    }

    public final int getRegAx() {
        return this.regAx;
    }

    public final void setRegAx(int value) {
        this.regAx = value & 0xFF;
    }

    public final int getRegFx() {
        return this.regFx;
    }

    public final void setRegFx(int value) {
        this.regFx = value & 0xFF;
    }

    public final int getRegBx() {
        return this.regBx;
    }

    public final void setRegBx(int value) {
        this.regBx = value & 0xFF;
    }

    public final int getRegCx() {
        return this.regCx;
    }

    public final void setRegCx(int value) {
        this.regCx = value & 0xFF;
    }

    public final int getRegDx() {
        return this.regDx;
    }

    public final void setRegDx(int value) {
        this.regDx = value & 0xFF;
    }

    public final int getRegEx() {
        return this.regEx;
    }

    public final void setRegEx(int value) {
        this.regEx = value & 0xFF;
    }

    public final int getRegHx() {
        return this.regHx;
    }

    public final void setRegHx(int value) {
        this.regHx = value & 0xFF;
    }

    public final int getRegLx() {
        return this.regLx;
    }

    public final void setRegLx(int value) {
        this.regLx = value & 0xFF;
    }

    public final int getRegAF() {
        return this.regA << 8 | (this.carryFlag ? this.sz5h3pnFlags | 1 : this.sz5h3pnFlags);
    }

    public final void setRegAF(int word) {
        this.regA = word >>> 8 & 0xFF;
        this.sz5h3pnFlags = word & 0xFE;
        this.carryFlag = (word & 1) != 0;
    }

    public final int getRegAFx() {
        return this.regAx << 8 | this.regFx;
    }

    public final void setRegAFx(int word) {
        this.regAx = word >>> 8 & 0xFF;
        this.regFx = word & 0xFF;
    }

    public final int getRegBC() {
        return this.regB << 8 | this.regC;
    }

    public final void setRegBC(int word) {
        this.regB = word >>> 8 & 0xFF;
        this.regC = word & 0xFF;
    }

    private void incRegBC() {
        if (++this.regC < 256) {
            return;
        }
        this.regC = 0;
        if (++this.regB < 256) {
            return;
        }
        this.regB = 0;
    }

    private void decRegBC() {
        if (--this.regC >= 0) {
            return;
        }
        this.regC = 255;
        if (--this.regB >= 0) {
            return;
        }
        this.regB = 255;
    }

    public final int getRegBCx() {
        return this.regBx << 8 | this.regCx;
    }

    public final void setRegBCx(int word) {
        this.regBx = word >>> 8 & 0xFF;
        this.regCx = word & 0xFF;
    }

    public final int getRegDE() {
        return this.regD << 8 | this.regE;
    }

    public final void setRegDE(int word) {
        this.regD = word >>> 8 & 0xFF;
        this.regE = word & 0xFF;
    }

    private void incRegDE() {
        if (++this.regE < 256) {
            return;
        }
        this.regE = 0;
        if (++this.regD < 256) {
            return;
        }
        this.regD = 0;
    }

    private void decRegDE() {
        if (--this.regE >= 0) {
            return;
        }
        this.regE = 255;
        if (--this.regD >= 0) {
            return;
        }
        this.regD = 255;
    }

    public final int getRegDEx() {
        return this.regDx << 8 | this.regEx;
    }

    public final void setRegDEx(int word) {
        this.regDx = word >>> 8 & 0xFF;
        this.regEx = word & 0xFF;
    }

    public final int getRegHL() {
        return this.regH << 8 | this.regL;
    }

    public final void setRegHL(int word) {
        this.regH = word >>> 8 & 0xFF;
        this.regL = word & 0xFF;
    }

    private void incRegHL() {
        if (++this.regL < 256) {
            return;
        }
        this.regL = 0;
        if (++this.regH < 256) {
            return;
        }
        this.regH = 0;
    }

    private void decRegHL() {
        if (--this.regL >= 0) {
            return;
        }
        this.regL = 255;
        if (--this.regH >= 0) {
            return;
        }
        this.regH = 255;
    }

    public final int getRegHLx() {
        return this.regHx << 8 | this.regLx;
    }

    public final void setRegHLx(int word) {
        this.regHx = word >>> 8 & 0xFF;
        this.regLx = word & 0xFF;
    }

    public final int getRegPC() {
        return this.regPC;
    }

    public final void setRegPC(int address) {
        this.regPC = address & 0xFFFF;
    }

    public final int getRegSP() {
        return this.regSP;
    }

    public final void setRegSP(int word) {
        this.regSP = word & 0xFFFF;
    }

    public final int getRegIX() {
        return this.regIX;
    }

    public final void setRegIX(int word) {
        this.regIX = word & 0xFFFF;
    }

    public final int getRegIY() {
        return this.regIY;
    }

    public final void setRegIY(int word) {
        this.regIY = word & 0xFFFF;
    }

    public final int getRegI() {
        return this.regI;
    }

    public final void setRegI(int value) {
        this.regI = value & 0xFF;
    }

    public final int getRegR() {
        return this.regRbit7 ? this.regR & 0x7F | 0x80 : this.regR & 0x7F;
    }

    public final void setRegR(int value) {
        this.regR = value & 0x7F;
        this.regRbit7 = value > 127;
    }

    public final int getPairIR() {
        if (this.regRbit7) {
            return this.regI << 8 | (this.regR & 0x7F | 0x80);
        }
        return this.regI << 8 | this.regR & 0x7F;
    }

    public final int getMemPtr() {
        return this.memptr & 0xFFFF;
    }

    public final void setMemPtr(int word) {
        this.memptr = word & 0xFFFF;
    }

    public final boolean isCarryFlag() {
        return this.carryFlag;
    }

    public final void setCarryFlag(boolean state) {
        this.carryFlag = state;
    }

    public final boolean isAddSubFlag() {
        return (this.sz5h3pnFlags & 2) != 0;
    }

    public final void setAddSubFlag(boolean state) {
        this.sz5h3pnFlags = state ? (this.sz5h3pnFlags |= 2) : (this.sz5h3pnFlags &= 0xFFFFFFFD);
    }

    public final boolean isParOverFlag() {
        return (this.sz5h3pnFlags & 4) != 0;
    }

    public final void setParOverFlag(boolean state) {
        this.sz5h3pnFlags = state ? (this.sz5h3pnFlags |= 4) : (this.sz5h3pnFlags &= 0xFFFFFFFB);
    }

    public final boolean isBit3Flag() {
        return (this.sz5h3pnFlags & 8) != 0;
    }

    public final void setBit3Fag(boolean state) {
        this.sz5h3pnFlags = state ? (this.sz5h3pnFlags |= 8) : (this.sz5h3pnFlags &= 0xFFFFFFF7);
    }

    public final boolean isHalfCarryFlag() {
        return (this.sz5h3pnFlags & 0x10) != 0;
    }

    public final void setHalfCarryFlag(boolean state) {
        this.sz5h3pnFlags = state ? (this.sz5h3pnFlags |= 0x10) : (this.sz5h3pnFlags &= 0xFFFFFFEF);
    }

    public final boolean isBit5Flag() {
        return (this.sz5h3pnFlags & 0x20) != 0;
    }

    public final void setBit5Flag(boolean state) {
        this.sz5h3pnFlags = state ? (this.sz5h3pnFlags |= 0x20) : (this.sz5h3pnFlags &= 0xFFFFFFDF);
    }

    public final boolean isZeroFlag() {
        return (this.sz5h3pnFlags & 0x40) != 0;
    }

    public final void setZeroFlag(boolean state) {
        this.sz5h3pnFlags = state ? (this.sz5h3pnFlags |= 0x40) : (this.sz5h3pnFlags &= 0xFFFFFFBF);
    }

    public final boolean isSignFlag() {
        return (this.sz5h3pnFlags & 0x80) != 0;
    }

    public final void setSignFlag(boolean state) {
        this.sz5h3pnFlags = state ? (this.sz5h3pnFlags |= 0x80) : (this.sz5h3pnFlags &= 0xFFFFFF7F);
    }

    public final int getFlags() {
        return this.carryFlag ? this.sz5h3pnFlags | 1 : this.sz5h3pnFlags;
    }

    public final void setFlags(int regF) {
        this.sz5h3pnFlags = regF & 0xFE;
        this.carryFlag = (regF & 1) != 0;
    }

    public final boolean isIFF1() {
        return this.ffIFF1;
    }

    public final void setIFF1(boolean state) {
        this.ffIFF1 = state;
    }

    public final boolean isIFF2() {
        return this.ffIFF2;
    }

    public final void setIFF2(boolean state) {
        this.ffIFF2 = state;
    }

    public final boolean isNMI() {
        return this.activeNMI;
    }

    public final void setNMI(boolean nmi) {
        this.activeNMI = nmi;
    }

    public final void triggerNMI() {
        this.activeNMI = true;
    }

    public final boolean isINTLine() {
        return this.activeINT;
    }

    public final void setINTLine(boolean intLine) {
        this.activeINT = intLine;
    }

    public final IntMode getIM() {
        return this.modeINT;
    }

    public final void setIM(IntMode mode) {
        this.modeINT = mode;
    }

    public final boolean isHalted() {
        return this.halted;
    }

    public void setHalted(boolean state) {
        this.halted = state;
    }

    public void setPinReset() {
        this.pinReset = true;
    }

    public final boolean isPendingEI() {
        return this.pendingEI;
    }

    public final void setPendingEI(boolean state) {
        this.pendingEI = state;
    }

    public final Z80State getZ80State() {
        Z80State state = new Z80State();
        state.setRegA(this.regA);
        state.setRegF(this.getFlags());
        state.setRegB(this.regB);
        state.setRegC(this.regC);
        state.setRegD(this.regD);
        state.setRegE(this.regE);
        state.setRegH(this.regH);
        state.setRegL(this.regL);
        state.setRegAx(this.regAx);
        state.setRegFx(this.regFx);
        state.setRegBx(this.regBx);
        state.setRegCx(this.regCx);
        state.setRegDx(this.regDx);
        state.setRegEx(this.regEx);
        state.setRegHx(this.regHx);
        state.setRegLx(this.regLx);
        state.setRegIX(this.regIX);
        state.setRegIY(this.regIY);
        state.setRegSP(this.regSP);
        state.setRegPC(this.regPC);
        state.setRegI(this.regI);
        state.setRegR(this.getRegR());
        state.setMemPtr(this.memptr);
        state.setHalted(this.halted);
        state.setIFF1(this.ffIFF1);
        state.setIFF2(this.ffIFF2);
        state.setIM(this.modeINT);
        state.setINTLine(this.activeINT);
        state.setPendingEI(this.pendingEI);
        state.setNMI(this.activeNMI);
        return state;
    }

    public final void setZ80State(Z80State state) {
        this.regA = state.getRegA();
        this.setFlags(state.getRegF());
        this.regB = state.getRegB();
        this.regC = state.getRegC();
        this.regD = state.getRegD();
        this.regE = state.getRegE();
        this.regH = state.getRegH();
        this.regL = state.getRegL();
        this.regAx = state.getRegAx();
        this.regFx = state.getRegFx();
        this.regBx = state.getRegBx();
        this.regCx = state.getRegCx();
        this.regDx = state.getRegDx();
        this.regEx = state.getRegEx();
        this.regHx = state.getRegHx();
        this.regLx = state.getRegLx();
        this.regIX = state.getRegIX();
        this.regIY = state.getRegIY();
        this.regSP = state.getRegSP();
        this.regPC = state.getRegPC();
        this.regI = state.getRegI();
        this.setRegR(state.getRegR());
        this.memptr = state.getMemPtr();
        this.halted = state.isHalted();
        this.ffIFF1 = state.isIFF1();
        this.ffIFF2 = state.isIFF2();
        this.modeINT = state.getIM();
        this.activeINT = state.isINTLine();
        this.pendingEI = state.isPendingEI();
        this.activeNMI = state.isNMI();
    }

    public final void reset() {
        if (this.pinReset) {
            this.pinReset = false;
        } else {
            this.regAx = 255;
            this.regA = 255;
            this.setFlags(255);
            this.regFx = 255;
            this.regBx = 255;
            this.regB = 255;
            this.regCx = 255;
            this.regC = 255;
            this.regDx = 255;
            this.regD = 255;
            this.regEx = 255;
            this.regE = 255;
            this.regHx = 255;
            this.regH = 255;
            this.regLx = 255;
            this.regL = 255;
            this.regIY = 65535;
            this.regIX = 65535;
            this.regSP = 65535;
            this.memptr = 65535;
        }
        this.regPC = 0;
        this.regR = 0;
        this.regI = 0;
        this.regRbit7 = false;
        this.ffIFF1 = false;
        this.ffIFF2 = false;
        this.pendingEI = false;
        this.activeNMI = false;
        this.activeINT = false;
        this.halted = false;
        this.setIM(IntMode.IM0);
    }

    private int rlc(int oper8) {
        this.carryFlag = oper8 > 127;
        oper8 = oper8 << 1 & 0xFE;
        if (this.carryFlag) {
            oper8 |= 1;
        }
        this.sz5h3pnFlags = sz53pn_addTable[oper8];
        return oper8;
    }

    private int rl(int oper8) {
        boolean carry = this.carryFlag;
        this.carryFlag = oper8 > 127;
        oper8 = oper8 << 1 & 0xFE;
        if (carry) {
            oper8 |= 1;
        }
        this.sz5h3pnFlags = sz53pn_addTable[oper8];
        return oper8;
    }

    private int sla(int oper8) {
        this.carryFlag = oper8 > 127;
        oper8 = oper8 << 1 & 0xFE;
        this.sz5h3pnFlags = sz53pn_addTable[oper8];
        return oper8;
    }

    private int sll(int oper8) {
        this.carryFlag = oper8 > 127;
        oper8 = (oper8 << 1 | 1) & 0xFF;
        this.sz5h3pnFlags = sz53pn_addTable[oper8];
        return oper8;
    }

    private int rrc(int oper8) {
        this.carryFlag = (oper8 & 1) != 0;
        oper8 >>>= 1;
        if (this.carryFlag) {
            oper8 |= 0x80;
        }
        this.sz5h3pnFlags = sz53pn_addTable[oper8];
        return oper8;
    }

    private int rr(int oper8) {
        boolean carry = this.carryFlag;
        this.carryFlag = (oper8 & 1) != 0;
        oper8 >>>= 1;
        if (carry) {
            oper8 |= 0x80;
        }
        this.sz5h3pnFlags = sz53pn_addTable[oper8];
        return oper8;
    }

    private void rrd() {
        int aux = (this.regA & 0xF) << 4;
        this.memptr = this.getRegHL();
        int memHL = this.MemIoImpl.peek8(this.memptr);
        this.regA = this.regA & 0xF0 | memHL & 0xF;
        this.MemIoImpl.contendedStates(this.memptr, 4);
        this.MemIoImpl.poke8(this.memptr, memHL >>> 4 | aux);
        this.sz5h3pnFlags = sz53pn_addTable[this.regA];
        ++this.memptr;
    }

    private void rld() {
        int aux = this.regA & 0xF;
        this.memptr = this.getRegHL();
        int memHL = this.MemIoImpl.peek8(this.memptr);
        this.regA = this.regA & 0xF0 | memHL >>> 4;
        this.MemIoImpl.contendedStates(this.memptr, 4);
        this.MemIoImpl.poke8(this.memptr, (memHL << 4 | aux) & 0xFF);
        this.sz5h3pnFlags = sz53pn_addTable[this.regA];
        ++this.memptr;
    }

    private int sra(int oper8) {
        int sign = oper8 & 0x80;
        this.carryFlag = (oper8 & 1) != 0;
        oper8 = oper8 >> 1 | sign;
        this.sz5h3pnFlags = sz53pn_addTable[oper8];
        return oper8;
    }

    private int srl(int oper8) {
        this.carryFlag = (oper8 & 1) != 0;
        this.sz5h3pnFlags = sz53pn_addTable[oper8 >>>= 1];
        return oper8;
    }

    private int inc8(int oper8) {
        oper8 = oper8 + 1 & 0xFF;
        this.sz5h3pnFlags = sz53n_addTable[oper8];
        if ((oper8 & 0xF) == 0) {
            this.sz5h3pnFlags |= 0x10;
        }
        if (oper8 == 128) {
            this.sz5h3pnFlags |= 4;
        }
        return oper8;
    }

    private int dec8(int oper8) {
        oper8 = oper8 - 1 & 0xFF;
        this.sz5h3pnFlags = sz53n_subTable[oper8];
        if ((oper8 & 0xF) == 15) {
            this.sz5h3pnFlags |= 0x10;
        }
        if (oper8 == 127) {
            this.sz5h3pnFlags |= 4;
        }
        return oper8;
    }

    private void add(int oper8) {
        int res = this.regA + oper8;
        this.carryFlag = res > 255;
        this.sz5h3pnFlags = sz53n_addTable[res &= 0xFF];
        if ((res & 0xF) < (this.regA & 0xF)) {
            this.sz5h3pnFlags |= 0x10;
        }
        if (((this.regA ^ ~oper8) & (this.regA ^ res)) > 127) {
            this.sz5h3pnFlags |= 4;
        }
        this.regA = res;
    }

    private void adc(int oper8) {
        int res = this.regA + oper8;
        if (this.carryFlag) {
            ++res;
        }
        this.carryFlag = res > 255;
        this.sz5h3pnFlags = sz53n_addTable[res &= 0xFF];
        if (((this.regA ^ oper8 ^ res) & 0x10) != 0) {
            this.sz5h3pnFlags |= 0x10;
        }
        if (((this.regA ^ ~oper8) & (this.regA ^ res)) > 127) {
            this.sz5h3pnFlags |= 4;
        }
        this.regA = res;
    }

    private int add16(int reg16, int oper16) {
        this.carryFlag = (oper16 += reg16) > 65535;
        this.sz5h3pnFlags = this.sz5h3pnFlags & 0xC4 | oper16 >>> 8 & 0x28;
        if (((oper16 &= 0xFFFF) & 0xFFF) < (reg16 & 0xFFF)) {
            this.sz5h3pnFlags |= 0x10;
        }
        this.memptr = reg16 + 1;
        return oper16;
    }

    private void adc16(int reg16) {
        int regHL = this.getRegHL();
        this.memptr = regHL + 1;
        int res = regHL + reg16;
        if (this.carryFlag) {
            ++res;
        }
        this.carryFlag = res > 65535;
        this.setRegHL(res &= 0xFFFF);
        this.sz5h3pnFlags = sz53n_addTable[this.regH];
        if (res != 0) {
            this.sz5h3pnFlags &= 0xFFFFFFBF;
        }
        if (((res ^ regHL ^ reg16) & 0x1000) != 0) {
            this.sz5h3pnFlags |= 0x10;
        }
        if (((regHL ^ ~reg16) & (regHL ^ res)) > Short.MAX_VALUE) {
            this.sz5h3pnFlags |= 4;
        }
    }

    private void sub(int oper8) {
        int res = this.regA - oper8;
        this.carryFlag = res < 0;
        this.sz5h3pnFlags = sz53n_subTable[res &= 0xFF];
        if ((res & 0xF) > (this.regA & 0xF)) {
            this.sz5h3pnFlags |= 0x10;
        }
        if (((this.regA ^ oper8) & (this.regA ^ res)) > 127) {
            this.sz5h3pnFlags |= 4;
        }
        this.regA = res;
    }

    private void sbc(int oper8) {
        int res = this.regA - oper8;
        if (this.carryFlag) {
            --res;
        }
        this.carryFlag = res < 0;
        this.sz5h3pnFlags = sz53n_subTable[res &= 0xFF];
        if (((this.regA ^ oper8 ^ res) & 0x10) != 0) {
            this.sz5h3pnFlags |= 0x10;
        }
        if (((this.regA ^ oper8) & (this.regA ^ res)) > 127) {
            this.sz5h3pnFlags |= 4;
        }
        this.regA = res;
    }

    private void sbc16(int reg16) {
        int regHL = this.getRegHL();
        this.memptr = regHL + 1;
        int res = regHL - reg16;
        if (this.carryFlag) {
            --res;
        }
        this.carryFlag = res < 0;
        this.setRegHL(res &= 0xFFFF);
        this.sz5h3pnFlags = sz53n_subTable[this.regH];
        if (res != 0) {
            this.sz5h3pnFlags &= 0xFFFFFFBF;
        }
        if (((res ^ regHL ^ reg16) & 0x1000) != 0) {
            this.sz5h3pnFlags |= 0x10;
        }
        if (((regHL ^ reg16) & (regHL ^ res)) > Short.MAX_VALUE) {
            this.sz5h3pnFlags |= 4;
        }
    }

    private void and(int oper8) {
        this.regA &= oper8;
        this.carryFlag = false;
        this.sz5h3pnFlags = sz53pn_addTable[this.regA] | 0x10;
    }

    public final void xor(int oper8) {
        this.regA = (this.regA ^ oper8) & 0xFF;
        this.carryFlag = false;
        this.sz5h3pnFlags = sz53pn_addTable[this.regA];
    }

    private void or(int oper8) {
        this.regA = (this.regA | oper8) & 0xFF;
        this.carryFlag = false;
        this.sz5h3pnFlags = sz53pn_addTable[this.regA];
    }

    public final void cp(int oper8) {
        int res = this.regA - (oper8 & 0xFF);
        this.carryFlag = res < 0;
        this.sz5h3pnFlags = sz53n_addTable[oper8] & 0x28 | sz53n_subTable[res &= 0xFF] & 0xD2;
        if ((res & 0xF) > (this.regA & 0xF)) {
            this.sz5h3pnFlags |= 0x10;
        }
        if (((this.regA ^ oper8) & (this.regA ^ res)) > 127) {
            this.sz5h3pnFlags |= 4;
        }
    }

    private void daa() {
        int suma = 0;
        boolean carry = this.carryFlag;
        if ((this.sz5h3pnFlags & 0x10) != 0 || (this.regA & 0xF) > 9) {
            suma = 6;
        }
        if (carry || this.regA > 153) {
            suma |= 0x60;
        }
        if (this.regA > 153) {
            carry = true;
        }
        if ((this.sz5h3pnFlags & 2) != 0) {
            this.sub(suma);
            this.sz5h3pnFlags = this.sz5h3pnFlags & 0x10 | sz53pn_subTable[this.regA];
        } else {
            this.add(suma);
            this.sz5h3pnFlags = this.sz5h3pnFlags & 0x10 | sz53pn_addTable[this.regA];
        }
        this.carryFlag = carry;
    }

    private int pop() {
        int word = this.MemIoImpl.peek16(this.regSP);
        this.regSP = this.regSP + 2 & 0xFFFF;
        return word;
    }

    private void push(int word) {
        this.regSP = this.regSP - 1 & 0xFFFF;
        this.MemIoImpl.poke8(this.regSP, word >>> 8);
        this.regSP = this.regSP - 1 & 0xFFFF;
        this.MemIoImpl.poke8(this.regSP, word);
    }

    private void ldi() {
        int work8 = this.MemIoImpl.peek8(this.getRegHL());
        int regDE = this.getRegDE();
        this.MemIoImpl.poke8(regDE, work8);
        this.MemIoImpl.contendedStates(regDE, 2);
        this.incRegHL();
        this.incRegDE();
        this.decRegBC();
        this.sz5h3pnFlags = this.sz5h3pnFlags & 0xC0 | (work8 += this.regA) & 8;
        if ((work8 & 2) != 0) {
            this.sz5h3pnFlags |= 0x20;
        }
        if (this.regC != 0 || this.regB != 0) {
            this.sz5h3pnFlags |= 4;
        }
    }

    private void ldd() {
        int work8 = this.MemIoImpl.peek8(this.getRegHL());
        int regDE = this.getRegDE();
        this.MemIoImpl.poke8(regDE, work8);
        this.MemIoImpl.contendedStates(regDE, 2);
        this.decRegHL();
        this.decRegDE();
        this.decRegBC();
        this.sz5h3pnFlags = this.sz5h3pnFlags & 0xC0 | (work8 += this.regA) & 8;
        if ((work8 & 2) != 0) {
            this.sz5h3pnFlags |= 0x20;
        }
        if (this.regC != 0 || this.regB != 0) {
            this.sz5h3pnFlags |= 4;
        }
    }

    private void cpi() {
        int regHL = this.getRegHL();
        int memHL = this.MemIoImpl.peek8(regHL);
        boolean carry = this.carryFlag;
        this.cp(memHL);
        this.carryFlag = carry;
        this.MemIoImpl.contendedStates(regHL, 5);
        this.incRegHL();
        this.decRegBC();
        memHL = this.regA - memHL - ((this.sz5h3pnFlags & 0x10) != 0 ? 1 : 0);
        this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD2 | memHL & 8;
        if ((memHL & 2) != 0) {
            this.sz5h3pnFlags |= 0x20;
        }
        if (this.regC != 0 || this.regB != 0) {
            this.sz5h3pnFlags |= 4;
        }
        ++this.memptr;
    }

    private void cpd() {
        int regHL = this.getRegHL();
        int memHL = this.MemIoImpl.peek8(regHL);
        boolean carry = this.carryFlag;
        this.cp(memHL);
        this.carryFlag = carry;
        this.MemIoImpl.contendedStates(regHL, 5);
        this.decRegHL();
        this.decRegBC();
        memHL = this.regA - memHL - ((this.sz5h3pnFlags & 0x10) != 0 ? 1 : 0);
        this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD2 | memHL & 8;
        if ((memHL & 2) != 0) {
            this.sz5h3pnFlags |= 0x20;
        }
        if (this.regC != 0 || this.regB != 0) {
            this.sz5h3pnFlags |= 4;
        }
        --this.memptr;
    }

    private void ini() {
        this.memptr = this.getRegBC();
        this.MemIoImpl.contendedStates(this.getPairIR(), 1);
        int work8 = this.MemIoImpl.inPort(this.memptr);
        this.MemIoImpl.poke8(this.getRegHL(), work8);
        ++this.memptr;
        this.regB = this.regB - 1 & 0xFF;
        this.incRegHL();
        this.sz5h3pnFlags = sz53pn_addTable[this.regB];
        if (work8 > 127) {
            this.sz5h3pnFlags |= 2;
        }
        this.carryFlag = false;
        int tmp = work8 + (this.regC + 1 & 0xFF);
        if (tmp > 255) {
            this.sz5h3pnFlags |= 0x10;
            this.carryFlag = true;
        }
        this.sz5h3pnFlags = (sz53pn_addTable[tmp & 7 ^ this.regB] & 4) == 4 ? (this.sz5h3pnFlags |= 4) : (this.sz5h3pnFlags &= 0xFFFFFFFB);
    }

    private void ind() {
        this.memptr = this.getRegBC();
        this.MemIoImpl.contendedStates(this.getPairIR(), 1);
        int work8 = this.MemIoImpl.inPort(this.memptr);
        this.MemIoImpl.poke8(this.getRegHL(), work8);
        --this.memptr;
        this.regB = this.regB - 1 & 0xFF;
        this.decRegHL();
        this.sz5h3pnFlags = sz53pn_addTable[this.regB];
        if (work8 > 127) {
            this.sz5h3pnFlags |= 2;
        }
        this.carryFlag = false;
        int tmp = work8 + (this.regC - 1 & 0xFF);
        if (tmp > 255) {
            this.sz5h3pnFlags |= 0x10;
            this.carryFlag = true;
        }
        this.sz5h3pnFlags = (sz53pn_addTable[tmp & 7 ^ this.regB] & 4) == 4 ? (this.sz5h3pnFlags |= 4) : (this.sz5h3pnFlags &= 0xFFFFFFFB);
    }

    private void outi() {
        this.MemIoImpl.contendedStates(this.getPairIR(), 1);
        this.regB = this.regB - 1 & 0xFF;
        this.memptr = this.getRegBC();
        int work8 = this.MemIoImpl.peek8(this.getRegHL());
        this.MemIoImpl.outPort(this.memptr, work8);
        ++this.memptr;
        this.incRegHL();
        this.carryFlag = false;
        this.sz5h3pnFlags = work8 > 127 ? sz53n_subTable[this.regB] : sz53n_addTable[this.regB];
        if (this.regL + work8 > 255) {
            this.sz5h3pnFlags |= 0x10;
            this.carryFlag = true;
        }
        if ((sz53pn_addTable[this.regL + work8 & 7 ^ this.regB] & 4) == 4) {
            this.sz5h3pnFlags |= 4;
        }
    }

    private void outd() {
        this.MemIoImpl.contendedStates(this.getPairIR(), 1);
        this.regB = this.regB - 1 & 0xFF;
        this.memptr = this.getRegBC();
        int work8 = this.MemIoImpl.peek8(this.getRegHL());
        this.MemIoImpl.outPort(this.memptr, work8);
        --this.memptr;
        this.decRegHL();
        this.carryFlag = false;
        this.sz5h3pnFlags = work8 > 127 ? sz53n_subTable[this.regB] : sz53n_addTable[this.regB];
        if (this.regL + work8 > 255) {
            this.sz5h3pnFlags |= 0x10;
            this.carryFlag = true;
        }
        if ((sz53pn_addTable[this.regL + work8 & 7 ^ this.regB] & 4) == 4) {
            this.sz5h3pnFlags |= 4;
        }
    }

    private void bit(int mask, int reg) {
        boolean zeroFlag = (mask & reg) == 0;
        this.sz5h3pnFlags = sz53n_addTable[reg] & 0xFFFFFF3B | 0x10;
        if (zeroFlag) {
            this.sz5h3pnFlags |= 0x44;
        }
        if (mask == 128 && !zeroFlag) {
            this.sz5h3pnFlags |= 0x80;
        }
    }

    private void interruption() {
        if (this.halted) {
            this.halted = false;
            this.regPC = this.regPC + 1 & 0xFFFF;
        }
        this.clock.addTstates(7);
        ++this.regR;
        this.ffIFF2 = false;
        this.ffIFF1 = false;
        this.push(this.regPC);
        this.regPC = this.modeINT == IntMode.IM2 ? this.MemIoImpl.peek16(this.regI << 8 | 0xFF) : 56;
        this.memptr = this.regPC;
    }

    private void nmi() {
        this.MemIoImpl.fetchOpcode(this.regPC);
        this.clock.addTstates(1);
        if (this.halted) {
            this.halted = false;
            this.regPC = this.regPC + 1 & 0xFFFF;
        }
        ++this.regR;
        this.ffIFF1 = false;
        this.push(this.regPC);
        this.memptr = 102;
        this.regPC = 102;
    }

    public final boolean isBreakpoint(int address) {
        return this.breakpointAt[address & 0xFFFF];
    }

    public final void setBreakpoint(int address, boolean state) {
        this.breakpointAt[address & 0xFFFF] = state;
    }

    public void resetBreakpoints() {
        Arrays.fill(this.breakpointAt, false);
    }

    public final void execute(int statesLimit) {
        while (this.clock.getTstates() < statesLimit) {
            if (this.activeNMI) {
                this.activeNMI = false;
                this.nmi();
                continue;
            }
            if (this.activeINT && this.ffIFF1 && !this.pendingEI) {
                this.interruption();
            }
            ++this.regR;
            this.opCode = this.MemIoImpl.fetchOpcode(this.regPC);
            if (this.breakpointAt[this.regPC]) {
                this.opCode = this.NotifyImpl.atAddress(this.regPC, this.opCode);
            }
            this.regPC = this.regPC + 1 & 0xFFFF;
            this.decodeOpcode(this.opCode);
            if (this.pendingEI && this.opCode != 251) {
                this.pendingEI = false;
            }
            if (!this.execDone) continue;
            this.NotifyImpl.execDone();
        }
    }

    private void decodeOpcode(int opCode) {
        switch (opCode) {
            case 1: {
                this.setRegBC(this.MemIoImpl.peek16(this.regPC));
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 2: {
                this.MemIoImpl.poke8(this.getRegBC(), this.regA);
                this.memptr = this.regA << 8 | this.regC + 1 & 0xFF;
                break;
            }
            case 3: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                this.incRegBC();
                break;
            }
            case 4: {
                this.regB = this.inc8(this.regB);
                break;
            }
            case 5: {
                this.regB = this.dec8(this.regB);
                break;
            }
            case 6: {
                this.regB = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 7: {
                this.carryFlag = this.regA > 127;
                this.regA = this.regA << 1 & 0xFF;
                if (this.carryFlag) {
                    this.regA |= 1;
                }
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xC4 | this.regA & 0x28;
                break;
            }
            case 8: {
                int work8 = this.regA;
                this.regA = this.regAx;
                this.regAx = work8;
                work8 = this.getFlags();
                this.setFlags(this.regFx);
                this.regFx = work8;
                break;
            }
            case 9: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.setRegHL(this.add16(this.getRegHL(), this.getRegBC()));
                break;
            }
            case 10: {
                this.memptr = this.getRegBC();
                this.regA = this.MemIoImpl.peek8(this.memptr);
                ++this.memptr;
                break;
            }
            case 11: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                this.decRegBC();
                break;
            }
            case 12: {
                this.regC = this.inc8(this.regC);
                break;
            }
            case 13: {
                this.regC = this.dec8(this.regC);
                break;
            }
            case 14: {
                this.regC = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 15: {
                this.carryFlag = (this.regA & 1) != 0;
                this.regA >>>= 1;
                if (this.carryFlag) {
                    this.regA |= 0x80;
                }
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xC4 | this.regA & 0x28;
                break;
            }
            case 16: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                byte offset = (byte)this.MemIoImpl.peek8(this.regPC);
                --this.regB;
                if (this.regB != 0) {
                    this.regB &= 0xFF;
                    this.MemIoImpl.contendedStates(this.regPC, 5);
                    this.regPC = this.memptr = this.regPC + offset + 1 & 0xFFFF;
                    break;
                }
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 17: {
                this.setRegDE(this.MemIoImpl.peek16(this.regPC));
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 18: {
                this.MemIoImpl.poke8(this.getRegDE(), this.regA);
                this.memptr = this.regA << 8 | this.regE + 1 & 0xFF;
                break;
            }
            case 19: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                this.incRegDE();
                break;
            }
            case 20: {
                this.regD = this.inc8(this.regD);
                break;
            }
            case 21: {
                this.regD = this.dec8(this.regD);
                break;
            }
            case 22: {
                this.regD = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 23: {
                boolean oldCarry = this.carryFlag;
                this.carryFlag = this.regA > 127;
                this.regA = this.regA << 1 & 0xFF;
                if (oldCarry) {
                    this.regA |= 1;
                }
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xC4 | this.regA & 0x28;
                break;
            }
            case 24: {
                byte offset = (byte)this.MemIoImpl.peek8(this.regPC);
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.regPC = this.memptr = this.regPC + offset + 1 & 0xFFFF;
                break;
            }
            case 25: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.setRegHL(this.add16(this.getRegHL(), this.getRegDE()));
                break;
            }
            case 26: {
                this.memptr = this.getRegDE();
                this.regA = this.MemIoImpl.peek8(this.memptr);
                ++this.memptr;
                break;
            }
            case 27: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                this.decRegDE();
                break;
            }
            case 28: {
                this.regE = this.inc8(this.regE);
                break;
            }
            case 29: {
                this.regE = this.dec8(this.regE);
                break;
            }
            case 30: {
                this.regE = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 31: {
                boolean oldCarry = this.carryFlag;
                this.carryFlag = (this.regA & 1) != 0;
                this.regA >>>= 1;
                if (oldCarry) {
                    this.regA |= 0x80;
                }
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xC4 | this.regA & 0x28;
                break;
            }
            case 32: {
                byte offset = (byte)this.MemIoImpl.peek8(this.regPC);
                if ((this.sz5h3pnFlags & 0x40) == 0) {
                    this.MemIoImpl.contendedStates(this.regPC, 5);
                    this.regPC += offset;
                }
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 33: {
                this.setRegHL(this.MemIoImpl.peek16(this.regPC));
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 34: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.MemIoImpl.poke16(this.memptr, this.getRegHL());
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 35: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                this.incRegHL();
                break;
            }
            case 36: {
                this.regH = this.inc8(this.regH);
                break;
            }
            case 37: {
                this.regH = this.dec8(this.regH);
                break;
            }
            case 38: {
                this.regH = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 39: {
                this.daa();
                break;
            }
            case 40: {
                byte offset = (byte)this.MemIoImpl.peek8(this.regPC);
                if ((this.sz5h3pnFlags & 0x40) != 0) {
                    this.MemIoImpl.contendedStates(this.regPC, 5);
                    this.regPC += offset;
                }
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 41: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                int work16 = this.getRegHL();
                this.setRegHL(this.add16(work16, work16));
                break;
            }
            case 42: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.setRegHL(this.MemIoImpl.peek16(this.memptr));
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 43: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                this.decRegHL();
                break;
            }
            case 44: {
                this.regL = this.inc8(this.regL);
                break;
            }
            case 45: {
                this.regL = this.dec8(this.regL);
                break;
            }
            case 46: {
                this.regL = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 47: {
                this.regA ^= 0xFF;
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xC4 | 0x10 | this.regA & 0x28 | 2;
                break;
            }
            case 48: {
                byte offset = (byte)this.MemIoImpl.peek8(this.regPC);
                if (!this.carryFlag) {
                    this.MemIoImpl.contendedStates(this.regPC, 5);
                    this.regPC += offset;
                }
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 49: {
                this.regSP = this.MemIoImpl.peek16(this.regPC);
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 50: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.MemIoImpl.poke8(this.memptr, this.regA);
                this.memptr = this.regA << 8 | this.memptr + 1 & 0xFF;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 51: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                this.regSP = this.regSP + 1 & 0xFFFF;
                break;
            }
            case 52: {
                int work16 = this.getRegHL();
                int work8 = this.inc8(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 53: {
                int work16 = this.getRegHL();
                int work8 = this.dec8(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 54: {
                this.MemIoImpl.poke8(this.getRegHL(), this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 55: {
                this.carryFlag = true;
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xC4 | this.regA & 0x28;
                break;
            }
            case 56: {
                byte offset = (byte)this.MemIoImpl.peek8(this.regPC);
                if (this.carryFlag) {
                    this.MemIoImpl.contendedStates(this.regPC, 5);
                    this.regPC += offset;
                }
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 57: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.setRegHL(this.add16(this.getRegHL(), this.regSP));
                break;
            }
            case 58: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.regA = this.MemIoImpl.peek8(this.memptr);
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 59: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                this.regSP = this.regSP - 1 & 0xFFFF;
                break;
            }
            case 60: {
                this.regA = this.inc8(this.regA);
                break;
            }
            case 61: {
                this.regA = this.dec8(this.regA);
                break;
            }
            case 62: {
                this.regA = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 63: {
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xC4 | this.regA & 0x28;
                if (this.carryFlag) {
                    this.sz5h3pnFlags |= 0x10;
                }
                this.carryFlag = !this.carryFlag;
                break;
            }
            case 65: {
                this.regB = this.regC;
                break;
            }
            case 66: {
                this.regB = this.regD;
                break;
            }
            case 67: {
                this.regB = this.regE;
                break;
            }
            case 68: {
                this.regB = this.regH;
                break;
            }
            case 69: {
                this.regB = this.regL;
                break;
            }
            case 70: {
                this.regB = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 71: {
                this.regB = this.regA;
                break;
            }
            case 72: {
                this.regC = this.regB;
                break;
            }
            case 74: {
                this.regC = this.regD;
                break;
            }
            case 75: {
                this.regC = this.regE;
                break;
            }
            case 76: {
                this.regC = this.regH;
                break;
            }
            case 77: {
                this.regC = this.regL;
                break;
            }
            case 78: {
                this.regC = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 79: {
                this.regC = this.regA;
                break;
            }
            case 80: {
                this.regD = this.regB;
                break;
            }
            case 81: {
                this.regD = this.regC;
                break;
            }
            case 83: {
                this.regD = this.regE;
                break;
            }
            case 84: {
                this.regD = this.regH;
                break;
            }
            case 85: {
                this.regD = this.regL;
                break;
            }
            case 86: {
                this.regD = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 87: {
                this.regD = this.regA;
                break;
            }
            case 88: {
                this.regE = this.regB;
                break;
            }
            case 89: {
                this.regE = this.regC;
                break;
            }
            case 90: {
                this.regE = this.regD;
                break;
            }
            case 92: {
                this.regE = this.regH;
                break;
            }
            case 93: {
                this.regE = this.regL;
                break;
            }
            case 94: {
                this.regE = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 95: {
                this.regE = this.regA;
                break;
            }
            case 96: {
                this.regH = this.regB;
                break;
            }
            case 97: {
                this.regH = this.regC;
                break;
            }
            case 98: {
                this.regH = this.regD;
                break;
            }
            case 99: {
                this.regH = this.regE;
                break;
            }
            case 101: {
                this.regH = this.regL;
                break;
            }
            case 102: {
                this.regH = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 103: {
                this.regH = this.regA;
                break;
            }
            case 104: {
                this.regL = this.regB;
                break;
            }
            case 105: {
                this.regL = this.regC;
                break;
            }
            case 106: {
                this.regL = this.regD;
                break;
            }
            case 107: {
                this.regL = this.regE;
                break;
            }
            case 108: {
                this.regL = this.regH;
                break;
            }
            case 110: {
                this.regL = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 111: {
                this.regL = this.regA;
                break;
            }
            case 112: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regB);
                break;
            }
            case 113: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regC);
                break;
            }
            case 114: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regD);
                break;
            }
            case 115: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regE);
                break;
            }
            case 116: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regH);
                break;
            }
            case 117: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regL);
                break;
            }
            case 118: {
                this.regPC = this.regPC - 1 & 0xFFFF;
                this.halted = true;
                break;
            }
            case 119: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regA);
                break;
            }
            case 120: {
                this.regA = this.regB;
                break;
            }
            case 121: {
                this.regA = this.regC;
                break;
            }
            case 122: {
                this.regA = this.regD;
                break;
            }
            case 123: {
                this.regA = this.regE;
                break;
            }
            case 124: {
                this.regA = this.regH;
                break;
            }
            case 125: {
                this.regA = this.regL;
                break;
            }
            case 126: {
                this.regA = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 128: {
                this.add(this.regB);
                break;
            }
            case 129: {
                this.add(this.regC);
                break;
            }
            case 130: {
                this.add(this.regD);
                break;
            }
            case 131: {
                this.add(this.regE);
                break;
            }
            case 132: {
                this.add(this.regH);
                break;
            }
            case 133: {
                this.add(this.regL);
                break;
            }
            case 134: {
                this.add(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 135: {
                this.add(this.regA);
                break;
            }
            case 136: {
                this.adc(this.regB);
                break;
            }
            case 137: {
                this.adc(this.regC);
                break;
            }
            case 138: {
                this.adc(this.regD);
                break;
            }
            case 139: {
                this.adc(this.regE);
                break;
            }
            case 140: {
                this.adc(this.regH);
                break;
            }
            case 141: {
                this.adc(this.regL);
                break;
            }
            case 142: {
                this.adc(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 143: {
                this.adc(this.regA);
                break;
            }
            case 144: {
                this.sub(this.regB);
                break;
            }
            case 145: {
                this.sub(this.regC);
                break;
            }
            case 146: {
                this.sub(this.regD);
                break;
            }
            case 147: {
                this.sub(this.regE);
                break;
            }
            case 148: {
                this.sub(this.regH);
                break;
            }
            case 149: {
                this.sub(this.regL);
                break;
            }
            case 150: {
                this.sub(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 151: {
                this.sub(this.regA);
                break;
            }
            case 152: {
                this.sbc(this.regB);
                break;
            }
            case 153: {
                this.sbc(this.regC);
                break;
            }
            case 154: {
                this.sbc(this.regD);
                break;
            }
            case 155: {
                this.sbc(this.regE);
                break;
            }
            case 156: {
                this.sbc(this.regH);
                break;
            }
            case 157: {
                this.sbc(this.regL);
                break;
            }
            case 158: {
                this.sbc(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 159: {
                this.sbc(this.regA);
                break;
            }
            case 160: {
                this.and(this.regB);
                break;
            }
            case 161: {
                this.and(this.regC);
                break;
            }
            case 162: {
                this.and(this.regD);
                break;
            }
            case 163: {
                this.and(this.regE);
                break;
            }
            case 164: {
                this.and(this.regH);
                break;
            }
            case 165: {
                this.and(this.regL);
                break;
            }
            case 166: {
                this.and(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 167: {
                this.and(this.regA);
                break;
            }
            case 168: {
                this.xor(this.regB);
                break;
            }
            case 169: {
                this.xor(this.regC);
                break;
            }
            case 170: {
                this.xor(this.regD);
                break;
            }
            case 171: {
                this.xor(this.regE);
                break;
            }
            case 172: {
                this.xor(this.regH);
                break;
            }
            case 173: {
                this.xor(this.regL);
                break;
            }
            case 174: {
                this.xor(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 175: {
                this.xor(this.regA);
                break;
            }
            case 176: {
                this.or(this.regB);
                break;
            }
            case 177: {
                this.or(this.regC);
                break;
            }
            case 178: {
                this.or(this.regD);
                break;
            }
            case 179: {
                this.or(this.regE);
                break;
            }
            case 180: {
                this.or(this.regH);
                break;
            }
            case 181: {
                this.or(this.regL);
                break;
            }
            case 182: {
                this.or(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 183: {
                this.or(this.regA);
                break;
            }
            case 184: {
                this.cp(this.regB);
                break;
            }
            case 185: {
                this.cp(this.regC);
                break;
            }
            case 186: {
                this.cp(this.regD);
                break;
            }
            case 187: {
                this.cp(this.regE);
                break;
            }
            case 188: {
                this.cp(this.regH);
                break;
            }
            case 189: {
                this.cp(this.regL);
                break;
            }
            case 190: {
                this.cp(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 191: {
                this.cp(this.regA);
                break;
            }
            case 192: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                if ((this.sz5h3pnFlags & 0x40) != 0) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 193: {
                this.setRegBC(this.pop());
                break;
            }
            case 194: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.sz5h3pnFlags & 0x40) == 0) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 195: {
                this.memptr = this.regPC = this.MemIoImpl.peek16(this.regPC);
                break;
            }
            case 196: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.sz5h3pnFlags & 0x40) == 0) {
                    this.MemIoImpl.contendedStates(this.regPC + 1 & 0xFFFF, 1);
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 197: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.getRegBC());
                break;
            }
            case 198: {
                this.add(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 199: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.regPC);
                this.memptr = 0;
                this.regPC = 0;
                break;
            }
            case 200: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                if ((this.sz5h3pnFlags & 0x40) == 0) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 201: {
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 202: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.sz5h3pnFlags & 0x40) != 0) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 203: {
                this.decodeCB();
                break;
            }
            case 204: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.sz5h3pnFlags & 0x40) != 0) {
                    this.MemIoImpl.contendedStates(this.regPC + 1 & 0xFFFF, 1);
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 205: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.MemIoImpl.contendedStates(this.regPC + 1 & 0xFFFF, 1);
                this.push(this.regPC + 2);
                this.regPC = this.memptr;
                break;
            }
            case 206: {
                this.adc(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 207: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.regPC);
                this.memptr = 8;
                this.regPC = 8;
                break;
            }
            case 208: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                if (this.carryFlag) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 209: {
                this.setRegDE(this.pop());
                break;
            }
            case 210: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (!this.carryFlag) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 211: {
                int work8 = this.MemIoImpl.peek8(this.regPC);
                this.memptr = this.regA << 8;
                this.MemIoImpl.outPort(this.memptr | work8, this.regA);
                this.memptr |= work8 + 1 & 0xFF;
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 212: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (!this.carryFlag) {
                    this.MemIoImpl.contendedStates(this.regPC + 1 & 0xFFFF, 1);
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 213: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.getRegDE());
                break;
            }
            case 214: {
                this.sub(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 215: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.regPC);
                this.memptr = 16;
                this.regPC = 16;
                break;
            }
            case 216: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                if (!this.carryFlag) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 217: {
                int work8 = this.regB;
                this.regB = this.regBx;
                this.regBx = work8;
                work8 = this.regC;
                this.regC = this.regCx;
                this.regCx = work8;
                work8 = this.regD;
                this.regD = this.regDx;
                this.regDx = work8;
                work8 = this.regE;
                this.regE = this.regEx;
                this.regEx = work8;
                work8 = this.regH;
                this.regH = this.regHx;
                this.regHx = work8;
                work8 = this.regL;
                this.regL = this.regLx;
                this.regLx = work8;
                break;
            }
            case 218: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.carryFlag) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 219: {
                this.memptr = this.regA << 8 | this.MemIoImpl.peek8(this.regPC);
                this.regA = this.MemIoImpl.inPort(this.memptr);
                ++this.memptr;
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 220: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.carryFlag) {
                    this.MemIoImpl.contendedStates(this.regPC + 1 & 0xFFFF, 1);
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 221: {
                this.regIX = this.decodeDDFD(this.regIX);
                break;
            }
            case 222: {
                this.sbc(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 223: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.regPC);
                this.memptr = 24;
                this.regPC = 24;
                break;
            }
            case 224: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                if ((this.sz5h3pnFlags & 4) != 0) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 225: {
                this.setRegHL(this.pop());
                break;
            }
            case 226: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.sz5h3pnFlags & 4) == 0) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 227: {
                int work16 = this.regH;
                int work8 = this.regL;
                this.setRegHL(this.MemIoImpl.peek16(this.regSP));
                this.MemIoImpl.contendedStates(this.regSP + 1 & 0xFFFF, 1);
                this.MemIoImpl.poke8(this.regSP + 1 & 0xFFFF, work16);
                this.MemIoImpl.poke8(this.regSP, work8);
                this.MemIoImpl.contendedStates(this.regSP, 2);
                this.memptr = this.getRegHL();
                break;
            }
            case 228: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.sz5h3pnFlags & 4) == 0) {
                    this.MemIoImpl.contendedStates(this.regPC + 1 & 0xFFFF, 1);
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 229: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.getRegHL());
                break;
            }
            case 230: {
                this.and(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 231: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.regPC);
                this.memptr = 32;
                this.regPC = 32;
                break;
            }
            case 232: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                if ((this.sz5h3pnFlags & 4) == 0) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 233: {
                this.regPC = this.getRegHL();
                break;
            }
            case 234: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.sz5h3pnFlags & 4) != 0) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 235: {
                int work8 = this.regH;
                this.regH = this.regD;
                this.regD = work8;
                work8 = this.regL;
                this.regL = this.regE;
                this.regE = work8;
                break;
            }
            case 236: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.sz5h3pnFlags & 4) != 0) {
                    this.MemIoImpl.contendedStates(this.regPC + 1 & 0xFFFF, 1);
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 237: {
                this.decodeED();
                break;
            }
            case 238: {
                this.xor(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 239: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.regPC);
                this.memptr = 40;
                this.regPC = 40;
                break;
            }
            case 240: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                if (this.sz5h3pnFlags >= 128) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 241: {
                this.setRegAF(this.pop());
                break;
            }
            case 242: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.sz5h3pnFlags < 128) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 243: {
                this.ffIFF2 = false;
                this.ffIFF1 = false;
                break;
            }
            case 244: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.sz5h3pnFlags < 128) {
                    this.MemIoImpl.contendedStates(this.regPC + 1 & 0xFFFF, 1);
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 245: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.getRegAF());
                break;
            }
            case 246: {
                this.or(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 247: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.regPC);
                this.memptr = 48;
                this.regPC = 48;
                break;
            }
            case 248: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                if (this.sz5h3pnFlags <= 127) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 249: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                this.regSP = this.getRegHL();
                break;
            }
            case 250: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.sz5h3pnFlags > 127) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 251: {
                this.ffIFF2 = true;
                this.ffIFF1 = true;
                this.pendingEI = true;
                break;
            }
            case 252: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.sz5h3pnFlags > 127) {
                    this.MemIoImpl.contendedStates(this.regPC + 1 & 0xFFFF, 1);
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 253: {
                this.regIY = this.decodeDDFD(this.regIY);
                break;
            }
            case 254: {
                this.cp(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 255: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(this.regPC);
                this.memptr = 56;
                this.regPC = 56;
            }
        }
    }

    private void decodeCB() {
        ++this.regR;
        this.opCode = this.MemIoImpl.fetchOpcode(this.regPC);
        this.regPC = this.regPC + 1 & 0xFFFF;
        switch (this.opCode) {
            case 0: {
                this.regB = this.rlc(this.regB);
                break;
            }
            case 1: {
                this.regC = this.rlc(this.regC);
                break;
            }
            case 2: {
                this.regD = this.rlc(this.regD);
                break;
            }
            case 3: {
                this.regE = this.rlc(this.regE);
                break;
            }
            case 4: {
                this.regH = this.rlc(this.regH);
                break;
            }
            case 5: {
                this.regL = this.rlc(this.regL);
                break;
            }
            case 6: {
                int work16 = this.getRegHL();
                int work8 = this.rlc(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 7: {
                this.regA = this.rlc(this.regA);
                break;
            }
            case 8: {
                this.regB = this.rrc(this.regB);
                break;
            }
            case 9: {
                this.regC = this.rrc(this.regC);
                break;
            }
            case 10: {
                this.regD = this.rrc(this.regD);
                break;
            }
            case 11: {
                this.regE = this.rrc(this.regE);
                break;
            }
            case 12: {
                this.regH = this.rrc(this.regH);
                break;
            }
            case 13: {
                this.regL = this.rrc(this.regL);
                break;
            }
            case 14: {
                int work16 = this.getRegHL();
                int work8 = this.rrc(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 15: {
                this.regA = this.rrc(this.regA);
                break;
            }
            case 16: {
                this.regB = this.rl(this.regB);
                break;
            }
            case 17: {
                this.regC = this.rl(this.regC);
                break;
            }
            case 18: {
                this.regD = this.rl(this.regD);
                break;
            }
            case 19: {
                this.regE = this.rl(this.regE);
                break;
            }
            case 20: {
                this.regH = this.rl(this.regH);
                break;
            }
            case 21: {
                this.regL = this.rl(this.regL);
                break;
            }
            case 22: {
                int work16 = this.getRegHL();
                int work8 = this.rl(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 23: {
                this.regA = this.rl(this.regA);
                break;
            }
            case 24: {
                this.regB = this.rr(this.regB);
                break;
            }
            case 25: {
                this.regC = this.rr(this.regC);
                break;
            }
            case 26: {
                this.regD = this.rr(this.regD);
                break;
            }
            case 27: {
                this.regE = this.rr(this.regE);
                break;
            }
            case 28: {
                this.regH = this.rr(this.regH);
                break;
            }
            case 29: {
                this.regL = this.rr(this.regL);
                break;
            }
            case 30: {
                int work16 = this.getRegHL();
                int work8 = this.rr(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 31: {
                this.regA = this.rr(this.regA);
                break;
            }
            case 32: {
                this.regB = this.sla(this.regB);
                break;
            }
            case 33: {
                this.regC = this.sla(this.regC);
                break;
            }
            case 34: {
                this.regD = this.sla(this.regD);
                break;
            }
            case 35: {
                this.regE = this.sla(this.regE);
                break;
            }
            case 36: {
                this.regH = this.sla(this.regH);
                break;
            }
            case 37: {
                this.regL = this.sla(this.regL);
                break;
            }
            case 38: {
                int work16 = this.getRegHL();
                int work8 = this.sla(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 39: {
                this.regA = this.sla(this.regA);
                break;
            }
            case 40: {
                this.regB = this.sra(this.regB);
                break;
            }
            case 41: {
                this.regC = this.sra(this.regC);
                break;
            }
            case 42: {
                this.regD = this.sra(this.regD);
                break;
            }
            case 43: {
                this.regE = this.sra(this.regE);
                break;
            }
            case 44: {
                this.regH = this.sra(this.regH);
                break;
            }
            case 45: {
                this.regL = this.sra(this.regL);
                break;
            }
            case 46: {
                int work16 = this.getRegHL();
                int work8 = this.sra(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 47: {
                this.regA = this.sra(this.regA);
                break;
            }
            case 48: {
                this.regB = this.sll(this.regB);
                break;
            }
            case 49: {
                this.regC = this.sll(this.regC);
                break;
            }
            case 50: {
                this.regD = this.sll(this.regD);
                break;
            }
            case 51: {
                this.regE = this.sll(this.regE);
                break;
            }
            case 52: {
                this.regH = this.sll(this.regH);
                break;
            }
            case 53: {
                this.regL = this.sll(this.regL);
                break;
            }
            case 54: {
                int work16 = this.getRegHL();
                int work8 = this.sll(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 55: {
                this.regA = this.sll(this.regA);
                break;
            }
            case 56: {
                this.regB = this.srl(this.regB);
                break;
            }
            case 57: {
                this.regC = this.srl(this.regC);
                break;
            }
            case 58: {
                this.regD = this.srl(this.regD);
                break;
            }
            case 59: {
                this.regE = this.srl(this.regE);
                break;
            }
            case 60: {
                this.regH = this.srl(this.regH);
                break;
            }
            case 61: {
                this.regL = this.srl(this.regL);
                break;
            }
            case 62: {
                int work16 = this.getRegHL();
                int work8 = this.srl(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 63: {
                this.regA = this.srl(this.regA);
                break;
            }
            case 64: {
                this.bit(1, this.regB);
                break;
            }
            case 65: {
                this.bit(1, this.regC);
                break;
            }
            case 66: {
                this.bit(1, this.regD);
                break;
            }
            case 67: {
                this.bit(1, this.regE);
                break;
            }
            case 68: {
                this.bit(1, this.regH);
                break;
            }
            case 69: {
                this.bit(1, this.regL);
                break;
            }
            case 70: {
                int work16 = this.getRegHL();
                this.bit(1, this.MemIoImpl.peek8(work16));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | this.memptr >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(work16, 1);
                break;
            }
            case 71: {
                this.bit(1, this.regA);
                break;
            }
            case 72: {
                this.bit(2, this.regB);
                break;
            }
            case 73: {
                this.bit(2, this.regC);
                break;
            }
            case 74: {
                this.bit(2, this.regD);
                break;
            }
            case 75: {
                this.bit(2, this.regE);
                break;
            }
            case 76: {
                this.bit(2, this.regH);
                break;
            }
            case 77: {
                this.bit(2, this.regL);
                break;
            }
            case 78: {
                int work16 = this.getRegHL();
                this.bit(2, this.MemIoImpl.peek8(work16));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | this.memptr >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(work16, 1);
                break;
            }
            case 79: {
                this.bit(2, this.regA);
                break;
            }
            case 80: {
                this.bit(4, this.regB);
                break;
            }
            case 81: {
                this.bit(4, this.regC);
                break;
            }
            case 82: {
                this.bit(4, this.regD);
                break;
            }
            case 83: {
                this.bit(4, this.regE);
                break;
            }
            case 84: {
                this.bit(4, this.regH);
                break;
            }
            case 85: {
                this.bit(4, this.regL);
                break;
            }
            case 86: {
                int work16 = this.getRegHL();
                this.bit(4, this.MemIoImpl.peek8(work16));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | this.memptr >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(work16, 1);
                break;
            }
            case 87: {
                this.bit(4, this.regA);
                break;
            }
            case 88: {
                this.bit(8, this.regB);
                break;
            }
            case 89: {
                this.bit(8, this.regC);
                break;
            }
            case 90: {
                this.bit(8, this.regD);
                break;
            }
            case 91: {
                this.bit(8, this.regE);
                break;
            }
            case 92: {
                this.bit(8, this.regH);
                break;
            }
            case 93: {
                this.bit(8, this.regL);
                break;
            }
            case 94: {
                int work16 = this.getRegHL();
                this.bit(8, this.MemIoImpl.peek8(work16));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | this.memptr >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(work16, 1);
                break;
            }
            case 95: {
                this.bit(8, this.regA);
                break;
            }
            case 96: {
                this.bit(16, this.regB);
                break;
            }
            case 97: {
                this.bit(16, this.regC);
                break;
            }
            case 98: {
                this.bit(16, this.regD);
                break;
            }
            case 99: {
                this.bit(16, this.regE);
                break;
            }
            case 100: {
                this.bit(16, this.regH);
                break;
            }
            case 101: {
                this.bit(16, this.regL);
                break;
            }
            case 102: {
                int work16 = this.getRegHL();
                this.bit(16, this.MemIoImpl.peek8(work16));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | this.memptr >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(work16, 1);
                break;
            }
            case 103: {
                this.bit(16, this.regA);
                break;
            }
            case 104: {
                this.bit(32, this.regB);
                break;
            }
            case 105: {
                this.bit(32, this.regC);
                break;
            }
            case 106: {
                this.bit(32, this.regD);
                break;
            }
            case 107: {
                this.bit(32, this.regE);
                break;
            }
            case 108: {
                this.bit(32, this.regH);
                break;
            }
            case 109: {
                this.bit(32, this.regL);
                break;
            }
            case 110: {
                int work16 = this.getRegHL();
                this.bit(32, this.MemIoImpl.peek8(work16));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | this.memptr >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(work16, 1);
                break;
            }
            case 111: {
                this.bit(32, this.regA);
                break;
            }
            case 112: {
                this.bit(64, this.regB);
                break;
            }
            case 113: {
                this.bit(64, this.regC);
                break;
            }
            case 114: {
                this.bit(64, this.regD);
                break;
            }
            case 115: {
                this.bit(64, this.regE);
                break;
            }
            case 116: {
                this.bit(64, this.regH);
                break;
            }
            case 117: {
                this.bit(64, this.regL);
                break;
            }
            case 118: {
                int work16 = this.getRegHL();
                this.bit(64, this.MemIoImpl.peek8(work16));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | this.memptr >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(work16, 1);
                break;
            }
            case 119: {
                this.bit(64, this.regA);
                break;
            }
            case 120: {
                this.bit(128, this.regB);
                break;
            }
            case 121: {
                this.bit(128, this.regC);
                break;
            }
            case 122: {
                this.bit(128, this.regD);
                break;
            }
            case 123: {
                this.bit(128, this.regE);
                break;
            }
            case 124: {
                this.bit(128, this.regH);
                break;
            }
            case 125: {
                this.bit(128, this.regL);
                break;
            }
            case 126: {
                int work16 = this.getRegHL();
                this.bit(128, this.MemIoImpl.peek8(work16));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | this.memptr >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(work16, 1);
                break;
            }
            case 127: {
                this.bit(128, this.regA);
                break;
            }
            case 128: {
                this.regB &= 0xFE;
                break;
            }
            case 129: {
                this.regC &= 0xFE;
                break;
            }
            case 130: {
                this.regD &= 0xFE;
                break;
            }
            case 131: {
                this.regE &= 0xFE;
                break;
            }
            case 132: {
                this.regH &= 0xFE;
                break;
            }
            case 133: {
                this.regL &= 0xFE;
                break;
            }
            case 134: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) & 0xFE;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 135: {
                this.regA &= 0xFE;
                break;
            }
            case 136: {
                this.regB &= 0xFD;
                break;
            }
            case 137: {
                this.regC &= 0xFD;
                break;
            }
            case 138: {
                this.regD &= 0xFD;
                break;
            }
            case 139: {
                this.regE &= 0xFD;
                break;
            }
            case 140: {
                this.regH &= 0xFD;
                break;
            }
            case 141: {
                this.regL &= 0xFD;
                break;
            }
            case 142: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) & 0xFD;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 143: {
                this.regA &= 0xFD;
                break;
            }
            case 144: {
                this.regB &= 0xFB;
                break;
            }
            case 145: {
                this.regC &= 0xFB;
                break;
            }
            case 146: {
                this.regD &= 0xFB;
                break;
            }
            case 147: {
                this.regE &= 0xFB;
                break;
            }
            case 148: {
                this.regH &= 0xFB;
                break;
            }
            case 149: {
                this.regL &= 0xFB;
                break;
            }
            case 150: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) & 0xFB;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 151: {
                this.regA &= 0xFB;
                break;
            }
            case 152: {
                this.regB &= 0xF7;
                break;
            }
            case 153: {
                this.regC &= 0xF7;
                break;
            }
            case 154: {
                this.regD &= 0xF7;
                break;
            }
            case 155: {
                this.regE &= 0xF7;
                break;
            }
            case 156: {
                this.regH &= 0xF7;
                break;
            }
            case 157: {
                this.regL &= 0xF7;
                break;
            }
            case 158: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) & 0xF7;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 159: {
                this.regA &= 0xF7;
                break;
            }
            case 160: {
                this.regB &= 0xEF;
                break;
            }
            case 161: {
                this.regC &= 0xEF;
                break;
            }
            case 162: {
                this.regD &= 0xEF;
                break;
            }
            case 163: {
                this.regE &= 0xEF;
                break;
            }
            case 164: {
                this.regH &= 0xEF;
                break;
            }
            case 165: {
                this.regL &= 0xEF;
                break;
            }
            case 166: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) & 0xEF;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 167: {
                this.regA &= 0xEF;
                break;
            }
            case 168: {
                this.regB &= 0xDF;
                break;
            }
            case 169: {
                this.regC &= 0xDF;
                break;
            }
            case 170: {
                this.regD &= 0xDF;
                break;
            }
            case 171: {
                this.regE &= 0xDF;
                break;
            }
            case 172: {
                this.regH &= 0xDF;
                break;
            }
            case 173: {
                this.regL &= 0xDF;
                break;
            }
            case 174: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) & 0xDF;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 175: {
                this.regA &= 0xDF;
                break;
            }
            case 176: {
                this.regB &= 0xBF;
                break;
            }
            case 177: {
                this.regC &= 0xBF;
                break;
            }
            case 178: {
                this.regD &= 0xBF;
                break;
            }
            case 179: {
                this.regE &= 0xBF;
                break;
            }
            case 180: {
                this.regH &= 0xBF;
                break;
            }
            case 181: {
                this.regL &= 0xBF;
                break;
            }
            case 182: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) & 0xBF;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 183: {
                this.regA &= 0xBF;
                break;
            }
            case 184: {
                this.regB &= 0x7F;
                break;
            }
            case 185: {
                this.regC &= 0x7F;
                break;
            }
            case 186: {
                this.regD &= 0x7F;
                break;
            }
            case 187: {
                this.regE &= 0x7F;
                break;
            }
            case 188: {
                this.regH &= 0x7F;
                break;
            }
            case 189: {
                this.regL &= 0x7F;
                break;
            }
            case 190: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) & 0x7F;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 191: {
                this.regA &= 0x7F;
                break;
            }
            case 192: {
                this.regB |= 1;
                break;
            }
            case 193: {
                this.regC |= 1;
                break;
            }
            case 194: {
                this.regD |= 1;
                break;
            }
            case 195: {
                this.regE |= 1;
                break;
            }
            case 196: {
                this.regH |= 1;
                break;
            }
            case 197: {
                this.regL |= 1;
                break;
            }
            case 198: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) | 1;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 199: {
                this.regA |= 1;
                break;
            }
            case 200: {
                this.regB |= 2;
                break;
            }
            case 201: {
                this.regC |= 2;
                break;
            }
            case 202: {
                this.regD |= 2;
                break;
            }
            case 203: {
                this.regE |= 2;
                break;
            }
            case 204: {
                this.regH |= 2;
                break;
            }
            case 205: {
                this.regL |= 2;
                break;
            }
            case 206: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) | 2;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 207: {
                this.regA |= 2;
                break;
            }
            case 208: {
                this.regB |= 4;
                break;
            }
            case 209: {
                this.regC |= 4;
                break;
            }
            case 210: {
                this.regD |= 4;
                break;
            }
            case 211: {
                this.regE |= 4;
                break;
            }
            case 212: {
                this.regH |= 4;
                break;
            }
            case 213: {
                this.regL |= 4;
                break;
            }
            case 214: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) | 4;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 215: {
                this.regA |= 4;
                break;
            }
            case 216: {
                this.regB |= 8;
                break;
            }
            case 217: {
                this.regC |= 8;
                break;
            }
            case 218: {
                this.regD |= 8;
                break;
            }
            case 219: {
                this.regE |= 8;
                break;
            }
            case 220: {
                this.regH |= 8;
                break;
            }
            case 221: {
                this.regL |= 8;
                break;
            }
            case 222: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) | 8;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 223: {
                this.regA |= 8;
                break;
            }
            case 224: {
                this.regB |= 0x10;
                break;
            }
            case 225: {
                this.regC |= 0x10;
                break;
            }
            case 226: {
                this.regD |= 0x10;
                break;
            }
            case 227: {
                this.regE |= 0x10;
                break;
            }
            case 228: {
                this.regH |= 0x10;
                break;
            }
            case 229: {
                this.regL |= 0x10;
                break;
            }
            case 230: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) | 0x10;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 231: {
                this.regA |= 0x10;
                break;
            }
            case 232: {
                this.regB |= 0x20;
                break;
            }
            case 233: {
                this.regC |= 0x20;
                break;
            }
            case 234: {
                this.regD |= 0x20;
                break;
            }
            case 235: {
                this.regE |= 0x20;
                break;
            }
            case 236: {
                this.regH |= 0x20;
                break;
            }
            case 237: {
                this.regL |= 0x20;
                break;
            }
            case 238: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) | 0x20;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 239: {
                this.regA |= 0x20;
                break;
            }
            case 240: {
                this.regB |= 0x40;
                break;
            }
            case 241: {
                this.regC |= 0x40;
                break;
            }
            case 242: {
                this.regD |= 0x40;
                break;
            }
            case 243: {
                this.regE |= 0x40;
                break;
            }
            case 244: {
                this.regH |= 0x40;
                break;
            }
            case 245: {
                this.regL |= 0x40;
                break;
            }
            case 246: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) | 0x40;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 247: {
                this.regA |= 0x40;
                break;
            }
            case 248: {
                this.regB |= 0x80;
                break;
            }
            case 249: {
                this.regC |= 0x80;
                break;
            }
            case 250: {
                this.regD |= 0x80;
                break;
            }
            case 251: {
                this.regE |= 0x80;
                break;
            }
            case 252: {
                this.regH |= 0x80;
                break;
            }
            case 253: {
                this.regL |= 0x80;
                break;
            }
            case 254: {
                int work16 = this.getRegHL();
                int work8 = this.MemIoImpl.peek8(work16) | 0x80;
                this.MemIoImpl.contendedStates(work16, 1);
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 255: {
                this.regA |= 0x80;
                break;
            }
        }
    }

    private int decodeDDFD(int regIXY) {
        ++this.regR;
        this.opCode = this.MemIoImpl.fetchOpcode(this.regPC);
        this.regPC = this.regPC + 1 & 0xFFFF;
        switch (this.opCode) {
            case 9: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                regIXY = this.add16(regIXY, this.getRegBC());
                break;
            }
            case 25: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                regIXY = this.add16(regIXY, this.getRegDE());
                break;
            }
            case 33: {
                regIXY = this.MemIoImpl.peek16(this.regPC);
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 34: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.MemIoImpl.poke16(this.memptr, regIXY);
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 35: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                regIXY = regIXY + 1 & 0xFFFF;
                break;
            }
            case 36: {
                regIXY = this.inc8(regIXY >>> 8) << 8 | regIXY & 0xFF;
                break;
            }
            case 37: {
                regIXY = this.dec8(regIXY >>> 8) << 8 | regIXY & 0xFF;
                break;
            }
            case 38: {
                regIXY = this.MemIoImpl.peek8(this.regPC) << 8 | regIXY & 0xFF;
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 41: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                regIXY = this.add16(regIXY, regIXY);
                break;
            }
            case 42: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                regIXY = this.MemIoImpl.peek16(this.memptr);
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 43: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                regIXY = regIXY - 1 & 0xFFFF;
                break;
            }
            case 44: {
                regIXY = regIXY & 0xFF00 | this.inc8(regIXY & 0xFF);
                break;
            }
            case 45: {
                regIXY = regIXY & 0xFF00 | this.dec8(regIXY & 0xFF);
                break;
            }
            case 46: {
                regIXY = regIXY & 0xFF00 | this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 52: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                int work8 = this.MemIoImpl.peek8(this.memptr);
                this.MemIoImpl.contendedStates(this.memptr, 1);
                this.MemIoImpl.poke8(this.memptr, this.inc8(work8));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 53: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                int work8 = this.MemIoImpl.peek8(this.memptr);
                this.MemIoImpl.contendedStates(this.memptr, 1);
                this.MemIoImpl.poke8(this.memptr, this.dec8(work8));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 54: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.regPC = this.regPC + 1 & 0xFFFF;
                int work8 = this.MemIoImpl.peek8(this.regPC);
                this.MemIoImpl.contendedStates(this.regPC, 2);
                this.regPC = this.regPC + 1 & 0xFFFF;
                this.MemIoImpl.poke8(this.memptr, work8);
                break;
            }
            case 57: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                regIXY = this.add16(regIXY, this.regSP);
                break;
            }
            case 68: {
                this.regB = regIXY >>> 8;
                break;
            }
            case 69: {
                this.regB = regIXY & 0xFF;
                break;
            }
            case 70: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.regB = this.MemIoImpl.peek8(this.memptr);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 76: {
                this.regC = regIXY >>> 8;
                break;
            }
            case 77: {
                this.regC = regIXY & 0xFF;
                break;
            }
            case 78: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.regC = this.MemIoImpl.peek8(this.memptr);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 84: {
                this.regD = regIXY >>> 8;
                break;
            }
            case 85: {
                this.regD = regIXY & 0xFF;
                break;
            }
            case 86: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.regD = this.MemIoImpl.peek8(this.memptr);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 92: {
                this.regE = regIXY >>> 8;
                break;
            }
            case 93: {
                this.regE = regIXY & 0xFF;
                break;
            }
            case 94: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.regE = this.MemIoImpl.peek8(this.memptr);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 96: {
                regIXY = regIXY & 0xFF | this.regB << 8;
                break;
            }
            case 97: {
                regIXY = regIXY & 0xFF | this.regC << 8;
                break;
            }
            case 98: {
                regIXY = regIXY & 0xFF | this.regD << 8;
                break;
            }
            case 99: {
                regIXY = regIXY & 0xFF | this.regE << 8;
                break;
            }
            case 100: {
                break;
            }
            case 101: {
                regIXY = regIXY & 0xFF | (regIXY & 0xFF) << 8;
                break;
            }
            case 102: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.regH = this.MemIoImpl.peek8(this.memptr);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 103: {
                regIXY = regIXY & 0xFF | this.regA << 8;
                break;
            }
            case 104: {
                regIXY = regIXY & 0xFF00 | this.regB;
                break;
            }
            case 105: {
                regIXY = regIXY & 0xFF00 | this.regC;
                break;
            }
            case 106: {
                regIXY = regIXY & 0xFF00 | this.regD;
                break;
            }
            case 107: {
                regIXY = regIXY & 0xFF00 | this.regE;
                break;
            }
            case 108: {
                regIXY = regIXY & 0xFF00 | regIXY >>> 8;
                break;
            }
            case 109: {
                break;
            }
            case 110: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.regL = this.MemIoImpl.peek8(this.memptr);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 111: {
                regIXY = regIXY & 0xFF00 | this.regA;
                break;
            }
            case 112: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.MemIoImpl.poke8(this.memptr, this.regB);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 113: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.MemIoImpl.poke8(this.memptr, this.regC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 114: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.MemIoImpl.poke8(this.memptr, this.regD);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 115: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.MemIoImpl.poke8(this.memptr, this.regE);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 116: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.MemIoImpl.poke8(this.memptr, this.regH);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 117: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.MemIoImpl.poke8(this.memptr, this.regL);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 119: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.MemIoImpl.poke8(this.memptr, this.regA);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 124: {
                this.regA = regIXY >>> 8;
                break;
            }
            case 125: {
                this.regA = regIXY & 0xFF;
                break;
            }
            case 126: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.regA = this.MemIoImpl.peek8(this.memptr);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 132: {
                this.add(regIXY >>> 8);
                break;
            }
            case 133: {
                this.add(regIXY & 0xFF);
                break;
            }
            case 134: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.add(this.MemIoImpl.peek8(this.memptr));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 140: {
                this.adc(regIXY >>> 8);
                break;
            }
            case 141: {
                this.adc(regIXY & 0xFF);
                break;
            }
            case 142: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.adc(this.MemIoImpl.peek8(this.memptr));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 148: {
                this.sub(regIXY >>> 8);
                break;
            }
            case 149: {
                this.sub(regIXY & 0xFF);
                break;
            }
            case 150: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.sub(this.MemIoImpl.peek8(this.memptr));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 156: {
                this.sbc(regIXY >>> 8);
                break;
            }
            case 157: {
                this.sbc(regIXY & 0xFF);
                break;
            }
            case 158: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.sbc(this.MemIoImpl.peek8(this.memptr));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 164: {
                this.and(regIXY >>> 8);
                break;
            }
            case 165: {
                this.and(regIXY & 0xFF);
                break;
            }
            case 166: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.and(this.MemIoImpl.peek8(this.memptr));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 172: {
                this.xor(regIXY >>> 8);
                break;
            }
            case 173: {
                this.xor(regIXY & 0xFF);
                break;
            }
            case 174: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.xor(this.MemIoImpl.peek8(this.memptr));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 180: {
                this.or(regIXY >>> 8);
                break;
            }
            case 181: {
                this.or(regIXY & 0xFF);
                break;
            }
            case 182: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.or(this.MemIoImpl.peek8(this.memptr));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 188: {
                this.cp(regIXY >>> 8);
                break;
            }
            case 189: {
                this.cp(regIXY & 0xFF);
                break;
            }
            case 190: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.MemIoImpl.contendedStates(this.regPC, 5);
                this.cp(this.MemIoImpl.peek8(this.memptr));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 203: {
                this.memptr = regIXY + (byte)this.MemIoImpl.peek8(this.regPC) & 0xFFFF;
                this.regPC = this.regPC + 1 & 0xFFFF;
                this.opCode = this.MemIoImpl.peek8(this.regPC);
                this.MemIoImpl.contendedStates(this.regPC, 2);
                this.regPC = this.regPC + 1 & 0xFFFF;
                if (this.opCode < 128) {
                    this.decodeDDFDCBto7F(this.opCode, this.memptr);
                    break;
                }
                this.decodeDDFDCBtoFF(this.opCode, this.memptr);
                break;
            }
            case 225: {
                regIXY = this.pop();
                break;
            }
            case 227: {
                int work16 = regIXY;
                regIXY = this.MemIoImpl.peek16(this.regSP);
                this.MemIoImpl.contendedStates(this.regSP + 1 & 0xFFFF, 1);
                this.MemIoImpl.poke8(this.regSP + 1 & 0xFFFF, work16 >>> 8);
                this.MemIoImpl.poke8(this.regSP, work16);
                this.MemIoImpl.contendedStates(this.regSP, 2);
                this.memptr = regIXY;
                break;
            }
            case 229: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.push(regIXY);
                break;
            }
            case 233: {
                this.regPC = regIXY;
                break;
            }
            case 249: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 2);
                this.regSP = regIXY;
                break;
            }
            default: {
                if (this.breakpointAt[this.regPC]) {
                    this.opCode = this.NotifyImpl.atAddress(this.regPC, this.opCode);
                }
                this.decodeOpcode(this.opCode);
            }
        }
        return regIXY;
    }

    private void decodeDDFDCBto7F(int opCode, int address) {
        switch (opCode) {
            case 0: {
                this.regB = this.rlc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 1: {
                this.regC = this.rlc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 2: {
                this.regD = this.rlc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 3: {
                this.regE = this.rlc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 4: {
                this.regH = this.rlc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 5: {
                this.regL = this.rlc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 6: {
                int work8 = this.rlc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 7: {
                this.regA = this.rlc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 8: {
                this.regB = this.rrc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 9: {
                this.regC = this.rrc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 10: {
                this.regD = this.rrc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 11: {
                this.regE = this.rrc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 12: {
                this.regH = this.rrc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 13: {
                this.regL = this.rrc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 14: {
                int work8 = this.rrc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 15: {
                this.regA = this.rrc(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 16: {
                this.regB = this.rl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 17: {
                this.regC = this.rl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 18: {
                this.regD = this.rl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 19: {
                this.regE = this.rl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 20: {
                this.regH = this.rl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 21: {
                this.regL = this.rl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 22: {
                int work8 = this.rl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 23: {
                this.regA = this.rl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 24: {
                this.regB = this.rr(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 25: {
                this.regC = this.rr(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 26: {
                this.regD = this.rr(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 27: {
                this.regE = this.rr(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 28: {
                this.regH = this.rr(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 29: {
                this.regL = this.rr(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 30: {
                int work8 = this.rr(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 31: {
                this.regA = this.rr(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 32: {
                this.regB = this.sla(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 33: {
                this.regC = this.sla(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 34: {
                this.regD = this.sla(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 35: {
                this.regE = this.sla(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 36: {
                this.regH = this.sla(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 37: {
                this.regL = this.sla(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 38: {
                int work8 = this.sla(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 39: {
                this.regA = this.sla(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 40: {
                this.regB = this.sra(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 41: {
                this.regC = this.sra(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 42: {
                this.regD = this.sra(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 43: {
                this.regE = this.sra(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 44: {
                this.regH = this.sra(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 45: {
                this.regL = this.sra(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 46: {
                int work8 = this.sra(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 47: {
                this.regA = this.sra(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 48: {
                this.regB = this.sll(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 49: {
                this.regC = this.sll(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 50: {
                this.regD = this.sll(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 51: {
                this.regE = this.sll(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 52: {
                this.regH = this.sll(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 53: {
                this.regL = this.sll(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 54: {
                int work8 = this.sll(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 55: {
                this.regA = this.sll(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 56: {
                this.regB = this.srl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 57: {
                this.regC = this.srl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 58: {
                this.regD = this.srl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 59: {
                this.regE = this.srl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 60: {
                this.regH = this.srl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 61: {
                this.regL = this.srl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 62: {
                int work8 = this.srl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 63: {
                this.regA = this.srl(this.MemIoImpl.peek8(address));
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                this.bit(1, this.MemIoImpl.peek8(address));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | address >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(address, 1);
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                this.bit(2, this.MemIoImpl.peek8(address));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | address >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(address, 1);
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                this.bit(4, this.MemIoImpl.peek8(address));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | address >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(address, 1);
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.bit(8, this.MemIoImpl.peek8(address));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | address >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(address, 1);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                this.bit(16, this.MemIoImpl.peek8(address));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | address >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(address, 1);
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                this.bit(32, this.MemIoImpl.peek8(address));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | address >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(address, 1);
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.bit(64, this.MemIoImpl.peek8(address));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | address >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(address, 1);
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.bit(128, this.MemIoImpl.peek8(address));
                this.sz5h3pnFlags = this.sz5h3pnFlags & 0xD4 | address >>> 8 & 0x28;
                this.MemIoImpl.contendedStates(address, 1);
            }
        }
    }

    private void decodeDDFDCBtoFF(int opCode, int address) {
        switch (opCode) {
            case 128: {
                this.regB = this.MemIoImpl.peek8(address) & 0xFE;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 129: {
                this.regC = this.MemIoImpl.peek8(address) & 0xFE;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 130: {
                this.regD = this.MemIoImpl.peek8(address) & 0xFE;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 131: {
                this.regE = this.MemIoImpl.peek8(address) & 0xFE;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 132: {
                this.regH = this.MemIoImpl.peek8(address) & 0xFE;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 133: {
                this.regL = this.MemIoImpl.peek8(address) & 0xFE;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 134: {
                int work8 = this.MemIoImpl.peek8(address) & 0xFE;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 135: {
                this.regA = this.MemIoImpl.peek8(address) & 0xFE;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 136: {
                this.regB = this.MemIoImpl.peek8(address) & 0xFD;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 137: {
                this.regC = this.MemIoImpl.peek8(address) & 0xFD;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 138: {
                this.regD = this.MemIoImpl.peek8(address) & 0xFD;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 139: {
                this.regE = this.MemIoImpl.peek8(address) & 0xFD;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 140: {
                this.regH = this.MemIoImpl.peek8(address) & 0xFD;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 141: {
                this.regL = this.MemIoImpl.peek8(address) & 0xFD;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 142: {
                int work8 = this.MemIoImpl.peek8(address) & 0xFD;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 143: {
                this.regA = this.MemIoImpl.peek8(address) & 0xFD;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 144: {
                this.regB = this.MemIoImpl.peek8(address) & 0xFB;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 145: {
                this.regC = this.MemIoImpl.peek8(address) & 0xFB;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 146: {
                this.regD = this.MemIoImpl.peek8(address) & 0xFB;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 147: {
                this.regE = this.MemIoImpl.peek8(address) & 0xFB;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 148: {
                this.regH = this.MemIoImpl.peek8(address) & 0xFB;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 149: {
                this.regL = this.MemIoImpl.peek8(address) & 0xFB;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 150: {
                int work8 = this.MemIoImpl.peek8(address) & 0xFB;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 151: {
                this.regA = this.MemIoImpl.peek8(address) & 0xFB;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 152: {
                this.regB = this.MemIoImpl.peek8(address) & 0xF7;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 153: {
                this.regC = this.MemIoImpl.peek8(address) & 0xF7;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 154: {
                this.regD = this.MemIoImpl.peek8(address) & 0xF7;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 155: {
                this.regE = this.MemIoImpl.peek8(address) & 0xF7;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 156: {
                this.regH = this.MemIoImpl.peek8(address) & 0xF7;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 157: {
                this.regL = this.MemIoImpl.peek8(address) & 0xF7;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 158: {
                int work8 = this.MemIoImpl.peek8(address) & 0xF7;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 159: {
                this.regA = this.MemIoImpl.peek8(address) & 0xF7;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 160: {
                this.regB = this.MemIoImpl.peek8(address) & 0xEF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 161: {
                this.regC = this.MemIoImpl.peek8(address) & 0xEF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 162: {
                this.regD = this.MemIoImpl.peek8(address) & 0xEF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 163: {
                this.regE = this.MemIoImpl.peek8(address) & 0xEF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 164: {
                this.regH = this.MemIoImpl.peek8(address) & 0xEF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 165: {
                this.regL = this.MemIoImpl.peek8(address) & 0xEF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 166: {
                int work8 = this.MemIoImpl.peek8(address) & 0xEF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 167: {
                this.regA = this.MemIoImpl.peek8(address) & 0xEF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 168: {
                this.regB = this.MemIoImpl.peek8(address) & 0xDF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 169: {
                this.regC = this.MemIoImpl.peek8(address) & 0xDF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 170: {
                this.regD = this.MemIoImpl.peek8(address) & 0xDF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 171: {
                this.regE = this.MemIoImpl.peek8(address) & 0xDF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 172: {
                this.regH = this.MemIoImpl.peek8(address) & 0xDF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 173: {
                this.regL = this.MemIoImpl.peek8(address) & 0xDF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 174: {
                int work8 = this.MemIoImpl.peek8(address) & 0xDF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 175: {
                this.regA = this.MemIoImpl.peek8(address) & 0xDF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 176: {
                this.regB = this.MemIoImpl.peek8(address) & 0xBF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 177: {
                this.regC = this.MemIoImpl.peek8(address) & 0xBF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 178: {
                this.regD = this.MemIoImpl.peek8(address) & 0xBF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 179: {
                this.regE = this.MemIoImpl.peek8(address) & 0xBF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 180: {
                this.regH = this.MemIoImpl.peek8(address) & 0xBF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 181: {
                this.regL = this.MemIoImpl.peek8(address) & 0xBF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 182: {
                int work8 = this.MemIoImpl.peek8(address) & 0xBF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 183: {
                this.regA = this.MemIoImpl.peek8(address) & 0xBF;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 184: {
                this.regB = this.MemIoImpl.peek8(address) & 0x7F;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 185: {
                this.regC = this.MemIoImpl.peek8(address) & 0x7F;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 186: {
                this.regD = this.MemIoImpl.peek8(address) & 0x7F;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 187: {
                this.regE = this.MemIoImpl.peek8(address) & 0x7F;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 188: {
                this.regH = this.MemIoImpl.peek8(address) & 0x7F;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 189: {
                this.regL = this.MemIoImpl.peek8(address) & 0x7F;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 190: {
                int work8 = this.MemIoImpl.peek8(address) & 0x7F;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 191: {
                this.regA = this.MemIoImpl.peek8(address) & 0x7F;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 192: {
                this.regB = this.MemIoImpl.peek8(address) | 1;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 193: {
                this.regC = this.MemIoImpl.peek8(address) | 1;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 194: {
                this.regD = this.MemIoImpl.peek8(address) | 1;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 195: {
                this.regE = this.MemIoImpl.peek8(address) | 1;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 196: {
                this.regH = this.MemIoImpl.peek8(address) | 1;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 197: {
                this.regL = this.MemIoImpl.peek8(address) | 1;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 198: {
                int work8 = this.MemIoImpl.peek8(address) | 1;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 199: {
                this.regA = this.MemIoImpl.peek8(address) | 1;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 200: {
                this.regB = this.MemIoImpl.peek8(address) | 2;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 201: {
                this.regC = this.MemIoImpl.peek8(address) | 2;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 202: {
                this.regD = this.MemIoImpl.peek8(address) | 2;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 203: {
                this.regE = this.MemIoImpl.peek8(address) | 2;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 204: {
                this.regH = this.MemIoImpl.peek8(address) | 2;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 205: {
                this.regL = this.MemIoImpl.peek8(address) | 2;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 206: {
                int work8 = this.MemIoImpl.peek8(address) | 2;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 207: {
                this.regA = this.MemIoImpl.peek8(address) | 2;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 208: {
                this.regB = this.MemIoImpl.peek8(address) | 4;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 209: {
                this.regC = this.MemIoImpl.peek8(address) | 4;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 210: {
                this.regD = this.MemIoImpl.peek8(address) | 4;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 211: {
                this.regE = this.MemIoImpl.peek8(address) | 4;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 212: {
                this.regH = this.MemIoImpl.peek8(address) | 4;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 213: {
                this.regL = this.MemIoImpl.peek8(address) | 4;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 214: {
                int work8 = this.MemIoImpl.peek8(address) | 4;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 215: {
                this.regA = this.MemIoImpl.peek8(address) | 4;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 216: {
                this.regB = this.MemIoImpl.peek8(address) | 8;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 217: {
                this.regC = this.MemIoImpl.peek8(address) | 8;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 218: {
                this.regD = this.MemIoImpl.peek8(address) | 8;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 219: {
                this.regE = this.MemIoImpl.peek8(address) | 8;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 220: {
                this.regH = this.MemIoImpl.peek8(address) | 8;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 221: {
                this.regL = this.MemIoImpl.peek8(address) | 8;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 222: {
                int work8 = this.MemIoImpl.peek8(address) | 8;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 223: {
                this.regA = this.MemIoImpl.peek8(address) | 8;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 224: {
                this.regB = this.MemIoImpl.peek8(address) | 0x10;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 225: {
                this.regC = this.MemIoImpl.peek8(address) | 0x10;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 226: {
                this.regD = this.MemIoImpl.peek8(address) | 0x10;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 227: {
                this.regE = this.MemIoImpl.peek8(address) | 0x10;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 228: {
                this.regH = this.MemIoImpl.peek8(address) | 0x10;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 229: {
                this.regL = this.MemIoImpl.peek8(address) | 0x10;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 230: {
                int work8 = this.MemIoImpl.peek8(address) | 0x10;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 231: {
                this.regA = this.MemIoImpl.peek8(address) | 0x10;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 232: {
                this.regB = this.MemIoImpl.peek8(address) | 0x20;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 233: {
                this.regC = this.MemIoImpl.peek8(address) | 0x20;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 234: {
                this.regD = this.MemIoImpl.peek8(address) | 0x20;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 235: {
                this.regE = this.MemIoImpl.peek8(address) | 0x20;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 236: {
                this.regH = this.MemIoImpl.peek8(address) | 0x20;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 237: {
                this.regL = this.MemIoImpl.peek8(address) | 0x20;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 238: {
                int work8 = this.MemIoImpl.peek8(address) | 0x20;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 239: {
                this.regA = this.MemIoImpl.peek8(address) | 0x20;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 240: {
                this.regB = this.MemIoImpl.peek8(address) | 0x40;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 241: {
                this.regC = this.MemIoImpl.peek8(address) | 0x40;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 242: {
                this.regD = this.MemIoImpl.peek8(address) | 0x40;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 243: {
                this.regE = this.MemIoImpl.peek8(address) | 0x40;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 244: {
                this.regH = this.MemIoImpl.peek8(address) | 0x40;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 245: {
                this.regL = this.MemIoImpl.peek8(address) | 0x40;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 246: {
                int work8 = this.MemIoImpl.peek8(address) | 0x40;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 247: {
                this.regA = this.MemIoImpl.peek8(address) | 0x40;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
                break;
            }
            case 248: {
                this.regB = this.MemIoImpl.peek8(address) | 0x80;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regB);
                break;
            }
            case 249: {
                this.regC = this.MemIoImpl.peek8(address) | 0x80;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regC);
                break;
            }
            case 250: {
                this.regD = this.MemIoImpl.peek8(address) | 0x80;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regD);
                break;
            }
            case 251: {
                this.regE = this.MemIoImpl.peek8(address) | 0x80;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regE);
                break;
            }
            case 252: {
                this.regH = this.MemIoImpl.peek8(address) | 0x80;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regH);
                break;
            }
            case 253: {
                this.regL = this.MemIoImpl.peek8(address) | 0x80;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regL);
                break;
            }
            case 254: {
                int work8 = this.MemIoImpl.peek8(address) | 0x80;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, work8);
                break;
            }
            case 255: {
                this.regA = this.MemIoImpl.peek8(address) | 0x80;
                this.MemIoImpl.contendedStates(address, 1);
                this.MemIoImpl.poke8(address, this.regA);
            }
        }
    }

    private void decodeED() {
        ++this.regR;
        this.opCode = this.MemIoImpl.fetchOpcode(this.regPC);
        this.regPC = this.regPC + 1 & 0xFFFF;
        switch (this.opCode) {
            case 64: {
                this.regB = this.MemIoImpl.inPort(this.getRegBC());
                this.sz5h3pnFlags = sz53pn_addTable[this.regB];
                break;
            }
            case 65: {
                this.MemIoImpl.outPort(this.getRegBC(), this.regB);
                break;
            }
            case 66: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.sbc16(this.getRegBC());
                break;
            }
            case 67: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.MemIoImpl.poke16(this.memptr, this.getRegBC());
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 68: 
            case 76: 
            case 84: 
            case 92: 
            case 100: 
            case 108: 
            case 116: 
            case 124: {
                int aux = this.regA;
                this.regA = 0;
                this.sub(aux);
                break;
            }
            case 69: 
            case 77: 
            case 85: 
            case 93: 
            case 101: 
            case 109: 
            case 117: 
            case 125: {
                this.ffIFF1 = this.ffIFF2;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 70: 
            case 78: 
            case 102: 
            case 110: {
                this.setIM(IntMode.IM0);
                break;
            }
            case 71: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.regI = this.regA;
                break;
            }
            case 72: {
                this.regC = this.MemIoImpl.inPort(this.getRegBC());
                this.sz5h3pnFlags = sz53pn_addTable[this.regC];
                break;
            }
            case 73: {
                this.MemIoImpl.outPort(this.getRegBC(), this.regC);
                break;
            }
            case 74: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.adc16(this.getRegBC());
                break;
            }
            case 75: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.setRegBC(this.MemIoImpl.peek16(this.memptr));
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 79: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.setRegR(this.regA);
                break;
            }
            case 80: {
                this.regD = this.MemIoImpl.inPort(this.getRegBC());
                this.sz5h3pnFlags = sz53pn_addTable[this.regD];
                break;
            }
            case 81: {
                this.MemIoImpl.outPort(this.getRegBC(), this.regD);
                break;
            }
            case 82: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.sbc16(this.getRegDE());
                break;
            }
            case 83: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.MemIoImpl.poke16(this.memptr, this.getRegDE());
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 86: 
            case 118: {
                this.setIM(IntMode.IM1);
                break;
            }
            case 87: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.regA = this.regI;
                this.sz5h3pnFlags = sz53n_addTable[this.regA];
                if (!this.ffIFF2) break;
                this.sz5h3pnFlags |= 4;
                break;
            }
            case 88: {
                this.regE = this.MemIoImpl.inPort(this.getRegBC());
                this.sz5h3pnFlags = sz53pn_addTable[this.regE];
                break;
            }
            case 89: {
                this.MemIoImpl.outPort(this.getRegBC(), this.regE);
                break;
            }
            case 90: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.adc16(this.getRegDE());
                break;
            }
            case 91: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.setRegDE(this.MemIoImpl.peek16(this.memptr));
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 94: 
            case 126: {
                this.setIM(IntMode.IM2);
                break;
            }
            case 95: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 1);
                this.regA = this.getRegR();
                this.sz5h3pnFlags = sz53n_addTable[this.regA];
                if (!this.ffIFF2) break;
                this.sz5h3pnFlags |= 4;
                break;
            }
            case 96: {
                this.regH = this.MemIoImpl.inPort(this.getRegBC());
                this.sz5h3pnFlags = sz53pn_addTable[this.regH];
                break;
            }
            case 97: {
                this.MemIoImpl.outPort(this.getRegBC(), this.regH);
                break;
            }
            case 98: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.sbc16(this.getRegHL());
                break;
            }
            case 99: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.MemIoImpl.poke16(this.memptr, this.getRegHL());
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 103: {
                this.rrd();
                break;
            }
            case 104: {
                this.regL = this.MemIoImpl.inPort(this.getRegBC());
                this.sz5h3pnFlags = sz53pn_addTable[this.regL];
                break;
            }
            case 105: {
                this.MemIoImpl.outPort(this.getRegBC(), this.regL);
                break;
            }
            case 106: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.adc16(this.getRegHL());
                break;
            }
            case 107: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.setRegHL(this.MemIoImpl.peek16(this.memptr));
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 111: {
                this.rld();
                break;
            }
            case 112: {
                int inPort = this.MemIoImpl.inPort(this.getRegBC());
                this.sz5h3pnFlags = sz53pn_addTable[inPort];
                break;
            }
            case 113: {
                this.MemIoImpl.outPort(this.getRegBC(), 0);
                break;
            }
            case 114: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.sbc16(this.regSP);
                break;
            }
            case 115: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.MemIoImpl.poke16(this.memptr, this.regSP);
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 120: {
                this.memptr = this.getRegBC();
                this.regA = this.MemIoImpl.inPort(this.memptr);
                ++this.memptr;
                this.sz5h3pnFlags = sz53pn_addTable[this.regA];
                break;
            }
            case 121: {
                this.memptr = this.getRegBC();
                this.MemIoImpl.outPort(this.memptr, this.regA);
                ++this.memptr;
                break;
            }
            case 122: {
                this.MemIoImpl.contendedStates(this.getPairIR(), 7);
                this.adc16(this.regSP);
                break;
            }
            case 123: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.regSP = this.MemIoImpl.peek16(this.memptr);
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 160: {
                this.ldi();
                break;
            }
            case 161: {
                this.cpi();
                break;
            }
            case 162: {
                this.ini();
                break;
            }
            case 163: {
                this.outi();
                break;
            }
            case 168: {
                this.ldd();
                break;
            }
            case 169: {
                this.cpd();
                break;
            }
            case 170: {
                this.ind();
                break;
            }
            case 171: {
                this.outd();
                break;
            }
            case 176: {
                this.ldi();
                if ((this.sz5h3pnFlags & 4) != 4) break;
                this.regPC = this.regPC - 2 & 0xFFFF;
                this.memptr = this.regPC + 1;
                this.MemIoImpl.contendedStates(this.getRegDE() - 1 & 0xFFFF, 5);
                break;
            }
            case 177: {
                this.cpi();
                if ((this.sz5h3pnFlags & 4) != 4 || (this.sz5h3pnFlags & 0x40) != 0) break;
                this.regPC = this.regPC - 2 & 0xFFFF;
                this.memptr = this.regPC + 1;
                this.MemIoImpl.contendedStates(this.getRegHL() - 1 & 0xFFFF, 5);
                break;
            }
            case 178: {
                this.ini();
                if (this.regB == 0) break;
                this.regPC = this.regPC - 2 & 0xFFFF;
                this.MemIoImpl.contendedStates(this.getRegHL() - 1 & 0xFFFF, 5);
                break;
            }
            case 179: {
                this.outi();
                if (this.regB == 0) break;
                this.regPC = this.regPC - 2 & 0xFFFF;
                this.MemIoImpl.contendedStates(this.getRegBC(), 5);
                break;
            }
            case 184: {
                this.ldd();
                if ((this.sz5h3pnFlags & 4) != 4) break;
                this.regPC = this.regPC - 2 & 0xFFFF;
                this.memptr = this.regPC + 1;
                this.MemIoImpl.contendedStates(this.getRegDE() + 1 & 0xFFFF, 5);
                break;
            }
            case 185: {
                this.cpd();
                if ((this.sz5h3pnFlags & 4) != 4 || (this.sz5h3pnFlags & 0x40) != 0) break;
                this.regPC = this.regPC - 2 & 0xFFFF;
                this.memptr = this.regPC + 1;
                this.MemIoImpl.contendedStates(this.getRegHL() + 1 & 0xFFFF, 5);
                break;
            }
            case 186: {
                this.ind();
                if (this.regB == 0) break;
                this.regPC = this.regPC - 2 & 0xFFFF;
                this.MemIoImpl.contendedStates(this.getRegHL() + 1 & 0xFFFF, 5);
                break;
            }
            case 187: {
                this.outd();
                if (this.regB == 0) break;
                this.regPC = this.regPC - 2 & 0xFFFF;
                this.MemIoImpl.contendedStates(this.getRegBC(), 5);
                break;
            }
        }
    }

    static {
        for (int idx = 0; idx < 256; ++idx) {
            if (idx > 127) {
                int n = idx;
                sz53n_addTable[n] = sz53n_addTable[n] | 0x80;
            }
            boolean evenBits = true;
            for (int mask = 1; mask < 256; mask <<= 1) {
                if ((idx & mask) == 0) continue;
                evenBits = !evenBits;
            }
            int n = idx;
            sz53n_addTable[n] = sz53n_addTable[n] | idx & 0x28;
            Z80.sz53n_subTable[idx] = sz53n_addTable[idx] | 2;
            if (evenBits) {
                Z80.sz53pn_addTable[idx] = sz53n_addTable[idx] | 4;
                Z80.sz53pn_subTable[idx] = sz53n_subTable[idx] | 4;
                continue;
            }
            Z80.sz53pn_addTable[idx] = sz53n_addTable[idx];
            Z80.sz53pn_subTable[idx] = sz53n_subTable[idx];
        }
        sz53n_addTable[0] = sz53n_addTable[0] | 0x40;
        sz53pn_addTable[0] = sz53pn_addTable[0] | 0x40;
        sz53n_subTable[0] = sz53n_subTable[0] | 0x40;
        sz53pn_subTable[0] = sz53pn_subTable[0] | 0x40;
    }

    public static enum IntMode {
        IM0,
        IM1,
        IM2;

    }
}

