/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.List;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.model.entity.GenerationAwareConfigurable;
import org.dbgl.model.entity.ITitledEntity;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public final class Combo_ {
    public static final String DYN_OPT_SECTION = "dynOptSection";
    public static final String DYN_OPT_ITEM = "dynOptItem";
    public static final String DYN_SECTION_ITEM_GETTER = "dynSectionItemGetter";
    public static final String DYN_ITEMS_GETTER = "dynItemsGetter";

    private Combo_() {
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static final class Builder
    extends ControlBuilder<Builder> {
        int visibleItemCount_ = 10;
        String tooltip_;
        String[] items_;
        int select_ = -1;
        boolean autoSelect_ = false;
        String dynOptSection_;
        String dynOptItem_;
        Function<GenerationAwareConfigurable, String> dynSectionItemGetter_;
        Function<GenerationAwareConfigurable, String[]> dynItemsGetter_;

        Builder(Composite composite) {
            super(composite, 8, 1, 0x1000000, false, false);
        }

        public Builder tooltip(String key) {
            this.tooltip_ = TextService.getInstance().get(key);
            return this;
        }

        public Builder editable() {
            return (Builder)this.style(0);
        }

        public Builder wide() {
            this.horizontalAlignment_ = 4;
            this.grabExcessHorizontalSpace_ = true;
            return this;
        }

        public Builder autoSelect(String[] values) {
            this.autoSelect_ = true;
            this.items_ = values;
            this.wide();
            this.editable();
            this.visibleItemCount(15);
            return this;
        }

        public Builder autoSelect(List<ITitledEntity> values) {
            return this.autoSelect((String[])values.stream().map(ITitledEntity::getTitle).toArray(String[]::new));
        }

        public Builder visibleItemCount(int count) {
            this.visibleItemCount_ = count;
            return this;
        }

        public Builder items(String[] items) {
            this.items_ = items;
            return this;
        }

        public Builder items(List<String> items) {
            this.items_ = items.toArray(new String[items.size()]);
            return this;
        }

        public Builder dynItem(Function<GenerationAwareConfigurable, String> getMethod) {
            this.dynSectionItemGetter_ = getMethod;
            return this;
        }

        public Builder dynItems(Function<GenerationAwareConfigurable, String[]> getMethod) {
            this.dynItemsGetter_ = getMethod;
            return this;
        }

        public Builder items(String section, String item) {
            this.items_ = SettingsService.getInstance().getValues(section, item);
            this.dynOptSection_ = section;
            this.dynOptItem_ = item;
            return this;
        }

        public Builder select(int select) {
            this.select_ = select;
            return this;
        }

        public Combo build() {
            Combo combo = new Combo(this.composite_, this.style_);
            if (DarkTheme.forced()) {
                combo.setBackground(DarkTheme.inputBackground);
                combo.setForeground(DarkTheme.defaultForeground);
            }
            combo.setLayoutData(this.layoutData());
            combo.setVisibleItemCount(this.visibleItemCount_);
            if (this.tooltip_ != null) {
                combo.setToolTipText(this.tooltip_);
            }
            if (this.items_ != null) {
                combo.setItems(this.items_);
            }
            if (this.select_ >= 0) {
                combo.select(this.select_);
            }
            if (StringUtils.isNotBlank(this.dynOptSection_)) {
                combo.setData(Combo_.DYN_OPT_SECTION, this.dynOptSection_);
                combo.setData(Combo_.DYN_OPT_ITEM, this.dynOptItem_);
            }
            if (this.dynSectionItemGetter_ != null) {
                combo.setData(Combo_.DYN_SECTION_ITEM_GETTER, this.dynSectionItemGetter_);
            }
            if (this.dynItemsGetter_ != null) {
                combo.setData(Combo_.DYN_ITEMS_GETTER, this.dynItemsGetter_);
            }
            if (this.autoSelect_) {
                combo.setData("currentLength", 0);
                combo.setData("mutex", false);
                combo.addModifyListener(event -> {
                    if (!((Boolean)combo.getData("mutex")).booleanValue()) {
                        OptionalInt opt;
                        String text = combo.getText();
                        int newLength = text.length();
                        if (newLength > (Integer)combo.getData("currentLength") && (opt = IntStream.range(0, combo.getItemCount()).filter(i -> combo.getItem(i).toLowerCase().startsWith(text.toLowerCase())).findFirst()).isPresent()) {
                            combo.setData("mutex", true);
                            combo.setText(text + combo.getItem(opt.getAsInt()).substring(newLength));
                            combo.setSelection(new Point(newLength, combo.getText().length()));
                            combo.setData("mutex", false);
                        }
                        combo.setData("currentLength", newLength);
                    }
                });
            }
            return combo;
        }
    }
}

