/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.entity.Filter;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.model.repository.FilterRepository;
import org.dbgl.model.repository.ProfileRepository;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EditFilterDialog
extends SizeControlledTabbedDialog<Filter> {
    private static String EMPTY_FIELD = "[ ]";
    private final Filter filter_;
    private final Set<Integer> selectedProfileIds_;
    private final String[] columnNames_;
    private List<DosboxVersion> dbversionsList_;
    private List<Profile> profilesList_;

    public EditFilterDialog(Shell parent, Filter filter, Set<Integer> selectedProfileIds, String[] columnNames) {
        super(parent, "filterdialog");
        this.filter_ = filter;
        this.selectedProfileIds_ = selectedProfileIds;
        this.columnNames_ = columnNames;
    }

    @Override
    protected String getDialogTitle() {
        return this.filter_ == null ? this.text_.get("dialog.filter.title.add") : this.text_.get("dialog.filter.title.edit", new Object[]{this.filter_.getTitle(), this.filter_.getId()});
    }

    @Override
    protected boolean prepare() {
        try {
            this.dbversionsList_ = new DosboxVersionRepository().listAll();
            this.profilesList_ = new ProfileRepository().list("", "", this.dbversionsList_);
        }
        catch (SQLException e) {
            Mess_.on(this.shell_).exception(e).warning();
        }
        return true;
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite("dialog.filter.tab.info", 2);
        SashForm sashForm = EditFilterDialog.createSashForm(composite, 2);
        Composite leftComposite = Composite_.on(sashForm).innerLayout(2).build();
        final Text filterTitle = Chain.on(leftComposite).lbl(l -> l.key("dialog.filter.title")).txt(t -> t).text();
        final Text filterText = Chain.on(leftComposite).lbl(l -> l.key("dialog.filter.filter")).txt(Text_.Builder::multi).text();
        Tree tree = EditFilterDialog.createTree(sashForm, 2080);
        for (int i = 0; i < this.columnNames_.length; ++i) {
            if (i == 20) continue;
            TreeItem item = new TreeItem(tree, 0);
            item.setText(this.columnNames_[i]);
            class TreeNodeItem
            implements Comparable<TreeNodeItem> {
                String value;
                String subQuery;
                String likeQuery;

                public TreeNodeItem(String v, String q, String l) {
                    this.value = StringUtils.isEmpty(v) ? EMPTY_FIELD : v;
                    this.subQuery = q;
                    this.likeQuery = l;
                }

                public int hashCode() {
                    return Objects.hash(this.value, this.subQuery, this.likeQuery);
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof TreeNodeItem)) {
                        return false;
                    }
                    TreeNodeItem that = (TreeNodeItem)obj;
                    return StringUtils.equals(this.value, that.value) && StringUtils.equals(this.subQuery, that.subQuery) && StringUtils.equals(this.likeQuery, that.likeQuery);
                }

                @Override
                public int compareTo(TreeNodeItem o) {
                    int eq2;
                    int eq1 = this.value.equals(EMPTY_FIELD) ? 1 : 0;
                    int n = eq2 = o.value.equals(EMPTY_FIELD) ? 1 : 0;
                    if (eq1 + eq2 > 0) {
                        return eq2 - eq1;
                    }
                    return this.value.compareToIgnoreCase(o.value);
                }
            }
            TreeSet<TreeNodeItem> values = new TreeSet<TreeNodeItem>();
            switch (i) {
                case 0: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(p.getTitle(), "GAM.TITLE='" + p.getTitle() + "'", "GAM.TITLE"));
                    }
                    break;
                }
                case 1: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(this.text_.toString(p.hasSetup()), p.hasSetup() ? "GAM.SETUP<>''" : "(GAM.SETUP IS NULL OR GAM.SETUP='')", null));
                    }
                    break;
                }
                case 2: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(p.getDeveloper(), "DEV.NAME='" + p.getDeveloper() + "'", "DEV.NAME"));
                    }
                    break;
                }
                case 3: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(p.getPublisher(), "PUBL.NAME='" + p.getPublisher() + "'", "PUBL.NAME"));
                    }
                    break;
                }
                case 4: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(p.getGenre(), "GEN.NAME='" + p.getGenre() + "'", "GEN.NAME"));
                    }
                    break;
                }
                case 5: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(p.getYear(), "YR.YEAR='" + p.getYear() + "'", null));
                    }
                    break;
                }
                case 6: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(p.getStatus(), "STAT.STAT='" + p.getStatus() + "'", "STAT.STAT"));
                    }
                    break;
                }
                case 7: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(this.text_.toString(p.isFavorite()), "GAM.FAVORITE=" + p.isFavorite(), null));
                    }
                    break;
                }
                case 8: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(String.valueOf(p.getId()), "GAM.ID=" + p.getId(), null));
                    }
                    break;
                }
                case 9: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(String.valueOf(p.getDosboxVersion().getId()), "GAM.DBVERSION_ID=" + p.getDosboxVersion().getId(), null));
                    }
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    for (Profile p : this.profilesList_) {
                        int idx = i - 10;
                        values.add(new TreeNodeItem(String.valueOf(p.getCustomStrings()[idx]), "CUST" + (idx + 1) + ".VALUE='" + p.getCustomStrings()[idx] + "'", "CUST" + (idx + 1) + ".VALUE"));
                    }
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    for (Profile p : this.profilesList_) {
                        int idx = i - 10;
                        values.add(new TreeNodeItem(String.valueOf(p.getCustomStrings()[idx]), "GAM.CUSTOM" + (idx + 1) + "='" + p.getCustomStrings()[idx] + "'", "GAM.CUSTOM" + (idx + 1)));
                    }
                    break;
                }
                case 18: 
                case 19: {
                    for (Profile p : this.profilesList_) {
                        int idx = i - 10 - 8;
                        values.add(new TreeNodeItem(String.valueOf(p.getCustomInts()[idx]), "GAM.CUSTOM" + (idx + 9) + "=" + p.getCustomInts()[idx], null));
                    }
                    break;
                }
                case 21: {
                    for (Profile p : this.profilesList_) {
                        String dbversionTitle = BaseRepository.findById(this.dbversionsList_, p.getDosboxVersion().getId()).getTitle();
                        values.add(new TreeNodeItem(dbversionTitle, "GAM.DBVERSION_ID=" + p.getDosboxVersion().getId(), null));
                    }
                    break;
                }
                case 22: {
                    for (Profile p : this.profilesList_) {
                        Date date = p.getStats().getCreated();
                        values.add(new TreeNodeItem(this.text_.toString(date), EditFilterDialog.toDatabaseString("GAM.STATS_CREATED", date), null));
                    }
                    break;
                }
                case 23: {
                    for (Profile p : this.profilesList_) {
                        Date date = p.getStats().getModified();
                        values.add(new TreeNodeItem(this.text_.toString(date), EditFilterDialog.toDatabaseString("GAM.STATS_LASTMODIFY", date), null));
                    }
                    break;
                }
                case 24: {
                    for (Profile p : this.profilesList_) {
                        Date date = p.getStats().getLastRun();
                        values.add(new TreeNodeItem(this.text_.toString(date), EditFilterDialog.toDatabaseString("GAM.STATS_LASTRUN", date), null));
                    }
                    break;
                }
                case 25: {
                    for (Profile p : this.profilesList_) {
                        Date date = p.getProfileStats().getLastSetup();
                        values.add(new TreeNodeItem(this.text_.toString(date), EditFilterDialog.toDatabaseString("GAM.STATS_LASTSETUP", date), null));
                    }
                    break;
                }
                case 26: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(String.valueOf(p.getStats().getRuns()), "GAM.STATS_RUNS=" + p.getStats().getRuns(), null));
                    }
                    break;
                }
                case 27: {
                    for (Profile p : this.profilesList_) {
                        values.add(new TreeNodeItem(String.valueOf(p.getProfileStats().getSetups()), "GAM.STATS_SETUPS=" + p.getProfileStats().getSetups(), null));
                    }
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    for (Profile p : this.profilesList_) {
                        int idx = i - 10 - 10;
                        int c = i - 10 - 8 + 1;
                        values.add(new TreeNodeItem(String.valueOf(p.getCustomStrings()[idx]), "GAM.CUSTOM" + c + "='" + p.getCustomStrings()[idx] + "'", "GAM.CUSTOM" + c));
                    }
                    break;
                }
            }
            for (TreeNodeItem v : values) {
                String sentence;
                String[] words;
                TreeItem valueItem = new TreeItem(item, 0);
                valueItem.setText(v.value);
                valueItem.setData(v.subQuery);
                valueItem.setGrayed(true);
                if (v.likeQuery == null || (words = (sentence = v.value.replaceAll("\\p{Punct}", " ")).split("\\s+")).length <= 1) continue;
                for (String w : words) {
                    TreeItem likeItem = new TreeItem(valueItem, 0);
                    likeItem.setText(w);
                    likeItem.setData("UPPER(" + v.likeQuery + ") LIKE '%" + w.toUpperCase() + "%'");
                }
            }
        }
        tree.addListener(13, event -> {
            if (event.detail == 32) {
                TreeItem tItem = (TreeItem)event.item;
                int depth = EditFilterDialog.depth(tItem);
                if (depth == 0) {
                    if (tItem.getChecked()) {
                        if (tItem.getGrayed() || this.getAllCheckedItems(tItem).isEmpty()) {
                            tItem.setChecked(false);
                        }
                    } else if (tItem.getGrayed()) {
                        tItem.setGrayed(false);
                    } else {
                        tItem.setGrayed(true);
                        tItem.setChecked(true);
                    }
                } else if (depth == 1) {
                    TreeItem parent;
                    parent.setChecked(!this.getAllCheckedItems(parent = tItem.getParentItem()).isEmpty());
                } else {
                    TreeItem parent;
                    if (tItem.getChecked()) {
                        if (tItem.getGrayed()) {
                            tItem.setChecked(false);
                        }
                    } else if (tItem.getGrayed()) {
                        tItem.setGrayed(false);
                    } else {
                        tItem.setGrayed(true);
                        tItem.setChecked(true);
                    }
                    parent.setChecked(!this.getAllCheckedItems(parent = tItem.getParentItem().getParentItem()).isEmpty());
                }
            }
        });
        tree.addListener(13, event -> {
            ArrayList<CallSite> rootQueriesAnd = new ArrayList<CallSite>();
            ArrayList<CallSite> rootQueriesOr = new ArrayList<CallSite>();
            StringBuilder generatedTitle = null;
            for (TreeItem rootItem : tree.getItems()) {
                if (!rootItem.getChecked()) continue;
                ArrayList<String> subQueriesAnd = new ArrayList<String>();
                ArrayList<String> subQueriesOr = new ArrayList<String>();
                for (TreeItem item : this.getAllCheckedItems(rootItem)) {
                    TreeItem parent = item.getParentItem();
                    TreeItem parentOfParent = null;
                    if (parent == null) continue;
                    if (generatedTitle == null) {
                        parentOfParent = parent.getParentItem();
                        generatedTitle = parentOfParent != null ? new StringBuilder(parentOfParent.getText() + ": " + item.getText()) : new StringBuilder(parent.getText() + ": " + item.getText());
                    } else if (!generatedTitle.toString().endsWith("...")) {
                        generatedTitle.append("...");
                    }
                    if (item.getGrayed()) {
                        subQueriesOr.add((String)item.getData());
                        continue;
                    }
                    subQueriesAnd.add((String)item.getData());
                }
                String resultAnd = StringUtils.join(subQueriesAnd, "\n\tAND ");
                String resultOr = StringUtils.join(subQueriesOr, "\n\tOR ");
                boolean and = StringUtils.isNotBlank(resultAnd);
                boolean or = StringUtils.isNotBlank(resultOr);
                Object result = null;
                if (and && or) {
                    result = "(" + resultAnd + ")\nAND\n(" + resultOr + ")";
                } else if (and) {
                    result = resultAnd;
                } else if (or) {
                    result = resultOr;
                }
                if (result == null) continue;
                if (rootItem.getGrayed()) {
                    rootQueriesOr.add((CallSite)((Object)("(" + (String)result + ")")));
                    continue;
                }
                rootQueriesAnd.add((CallSite)((Object)("(" + (String)result + ")")));
            }
            String resultAnd = StringUtils.join(rootQueriesAnd, "\nAND\n");
            String resultOr = StringUtils.join(rootQueriesOr, "\nOR\n");
            boolean and = StringUtils.isNotBlank(resultAnd);
            boolean or = StringUtils.isNotBlank(resultOr);
            Object result = null;
            if (and && or) {
                result = "(" + resultAnd + ")\nAND\n(" + resultOr + ")";
            } else if (and) {
                result = resultAnd;
            } else if (or) {
                result = resultOr;
            }
            if (StringUtils.isNotBlank(generatedTitle)) {
                filterTitle.setText(generatedTitle.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)result)) {
                filterText.setText((String)result);
            }
        });
        sashForm.setWeights(60, 40);
        Text results = Chain.on(composite).lbl(l -> l.key("dialog.filter.result")).txt(Text_.Builder::readOnly).text();
        this.createOkCancelButtons(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (!EditFilterDialog.this.isValid(filterTitle)) {
                    return;
                }
                try {
                    if (EditFilterDialog.this.filter_ == null) {
                        Filter f = new Filter(filterTitle.getText(), filterText.getText());
                        EditFilterDialog.this.result_ = new FilterRepository().add(f);
                    } else {
                        EditFilterDialog.this.filter_.setTitle(filterTitle.getText());
                        EditFilterDialog.this.filter_.setFilter(filterText.getText());
                        new FilterRepository().update(EditFilterDialog.this.filter_);
                        EditFilterDialog.this.result_ = EditFilterDialog.this.filter_;
                    }
                }
                catch (SQLException e) {
                    Mess_.on(EditFilterDialog.this.shell_).exception(e).warning();
                }
                EditFilterDialog.this.shell_.close();
            }
        });
        filterTitle.addListener(25, event -> {
            String oldTitle = ((Text)event.widget).getText();
            String newTitle = oldTitle.substring(0, event.start) + event.text + oldTitle.substring(event.end);
            if (StringUtils.isEmpty(filterText.getText()) || filterText.getText().equals("UPPER(GAM.TITLE) LIKE '%" + oldTitle.toUpperCase() + "%'")) {
                if (StringUtils.isEmpty(newTitle)) {
                    filterText.setText("");
                } else {
                    filterText.setText("UPPER(GAM.TITLE) LIKE '%" + newTitle.toUpperCase() + "%'");
                }
            }
        });
        filterText.addModifyListener(event -> {
            try {
                List<Profile> tmpList = new ProfileRepository().list("", filterText.getText(), this.dbversionsList_);
                results.setText(this.text_.get("dialog.filter.notice.results", new Object[]{tmpList.size()}));
                this.okButton_.setEnabled(true);
            }
            catch (SQLException e) {
                results.setText(this.text_.get("dialog.filter.error.invalidcondition"));
                this.okButton_.setEnabled(false);
            }
        });
        if (this.filter_ != null) {
            filterTitle.setText(this.filter_.getTitle());
            filterText.setText(this.filter_.getFilter());
        } else if (this.selectedProfileIds_ != null) {
            filterText.setText("GAM.ID IN (" + StringUtils.join(this.selectedProfileIds_, ',') + ")");
        }
        filterTitle.setFocus();
    }

    private static int depth(TreeItem item) {
        int result = 0;
        while ((item = item.getParentItem()) != null) {
            ++result;
        }
        return result;
    }

    private List<TreeItem> getAllCheckedItems(TreeItem treeItem) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        for (TreeItem item : treeItem.getItems()) {
            if (item.getChecked()) {
                result.add(item);
            }
            result.addAll(this.getAllCheckedItems(item));
        }
        return result;
    }

    private boolean isValid(Text title) {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (StringUtils.isBlank(title.getText())) {
            mess.key("dialog.filter.required.title").bind(title);
        }
        return mess.valid();
    }

    private static String toDatabaseString(String dbField, Date date) {
        StringBuilder sb = new StringBuilder();
        if (date == null) {
            sb.append(dbField).append(" IS NULL");
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            sb.append("YEAR(").append(dbField).append(")=").append(cal.get(1));
            sb.append(" AND MONTH(").append(dbField).append(")=").append(cal.get(2) + 1);
            sb.append(" AND DAYOFMONTH(").append(dbField).append(")=").append(cal.get(5));
        }
        return sb.toString();
    }
}

