/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.TextService;

public class NativeCommand {
    private final FileLocation command_;
    private final String parameters_;
    private final FileLocation cwd_;
    private final boolean waitFor_;
    private final int orderNr_;

    public NativeCommand(String command, String parameters, String cwd, boolean waitFor, int orderNr) {
        this.command_ = command == null ? null : new FileLocation(command, FileLocationService.getInstance().dataRelative());
        this.parameters_ = parameters;
        this.cwd_ = cwd == null ? null : new FileLocation(cwd, FileLocationService.getInstance().dataRelative());
        this.waitFor_ = waitFor;
        this.orderNr_ = orderNr;
    }

    public File getCommand() {
        return this.command_.getFile();
    }

    public File getCanonicalCommand() {
        return this.command_.getCanonicalFile();
    }

    public boolean isDosboxCommand() {
        return this.command_ == null;
    }

    public String getParameters() {
        return this.parameters_;
    }

    public File getCwd() {
        return this.cwd_.getFile();
    }

    public File getCanonicalCwd() {
        return this.cwd_.getCanonicalFile();
    }

    public boolean isWaitFor() {
        return this.waitFor_;
    }

    public int getOrderNr() {
        return this.orderNr_;
    }

    public List<String> getCanonicalCommandAndParameters() {
        ArrayList<String> execCommands = new ArrayList<String>();
        execCommands.add(this.getCanonicalCommand().getPath());
        if (this.parameters_.length() > 0) {
            Collections.addAll(execCommands, StringUtils.split(this.parameters_, ' '));
        }
        return execCommands;
    }

    public String toString() {
        if (this.isDosboxCommand()) {
            return "-- DOSBox --";
        }
        StringBuilder s = new StringBuilder(this.command_.getFile().getPath());
        if (StringUtils.isNotEmpty(this.parameters_)) {
            s.append(' ').append(this.parameters_);
        }
        if (!this.cwd_.getFile().getPath().equals(this.command_.getFile().getParent())) {
            s.append(", ").append(this.cwd_.getFile().getPath());
        }
        if (this.waitFor_) {
            s.append(", ").append(TextService.getInstance().get("dialog.nativecommand.waitfor"));
        }
        return s.toString();
    }

    public static void insertDosboxCommand(List<NativeCommand> nativeCommandsList) {
        int dosboxNr = 0;
        for (int i = 0; i < nativeCommandsList.size(); ++i) {
            if (nativeCommandsList.get(i).getOrderNr() != i) continue;
            ++dosboxNr;
        }
        nativeCommandsList.add(dosboxNr, new NativeCommand(null, null, null, true, dosboxNr));
    }
}

