/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrderingVector {
    private static final int MAX_ORDERING_COLS = 8;
    private static final String[] GAME_LIST_ORDER = new String[]{"LOWER(GAM.TITLE)", "GAM.SETUP", "LOWER(DEV.NAME)", "LOWER(PUBL.NAME)", "LOWER(GEN.NAME)", "YR.YEAR", "LOWER(STAT.STAT)", "GAM.FAVORITE", "GAM.ID", "GAM.DBVERSION_ID", "LOWER(CUST1.VALUE)", "LOWER(CUST2.VALUE)", "LOWER(CUST3.VALUE)", "LOWER(CUST4.VALUE)", "LOWER(GAM.CUSTOM5)", "LOWER(GAM.CUSTOM6)", "LOWER(GAM.CUSTOM7)", "LOWER(GAM.CUSTOM8)", "GAM.CUSTOM9", "GAM.CUSTOM10", "LOWER(GAM.CAPTURES)", "", "GAM.STATS_CREATED", "GAM.STATS_LASTMODIFY", "GAM.STATS_LASTRUN", "GAM.STATS_LASTSETUP", "GAM.STATS_RUNS", "GAM.STATS_SETUPS", "LOWER(GAM.CUSTOM11)", "LOWER(GAM.CUSTOM12)", "LOWER(GAM.CUSTOM13)", "LOWER(GAM.CUSTOM14)"};
    private final List<ColumnOrder> vector_ = new ArrayList<ColumnOrder>();

    public OrderingVector(int[] columnArray, boolean[] ascendingArray) {
        for (int i = 0; i < columnArray.length; ++i) {
            this.vector_.add(new ColumnOrder(columnArray[i], ascendingArray[i]));
        }
    }

    public void addOrdering(int column, boolean ascending) {
        ColumnOrder newOrdering = new ColumnOrder(column, ascending);
        int existingIndex = this.vector_.indexOf(newOrdering);
        if (existingIndex != -1) {
            this.vector_.remove(existingIndex);
        }
        this.vector_.add(0, newOrdering);
        if (this.vector_.size() > 8) {
            this.vector_.remove(8);
        }
    }

    public int[] getColumns() {
        int[] columnArray = new int[this.vector_.size()];
        for (int i = 0; i < columnArray.length; ++i) {
            columnArray[i] = this.vector_.get((int)i).column_;
        }
        return columnArray;
    }

    public boolean[] getAscendings() {
        boolean[] ascendingArray = new boolean[this.vector_.size()];
        for (int i = 0; i < ascendingArray.length; ++i) {
            ascendingArray[i] = this.vector_.get((int)i).ascending_;
        }
        return ascendingArray;
    }

    public String toClause() {
        StringBuilder orderingClause = new StringBuilder();
        if (!this.vector_.isEmpty()) {
            orderingClause.append(" ORDER BY ");
        }
        for (int index = 0; index < this.vector_.size(); ++index) {
            ColumnOrder element = this.vector_.get(index);
            orderingClause.append(element.toString());
            if (index + 1 >= this.vector_.size()) continue;
            orderingClause.append(',');
        }
        return orderingClause.toString();
    }

    private static class ColumnOrder {
        private final int column_;
        private final boolean ascending_;

        ColumnOrder(int col, boolean asc) {
            this.column_ = col;
            this.ascending_ = asc;
        }

        public int hashCode() {
            return Objects.hash(this.column_, this.ascending_);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.column_ == ((ColumnOrder)obj).column_;
        }

        public String toString() {
            return GAME_LIST_ORDER[this.column_ == 21 ? 9 : this.column_] + (this.ascending_ ? " ASC" : " DESC");
        }
    }
}

