/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.dbgl.util.SystemUtils;

class SectionsCollection {
    private Map<String, Map<String, String>> sections_ = new LinkedHashMap<String, Map<String, String>>();

    SectionsCollection() {
    }

    SectionsCollection(SectionsCollection sectionsCollection) {
        this();
        for (String sectionTitle : sectionsCollection.sections_.keySet()) {
            for (String sectionItem : sectionsCollection.sections_.get(sectionTitle).keySet()) {
                this.setValue(sectionTitle, sectionItem, sectionsCollection.sections_.get(sectionTitle).get(sectionItem));
            }
        }
    }

    boolean hasValue(String sectionTitle, String sectionItem) {
        return this.sections_.containsKey(sectionTitle) && this.sections_.get(sectionTitle).containsKey(sectionItem);
    }

    String getValue(String sectionTitle, String sectionItem) {
        if (this.sections_.containsKey(sectionTitle)) {
            return this.sections_.get(sectionTitle).get(sectionItem);
        }
        return null;
    }

    void setValue(String sectionTitle, String sectionItem, String value) {
        this.getOrCreateSection(sectionTitle).put(sectionItem, value);
    }

    String[] getSectionNames() {
        Set<String> sectionNames = this.sections_.keySet();
        return sectionNames.toArray(new String[sectionNames.size()]);
    }

    String[] getItemNames(String sectionTitle) {
        TreeSet<String> itemNames = new TreeSet<String>(this.sections_.get(sectionTitle).keySet());
        return itemNames.toArray(new String[itemNames.size()]);
    }

    void removeSection(String sectionTitle) {
        this.sections_.remove(sectionTitle);
    }

    void removeValue(String sectionTitle, String sectionItem) {
        Map<String, String> section = this.sections_.get(sectionTitle);
        section.remove(sectionItem);
        if (section.isEmpty()) {
            this.sections_.remove(sectionTitle);
        }
    }

    void removeDuplicateValuesIn(SectionsCollection collection) {
        Iterator<String> itSections = this.sections_.keySet().iterator();
        while (itSections.hasNext()) {
            String sectionTitle = itSections.next();
            Iterator<String> itItems = this.sections_.get(sectionTitle).keySet().iterator();
            while (itItems.hasNext()) {
                String sectionItem = itItems.next();
                if (!this.getValue(sectionTitle, sectionItem).equals(collection.getValue(sectionTitle, sectionItem))) continue;
                itItems.remove();
            }
            if (!this.sections_.get(sectionTitle).isEmpty()) continue;
            itSections.remove();
        }
    }

    void removeUnequalValuesIn(SectionsCollection collection) {
        Iterator<String> itSections = this.sections_.keySet().iterator();
        while (itSections.hasNext()) {
            String sectionTitle = itSections.next();
            Iterator<String> itItems = this.sections_.get(sectionTitle).keySet().iterator();
            while (itItems.hasNext()) {
                String sectionItem = itItems.next();
                if (this.getValue(sectionTitle, sectionItem).equals(collection.getValue(sectionTitle, sectionItem))) continue;
                itItems.remove();
            }
            if (!this.sections_.get(sectionTitle).isEmpty()) continue;
            itSections.remove();
        }
    }

    void removeValuesNotSetIn(SectionsCollection collection) {
        Iterator<String> itSections = this.sections_.keySet().iterator();
        while (itSections.hasNext()) {
            String sectionTitle = itSections.next();
            Iterator<String> itItems = this.sections_.get(sectionTitle).keySet().iterator();
            while (itItems.hasNext()) {
                String sectionItem = itItems.next();
                if (collection.hasValue(sectionTitle, sectionItem)) continue;
                itItems.remove();
            }
            if (!this.sections_.get(sectionTitle).isEmpty()) continue;
            itSections.remove();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Map<String, String>> section : this.sections_.entrySet()) {
            result.append("[" + section.getKey() + "]" + SystemUtils.EOLN);
            for (Map.Entry<String, String> item : section.getValue().entrySet()) {
                result.append(item.getKey()).append('=');
                result.append(item.getValue()).append(SystemUtils.EOLN);
            }
            result.append(SystemUtils.EOLN);
        }
        return result.toString();
    }

    private Map<String, String> getOrCreateSection(String sectionTitle) {
        return this.sections_.computeIfAbsent(sectionTitle, s -> new LinkedHashMap());
    }

    public void load(SectionsCollection sections) {
        for (Map.Entry<String, Map<String, String>> section : sections.sections_.entrySet()) {
            for (Map.Entry<String, String> item : section.getValue().entrySet()) {
                this.setValue(section.getKey(), item.getKey(), item.getValue());
            }
        }
    }
}

