/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.factory;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.model.GenericStats;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.repository.BaseRepository;

public class TemplateFactory {
    private TemplateFactory() {
    }

    public static Template create(DosboxVersion dosboxVersion) {
        Template template = new Template();
        template.setTitle("");
        template.setDefault(false);
        ArrayList<NativeCommand> nativeCommands = new ArrayList<NativeCommand>();
        NativeCommand.insertDosboxCommand(nativeCommands);
        template.setNativeCommands(nativeCommands);
        template.setDosboxVersion(dosboxVersion);
        Configuration config = new Configuration();
        config.getAutoexec().setExit(true);
        template.setConfiguration(config);
        template.setStats(new GenericStats());
        return template;
    }

    public static Template create(String title, DosboxVersion dosboxVersion) {
        Template template = new Template();
        template.setTitle(title);
        template.setDefault(false);
        ArrayList<NativeCommand> nativeCommands = new ArrayList<NativeCommand>();
        NativeCommand.insertDosboxCommand(nativeCommands);
        template.setNativeCommands(nativeCommands);
        template.setDosboxVersion(dosboxVersion);
        template.setConfiguration(new Configuration());
        template.setStats(new GenericStats());
        return template;
    }

    public static Template create(int id, String title, boolean isDefault, List<NativeCommand> nativeCommands, int dosboxVersionId, Timestamp created, Timestamp modified, Timestamp lastrun, int runs, List<DosboxVersion> dosboxVersions) {
        Template template = new Template();
        template.setId(id);
        template.setTitle(title);
        template.setDefault(isDefault);
        template.setNativeCommands(nativeCommands);
        template.setDosboxVersion(BaseRepository.findById(dosboxVersions, dosboxVersionId));
        template.setConfiguration(new Configuration());
        template.setConfigurationFileLocationByIdentifiers();
        template.setStats(new GenericStats(created, modified, lastrun, runs));
        return template;
    }

    public static Template createCopy(Template templ) {
        Template template = new Template();
        template.setTitle(templ.getTitle());
        template.setDefault(false);
        template.setNativeCommands(templ.getNativeCommands());
        template.setDosboxVersion(templ.getDosboxVersion());
        template.setConfiguration(new Configuration());
        template.setStats(new GenericStats());
        return template;
    }
}

