/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.repository;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.model.entity.Filter;
import org.dbgl.model.entity.LogEntry;
import org.dbgl.model.repository.LoggingRepository;
import org.dbgl.service.DatabaseService;
import org.dbgl.service.TextService;

public class FilterRepository
extends LoggingRepository<Filter> {
    private static final String CREATE_QRY = "INSERT INTO FILTERS(TITLE, FILTER, CONF_FILTER) VALUES (?, ?, '')";
    private static final String READ_QRY = "SELECT ID, TITLE, FILTER FROM FILTERS";
    private static final String UPD_QRY = "UPDATE FILTERS SET TITLE = ?, FILTER = ? WHERE ID = ?";
    private static final String DEL_QRY = "DELETE FROM FILTERS WHERE ID = ?";

    /*
     * Enabled aggressive exception aggregation
     */
    public Filter add(Filter filter) throws SQLException {
        try (DatabaseService.Transaction transaction = this.dbService_.startTransaction();){
            Filter filter2;
            block14: {
                PreparedStatement pstmt = transaction.prepareStatement(CREATE_QRY);
                try {
                    pstmt.setString(1, filter.getTitle());
                    pstmt.setString(2, filter.getFilter());
                    pstmt.executeUpdate();
                    filter.setId(FilterRepository.identity(transaction));
                    FilterRepository.log(transaction, LogEntry.Event.ADD, LogEntry.EntityType.FILTER, filter);
                    transaction.commit();
                    filter2 = filter;
                    if (pstmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return filter2;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"add filter"}));
        }
    }

    /*
     * Exception decompiling
     */
    public List<Filter> listAll() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void update(Filter filter) throws SQLException {
        try (DatabaseService.Transaction transaction = this.dbService_.startTransaction();
             PreparedStatement pstmt = transaction.prepareStatement(UPD_QRY);){
            pstmt.setString(1, filter.getTitle());
            pstmt.setString(2, filter.getFilter());
            pstmt.setInt(3, filter.getId());
            pstmt.executeUpdate();
            FilterRepository.log(transaction, LogEntry.Event.EDIT, LogEntry.EntityType.FILTER, filter);
            transaction.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"update filter"}));
        }
    }

    public void remove(Filter filter) throws SQLException {
        try (DatabaseService.Transaction transaction = this.dbService_.startTransaction();){
            this.actionOnEntity(transaction, DEL_QRY, "remove filter", filter);
            FilterRepository.log(transaction, LogEntry.Event.REMOVE, LogEntry.EntityType.FILTER, filter);
            transaction.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
    }
}

