/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.repository;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.entity.LogEntry;
import org.dbgl.model.factory.TemplateFactory;
import org.dbgl.model.repository.LoggingRepository;
import org.dbgl.service.DatabaseService;
import org.dbgl.service.TextService;
import org.dbgl.util.FilesUtils;

public class TemplateRepository
extends LoggingRepository<Template> {
    private static final String CREATE_QRY = "INSERT INTO TEMPLATES(TITLE, ISDEFAULT, DBVERSION_ID) VALUES (?, ?, ?)";
    private static final String CREATE_NTVCMD_QRY = "INSERT INTO NATIVECOMMANDS(COMMAND, PARAMETERS, CWD, WAITFOR, ORDERNR, GAME_ID, TEMPLATE_ID) VALUES (?, ?, ?, ?, ?, NULL, ?)";
    private static final String READ_QRY = "SELECT ID, TITLE, ISDEFAULT, DBVERSION_ID, STATS_CREATED, STATS_LASTMODIFY, STATS_LASTRUN, STATS_RUNS FROM TEMPLATES ORDER BY ID";
    private static final String READ_BY_ID_QRY = "SELECT ID, TITLE, ISDEFAULT, DBVERSION_ID, STATS_CREATED, STATS_LASTMODIFY, STATS_LASTRUN, STATS_RUNS FROM TEMPLATES WHERE ID = ?";
    private static final String READ_NTVCMD_QRY = "SELECT COMMAND, PARAMETERS, CWD, WAITFOR, ORDERNR FROM NATIVECOMMANDS WHERE GAME_ID IS NULL AND TEMPLATE_ID = ? ORDER BY ORDERNR";
    private static final String UPD_QRY = "UPDATE TEMPLATES SET TITLE = ?, ISDEFAULT = ?, DBVERSION_ID = ?, STATS_LASTMODIFY = CURRENT_TIMESTAMP WHERE ID = ?";
    private static final String UPD_NODEFAULT_QRY = "UPDATE TEMPLATES SET ISDEFAULT = FALSE";
    private static final String DEL_QRY = "DELETE FROM TEMPLATES WHERE ID = ?";
    private static final String DEL_NTVCMD_QRY = "DELETE FROM NATIVECOMMANDS WHERE GAME_ID IS NULL AND TEMPLATE_ID = ?";
    private static final String REGISTER_RUN_QRY = "UPDATE TEMPLATES SET STATS_LASTRUN = CURRENT_TIMESTAMP, STATS_RUNS = (STATS_RUNS + 1) WHERE ID = ?";

    public Template add(Template template) throws SQLException {
        Template template2;
        block8: {
            DatabaseService.Transaction transaction = this.dbService_.startTransaction();
            try {
                TemplateRepository.doAdd(transaction, template);
                TemplateRepository.log(transaction, LogEntry.Event.ADD, LogEntry.EntityType.TEMPLATE, template);
                template.saveConfiguration();
                transaction.commit();
                template2 = template;
                if (transaction == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException e) {
                    e.printStackTrace();
                    throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"add template"}));
                }
            }
            transaction.close();
        }
        return template2;
    }

    private static void doAdd(DatabaseService.Transaction transaction, Template template) throws SQLException {
        try (PreparedStatement pstmt = transaction.prepareStatement(CREATE_QRY);){
            if (template.isDefault()) {
                try (Statement stmt = transaction.createStatement();){
                    stmt.executeUpdate(UPD_NODEFAULT_QRY);
                }
            }
            pstmt.setString(1, template.getTitle());
            pstmt.setBoolean(2, template.isDefault());
            pstmt.setInt(3, template.getDosboxVersion().getId());
            pstmt.executeUpdate();
            template.setId(TemplateRepository.identity(transaction));
            TemplateRepository.addNativeCommands(transaction, template);
            template.setConfigurationFileLocationByIdentifiers();
        }
    }

    private static void addNativeCommands(DatabaseService.Transaction transaction, Template template) throws SQLException {
        List<NativeCommand> commands = template.getNativeCommands();
        for (int i = 0; i < commands.size(); ++i) {
            NativeCommand cmd = commands.get(i);
            if (cmd.isDosboxCommand()) continue;
            try (PreparedStatement stmt = transaction.prepareStatement(CREATE_NTVCMD_QRY);){
                stmt.setString(1, cmd.getCommand().getPath());
                stmt.setString(2, cmd.getParameters());
                stmt.setString(3, cmd.getCwd().getPath());
                stmt.setBoolean(4, cmd.isWaitFor());
                stmt.setInt(5, i);
                stmt.setInt(6, template.getId());
                stmt.executeUpdate();
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"add template native commands"}));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public List<Template> listAll(List<DosboxVersion> dosboxVersions) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Template toTemplate(Connection con, ResultSet rs, List<DosboxVersion> dosboxVersions) throws SQLException {
        return TemplateFactory.create(rs.getInt(1), rs.getString(2), rs.getBoolean(3), TemplateRepository.listNativeCommands(con, rs.getInt(1)), rs.getInt(4), rs.getTimestamp(5), rs.getTimestamp(6), rs.getTimestamp(7), rs.getInt(8), dosboxVersions);
    }

    private static List<NativeCommand> listNativeCommands(Connection con, int templateId) throws SQLException {
        ArrayList<NativeCommand> nativeCommands = new ArrayList<NativeCommand>();
        try (PreparedStatement stmt = con.prepareStatement(READ_NTVCMD_QRY);){
            stmt.setInt(1, templateId);
            try (ResultSet resultset = stmt.executeQuery();){
                while (resultset.next()) {
                    nativeCommands.add(new NativeCommand(resultset.getString(1), resultset.getString(2), resultset.getString(3), resultset.getBoolean(4), resultset.getInt(5)));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"read template native commands"}));
        }
        NativeCommand.insertDosboxCommand(nativeCommands);
        return nativeCommands;
    }

    public void update(Template template) throws SQLException {
        try (DatabaseService.Transaction transaction = this.dbService_.startTransaction();
             PreparedStatement pstmt = transaction.prepareStatement(UPD_QRY);){
            if (template.isDefault()) {
                try (Statement stmt = transaction.createStatement();){
                    stmt.executeUpdate(UPD_NODEFAULT_QRY);
                }
            }
            pstmt.setString(1, template.getTitle());
            pstmt.setBoolean(2, template.isDefault());
            pstmt.setInt(3, template.getDosboxVersion().getId());
            pstmt.setInt(4, template.getId());
            pstmt.executeUpdate();
            this.actionOnEntity(transaction, DEL_NTVCMD_QRY, "remove template native commands", template);
            TemplateRepository.addNativeCommands(transaction, template);
            TemplateRepository.log(transaction, LogEntry.Event.EDIT, LogEntry.EntityType.TEMPLATE, template);
            template.saveConfiguration();
            transaction.commit();
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"update template"}));
        }
    }

    public void remove(Template template, boolean removeConfig) throws SQLException {
        try (DatabaseService.Transaction transaction = this.dbService_.startTransaction();){
            this.actionOnEntity(transaction, DEL_NTVCMD_QRY, "remove template native commands", template);
            this.actionOnEntity(transaction, DEL_QRY, "remove template", template);
            TemplateRepository.log(transaction, LogEntry.Event.REMOVE, LogEntry.EntityType.TEMPLATE, template);
            if (removeConfig) {
                FilesUtils.removeFile(template.getConfigurationCanonicalFile());
            }
            transaction.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
    }

    public Template duplicate(Template template) throws SQLException {
        Template template2;
        block8: {
            DatabaseService.Transaction transaction = this.dbService_.startTransaction();
            try {
                TemplateRepository.log(transaction, LogEntry.Event.DUPLICATE, LogEntry.EntityType.TEMPLATE, template);
                Template duplicate = TemplateFactory.createCopy(template);
                duplicate.loadConfigurationData(TextService.getInstance(), template.getConfigurationString(), template.getConfigurationCanonicalFile());
                TemplateRepository.doAdd(transaction, duplicate);
                TemplateRepository.log(transaction, LogEntry.Event.ADD, LogEntry.EntityType.TEMPLATE, duplicate);
                duplicate.saveConfiguration();
                transaction.commit();
                template2 = duplicate;
                if (transaction == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException e) {
                    e.printStackTrace();
                    throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"duplicate template"}));
                }
            }
            transaction.close();
        }
        return template2;
    }

    public Template registerRun(Template template) throws SQLException {
        return this.register(template, REGISTER_RUN_QRY, "register run template", LogEntry.Event.RUN);
    }

    private Template register(Template template, String query, String action, LogEntry.Event event) throws SQLException {
        Template template2;
        block8: {
            DatabaseService.Transaction transaction = this.dbService_.startTransaction();
            try {
                this.actionOnEntity(transaction, query, action, template);
                TemplateRepository.log(transaction, event, LogEntry.EntityType.TEMPLATE, template);
                transaction.commit();
                template2 = this.getById(template.getId(), Arrays.asList(template.getDosboxVersion()));
                if (transaction == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new SQLException(e);
                }
            }
            transaction.close();
        }
        return template2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Template getById(int templateId, List<DosboxVersion> dosboxVersions) throws SQLException {
        try (Connection con = this.dbService_.getConnection();
             PreparedStatement stmt = con.prepareStatement(READ_BY_ID_QRY);){
            stmt.setInt(1, templateId);
            try (ResultSet resultset = stmt.executeQuery();){
                if (!resultset.next()) return null;
                Template template = TemplateRepository.toTemplate(con, resultset, dosboxVersions);
                return template;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"read template " + templateId}));
        }
    }
}

