/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import org.dbgl.util.fat.BlockDevice;
import org.dbgl.util.fat.BootSector;
import org.dbgl.util.fat.FatType;

final class Fat16BootSector
extends BootSector {
    public static final int MAX_FAT12_CLUSTERS = 4084;
    public static final int MAX_FAT16_CLUSTERS = 65524;
    public static final int SECTORS_PER_FAT_OFFSET = 22;
    public static final int ROOT_DIR_ENTRIES_OFFSET = 17;

    public Fat16BootSector(BlockDevice device, long offset) {
        super(device, offset);
    }

    @Override
    public long getSectorsPerFat() {
        return this.get16(22);
    }

    @Override
    public FatType getFatType() {
        long rootDirSectors = (this.getRootDirEntryCount() * 32 + (this.getBytesPerSector() - 1)) / this.getBytesPerSector();
        long dataSectors = this.getSectorCount() - ((long)this.getNrReservedSectors() + (long)this.getNrFats() * this.getSectorsPerFat() + rootDirSectors);
        long clusterCount = dataSectors / (long)this.getSectorsPerCluster();
        if (clusterCount > 65524L) {
            throw new IllegalStateException("too many clusters for FAT12/16: " + clusterCount);
        }
        return clusterCount > 4084L ? FatType.FAT16 : FatType.FAT12;
    }

    @Override
    public long getSectorCount() {
        return this.getNrLogicalSectors() == 0 ? this.getNrTotalSectors() : (long)this.getNrLogicalSectors();
    }

    @Override
    public int getRootDirEntryCount() {
        return this.get16(17);
    }
}

