/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.dbgl.util.fat.AbstractDirectory;
import org.dbgl.util.fat.BlockDevice;
import org.dbgl.util.fat.Fat16BootSector;

final class Fat16RootDirectory
extends AbstractDirectory {
    private final BlockDevice device_;
    private final long deviceOffset_;

    private Fat16RootDirectory(Fat16BootSector bs) {
        super(bs.getRootDirEntryCount(), true);
        if (bs.getRootDirEntryCount() <= 0) {
            throw new IllegalArgumentException("root directory size is " + bs.getRootDirEntryCount());
        }
        this.deviceOffset_ = bs.getRootDirOffset();
        this.device_ = bs.getDevice();
    }

    public static Fat16RootDirectory read(Fat16BootSector bs) throws IOException {
        Fat16RootDirectory result = new Fat16RootDirectory(bs);
        result.read();
        return result;
    }

    @Override
    protected void read(ByteBuffer data) throws IOException {
        this.device_.read(this.deviceOffset_, data);
    }
}

