/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.io.IOException;
import org.dbgl.util.fat.AbstractDirectory;
import org.dbgl.util.fat.BlockDevice;
import org.dbgl.util.fat.BootSector;
import org.dbgl.util.fat.ClusterChain;
import org.dbgl.util.fat.ClusterChainDirectory;
import org.dbgl.util.fat.Fat;
import org.dbgl.util.fat.Fat16BootSector;
import org.dbgl.util.fat.Fat16RootDirectory;
import org.dbgl.util.fat.Fat32BootSector;
import org.dbgl.util.fat.FatLfnDirectory;
import org.dbgl.util.fat.FatType;

public final class FatFileSystem {
    private final Fat fat_;
    private final BootSector bs_;
    private final FatLfnDirectory rootDir_;
    private final AbstractDirectory rootDirStore_;
    private final FatType fatType_;

    public FatFileSystem(BlockDevice device) throws IOException {
        this.bs_ = BootSector.read(device);
        if (this.bs_.getNrFats() <= 0) {
            throw new IOException("boot sector says there are no FATs");
        }
        this.fatType_ = this.bs_.getFatType();
        this.fat_ = Fat.read(this.bs_, 0);
        for (int i = 1; i < this.bs_.getNrFats(); ++i) {
            if (this.fat_.equals(Fat.read(this.bs_, i))) continue;
            System.err.println("FAT " + i + " differs from FAT 0");
        }
        this.rootDirStore_ = this.fatType_ == FatType.FAT32 ? ClusterChainDirectory.readRoot(new ClusterChain(this.fat_, ((Fat32BootSector)this.bs_).getRootDirFirstCluster())) : Fat16RootDirectory.read((Fat16BootSector)this.bs_);
        this.rootDir_ = new FatLfnDirectory(this.rootDirStore_, this.fat_);
    }

    public FatLfnDirectory getRoot() {
        return this.rootDir_;
    }
}

