/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.DatabaseType;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDQL;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.TableBase;
import org.hsqldb.TextTable;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Collation;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class Table
extends TableBase
implements SchemaObject {
    public static final Table[] emptyArray = new Table[0];
    protected HsqlNameManager.HsqlName tableName;
    protected long changeTimestamp;
    public OrderedHashMap<String, ColumnSchema> columnList;
    int identityColumn;
    NumberSequence identitySequence;
    Constraint[] constraintList;
    Constraint[] fkConstraints;
    Constraint[] fkMainConstraints;
    Constraint[] checkConstraints;
    TriggerDef[] triggerList;
    TriggerDef[][] triggerLists;
    Expression[] colDefaults;
    private boolean hasDefaultValues;
    boolean[] colGenerated;
    private boolean hasGeneratedValues;
    boolean[] colUpdated;
    private boolean hasUpdatedValues;
    boolean[] colRefFK;
    boolean[] colMainFK;
    int referentialActions;
    int cascadingDeletes;
    boolean isDropped;
    private boolean hasDomainColumns;
    private boolean hasNotNullColumns;
    protected int[] defaultColumnMap;
    private RangeVariable[] defaultRanges;
    PeriodDefinition systemPeriod;
    PeriodDefinition applicationPeriod;
    int systemPeriodStartColumn;
    int systemPeriodEndColumn;

    public Table(Database database, HsqlNameManager.HsqlName hsqlName, int n) {
        this.database = database;
        this.tableName = hsqlName;
        this.persistenceId = database.persistentStoreCollection.getNextId();
        switch (n) {
            case 13: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                break;
            }
            case 2: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                break;
            }
            case 1: {
                this.persistenceScope = 22;
                this.isSessionBased = true;
                break;
            }
            case 12: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                break;
            }
            case 5: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                if (database.logger.isFileDatabase()) {
                    this.isCached = true;
                    this.isLogged = !database.isFilesReadOnly();
                    break;
                }
                n = 4;
                break;
            }
            case 4: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                this.isLogged = !database.isFilesReadOnly();
                break;
            }
            case 3: {
                this.persistenceScope = 22;
                this.isTemp = true;
                this.isSchemaBased = true;
                this.isSessionBased = true;
                break;
            }
            case 6: {
                this.persistenceScope = 23;
                if (!database.logger.isFileDatabase()) {
                    throw Error.error(459);
                }
                this.isSchemaBased = true;
                this.isSessionBased = true;
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                break;
            }
            case 7: {
                this.persistenceScope = 24;
                if (!database.logger.isFileDatabase()) {
                    if (!database.logger.isAllowedFullPath()) {
                        throw Error.error(459);
                    }
                    this.isReadOnly = true;
                }
                this.isSchemaBased = true;
                this.isText = true;
                break;
            }
            case 8: {
                this.persistenceScope = 21;
                this.isSchemaBased = true;
                this.isSessionBased = true;
                this.isView = true;
                break;
            }
            case 9: 
            case 14: {
                this.persistenceScope = 23;
                this.isSessionBased = true;
                break;
            }
            case 11: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
        this.tableType = n;
        this.identityColumn = -1;
        this.columnList = new OrderedHashMap();
        this.indexList = Index.emptyArray;
        this.constraintList = Constraint.emptyArray;
        this.fkConstraints = Constraint.emptyArray;
        this.fkMainConstraints = Constraint.emptyArray;
        this.checkConstraints = Constraint.emptyArray;
        this.triggerList = TriggerDef.emptyArray;
        this.triggerLists = new TriggerDef[9][];
        for (int i = 0; i < 9; ++i) {
            this.triggerLists[i] = TriggerDef.emptyArray;
        }
        if (database.isFilesReadOnly() && this.isFileBased()) {
            this.isReadOnly = true;
        }
    }

    public Table(Table table, HsqlNameManager.HsqlName hsqlName) {
        this.persistenceScope = 21;
        hsqlName.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
        this.tableName = hsqlName;
        this.database = table.database;
        this.tableType = 9;
        this.columnList = table.columnList;
        this.columnCount = table.columnCount;
        this.indexList = Index.emptyArray;
        this.constraintList = Constraint.emptyArray;
        this.createPrimaryKey();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public final HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.tableName.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.database.getCatalogName();
    }

    @Override
    public Grantee getOwner() {
        return this.tableName.schema.owner;
    }

    @Override
    public OrderedHashSet<HsqlNameManager.HsqlName> getReferences() {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        if (this.identitySequence != null && this.identitySequence.getName() != null) {
            orderedHashSet.add(this.identitySequence.getName());
        }
        return orderedHashSet;
    }

    public OrderedHashSet<HsqlNameManager.HsqlName> getReferencesForScript() {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = this.getReferences();
        for (int i = 0; i < this.colTypes.length; ++i) {
            ColumnSchema columnSchema = this.getColumn(i);
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = columnSchema.getReferences();
            if (orderedHashSet2 == null || orderedHashSet2.isEmpty()) continue;
            orderedHashSet.addAll(orderedHashSet2);
        }
        return orderedHashSet;
    }

    public OrderedHashSet<HsqlNameManager.HsqlName> getReferencesForDependents() {
        int n;
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        for (n = 0; n < this.colTypes.length; ++n) {
            ColumnSchema columnSchema = this.getColumn(n);
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = columnSchema.getReferences();
            if (orderedHashSet2 == null || orderedHashSet2.isEmpty()) continue;
            orderedHashSet.add(columnSchema.getName());
        }
        for (n = 0; n < this.fkConstraints.length; ++n) {
            if (this.fkConstraints[n].getMainTableName() == this.getName()) continue;
            orderedHashSet.add(this.fkConstraints[n].getName());
        }
        for (n = 0; n < this.triggerList.length; ++n) {
            orderedHashSet.add(this.triggerList[n].getName());
        }
        return orderedHashSet;
    }

    @Override
    public OrderedHashSet<SchemaObject> getComponents() {
        OrderedHashSet<SchemaObject> orderedHashSet = new OrderedHashSet<SchemaObject>();
        orderedHashSet.addAll(this.constraintList);
        orderedHashSet.addAll(this.triggerList);
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint()) continue;
            orderedHashSet.add(this.indexList[i]);
        }
        return orderedHashSet;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema columnSchema = this.getColumn(i);
            columnSchema.compile(session, this);
        }
    }

    @Override
    public String getSQL() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE").append(' ');
        if (this.isTemp()) {
            stringBuilder.append("GLOBAL").append(' ').append("TEMPORARY").append(' ');
        } else if (this.isText()) {
            stringBuilder.append("TEXT").append(' ');
        } else if (this.isCached()) {
            stringBuilder.append("CACHED").append(' ');
        } else {
            stringBuilder.append("MEMORY").append(' ');
        }
        stringBuilder.append("TABLE").append(' ').append(this.getName().getSchemaQualifiedStatementName()).append('(');
        int[] nArray = this.getPrimaryKey();
        Constraint constraint = this.getPrimaryConstraint();
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema columnSchema = this.getColumn(i);
            String string = columnSchema.getName().statementName;
            Type schemaObject = columnSchema.getDataType();
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string).append(' ').append(schemaObject.getTypeDefinition());
            if (!schemaObject.isDistinctType() && !schemaObject.isDomainType() && schemaObject.isCharacterType() && ((Collation)(object = schemaObject.getCollation())).isObjectCollation()) {
                stringBuilder.append(' ').append(((Collation)object).getCollateSQL());
            }
            if ((object = columnSchema.getDefaultSQL()) != null) {
                stringBuilder.append(' ').append("DEFAULT").append(' ').append((String)object);
            }
            if (columnSchema.isAutoUpdate()) {
                stringBuilder.append(' ').append("ON").append(' ').append("UPDATE").append(' ').append(columnSchema.getUpdateExpression().getSQL());
            }
            if (columnSchema.isIdentity()) {
                stringBuilder.append(' ').append(columnSchema.getIdentitySequence().getSQLColumnDefinition());
            }
            if (columnSchema.isGenerated()) {
                stringBuilder.append(' ').append("GENERATED").append(' ').append("ALWAYS").append(' ').append("AS").append("(").append(columnSchema.getGeneratingExpression().getSQL()).append(")");
            }
            if (columnSchema.getSystemPeriodType() == 1) {
                stringBuilder.append(' ').append("GENERATED").append(' ').append("ALWAYS").append(' ').append("AS").append(' ').append("ROW").append(' ').append("START");
            } else if (columnSchema.getSystemPeriodType() == 2) {
                stringBuilder.append(' ').append("GENERATED").append(' ').append("ALWAYS").append(' ').append("AS").append(' ').append("ROW").append(' ').append("END");
            }
            if (!columnSchema.isNullable()) {
                Constraint constraint2 = this.getNotNullConstraintForColumn(i);
                if (constraint2 != null && !constraint2.getName().isReservedName()) {
                    stringBuilder.append(' ').append("CONSTRAINT").append(' ').append(constraint2.getName().statementName);
                }
                stringBuilder.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (nArray.length != 1 || i != nArray[0] || !constraint.getName().isReservedName()) continue;
            stringBuilder.append(' ').append("PRIMARY").append(' ').append("KEY");
        }
        if (this.systemPeriod != null) {
            stringBuilder.append(',').append("PERIOD").append(' ').append("FOR").append(' ').append("SYSTEM_TIME").append('(').append(this.systemPeriod.getStartColumn().getName().statementName).append(',').append(this.systemPeriod.getEndColumn().getName().statementName).append(')');
        }
        if (this.applicationPeriod != null) {
            stringBuilder.append(',').append("PERIOD").append(' ').append("FOR").append(' ').append(this.applicationPeriod.getName().statementName).append('(').append(this.applicationPeriod.getStartColumn().getName().statementName).append(',').append(this.applicationPeriod.getEndColumn().getName().statementName).append(')');
        }
        for (Constraint constraint3 : this.getConstraints()) {
            if (constraint3.isForward || ((String)(object = constraint3.getSQL())).length() <= 0) continue;
            stringBuilder.append(',').append((String)object);
        }
        stringBuilder.append(')');
        if (this.onCommitPreserve()) {
            stringBuilder.append(' ').append("ON").append(' ').append("COMMIT").append(' ').append("PRESERVE").append(' ').append("ROWS");
        }
        if (this.isSystemVersioned) {
            stringBuilder.append(' ').append("WITH").append(' ').append("SYSTEM").append(' ').append("VERSIONING");
        }
        return stringBuilder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public RangeVariable[] getDefaultRanges() {
        if (this.defaultRanges == null) {
            this.defaultRanges = new RangeVariable[]{new RangeVariable(this, 0)};
        }
        return this.defaultRanges;
    }

    public final void setName(HsqlNameManager.HsqlName hsqlName) {
        this.tableName = hsqlName;
    }

    HsqlArrayList<String> getSQL(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet, OrderedHashSet<SchemaObject> orderedHashSet2) {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.isForward) {
                orderedHashSet2.add(constraint);
                continue;
            }
            if (constraint.getConstraintType() != 2 && constraint.getConstraintType() != 4) continue;
            orderedHashSet.add(constraint.getName());
        }
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        hsqlArrayList.add(this.getSQL());
        if (!this.isTemp && !this.isText && this.identitySequence != null && this.identitySequence.getName() == null) {
            hsqlArrayList.add(NumberSequence.getRestartSQL(this));
        }
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint() || this.indexList[i].getColumnCount() <= 0) continue;
            hsqlArrayList.add(this.indexList[i].getSQL());
        }
        return hsqlArrayList;
    }

    public String getSQLForReadOnly() {
        if (this.isReadOnly) {
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append("SET").append(' ').append("TABLE").append(' ').append(this.getName().getSchemaQualifiedStatementName()).append(' ').append("READ").append(' ').append("ONLY");
            return stringBuilder.toString();
        }
        return null;
    }

    public String[] getSQLForTextSource(boolean bl) {
        if (this.isText()) {
            String string;
            HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
            if (this.isReadOnly) {
                hsqlArrayList.add(this.getSQLForReadOnly());
            }
            if ((string = ((TextTable)this).getDataSourceDDL()) != null) {
                hsqlArrayList.add(string);
            }
            String string2 = ((TextTable)this).getDataSourceHeader();
            if (bl && string2 != null && !this.isReadOnly) {
                hsqlArrayList.add(string2);
            }
            String[] stringArray = new String[hsqlArrayList.size()];
            hsqlArrayList.toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    public String getSQLForClustered() {
        if (!this.isCached() && !this.isText()) {
            return null;
        }
        Index index = this.getClusteredIndex();
        if (index == null) {
            return null;
        }
        String string = this.getColumnListSQL(index.getColumns(), index.getColumnCount());
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("SET").append(' ').append("TABLE").append(' ').append(this.getName().getSchemaQualifiedStatementName()).append(' ').append("CLUSTERED").append(' ').append("ON").append(' ').append(string);
        return stringBuilder.toString();
    }

    public String getSQLForTableSpace() {
        if (!this.isCached() || this.tableSpace == 7) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("SET").append(' ').append("TABLE").append(' ').append(this.getName().getSchemaQualifiedStatementName()).append(' ').append("SPACE").append(' ').append(this.tableSpace);
        return stringBuilder.toString();
    }

    public HsqlArrayList<String> getTriggerSQLArray() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        for (int i = 0; i < this.triggerList.length; ++i) {
            if (this.triggerList[i].isSystem()) continue;
            hsqlArrayList.add(this.triggerList[i].getSQL());
        }
        return hsqlArrayList;
    }

    public String getIndexRootsSQL(long[] lArray) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("SET").append(' ').append("TABLE").append(' ').append(this.getName().getSchemaQualifiedStatementName()).append(' ').append("INDEX").append(' ').append('\'').append(StringUtil.getList(lArray, " ", "")).append(' ').append(StringUtil.getList(new long[this.indexList.length], " ", "")).append(' ').append(this.store.elementCount()).append('\'');
        return stringBuilder.toString();
    }

    public String getColumnListSQL(int[] nArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.getColumn((int)nArray[i]).getName().statementName);
            if (i >= n - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String getColumnListWithTypeSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema columnSchema = this.getColumn(i);
            String string = columnSchema.getName().statementName;
            Type type = columnSchema.getDataType();
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string).append(' ').append(type.getTypeDefinition());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public void setForwardConstraints(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Table table;
            Constraint constraint = this.constraintList[i];
            if (constraint.getConstraintType() != 0 || (table = constraint.getMain()) == this || orderedHashSet.contains(table.getName())) continue;
            constraint.isForward = true;
        }
    }

    public boolean isConnected() {
        return true;
    }

    public static int compareRows(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, Type[] typeArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = typeArray[nArray[i]].compare(session, objectArray[nArray[i]], objectArray2[nArray[i]]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public int getId() {
        return this.tableName.hashCode();
    }

    public String getTableTypeString() {
        switch (this.tableType) {
            case 4: {
                return "MEMORY";
            }
            case 5: {
                return "CACHED";
            }
            case 7: {
                return "TEXT";
            }
            case 14: {
                return "MODULE";
            }
            case 11: {
                return "FUNCTION";
            }
            case 1: 
            case 8: {
                return "VIEW";
            }
            case 3: {
                return "TEMP";
            }
        }
        return "SUBQUERY";
    }

    public final boolean isSchemaBaseTable() {
        switch (this.tableType) {
            case 4: 
            case 5: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public final boolean isWithDataSource() {
        return this.isWithDataSource;
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    public final boolean isView() {
        return this.isView;
    }

    public boolean isQueryBased() {
        return false;
    }

    public boolean isCached() {
        return this.isCached;
    }

    public boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    public boolean isDropped() {
        return this.isDropped;
    }

    final boolean isIndexingMutable() {
        return !this.isCached;
    }

    public void checkDataReadOnly() {
        if (this.isDataReadOnly()) {
            throw Error.error(456);
        }
    }

    public void setDataReadOnly(boolean bl) {
        if (!bl) {
            if (this.database.isFilesReadOnly() && this.isFileBased()) {
                throw Error.error(456);
            }
            if (this.database.getType() == DatabaseType.DB_MEM && this.isText) {
                throw Error.error(456);
            }
        }
        this.isReadOnly = bl;
    }

    public boolean isFileBased() {
        return this.isCached || this.isText;
    }

    public void addConstraint(Constraint constraint) {
        int n = constraint.getConstraintType() == 4 ? 0 : this.constraintList.length;
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, constraint, n, 1);
        this.updateConstraintLists();
    }

    void updateConstraintLists() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.referentialActions = 0;
        this.cascadingDeletes = 0;
        block10: for (n = 0; n < this.constraintList.length; ++n) {
            switch (this.constraintList[n].getConstraintType()) {
                case 0: {
                    ++n2;
                    continue block10;
                }
                case 1: {
                    ++n3;
                    continue block10;
                }
                case 3: {
                    if (this.constraintList[n].isNotNull()) continue block10;
                    ++n4;
                }
            }
        }
        this.fkConstraints = n2 == 0 ? Constraint.emptyArray : new Constraint[n2];
        n2 = 0;
        this.fkMainConstraints = n3 == 0 ? Constraint.emptyArray : new Constraint[n3];
        n3 = 0;
        this.checkConstraints = n4 == 0 ? Constraint.emptyArray : new Constraint[n4];
        n4 = 0;
        this.colRefFK = new boolean[this.columnCount];
        this.colMainFK = new boolean[this.columnCount];
        block11: for (n = 0; n < this.constraintList.length; ++n) {
            switch (this.constraintList[n].getConstraintType()) {
                case 0: {
                    this.fkConstraints[n2] = this.constraintList[n];
                    ArrayUtil.intIndexesToBooleanArray(this.constraintList[n].getRefColumns(), this.colRefFK);
                    ++n2;
                    continue block11;
                }
                case 1: {
                    this.fkMainConstraints[n3] = this.constraintList[n];
                    ArrayUtil.intIndexesToBooleanArray(this.constraintList[n].getMainColumns(), this.colMainFK);
                    if (this.constraintList[n].hasCoreTriggeredAction()) {
                        ++this.referentialActions;
                        if (this.constraintList[n].getDeleteAction() == 0) {
                            ++this.cascadingDeletes;
                        }
                    }
                    ++n3;
                    continue block11;
                }
                case 3: {
                    if (this.constraintList[n].isNotNull()) continue block11;
                    this.checkConstraints[n4] = this.constraintList[n];
                    ++n4;
                }
            }
        }
    }

    void verifyConstraintsIntegrity() {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.getConstraintType() != 0 && constraint.getConstraintType() != 1) continue;
            if (constraint.getMain() != this.database.schemaManager.findUserTable(constraint.getMain().getName().name, constraint.getMain().getName().schema.name)) {
                throw Error.runtimeError(201, "FK mismatch : " + constraint.getName().name);
            }
            if (constraint.getRef() == this.database.schemaManager.findUserTable(constraint.getRef().getName().name, constraint.getRef().getName().schema.name)) continue;
            throw Error.runtimeError(201, "FK mismatch : " + constraint.getName().name);
        }
    }

    public Constraint[] getConstraints() {
        return this.constraintList;
    }

    public Constraint[] getFKConstraints() {
        return this.fkConstraints;
    }

    public Constraint getPrimaryConstraint() {
        return this.hasPrimaryKey() ? this.constraintList[0] : null;
    }

    void collectFKReadLocks(int[] nArray, OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        for (int i = 0; i < this.fkMainConstraints.length; ++i) {
            Constraint constraint = this.fkMainConstraints[i];
            Table table = constraint.getRef();
            int[] nArray2 = constraint.getMainColumns();
            if (table == this) continue;
            if (nArray == null) {
                int[] nArray3;
                if (!constraint.core.hasDeleteAction) continue;
                int[] nArray4 = nArray3 = constraint.getDeleteAction() == 0 ? null : constraint.getRefColumns();
                if (!orderedHashSet.add(table.getName())) continue;
                table.collectFKReadLocks(nArray3, orderedHashSet);
                continue;
            }
            if (!ArrayUtil.haveCommonElement(nArray, nArray2) || !orderedHashSet.add(table.getName())) continue;
            table.collectFKReadLocks(constraint.getRefColumns(), orderedHashSet);
        }
    }

    void collectFKWriteLocks(int[] nArray, OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        for (int i = 0; i < this.fkMainConstraints.length; ++i) {
            Constraint constraint = this.fkMainConstraints[i];
            Table table = constraint.getRef();
            int[] nArray2 = constraint.getMainColumns();
            if (table == this) continue;
            if (nArray == null) {
                int[] nArray3;
                if (!constraint.core.hasDeleteAction) continue;
                int[] nArray4 = nArray3 = constraint.getDeleteAction() == 0 ? null : constraint.getRefColumns();
                if (!orderedHashSet.add(table.getName())) continue;
                table.collectFKWriteLocks(nArray3, orderedHashSet);
                continue;
            }
            if (!ArrayUtil.haveCommonElement(nArray, nArray2) || !constraint.core.hasUpdateAction || !orderedHashSet.add(table.getName())) continue;
            table.collectFKWriteLocks(constraint.getRefColumns(), orderedHashSet);
        }
    }

    Constraint getNotNullConstraintForColumn(int n) {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.isNotNull() || constraint.notNullColumnIndex != n) continue;
            return constraint;
        }
        return null;
    }

    Constraint getUniqueConstraintForColumns(int[] nArray) {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.isUniqueWithColumns(nArray)) continue;
            return constraint;
        }
        return null;
    }

    Constraint getFKConstraintForColumns(Table table, int[] nArray, int[] nArray2) {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.isEquivalent(table, nArray, this, nArray2)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint getUniqueOrPKConstraintForIndex(Index index) {
        for (Constraint constraint : this.constraintList) {
            if (constraint.getMainIndex() != index || constraint.getConstraintType() != 2 && constraint.getConstraintType() != 4) continue;
            return constraint;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = this.constraintList.length;
        for (int i = n; i < n3; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.getConstraintType() != n2) continue;
            return i;
        }
        return -1;
    }

    public void addColumn(ColumnSchema columnSchema) {
        String string = columnSchema.getName().name;
        if (this.findColumn(string) >= 0) {
            throw Error.error(5504, string);
        }
        if (columnSchema.isIdentity()) {
            if (this.identityColumn != -1) {
                throw Error.error(5525, string);
            }
            this.identityColumn = this.columnCount;
            this.identitySequence = columnSchema.getIdentitySequence();
        }
        this.addColumnNoCheck(columnSchema);
    }

    public void addColumnNoCheck(ColumnSchema columnSchema) {
        this.columnList.add(columnSchema.getName().name, columnSchema);
        ++this.columnCount;
    }

    public boolean hasGeneratedColumn() {
        return this.hasGeneratedValues;
    }

    public boolean hasUpdatedColumn() {
        return this.hasUpdatedValues;
    }

    public boolean hasLobColumn() {
        return this.hasLobColumn;
    }

    public boolean hasIdentityColumn() {
        return this.identityColumn != -1;
    }

    public PeriodDefinition getSystemPeriod() {
        return this.systemPeriod;
    }

    public int getSystemPeriodStartIndex() {
        return this.systemPeriodStartColumn;
    }

    public int getSystemPeriodEndIndex() {
        return this.systemPeriodEndColumn;
    }

    public PeriodDefinition getApplicationPeriod() {
        return this.applicationPeriod;
    }

    void checkReferentialColumnsMatch(int[] nArray, Table table, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            Type type = this.colTypes[nArray[i]];
            Type type2 = table.colTypes[nArray2[i]];
            if (type.canCompareDirect(type2)) continue;
            throw Error.error(5562);
        }
    }

    Table moveDefinition(Session session, int n, ColumnSchema[] columnSchemaArray, Constraint constraint, Index index, int[] nArray, int n2, OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet, OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2) {
        int n3;
        Object object;
        Object object2;
        int n4;
        int n5;
        Table table;
        boolean bl;
        boolean bl2 = bl = constraint != null && constraint.getConstraintType() == 4;
        if (this.isText) {
            table = new TextTable(this.database, this.tableName, n);
            ((TextTable)table).dataSource = ((TextTable)this).dataSource;
            ((TextTable)table).isReversed = ((TextTable)this).isReversed;
            ((TextTable)table).isConnected = ((TextTable)this).isConnected;
        } else {
            table = new Table(this.database, this.tableName, n);
        }
        table.systemPeriod = this.systemPeriod;
        table.applicationPeriod = this.applicationPeriod;
        table.isSystemVersioned = this.isSystemVersioned;
        if (this.isTemp) {
            table.persistenceScope = this.persistenceScope;
        }
        table.tableSpace = this.tableSpace;
        for (n5 = 0; n5 < this.columnCount; ++n5) {
            n4 = ArrayUtil.find(nArray, n5);
            if (n4 >= 0) {
                if (n2 < 0) continue;
                if (n2 == 0) {
                    if (columnSchemaArray.length != 0) {
                        table.addColumn(columnSchemaArray[n4]);
                        continue;
                    }
                } else if (columnSchemaArray.length != 0) {
                    table.addColumn(columnSchemaArray[n4]);
                }
            }
            object2 = this.columnList.get(n5);
            object2 = ((ColumnSchema)object2).duplicate();
            ((ColumnSchema)object2).setPrimaryKey(false);
            table.addColumn((ColumnSchema)object2);
        }
        for (n4 = n5 = ArrayUtil.countSmallerElements(nArray, this.columnCount); n4 < nArray.length; ++n4) {
            table.addColumn(columnSchemaArray[n4]);
        }
        int[] nArray2 = null;
        object2 = this.getIndex(0).getName();
        if (this.hasPrimaryKey() && !orderedHashSet.contains(this.getPrimaryConstraint().getName())) {
            nArray2 = this.getPrimaryKey();
            nArray2 = ArrayUtil.toAdjustedColumnArray(nArray2, nArray, n2);
        } else if (bl) {
            nArray2 = constraint.getMainColumns();
            object2 = session.database.nameManager.newConstraintIndexName(this.tableName, constraint.getName(), session.database.sqlSysIndexNames);
        }
        table.createPrimaryKey((HsqlNameManager.HsqlName)object2, nArray2, false);
        for (int i = 1; i < this.indexList.length; ++i) {
            Index index2 = this.indexList[i];
            if (orderedHashSet2.contains(index2.getName())) continue;
            object = ArrayUtil.toAdjustedColumnArray(index2.getColumns(), nArray, n2);
            Index index3 = table.createIndexStructure(index2.getName(), (int[])object, index2.getColumnDesc(), null, false, index2.isUnique(), index2.isConstraint(), index2.isForward());
            index3.setClustered(index2.isClustered());
            table.addIndexStructure(index3);
        }
        if (index != null) {
            index.setTable(table);
            table.addIndexStructure(index);
        }
        HsqlArrayList<Object> hsqlArrayList = new HsqlArrayList<Object>();
        if (bl) {
            constraint.core.mainIndex = table.indexList[0];
            constraint.core.mainTable = table;
            constraint.core.mainTableName = table.tableName;
            hsqlArrayList.add(constraint);
        }
        for (n3 = 0; n3 < this.constraintList.length; ++n3) {
            object = this.constraintList[n3];
            if (orderedHashSet.contains(((Constraint)object).getName())) continue;
            object = ((Constraint)object).duplicate();
            ((Constraint)object).updateTable(session, this, table, nArray, n2);
            hsqlArrayList.add(object);
        }
        if (!bl && constraint != null) {
            constraint.updateTable(session, this, table, new int[0], 0);
            hsqlArrayList.add(constraint);
        }
        table.constraintList = new Constraint[hsqlArrayList.size()];
        hsqlArrayList.toArray(table.constraintList);
        table.updateConstraintLists();
        table.setBestRowIdentifiers();
        table.triggerList = this.triggerList;
        table.triggerLists = this.triggerLists;
        for (n3 = 0; n3 < table.constraintList.length; ++n3) {
            table.constraintList[n3].compile(session, table);
        }
        for (n3 = 0; n3 < table.columnCount; ++n3) {
            table.getColumn(n3).compile(session, table);
        }
        return table;
    }

    void checkColumnInCheckConstraint(int n) {
        for (Constraint constraint : this.constraintList) {
            if (constraint.getConstraintType() != 3 || constraint.isNotNull() || !constraint.hasColumn(n)) continue;
            HsqlNameManager.HsqlName hsqlName = constraint.getName();
            throw Error.error(5502, hsqlName.getSchemaQualifiedStatementName());
        }
    }

    void checkColumnInFKConstraint(int n) {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.hasColumn(n) || constraint.getConstraintType() != 1 && constraint.getConstraintType() != 0) continue;
            HsqlNameManager.HsqlName hsqlName = constraint.getName();
            throw Error.error(5533, hsqlName.getSchemaQualifiedStatementName());
        }
    }

    OrderedHashSet<Constraint> getDependentConstraints(int n) {
        OrderedHashSet<Constraint> orderedHashSet = new OrderedHashSet<Constraint>();
        for (Constraint constraint : this.constraintList) {
            if (!constraint.hasColumnOnly(n)) continue;
            orderedHashSet.add(constraint);
        }
        return orderedHashSet;
    }

    OrderedHashSet<Constraint> getContainingConstraints(int n) {
        OrderedHashSet<Constraint> orderedHashSet = new OrderedHashSet<Constraint>();
        for (Constraint constraint : this.constraintList) {
            if (!constraint.hasColumnPlus(n)) continue;
            orderedHashSet.add(constraint);
        }
        return orderedHashSet;
    }

    OrderedHashSet<HsqlNameManager.HsqlName> getContainingIndexNames(int n) {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        for (Index index : this.indexList) {
            if (ArrayUtil.find(index.getColumns(), n) == -1) continue;
            orderedHashSet.add(index.getName());
        }
        return orderedHashSet;
    }

    OrderedHashSet<Constraint> getDependentConstraints(Constraint constraint) {
        OrderedHashSet<Constraint> orderedHashSet = new OrderedHashSet<Constraint>();
        for (Constraint constraint2 : this.fkMainConstraints) {
            if (constraint2.core.uniqueName != constraint.getName()) continue;
            orderedHashSet.add(constraint2);
        }
        return orderedHashSet;
    }

    public OrderedHashSet<Constraint> getDependentExternalConstraints() {
        OrderedHashSet<Constraint> orderedHashSet = new OrderedHashSet<Constraint>();
        for (Constraint constraint : this.constraintList) {
            if (constraint.getConstraintType() != 1 && constraint.getConstraintType() != 0 || constraint.core.mainTable == constraint.core.refTable) continue;
            orderedHashSet.add(constraint);
        }
        return orderedHashSet;
    }

    public OrderedHashSet<HsqlNameManager.HsqlName> getUniquePKConstraintNames() {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        for (Constraint constraint : this.constraintList) {
            if (constraint.getConstraintType() != 2 && constraint.getConstraintType() != 4) continue;
            orderedHashSet.add(constraint.getName());
        }
        return orderedHashSet;
    }

    void checkColumnInFKConstraint(int n, int n2) {
        for (Constraint constraint : this.constraintList) {
            if (constraint.getConstraintType() != 0 || !constraint.hasColumn(n) || n2 != constraint.getUpdateAction() && n2 != constraint.getDeleteAction()) continue;
            HsqlNameManager.HsqlName hsqlName = constraint.getName();
            throw Error.error(5533, hsqlName.getSchemaQualifiedStatementName());
        }
    }

    public int getIdentityColumnIndex() {
        return this.identityColumn;
    }

    public int getColumnIndex(String string) {
        int n = this.findColumn(string);
        if (n == -1) {
            throw Error.error(5501, string);
        }
        return n;
    }

    public int findColumn(String string) {
        int n = this.columnList.getIndex(string);
        return n;
    }

    void resetDefaultFlags() {
        this.hasDefaultValues = false;
        this.hasGeneratedValues = false;
        this.hasUpdatedValues = false;
        this.hasNotNullColumns = false;
        this.hasDomainColumns = false;
        this.hasLobColumn = false;
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema columnSchema = this.getColumn(i);
            this.colNotNull[i] = columnSchema.isPrimaryKey() || !columnSchema.isNullable();
            this.colDefaults[i] = columnSchema.getDefaultExpression();
            this.colGenerated[i] = columnSchema.isGenerated();
            this.colUpdated[i] = columnSchema.isAutoUpdate();
            this.hasDefaultValues |= this.colDefaults[i] != null;
            this.hasGeneratedValues |= this.colGenerated[i];
            this.hasUpdatedValues |= this.colUpdated[i];
            this.hasNotNullColumns |= this.colNotNull[i];
            if (this.colTypes[i].isDomainType()) {
                this.hasDomainColumns = true;
            }
            if (!this.colTypes[i].isLobType()) continue;
            this.hasLobColumn = true;
        }
    }

    public int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    public boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    public Index getClusteredIndex() {
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!this.indexList[i].isClustered()) continue;
            return this.indexList[i];
        }
        return null;
    }

    synchronized Index getIndexForColumn(Session session, int n) {
        int n2 = this.bestIndexForColumn[n];
        if (n2 > -1) {
            return this.indexList[n2];
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 14: {
                Index index = this.createIndexForColumns(session, new int[]{n});
                return index;
            }
        }
        return null;
    }

    boolean isIndexed(int n) {
        return this.bestIndexForColumn[n] != -1;
    }

    int[] getUniqueNotNullColumnGroup(boolean[] blArray) {
        for (Constraint constraint : this.constraintList) {
            int[] nArray;
            if (!(constraint.getConstraintType() == 2 ? ArrayUtil.areAllIntIndexesInBooleanArray(nArray = constraint.getMainColumns(), this.colNotNull) && ArrayUtil.areAllIntIndexesInBooleanArray(nArray, blArray) : constraint.getConstraintType() == 4 && ArrayUtil.areAllIntIndexesInBooleanArray(nArray = constraint.getMainColumns(), blArray))) continue;
            return nArray;
        }
        return null;
    }

    boolean areColumnsNotNull(int[] nArray) {
        return ArrayUtil.areAllIntIndexesInBooleanArray(nArray, this.colNotNull);
    }

    public void createPrimaryKey() {
        this.createPrimaryKey(null, ValuePool.emptyIntArray, false);
    }

    public void createPrimaryKey(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) {
        if (nArray == null) {
            nArray = ValuePool.emptyIntArray;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.getColumn(nArray[i]).setPrimaryKey(true);
        }
        this.setColumnStructures();
        Object[] objectArray = new Type[nArray.length];
        ArrayUtil.projectRow(this.colTypes, nArray, objectArray);
        HsqlNameManager.HsqlName hsqlName2 = hsqlName;
        if (hsqlName2 == null) {
            hsqlName2 = this.database.nameManager.newAutoName("IDX", this.getSchemaName(), this.getName(), 20);
        }
        this.createPrimaryIndex(nArray, (Type[])objectArray, hsqlName2);
        this.setBestRowIdentifiers();
    }

    public void createPrimaryKeyConstraint(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) {
        this.createPrimaryKey(hsqlName, nArray, bl);
        Constraint constraint = new Constraint(hsqlName, this, this.getPrimaryIndex(), 4);
        this.addConstraint(constraint);
    }

    void setColumnStructures() {
        if (this.colTypes == null) {
            this.colTypes = new Type[this.columnCount];
        }
        this.colDefaults = new Expression[this.columnCount];
        this.colNotNull = new boolean[this.columnCount];
        this.emptyColumnCheckList = new boolean[this.columnCount];
        this.colGenerated = new boolean[this.columnCount];
        this.colUpdated = new boolean[this.columnCount];
        this.defaultColumnMap = new int[this.columnCount];
        this.systemPeriodStartColumn = 0;
        this.systemPeriodEndColumn = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            this.setSingleColumnTypeVars(i);
        }
        this.resetDefaultFlags();
    }

    void setColumnTypeVars(int n) {
        this.setSingleColumnTypeVars(n);
        this.resetDefaultFlags();
    }

    private void setSingleColumnTypeVars(int n) {
        Type type;
        ColumnSchema columnSchema = this.getColumn(n);
        this.colTypes[n] = type = columnSchema.getDataType();
        this.colNotNull[n] = columnSchema.isPrimaryKey() || !columnSchema.isNullable();
        this.defaultColumnMap[n] = n;
        if (columnSchema.isIdentity()) {
            this.identitySequence = columnSchema.getIdentitySequence();
            this.identityColumn = n;
        } else if (this.identityColumn == n) {
            this.identitySequence = null;
            this.identityColumn = -1;
        }
        this.colDefaults[n] = columnSchema.getDefaultExpression();
        this.colGenerated[n] = columnSchema.isGenerated();
        this.colUpdated[n] = columnSchema.isAutoUpdate();
        if (columnSchema.isSystemPeriod()) {
            int n2 = columnSchema.getSystemPeriodType();
            if (n2 == 1) {
                this.systemPeriodStartColumn = n;
            } else if (n2 == 2) {
                this.systemPeriodEndColumn = n;
            }
        }
    }

    public int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.columnCount];
    }

    boolean[] getColumnCheckList(int[] nArray) {
        boolean[] blArray = new boolean[this.columnCount];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n <= -1) continue;
            blArray[n] = true;
        }
        return blArray;
    }

    int[] findColumnIndexes(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.findColumn(stringArray[i]);
        }
        return nArray;
    }

    int[] getColumnIndexes(OrderedHashSet<String> orderedHashSet) {
        int[] nArray = new int[orderedHashSet.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getColumnIndex(orderedHashSet.get(i));
            if (nArray[i] != -1) continue;
            throw Error.error(5501, orderedHashSet.get(i));
        }
        return nArray;
    }

    public ColumnSchema getColumn(int n) {
        return this.columnList.get(n);
    }

    public void getColumnNames(boolean[] blArray, Set<HsqlNameManager.HsqlName> set) {
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            set.add(this.columnList.get(i).getName());
        }
    }

    public OrderedHashSet<HsqlNameManager.HsqlName> getColumnNameSet() {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        for (int i = 0; i < this.columnCount; ++i) {
            orderedHashSet.add(this.columnList.get(i).getName());
        }
        return orderedHashSet;
    }

    public String[] getColumnLabels() {
        String[] stringArray = new String[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            stringArray[i] = this.columnList.get((int)i).getName().name;
        }
        return stringArray;
    }

    public Object[] getNewRowData(Session session) {
        Object[] objectArray = new Object[this.columnCount];
        if (this.hasDefaultValues) {
            for (int i = 0; i < this.columnCount; ++i) {
                Expression expression = this.colDefaults[i];
                if (expression == null) continue;
                objectArray[i] = expression.getValue(session, this.colTypes[i]);
            }
        }
        return objectArray;
    }

    boolean hasTrigger(int n) {
        return this.triggerLists[n].length != 0;
    }

    void addTrigger(TriggerDef triggerDef, HsqlNameManager.HsqlName hsqlName) {
        int n;
        int n2 = this.triggerList.length;
        if (hsqlName != null && (n = this.getTriggerIndex(hsqlName.name)) != -1) {
            n2 = n + 1;
        }
        this.triggerList = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerList, triggerDef, n2, 1);
        TriggerDef[] triggerDefArray = this.triggerLists[triggerDef.triggerType];
        n2 = triggerDefArray.length;
        if (hsqlName != null) {
            for (int i = 0; i < triggerDefArray.length; ++i) {
                TriggerDef triggerDef2 = triggerDefArray[i];
                if (!triggerDef2.getName().name.equals(hsqlName.name)) continue;
                n2 = i + 1;
                break;
            }
        }
        triggerDefArray = (TriggerDef[])ArrayUtil.toAdjustedArray(triggerDefArray, triggerDef, n2, 1);
        this.triggerLists[triggerDef.triggerType] = triggerDefArray;
    }

    TriggerDef getTrigger(String string) {
        for (int i = this.triggerList.length - 1; i >= 0; --i) {
            if (!this.triggerList[i].getName().name.equals(string)) continue;
            return this.triggerList[i];
        }
        return null;
    }

    public int getTriggerIndex(String string) {
        for (int i = 0; i < this.triggerList.length; ++i) {
            if (!this.triggerList[i].getName().name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    void removeTrigger(TriggerDef triggerDef) {
        int n;
        TriggerDef triggerDef2 = null;
        for (n = 0; n < this.triggerList.length; ++n) {
            triggerDef2 = this.triggerList[n];
            if (!triggerDef2.getName().name.equals(triggerDef.getName().name)) continue;
            triggerDef2.terminate();
            this.triggerList = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerList, null, n, -1);
            break;
        }
        if (triggerDef2 == null) {
            return;
        }
        n = triggerDef2.triggerType;
        for (int i = 0; i < this.triggerLists[n].length; ++i) {
            triggerDef2 = this.triggerLists[n][i];
            if (!triggerDef2.getName().name.equals(triggerDef.getName().name)) continue;
            this.triggerLists[n] = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerLists[n], null, i, -1);
            break;
        }
    }

    void releaseTriggers() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < this.triggerLists[i].length; ++j) {
                this.triggerLists[i][j].terminate();
            }
            this.triggerLists[i] = TriggerDef.emptyArray;
        }
        this.triggerList = TriggerDef.emptyArray;
    }

    void terminateTriggers() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < this.triggerLists[i].length; ++j) {
                this.triggerLists[i][j].terminate();
            }
        }
    }

    int getIndexIndex(String string) {
        Index[] indexArray = this.indexList;
        for (int i = 0; i < indexArray.length; ++i) {
            if (!string.equals(indexArray[i].getName().name)) continue;
            return i;
        }
        return -1;
    }

    Index getIndex(String string) {
        Index[] indexArray = this.indexList;
        int n = this.getIndexIndex(string);
        return n == -1 ? null : indexArray[n];
    }

    Index getUserIndex(String string) {
        Index[] indexArray = this.indexList;
        for (int i = 0; i < indexArray.length; ++i) {
            if (!string.equals(indexArray[i].getName().name) || indexArray[i].isConstraint()) continue;
            return indexArray[i];
        }
        return null;
    }

    Index getSystemIndex(String string) {
        Index[] indexArray = this.indexList;
        for (int i = 0; i < indexArray.length; ++i) {
            if (!string.equals(indexArray[i].getName().name) || !indexArray[i].isConstraint()) continue;
            return indexArray[i];
        }
        return null;
    }

    int getConstraintIndex(String string) {
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            if (!this.constraintList[i].getName().name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        return n < 0 ? null : this.constraintList[n];
    }

    public Constraint getUniqueConstraintForIndex(Index index) {
        for (Constraint constraint : this.constraintList) {
            if (constraint.getMainIndex() != index || constraint.getConstraintType() != 4 && constraint.getConstraintType() != 2) continue;
            return constraint;
        }
        return null;
    }

    void removeConstraint(String string) {
        int n = this.getConstraintIndex(string);
        if (n != -1) {
            this.removeConstraint(n);
        }
    }

    void removeConstraint(int n) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, null, n, -1);
        this.updateConstraintLists();
    }

    void renameColumn(ColumnSchema columnSchema, String string, boolean bl) {
        String string2 = columnSchema.getName().name;
        int n = this.getColumnIndex(string2);
        this.columnList.setKeyAt(n, string);
        columnSchema.getName().rename(string, bl);
    }

    void renameColumn(ColumnSchema columnSchema, HsqlNameManager.HsqlName hsqlName) {
        String string = columnSchema.getName().name;
        int n = this.getColumnIndex(string);
        if (this.findColumn(hsqlName.name) != -1) {
            throw Error.error(5504);
        }
        this.columnList.setKeyAt(n, hsqlName.name);
        columnSchema.getName().rename(hsqlName);
    }

    public TriggerDef[] getTriggers() {
        return this.triggerList;
    }

    public boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    public boolean isInsertable() {
        return this.isWritable();
    }

    public boolean isUpdatable() {
        return this.isWritable();
    }

    public boolean isTriggerInsertable() {
        return false;
    }

    public boolean isTriggerUpdatable() {
        return false;
    }

    public boolean isTriggerDeletable() {
        return false;
    }

    public int[] getUpdatableColumns() {
        return this.defaultColumnMap;
    }

    public Table getBaseTable() {
        return this;
    }

    public int[] getBaseTableColumnMap() {
        return this.defaultColumnMap;
    }

    Index createIndexForColumns(Session session, int[] nArray) {
        Index index = null;
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("IDX_T", this.getSchemaName(), this.getName(), 20);
        try {
            index = this.createAndAddIndexStructure(session, hsqlName, nArray, null, null, false, false, false);
        }
        catch (Throwable throwable) {
            return null;
        }
        return index;
    }

    void fireTriggers(Session session, int n, RowSetNavigatorDataChange rowSetNavigatorDataChange) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef triggerDef : this.triggerLists[n]) {
            boolean bl = triggerDef instanceof TriggerDefSQL;
            if (triggerDef.hasOldTable()) {
                // empty if block
            }
            triggerDef.pushPair(session, null, null);
        }
    }

    void fireTriggers(Session session, int n, RowSetNavigator rowSetNavigator) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef triggerDef : this.triggerLists[n]) {
            boolean bl = triggerDef instanceof TriggerDefSQL;
            if (triggerDef.hasOldTable()) {
                // empty if block
            }
            triggerDef.pushPair(session, null, null);
        }
    }

    void fireTriggers(Session session, int n, Object[] objectArray, Object[] objectArray2, int[] nArray) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef triggerDef : this.triggerLists[n]) {
            boolean bl = triggerDef instanceof TriggerDefSQL;
            if (nArray != null && triggerDef.getUpdateColumnIndexes() != null && !ArrayUtil.haveCommonElement(triggerDef.getUpdateColumnIndexes(), nArray)) continue;
            if (triggerDef.isForEachRow()) {
                switch (triggerDef.triggerType) {
                    case 6: {
                        break;
                    }
                    case 3: {
                        if (bl) break;
                        objectArray2 = (Object[])ArrayUtil.duplicateArray(objectArray2);
                        break;
                    }
                    case 5: {
                        if (bl) break;
                        objectArray = (Object[])ArrayUtil.duplicateArray(objectArray);
                        objectArray2 = (Object[])ArrayUtil.duplicateArray(objectArray2);
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 8: {
                        if (bl) break;
                        objectArray = (Object[])ArrayUtil.duplicateArray(objectArray);
                    }
                }
                triggerDef.pushPair(session, objectArray, objectArray2);
                continue;
            }
            triggerDef.pushPair(session, null, null);
        }
    }

    public void enforceRowConstraints(Session session, Object[] objectArray) {
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema columnSchema;
            Object object;
            Type type = this.colTypes[i];
            if (this.hasDomainColumns && type.isDomainType()) {
                object = type.userTypeModifier.getConstraints();
                columnSchema = this.getColumn(i);
                for (int j = 0; j < ((Constraint[])object).length; ++j) {
                    object[j].checkCheckConstraint(session, this, columnSchema, objectArray[i]);
                }
            }
            if (!this.colNotNull[i] || objectArray[i] != null) continue;
            Constraint constraint = this.getNotNullConstraintForColumn(i);
            if (constraint == null && ArrayUtil.find(this.getPrimaryKey(), i) > -1) {
                constraint = this.getPrimaryConstraint();
            }
            object = constraint == null ? "" : constraint.getName().name;
            columnSchema = this.getColumn(i);
            String[] stringArray = new String[]{object, this.tableName.statementName, columnSchema.getName().statementName};
            throw Error.error(null, 10, 3, stringArray);
        }
    }

    public void enforceTypeLimits(Session session, Object[] objectArray) {
        int n;
        try {
            for (n = 0; n < this.columnCount; ++n) {
                objectArray[n] = this.colTypes[n].convertToTypeLimits(session, objectArray[n]);
            }
        }
        catch (HsqlException hsqlException) {
            int n2 = hsqlException.getErrorCode();
            if (n2 == -3401 || n2 == -3403 || n2 == -3408) {
                ColumnSchema columnSchema = this.getColumn(n);
                String[] stringArray = new String[]{"size limit: " + this.colTypes[n].precision, this.tableName.statementName, columnSchema.getName().statementName};
                throw Error.error(hsqlException, n2, 3, stringArray);
            }
            throw hsqlException;
        }
    }

    int indexTypeForColumn(Session session, int n) {
        int n2 = this.bestIndexForColumn[n];
        if (n2 > -1) {
            return this.indexList[n2].isUnique() && this.indexList[n2].getColumnCount() == 1 ? 2 : 1;
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 14: {
                return 1;
            }
        }
        return 0;
    }

    synchronized Index getIndexForColumns(int[] nArray) {
        int n = this.bestIndexForColumn[nArray[0]];
        if (n > -1) {
            return this.indexList[n];
        }
        return null;
    }

    Index getFullIndexForColumns(int[] nArray) {
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!ArrayUtil.haveEqualArrays(this.indexList[i].getColumns(), nArray, nArray.length)) continue;
            return this.indexList[i];
        }
        return null;
    }

    Index getIndexForAllColumns(int[] nArray) {
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!ArrayUtil.haveEqualSets(this.indexList[i].getColumns(), nArray, nArray.length)) continue;
            return this.indexList[i];
        }
        return null;
    }

    synchronized Index.IndexUse[] getIndexForColumns(Session session, OrderedIntHashSet orderedIntHashSet, int n, boolean bl) {
        if (orderedIntHashSet.isEmpty()) {
            return Index.emptyUseArray;
        }
        Index.IndexUse[] indexUseArray = this.findIndexForColumns(session, orderedIntHashSet, n, bl);
        if (indexUseArray.length == 0) {
            Index index = null;
            switch (this.tableType) {
                case 1: 
                case 2: 
                case 3: 
                case 8: 
                case 11: 
                case 14: {
                    index = this.createIndexForColumns(session, orderedIntHashSet.toArray());
                }
            }
            if (index != null) {
                indexUseArray = index.asArray();
            }
        }
        return indexUseArray;
    }

    Index.IndexUse[] findIndexForColumns(Session session, OrderedIntHashSet orderedIntHashSet, int n, boolean bl) {
        Index.IndexUse[] indexUseArray = Index.emptyUseArray;
        if (orderedIntHashSet.isEmpty()) {
            return Index.emptyUseArray;
        }
        int n2 = this.indexList.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            Index index = this.getIndex(i);
            int[] nArray = index.getColumns();
            int n4 = n3 = bl ? orderedIntHashSet.getOrderedStartMatchCount(nArray) : orderedIntHashSet.getStartMatchCount(nArray);
            if (n3 == 0) continue;
            if (n3 == orderedIntHashSet.size()) {
                return index.asArray();
            }
            if (n3 == index.getColumnCount() && index.isUnique()) {
                return index.asArray();
            }
            if (indexUseArray.length == 0 && n3 == index.getColumnCount()) {
                indexUseArray = index.asArray();
                continue;
            }
            Index.IndexUse[] indexUseArray2 = (Index.IndexUse[])ArrayUtil.resizeArray(indexUseArray, indexUseArray.length + 1);
            indexUseArray2[indexUseArray2.length - 1] = new Index.IndexUse(index, n3);
            indexUseArray = indexUseArray2;
        }
        return indexUseArray;
    }

    public Index getFullIndex(Session session) {
        if (this.fullIndex == null) {
            this.fullIndex = this.getFullIndexForColumns(this.defaultColumnMap);
            if (this.fullIndex == null) {
                this.fullIndex = this.createIndexForColumns(session, this.defaultColumnMap);
            }
        }
        return this.fullIndex;
    }

    public final long[] getIndexRootsArray() {
        PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(this);
        long[] lArray = new long[this.indexList.length];
        for (int i = 0; i < this.indexList.length; ++i) {
            CachedObject cachedObject = persistentStore.getAccessor(this.indexList[i]);
            lArray[i] = cachedObject == null ? -1L : cachedObject.getPos();
        }
        return lArray;
    }

    public void setIndexRoots(long[] lArray) {
        PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(this);
        long l = persistentStore.elementCount();
        persistentStore.setAccessors(0L, lArray, l);
    }

    void setIndexRoots(Session session, String string) {
        long l;
        int n;
        if (!this.isCached) {
            throw Error.error(5501, this.tableName.name);
        }
        int n2 = this.getIndexCount();
        ParserDQL parserDQL = new ParserDQL(session, new Scanner(session, string), null);
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n2];
        long l2 = -1L;
        parserDQL.read();
        for (n = 0; n < n2; ++n) {
            lArray[n] = l = parserDQL.readBigint();
        }
        for (n = 0; n < n2; ++n) {
            lArray2[n] = l = parserDQL.readBigint();
        }
        l2 = parserDQL.readBigint();
        PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(this);
        persistentStore.setAccessors(0L, lArray, l2);
    }

    public void generateAndCheckData(Session session, Object[] objectArray) {
        if (this.hasGeneratedValues || this.systemPeriod != null) {
            this.setGeneratedColumns(session, objectArray);
        }
        this.enforceTypeLimits(session, objectArray);
        if (this.hasDomainColumns || this.hasNotNullColumns) {
            this.enforceRowConstraints(session, objectArray);
        }
    }

    public void generateDefaultForNull(Object[] objectArray) {
        if (this.hasNotNullColumns) {
            for (int i = 0; i < this.colDefaults.length; ++i) {
                if (objectArray[i] != null || !this.colNotNull[i] || this.colDefaults[i] == null || this.colDefaults[i].getType() != 1) continue;
                objectArray[i] = this.colDefaults[i].getValue(null);
            }
        }
    }

    Row insertSingleRow(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray) {
        this.generateAndCheckData(session, objectArray);
        if (this.isView) {
            return null;
        }
        Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, true);
        session.addInsertAction(this, persistentStore, row, nArray);
        return row;
    }

    Row insertSystemVersionHistoryRow(Session session, PersistentStore persistentStore, Object[] objectArray) {
        TimestampData timestampData = session.getTransactionUTC();
        if (timestampData.equals(objectArray[this.systemPeriodStartColumn])) {
            return null;
        }
        Object[] objectArray2 = (Object[])ArrayUtil.duplicateArray(objectArray);
        objectArray2[this.systemPeriodEndColumn] = timestampData;
        Row row = (Row)persistentStore.getNewCachedObject(session, objectArray2, true);
        session.database.txManager.addInsertAction(session, this, persistentStore, row, null);
        return row;
    }

    void insertIntoTable(Session session, Result result) {
        PersistentStore persistentStore = this.getRowStore(session);
        RowSetNavigator rowSetNavigator = result.initialiseNavigator();
        while (rowSetNavigator.next()) {
            Object[] objectArray = rowSetNavigator.getCurrent();
            Object[] objectArray2 = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.columnCount);
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = this.colTypes[i].convertToTypeLimits(session, objectArray2[i]);
            }
            this.insertData(session, persistentStore, objectArray2, true);
        }
    }

    public void insertNoCheckFromLog(Session session, Object[] objectArray) {
        this.systemUpdateIdentityValue(objectArray);
        PersistentStore persistentStore = this.getRowStore(session);
        Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, true);
        boolean bl = true;
        if (this.isSystemVersioned) {
            bl = objectArray[this.systemPeriodEndColumn].equals(DateTimeType.epochLimitTimestamp);
        }
        this.database.txManager.addInsertAction(session, this, persistentStore, row, null);
    }

    public int insertSys(Session session, PersistentStore persistentStore, Result result) {
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n = 0;
        while (rowSetNavigator.next()) {
            this.insertSys(session, persistentStore, rowSetNavigator.getCurrent());
            ++n;
        }
        return n;
    }

    void insertResult(Session session, PersistentStore persistentStore, Result result) {
        RowSetNavigator rowSetNavigator = result.initialiseNavigator();
        while (rowSetNavigator.next()) {
            Object[] objectArray = rowSetNavigator.getCurrent();
            Object[] objectArray2 = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.columnCount);
            this.insertData(session, persistentStore, objectArray2, true);
        }
    }

    public void insertFromScript(Session session, PersistentStore persistentStore, Object[] objectArray) {
        boolean bl = true;
        this.systemUpdateIdentityValue(objectArray);
        if (this.isSystemVersioned) {
            bl = objectArray[this.systemPeriodEndColumn].equals(DateTimeType.epochLimitTimestamp);
        }
        this.insertData(session, persistentStore, objectArray, bl);
    }

    public void insertData(Session session, PersistentStore persistentStore, Object[] objectArray, boolean bl) {
        Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, false);
        persistentStore.indexRow(session, row);
    }

    public void insertSys(Session session, PersistentStore persistentStore, Object[] objectArray) {
        Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, false);
        persistentStore.indexRow(session, row);
    }

    protected void setIdentityColumn(Session session, Object[] objectArray) {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (this.identitySequence.getName() == null) {
                if (number == null) {
                    number = this.identitySequence.getValueObject();
                    objectArray[this.identityColumn] = number;
                } else {
                    this.identitySequence.userUpdate(number.longValue());
                }
            } else if (number == null) {
                number = session.sessionData.getSequenceValue(this.identitySequence);
                objectArray[this.identityColumn] = number;
            }
            if (session != null) {
                session.setLastIdentity(number);
            }
        }
    }

    public Object getColumnDefaultOrGeneratedValue(Session session, ColumnSchema columnSchema, Object[] objectArray) {
        Object object = null;
        if (columnSchema.isGenerated()) {
            Expression expression = columnSchema.getGeneratingExpression();
            RangeIterator rangeIterator = session.sessionContext.getCheckIterator(this.getDefaultRanges()[0]);
            rangeIterator.setCurrent(objectArray);
            object = expression.getValue(session, columnSchema.getDataType());
        } else if (columnSchema.isSystemPeriod()) {
            switch (columnSchema.getSystemPeriodType()) {
                case 1: {
                    object = session.getTransactionUTC();
                    break;
                }
                case 2: {
                    object = DateTimeType.epochLimitTimestamp;
                }
            }
        } else {
            object = columnSchema.getDefaultValue(session);
        }
        return object;
    }

    public void setGeneratedColumns(Session session, Object[] objectArray) {
        if (this.hasGeneratedValues) {
            for (int i = 0; i < this.colGenerated.length; ++i) {
                if (!this.colGenerated[i]) continue;
                ColumnSchema columnSchema = this.getColumn(i);
                Expression expression = columnSchema.getGeneratingExpression();
                RangeIterator rangeIterator = session.sessionContext.getCheckIterator(this.getDefaultRanges()[0]);
                rangeIterator.setCurrent(objectArray);
                objectArray[i] = expression.getValue(session, this.colTypes[i]);
            }
        }
        if (this.systemPeriod != null) {
            objectArray[this.systemPeriodStartColumn] = session.getTransactionUTC();
            objectArray[this.systemPeriodEndColumn] = DateTimeType.epochLimitTimestamp;
        }
    }

    public void setUpdatedColumns(Session session, Object[] objectArray, int[] nArray) {
        if (this.hasUpdatedValues) {
            for (int i = 0; i < this.colUpdated.length; ++i) {
                if (!this.colUpdated[i] || ArrayUtil.find(nArray, i) >= 0) continue;
                Expression expression = this.getColumn(i).getUpdateExpression();
                objectArray[i] = expression.getValue(session, this.colTypes[i]);
            }
        }
    }

    public void systemSetIdentityColumn(Session session, Object[] objectArray) {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (number == null) {
                number = this.identitySequence.getValueObject();
                objectArray[this.identityColumn] = number;
            } else if (this.identitySequence.getName() == null) {
                this.identitySequence.userUpdate(number.longValue());
            }
        }
    }

    public void systemUpdateIdentityValue(Object[] objectArray) {
        Number number;
        if (this.identityColumn != -1 && (number = (Number)objectArray[this.identityColumn]) != null && this.identitySequence.getName() == null) {
            this.identitySequence.systemUpdate(number.longValue());
        }
    }

    public Row getDeleteRowFromLog(Session session, Object[] objectArray) {
        Row row = null;
        PersistentStore persistentStore = this.getRowStore(session);
        if (this.hasPrimaryKey()) {
            Index index = this.getPrimaryIndex();
            int[] nArray = index.getDefaultColumnMap();
            RowIterator rowIterator = index.findFirstRow(session, persistentStore, objectArray, nArray);
            rowIterator.next();
            row = rowIterator.getCurrentRow();
            rowIterator.release();
        } else if (this.bestIndex == null) {
            RowIterator rowIterator = this.rowIterator(session);
            while (rowIterator.next() && Table.compareRows(session, (row = rowIterator.getCurrentRow()).getData(), objectArray, this.defaultColumnMap, this.colTypes) != 0) {
            }
            rowIterator.release();
        } else {
            RowIterator rowIterator = this.bestIndex.findFirstRow(session, persistentStore, objectArray);
            while (rowIterator.next()) {
                row = rowIterator.getCurrentRow();
                Object[] objectArray2 = row.getData();
                if (this.bestIndex.compareRowNonUnique(session, objectArray2, objectArray, this.bestIndex.getColumns()) != 0) {
                    row = null;
                    break;
                }
                if (Table.compareRows(session, objectArray2, objectArray, this.defaultColumnMap, this.colTypes) != 0) continue;
                break;
            }
            rowIterator.release();
        }
        return row;
    }

    public RowIterator rowIteratorClustered(Session session) {
        PersistentStore persistentStore = this.getRowStore(session);
        Index index = this.getClusteredIndex();
        if (index == null) {
            index = this.getPrimaryIndex();
        }
        return index.firstRow(session, persistentStore, null, 0, null);
    }

    public RowIterator rowIteratorForScript(PersistentStore persistentStore) {
        Index index = this.getClusteredIndex();
        if (index == null) {
            index = this.getPrimaryIndex();
        }
        return index.firstRow(persistentStore);
    }

    @Override
    public PersistentStore getRowStore(Session session) {
        if (this.store != null) {
            return this.store;
        }
        if (this.isSessionBased) {
            return session.sessionData.persistentStoreCollection.getStore(this);
        }
        return this.database.persistentStoreCollection.getStore(this);
    }

    public QueryExpression getQueryExpression() {
        return null;
    }

    public Expression getDataExpression() {
        return null;
    }

    public void prepareTable(Session session) {
    }

    public void materialise(Session session) {
    }

    public void materialiseCorrelated(Session session) {
    }
}

