/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.Label_;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.service.ImageService;
import org.dbgl.service.TextService;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class SizeControlledPagedDialog<T>
extends SizeControlledButtonDialog<T> {
    protected Tree tree_;
    protected ScrolledComposite rightComposite_;
    private Map<String, BiFunction<TemplateProfileBase, Composite, Composite>> pageGenerators_ = new HashMap<String, BiFunction<TemplateProfileBase, Composite, Composite>>();
    private Map<String, Composite> pages_ = new HashMap<String, Composite>();

    protected SizeControlledPagedDialog(Shell parent, String dialogName) {
        super(parent, dialogName);
    }

    @Override
    protected void onShellInit() {
        super.onShellInit();
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        this.contents_.setLayout(layout);
        SashForm sash = SizeControlledPagedDialog.createSashForm(this.contents_);
        sash.setLayoutData(new GridData(4, 4, true, true));
        sash.setLayout(new FillLayout());
        Composite leftComposite = Composite_.on(sash).layout(new FillLayout(512)).build();
        this.tree_ = SizeControlledPagedDialog.createTree(leftComposite, 2816);
        this.rightComposite_ = SizeControlledPagedDialog.createScrolledComposite(sash, 512);
        this.rightComposite_.setExpandVertical(true);
        this.rightComposite_.setExpandHorizontal(true);
        this.rightComposite_.setLayout(new GridLayout(1, true));
        this.rightComposite_.addControlListener(ControlListener.controlResizedAdapter(e -> {
            Control ctrl = this.rightComposite_.getContent();
            if (ctrl != null) {
                Rectangle r = this.rightComposite_.getClientArea();
                this.rightComposite_.setMinSize(ctrl.computeSize(r.width, -1));
            }
        }));
        sash.setWeights(22, 78);
    }

    protected void renderPage(TemplateProfileBase configurable, Widget item) {
        String key = (String)item.getData();
        if (this.pages_.containsKey(key) && this.pages_.get(key).isVisible()) {
            return;
        }
        this.pages_.values().stream().filter(x -> x.isVisible()).findAny().ifPresent(x -> {
            x.setVisible(false);
            ((GridData)x.getLayoutData()).exclude = true;
        });
        Composite page = this.pages_.computeIfAbsent(key, k -> this.pageGenerators_.get(k).apply(configurable, this.rightComposite_));
        page.setVisible(true);
        ((GridData)page.getLayoutData()).exclude = false;
        page.pack();
        this.rightComposite_.setContent(page);
        this.rightComposite_.setMinSize(page.computeSize(this.rightComposite_.getClientArea().width, -1));
    }

    protected void computeAllPages(TemplateProfileBase configurable) {
        this.pageGenerators_.keySet().forEach(key -> this.computePage(configurable, (String)key));
    }

    protected Composite computePage(TemplateProfileBase configurable, String key) {
        return this.pages_.computeIfAbsent(key, k -> {
            Composite page = this.pageGenerators_.get(k).apply(configurable, this.rightComposite_);
            page.setVisible(false);
            ((GridData)page.getLayoutData()).exclude = true;
            return page;
        });
    }

    protected Composite createPage(String key, Composite composite, int numColumns) {
        Composite page = Composite_.on(composite).grabAllSpace().pageLayout(numColumns).build();
        Chain.on(page).lbl(l -> (Label_.Builder)l.key(key).large().horSpan(numColumns)).lbl(l -> (Label_.Builder)((Label_.Builder)l.style(258)).grabHorSpace().horSpan(numColumns)).build();
        return page;
    }

    protected Composite createPage(String parentKey, String childKey, Composite composite, int numColumns) {
        Composite page = Composite_.on(composite).grabAllSpace().pageLayout(numColumns).build();
        Chain.on(page).lbl(l -> (Label_.Builder)l.txt(TextService.getInstance().get(parentKey) + " - " + TextService.getInstance().get(childKey)).large().horSpan(numColumns)).lbl(l -> (Label_.Builder)((Label_.Builder)l.style(258)).grabHorSpace().horSpan(numColumns)).build();
        return page;
    }

    protected TreeItem addPageGenerator(String key, BiFunction<TemplateProfileBase, Composite, Composite> pageGenerator) {
        this.pageGenerators_.put(key, pageGenerator);
        TreeItem treeItem = new TreeItem(this.tree_, 0);
        treeItem.setData(key);
        treeItem.setText(TextService.getInstance().get(key));
        String img = "bs/" + key.substring(key.lastIndexOf(46) + 1) + ".png";
        treeItem.setImage(ImageService.getResourceImage(this.getParent().getDisplay(), img));
        return treeItem;
    }

    protected TreeItem addPageGenerator(TreeItem parentItem, String key, BiFunction<TemplateProfileBase, Composite, Composite> pageGenerator) {
        this.pageGenerators_.put(key, pageGenerator);
        TreeItem treeItem = new TreeItem(parentItem, 0);
        treeItem.setData(key);
        treeItem.setText(TextService.getInstance().get(key));
        return treeItem;
    }

    protected TreeItem getreeItemByComposite(Composite composite) {
        String key = this.pages_.entrySet().stream().filter(x -> x.getValue() == composite).map(x -> (String)x.getKey()).findFirst().orElse(null);
        return Stream.of(this.tree_.getItems()).filter(x -> x.getData().equals(key)).findFirst().orElse(null);
    }

    protected TreeItem getTreeItemByControl(Control control) {
        Composite parent;
        for (parent = control.getParent(); parent != null && parent.getParent() != this.rightComposite_; parent = parent.getParent()) {
        }
        return this.getreeItemByComposite(parent);
    }
}

