/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.apache.commons.lang3.BooleanUtils;
import org.dbgl.service.ITextService;
import org.dbgl.service.ImageService;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SearchEngineSelector {
    private final Display display_;
    private final ITextService text_;
    private final SettingsService settings_;
    private final ToolItem toolItem_;
    private final boolean addGameWizard_;

    public SearchEngineSelector(final ToolBar toolBar, boolean addGameWizard) {
        this.display_ = toolBar.getDisplay();
        this.text_ = TextService.getInstance();
        this.settings_ = SettingsService.getInstance();
        this.addGameWizard_ = addGameWizard;
        WebSearchEngine defaultEngine = WebSearchEngine.getBySimpleName(this.settings_.getValue("gui", "searchengine"));
        if (defaultEngine == null) {
            defaultEngine = SettingsService.availableWebSearchEngines().get(0);
        }
        this.toolItem_ = new ToolItem(toolBar, 4);
        this.toolItem_.setImage(ImageService.getResourceImage(this.display_, defaultEngine.getIcon()));
        this.toolItem_.setToolTipText(this.text_.get("dialog.profile.consultsearchengine", new String[]{defaultEngine.getName()}));
        final Menu menu = new Menu(toolBar.getShell(), 8);
        for (final WebSearchEngine engine : SettingsService.availableWebSearchEngines()) {
            MenuItem item = new MenuItem(menu, 8);
            item.setImage(ImageService.getResourceImage(this.display_, engine.getIcon()));
            item.setText(engine.getName());
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent event) {
                    SearchEngineSelector.this.toolItem_.setImage(((MenuItem)event.widget).getImage());
                    SearchEngineSelector.this.toolItem_.setToolTipText(SearchEngineSelector.this.text_.get("dialog.profile.consultsearchengine", new String[]{engine.getName()}));
                    SearchEngineSelector.this.toolItem_.setData("selected", true);
                    SearchEngineSelector.this.settings_.setValue("gui", "searchengine", engine.getSimpleName());
                    if (SearchEngineSelector.this.addGameWizard_) {
                        SearchEngineSelector.this.settings_.setBooleanValue("addgamewizard", "consultsearchengine", true);
                    }
                }
            });
        }
        this.toolItem_.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4 && SearchEngineSelector.this.toolItem_.getData("profile") == null) {
                    Rectangle rect = SearchEngineSelector.this.toolItem_.getBounds();
                    Point pt = toolBar.toDisplay(new Point(rect.x, rect.y + rect.height));
                    menu.setLocation(pt.x, pt.y);
                    menu.setVisible(true);
                }
            }
        });
    }

    public void addToggleSelectionListener(boolean initialValue) {
        if (!initialValue) {
            this.toolItem_.setImage(ImageService.createDisabledImage(ImageService.getResourceImage(this.display_, WebSearchEngine.getBySimpleName(this.settings_.getValue("gui", "searchengine")).getIcon())));
        }
        this.toolItem_.setData("selected", initialValue);
        this.toolItem_.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (event.detail != 4) {
                    WebSearchEngine engine = WebSearchEngine.getBySimpleName(SearchEngineSelector.this.settings_.getValue("gui", "searchengine"));
                    boolean selected = (Boolean)SearchEngineSelector.this.toolItem_.getData("selected") == false;
                    SearchEngineSelector.this.toolItem_.setImage(selected ? ImageService.getResourceImage(SearchEngineSelector.this.display_, engine.getIcon()) : ImageService.createDisabledImage(ImageService.getResourceImage(SearchEngineSelector.this.display_, engine.getIcon())));
                    SearchEngineSelector.this.toolItem_.setData("selected", selected);
                    if (SearchEngineSelector.this.addGameWizard_) {
                        SearchEngineSelector.this.settings_.setBooleanValue("addgamewizard", "consultsearchengine", selected);
                    }
                }
            }
        });
    }

    public boolean isSelected() {
        return BooleanUtils.isTrue((Boolean)this.toolItem_.getData("selected"));
    }

    public ToolItem getToolItem() {
        return this.toolItem_;
    }
}

