/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import org.apache.commons.lang3.StringUtils;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.dialog.EditImgSizeDialog;
import org.dbgl.model.conf.mount.DirMount;
import org.dbgl.model.conf.mount.ImageMount;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.model.conf.mount.OverlayMount;
import org.dbgl.model.conf.mount.PhysFsMount;
import org.dbgl.model.factory.MountFactory;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditMountDialog
extends SizeControlledButtonDialog<String> {
    private final String mount_;
    private final char driveletter_;

    public EditMountDialog(Shell parent, String mount, char driveletter) {
        super(parent, "mountdialog");
        this.mount_ = mount;
        this.driveletter_ = driveletter;
    }

    @Override
    protected String getDialogTitle() {
        return this.mount_ == null ? this.text_.get("dialog.mount.title.add") : this.text_.get("dialog.mount.title.edit");
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout(new GridLayout(2, false));
        final Combo driveletter = Chain.on(this.contents_).lbl(l -> l.key("dialog.mount.driveletter")).cmb(c -> c.items("ABCDEFGHIJKLMNOPQRSTUVWXY".split("(?!^)"))).combo();
        final Button mountDirButton = Button_.on(this.contents_).radio().key("dialog.mount.mountdir").ctrl();
        Composite dirComposite = ((Composite_.Builder)Composite_.on(this.contents_).layoutData(new GridData(4, 1, true, false))).innerLayout(7).build();
        final Text dirMountDir = Chain.on(dirComposite).txt(t -> (Text_.Builder)t.horSpan(6)).but(b -> b.browse(false, Button_.BrowseType.DIR, Button_.CanonicalType.DOSROOT, false)).text();
        final Combo dirMountType = Chain.on(dirComposite).lbl(l -> l.key("dialog.mount.mountdiras")).cmb(c -> ((Combo_.Builder)c.horSpan(6)).items("profile", "mount_type")).combo();
        final Text dirMountLabel = Chain.on(dirComposite).lbl(l -> l.key("dialog.mount.drivelabel")).txt(t -> (Text_.Builder)t.horSpan(6)).text();
        final Combo dirMountLowlevelCdType = Chain.on(dirComposite).lbl(l -> ((Label_.Builder)l.horSpan(3)).key("dialog.mount.lowlevelcdsupport")).cmb(c -> c.items("profile", "lowlevelcd_type")).combo();
        final Combo dirMountUseCd = Chain.on(dirComposite).lbl(l -> l.key("dialog.mount.usecd")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(new String[]{"", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"})).combo();
        final Combo dirMountFreesize = Chain.on(dirComposite).lbl(l -> l.key("dialog.mount.freesize")).cmb(c -> c.editable().items("profile", "freesize")).combo();
        final Label dirMountMbLabel = Chain.on(dirComposite).lbl(l -> (Label_.Builder)l.horSpan(5)).label();
        dirMountType.add("", 0);
        dirMountLowlevelCdType.add("", 0);
        dirMountFreesize.add("", 0);
        ((Label_.Builder)((Label_.Builder)Label_.on(this.contents_).style(258)).layoutData(new GridData(4, 0x1000000, true, false, 2, 1))).build();
        final Button mountImageButton = Button_.on(this.contents_).radio().key("dialog.mount.mountimages").ctrl();
        Composite imgComposite = ((Composite_.Builder)Composite_.on(this.contents_).layoutData(new GridData(4, 4, true, true))).innerLayout(5).build();
        Chain imgChain = Chain.on(imgComposite).txt(t -> ((Text_.Builder)t.horSpan(4)).multi()).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.CDIMAGE, false)).build();
        final Combo imgMountType = Chain.on(imgComposite).lbl(l -> l.key("dialog.mount.mountdiras")).cmb(c -> c.items("profile", "imgmount_type")).combo();
        final Combo imgMountFs = Chain.on(imgComposite).lbl(l -> l.key("dialog.mount.imgmountfs")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "imgmount_fs")).combo();
        final Text imgMountSize = Chain.on(imgComposite).lbl(l -> l.key("dialog.mount.imgmountsize")).txt(t -> (Text_.Builder)t.horSpan(3)).text();
        final Button imgSizeHelperButton = Chain.on(imgComposite).but(b -> ((Button_.Builder)b.layoutData(new GridData(1, 0x1000000, false, false))).threedots().listen(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                String command = (String)new EditImgSizeDialog(EditMountDialog.this.shell_, imgMountSize.getText()).open();
                if (command != null) {
                    imgMountSize.setText(command);
                }
            }
        })).button();
        final Text imgMountImage = imgChain.getText();
        imgChain.getButton().setData("combo", imgMountType);
        imgMountType.setText("iso");
        imgMountFs.add("", 0);
        ((Label_.Builder)((Label_.Builder)Label_.on(this.contents_).style(258)).layoutData(new GridData(4, 0x1000000, true, false, 2, 1))).build();
        final Button mountZipButton = Button_.on(this.contents_).radio().key("dialog.mount.mountzip").ctrl();
        Composite zipComposite = ((Composite_.Builder)Composite_.on(this.contents_).layoutData(new GridData(4, 1, true, false))).innerLayout(3).build();
        final Text zipMountZip = Chain.on(zipComposite).lbl(l -> l.key("dialog.mount.zipfile")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.ZIP, false)).text();
        final Text zipMountWrite = Chain.on(zipComposite).lbl(l -> l.key("dialog.mount.writedirectory")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.DIR, Button_.CanonicalType.DOSROOT, false)).text();
        final Combo zipMountType = Chain.on(zipComposite).lbl(l -> l.key("dialog.mount.mountzipas")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "zipmount_type")).combo();
        final Text zipMountLabel = Chain.on(zipComposite).lbl(l -> l.key("dialog.mount.drivelabel")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        zipMountType.add("", 0);
        dirMountType.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                EditMountDialog.this.updateInterfaceElements(imgSizeHelperButton, dirMountUseCd, dirMountFreesize, dirMountMbLabel, dirMountType, dirMountLowlevelCdType, imgMountFs, imgMountSize);
            }
        });
        imgMountFs.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                EditMountDialog.this.updateInterfaceElements(imgSizeHelperButton, dirMountUseCd, dirMountFreesize, dirMountMbLabel, dirMountType, dirMountLowlevelCdType, imgMountFs, imgMountSize);
            }
        });
        SelectionAdapter driveLetterSelectionAdapter = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                boolean imgFsNone = "none".equalsIgnoreCase(imgMountFs.getText());
                int sel = driveletter.getSelectionIndex();
                if (sel >= 0) {
                    if (mountImageButton.getSelection() && imgFsNone) {
                        if (!StringUtils.isNumeric(driveletter.getItem(sel))) {
                            driveletter.setItems("0", "1", "2", "3");
                            driveletter.setText(driveletter.getItem(Math.min(sel, 3)));
                        }
                    } else if (StringUtils.isNumeric(driveletter.getItem(sel))) {
                        driveletter.setItems("ABCDEFGHIJKLMNOPQRSTUVWXY".split("(?!^)"));
                        driveletter.setText(driveletter.getItem(Math.min(sel, 3)));
                    }
                }
            }
        };
        imgMountFs.addSelectionListener(driveLetterSelectionAdapter);
        mountDirButton.addSelectionListener(driveLetterSelectionAdapter);
        mountImageButton.addSelectionListener(driveLetterSelectionAdapter);
        mountZipButton.addSelectionListener(driveLetterSelectionAdapter);
        this.createOkCancelButtons(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (!EditMountDialog.this.isValid(mountDirButton, dirMountDir, mountImageButton, imgMountImage, imgMountFs, imgMountSize, mountZipButton, zipMountZip)) {
                    return;
                }
                Mount mount = null;
                if (mountDirButton.getSelection()) {
                    mount = "overlay".equalsIgnoreCase(dirMountType.getText()) ? MountFactory.createOverlayMount(driveletter.getText(), dirMountDir.getText(), dirMountType.getText(), dirMountLabel.getText(), dirMountLowlevelCdType.isEnabled() ? dirMountLowlevelCdType.getText() : null, dirMountFreesize.isEnabled() ? dirMountFreesize.getText() : null, dirMountUseCd.isEnabled() ? dirMountUseCd.getText() : null) : MountFactory.createDirMount(driveletter.getText(), dirMountDir.getText(), dirMountType.getText(), dirMountLabel.getText(), dirMountLowlevelCdType.isEnabled() ? dirMountLowlevelCdType.getText() : null, dirMountFreesize.isEnabled() ? dirMountFreesize.getText() : null, dirMountUseCd.isEnabled() ? dirMountUseCd.getText() : null);
                } else if (mountImageButton.getSelection()) {
                    mount = MountFactory.createImageMount(driveletter.getText(), StringRelatedUtils.textAreaToStringArray(imgMountImage.getText(), imgMountImage.getLineDelimiter()), imgMountType.getText(), imgMountFs.getText(), imgMountSize.isEnabled() ? imgMountSize.getText() : null, null);
                } else if (mountZipButton.getSelection()) {
                    mount = MountFactory.createPhysFsMount(driveletter.getText(), zipMountZip.getText(), zipMountWrite.getText(), zipMountType.getText(), zipMountLabel.getText());
                }
                if (mount != null) {
                    EditMountDialog.this.result_ = mount.toString();
                }
                EditMountDialog.this.shell_.close();
            }
        });
        ModifyListener modListener = event -> {
            mountDirButton.setSelection(event.widget == dirMountDir);
            mountImageButton.setSelection(event.widget == imgMountImage);
            mountZipButton.setSelection(event.widget == zipMountZip);
            mountDirButton.notifyListeners(13, null);
        };
        dirMountDir.addModifyListener(modListener);
        imgMountImage.addModifyListener(modListener);
        zipMountZip.addModifyListener(modListener);
        Mount mount = null;
        if (this.mount_ != null) {
            try {
                mount = MountFactory.create(this.mount_);
            }
            catch (InvalidMountstringException invalidMountstringException) {
                // empty catch block
            }
        }
        if (mount == null) {
            mount = MountFactory.createDefaultNewMount(this.driveletter_);
        }
        driveletter.select(mount.getDrive() - 65);
        if (mount instanceof PhysFsMount) {
            PhysFsMount physFsMount = (PhysFsMount)mount;
            mountZipButton.setSelection(true);
            zipMountZip.setText(physFsMount.getPath().getPath());
            if (physFsMount.getWrite() != null) {
                zipMountWrite.setText(physFsMount.getWrite().getPath());
            }
            if (StringUtils.isNotBlank(physFsMount.getMountAs())) {
                zipMountType.setText(physFsMount.getMountAs());
            }
            zipMountLabel.setText(physFsMount.getLabel());
            zipMountZip.selectAll();
            zipMountZip.setFocus();
        } else if (mount instanceof ImageMount) {
            ImageMount imageMount = (ImageMount)mount;
            mountImageButton.setSelection(true);
            if (StringUtils.isNotBlank(imageMount.getMountAs())) {
                imgMountType.setText(imageMount.getMountAs());
            }
            if (imageMount.getFs().equalsIgnoreCase("none")) {
                driveletter.setItems("0", "1", "2", "3");
            }
            if (StringUtils.isNotBlank(imageMount.getFs())) {
                imgMountFs.setText(imageMount.getFs());
            }
            if (StringUtils.isNotBlank(imageMount.getSize())) {
                imgMountSize.setText(imageMount.getSize());
            }
            imgMountImage.setText(StringRelatedUtils.stringArrayToString(imageMount.getImgPathStrings(), imgMountImage.getLineDelimiter()));
            imgMountImage.selectAll();
            imgMountImage.setFocus();
        } else if (mount instanceof OverlayMount) {
            OverlayMount overlayMount = (OverlayMount)mount;
            mountDirButton.setSelection(true);
            dirMountDir.setText(overlayMount.getPath().getPath());
            if (StringUtils.isNotBlank(overlayMount.getMountAs())) {
                dirMountType.setText(overlayMount.getMountAs());
            }
            dirMountLabel.setText(overlayMount.getLabel());
            dirMountLowlevelCdType.setText(overlayMount.getLowlevelCD());
            dirMountUseCd.setText(overlayMount.getUseCD());
            if (StringUtils.isNotBlank(overlayMount.getFreesize())) {
                dirMountFreesize.setText(overlayMount.getFreesize());
            }
            dirMountDir.selectAll();
            dirMountDir.setFocus();
        } else if (mount instanceof DirMount) {
            DirMount dirMount = (DirMount)mount;
            mountDirButton.setSelection(true);
            dirMountDir.setText(dirMount.getPath().getPath());
            if (StringUtils.isNotBlank(dirMount.getMountAs())) {
                dirMountType.setText(dirMount.getMountAs());
            }
            dirMountLabel.setText(dirMount.getLabel());
            dirMountLowlevelCdType.setText(dirMount.getLowlevelCD());
            dirMountUseCd.setText(dirMount.getUseCD());
            if (StringUtils.isNotBlank(dirMount.getFreesize())) {
                dirMountFreesize.setText(dirMount.getFreesize());
            }
            dirMountDir.selectAll();
            dirMountDir.setFocus();
        }
        driveletter.setText(mount.getDriveAsString());
        driveletter.addSelectionListener(new SelectionAdapter(){
            String previouslyChosenDirMountType = null;

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (driveletter.getText().equals("A") || driveletter.getText().equals("B")) {
                    if (this.previouslyChosenDirMountType == null) {
                        this.previouslyChosenDirMountType = dirMountType.getText();
                        dirMountType.setText("floppy");
                    }
                } else if (this.previouslyChosenDirMountType != null) {
                    dirMountType.setText(this.previouslyChosenDirMountType);
                    this.previouslyChosenDirMountType = null;
                }
            }
        });
        this.updateInterfaceElements(imgSizeHelperButton, dirMountUseCd, dirMountFreesize, dirMountMbLabel, dirMountType, dirMountLowlevelCdType, imgMountFs, imgMountSize);
    }

    private void updateInterfaceElements(Button imgSizeConfig, Combo usecd, Combo freesize, Label mbLabel, Combo mountType, Combo lowlevelcdType, Combo imgmountFs, Text imgmountSize) {
        boolean enableLLItems = "cdrom".equalsIgnoreCase(mountType.getText());
        lowlevelcdType.setEnabled(enableLLItems);
        usecd.setEnabled(enableLLItems);
        freesize.setEnabled(!enableLLItems);
        String sizeLabel = "floppy".equalsIgnoreCase(mountType.getText()) ? this.text_.get("dialog.mount.kb") : this.text_.get("dialog.mount.mb");
        mbLabel.setText(sizeLabel);
        mbLabel.pack();
        boolean imgFsNone = "none".equalsIgnoreCase(imgmountFs.getText());
        imgmountSize.setEnabled(imgFsNone);
        imgSizeConfig.setEnabled(imgFsNone);
    }

    private boolean isValid(Button imgSizeHelperButton, Text dirMountDir, Button mountImageButton, Text imgMountImage, Combo imgMountFs, Text imgMountSize, Button mountZipButton, Text zipMountZip) {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (imgSizeHelperButton.getSelection() && StringUtils.isBlank(dirMountDir.getText())) {
            mess.key("dialog.mount.required.path").bind(dirMountDir);
        } else if (mountImageButton.getSelection()) {
            if (StringUtils.isBlank(imgMountImage.getText())) {
                mess.key("dialog.mount.required.image").bind(imgMountImage);
            }
            if (imgMountFs.getText().equalsIgnoreCase("none") && StringUtils.isBlank(imgMountSize.getText())) {
                mess.key("dialog.mount.required.imgsize").bind(imgMountSize);
            }
        } else if (mountZipButton.getSelection() && StringUtils.isBlank(zipMountZip.getText())) {
            mess.key("dialog.mount.required.zip").bind(zipMountZip);
        }
        return mess.valid();
    }
}

