/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;

public class Link {
    private String title_;
    private String destination_;

    public Link(String title, String destination) {
        this.title_ = title;
        this.destination_ = StringUtils.isNotBlank(destination) && !destination.contains("://") ? FilenameUtils.separatorsToSystem(destination) : destination;
    }

    public String getTitle() {
        return this.title_;
    }

    public String getDestination() {
        return this.destination_;
    }

    public String getDisplayTitle() {
        return StringUtils.isNotBlank(this.title_) ? StringRelatedUtils.toSwtGuiString(this.title_) : StringRelatedUtils.toSwtGuiString(this.destination_);
    }

    public String getUrl() {
        return StringUtils.isBlank(this.destination_) || this.destination_.contains("://") ? this.destination_ : FilesUtils.toUrl(new FileLocation(this.destination_, FileLocationService.getInstance().dataRelative()).getCanonicalFile());
    }

    public String getPathBasedAnchor() {
        return StringUtils.isBlank(this.destination_) ? null : "<a href=\"" + this.destination_ + "\">" + this.getDisplayTitle() + "</a>";
    }

    public String getUrlBasedAnchor() {
        return StringUtils.isBlank(this.destination_) ? null : "<a href=\"" + this.getUrl() + "\">" + this.getDisplayTitle() + "</a>";
    }

    public void setBaseDir(File baseDir) {
        if (StringUtils.isNotBlank(this.destination_) && !this.destination_.contains("://")) {
            File canonicalFile = new FileLocation(this.destination_, FileLocationService.getInstance().dataRelative()).getCanonicalFile();
            File relativeToDosrootFile = new FileLocation(canonicalFile.getPath(), FileLocationService.getInstance().dosrootRelative()).getFile();
            this.destination_ = FilesUtils.concat(baseDir, relativeToDosrootFile);
            if (!baseDir.isAbsolute()) {
                this.destination_ = FilesUtils.concat(FileLocationService.DOSROOT_DIR_STRING, this.destination_);
            }
        }
    }

    public void migrate(FileLocation fromPath, FileLocation toPath) {
        if (StringUtils.isBlank(this.destination_) || this.destination_.toLowerCase().startsWith("http://") || this.destination_.toLowerCase().startsWith("https://")) {
            return;
        }
        if (this.destination_.toLowerCase().startsWith("file://")) {
            this.destination_ = this.destination_.substring(7);
        }
        if (StringUtils.isNotBlank(this.destination_)) {
            this.destination_ = FilesUtils.migrate(new File(this.destination_), fromPath.getCanonicalFile(), toPath.getCanonicalFile()).getPath();
        }
    }

    public String toString() {
        return "title: [" + this.title_ + "], destination: [" + this.destination_ + "]";
    }
}

