/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.IntStream;
import org.dbgl.model.ICanBeDefault;
import org.dbgl.model.entity.IEntity;
import org.dbgl.service.DatabaseService;
import org.dbgl.service.TextService;

public abstract class BaseRepository<T extends IEntity> {
    private static final String IDENTITY_QRY = "CALL IDENTITY()";
    protected DatabaseService dbService_ = DatabaseService.getInstance();

    protected BaseRepository() {
    }

    protected void actionOnEntity(DatabaseService.Transaction transaction, String query, String action, T entity) throws SQLException {
        try (PreparedStatement stmt = transaction.prepareStatement(query);){
            stmt.setInt(1, entity.getId());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{action}));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static int identity(DatabaseService.Transaction transaction) throws SQLException {
        try (Statement stmt = transaction.createStatement();){
            int n;
            block14: {
                ResultSet resultset = stmt.executeQuery(IDENTITY_QRY);
                try {
                    resultset.next();
                    n = resultset.getInt(1);
                    if (resultset == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultset != null) {
                        try {
                            resultset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultset.close();
            }
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"get identity"}));
        }
    }

    public static <T extends IEntity> T findById(List<T> list, int id) {
        return (T)((IEntity)list.stream().filter(x -> x.getId() == id).findAny().orElse(null));
    }

    public static <T extends IEntity> int findIndexById(List<T> list, int id) {
        return IntStream.range(0, list.size()).filter(i -> ((IEntity)list.get(i)).getId() == id).findFirst().orElse(-1);
    }

    public static <T extends IEntity> int indexOf(List<T> list, T entity) {
        return BaseRepository.findIndexById(list, entity.getId());
    }

    public static <T extends ICanBeDefault> T findDefault(List<T> list) {
        return (T)((ICanBeDefault)list.stream().filter(ICanBeDefault::isDefault).findAny().orElse(null));
    }

    public static <T extends ICanBeDefault> int indexOfDefault(List<T> list) {
        return IntStream.range(0, list.size()).filter(i -> ((ICanBeDefault)list.get(i)).isDefault()).findFirst().orElse(-1);
    }
}

