/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.dbgl.util.fat.BlockDevice;
import org.dbgl.util.fat.BootSector;
import org.dbgl.util.fat.FatType;

final class Fat {
    public static final int FIRST_CLUSTER = 2;
    private final long[] entries_;
    private final FatType fatType_;
    private final int sectorCount_;
    private final int sectorSize_;
    private final BlockDevice device_;
    private final BootSector bs_;
    private final long offset_;
    private final int lastClusterIndex_;

    public static Fat read(BootSector bs, int fatNr) throws IOException, IllegalArgumentException {
        if (fatNr > bs.getNrFats()) {
            throw new IllegalArgumentException("boot sector says there are only " + bs.getNrFats() + " FATs when reading FAT #" + fatNr);
        }
        Fat result = new Fat(bs, bs.getFatOffset(fatNr));
        result.read();
        return result;
    }

    private Fat(BootSector bs, long offset) throws IOException {
        this.bs_ = bs;
        this.fatType_ = bs.getFatType();
        if (bs.getSectorsPerFat() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("FAT too large");
        }
        if (bs.getSectorsPerFat() <= 0L) {
            throw new IOException("boot sector says there are " + bs.getSectorsPerFat() + " sectors per FAT");
        }
        if (bs.getBytesPerSector() <= 0) {
            throw new IOException("boot sector says there are " + bs.getBytesPerSector() + " bytes per sector");
        }
        this.sectorCount_ = (int)bs.getSectorsPerFat();
        this.sectorSize_ = bs.getBytesPerSector();
        this.device_ = bs.getDevice();
        this.offset_ = offset;
        if (bs.getDataClusterCount() > Integer.MAX_VALUE) {
            throw new IOException("too many data clusters");
        }
        if (bs.getDataClusterCount() == 0L) {
            throw new IOException("no data clusters");
        }
        this.lastClusterIndex_ = (int)bs.getDataClusterCount() + 2;
        this.entries_ = new long[(int)((float)(this.sectorCount_ * this.sectorSize_) / this.fatType_.getEntrySize())];
        if (this.lastClusterIndex_ > this.entries_.length) {
            throw new IOException("file system has " + this.lastClusterIndex_ + "clusters but only " + this.entries_.length + " FAT entries");
        }
    }

    public BootSector getBootSector() {
        return this.bs_;
    }

    public BlockDevice getDevice() {
        return this.device_;
    }

    private void read() throws IOException {
        byte[] data = new byte[this.sectorCount_ * this.sectorSize_];
        this.device_.read(this.offset_, ByteBuffer.wrap(data));
        for (int i = 0; i < this.entries_.length; ++i) {
            this.entries_[i] = this.fatType_.readEntry(data, i);
        }
    }

    public int getMediumDescriptor() {
        return (int)(this.entries_[0] & 0xFFL);
    }

    public long[] getChain(long startCluster) {
        this.testCluster(startCluster);
        int count = 1;
        long cluster = startCluster;
        while (!this.isEofCluster(this.entries_[(int)cluster])) {
            ++count;
            cluster = this.entries_[(int)cluster];
        }
        long[] chain = new long[count];
        chain[0] = startCluster;
        cluster = startCluster;
        int i = 0;
        while (!this.isEofCluster(this.entries_[(int)cluster])) {
            cluster = this.entries_[(int)cluster];
            chain[++i] = cluster;
        }
        return chain;
    }

    public int getFreeClusterCount() {
        int result = 0;
        for (int i = 2; i < this.lastClusterIndex_; ++i) {
            if (!this.isFreeCluster(i)) continue;
            ++result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Fat)) {
            return false;
        }
        Fat other = (Fat)obj;
        if (this.fatType_ != other.fatType_) {
            return false;
        }
        if (this.sectorCount_ != other.sectorCount_) {
            return false;
        }
        if (this.sectorSize_ != other.sectorSize_) {
            return false;
        }
        if (this.lastClusterIndex_ != other.lastClusterIndex_) {
            return false;
        }
        if (!Arrays.equals(this.entries_, other.entries_)) {
            return false;
        }
        return this.getMediumDescriptor() == other.getMediumDescriptor();
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Arrays.hashCode(this.entries_);
        hash = 23 * hash + this.fatType_.hashCode();
        hash = 23 * hash + this.sectorCount_;
        hash = 23 * hash + this.sectorSize_;
        hash = 23 * hash + this.lastClusterIndex_;
        return hash;
    }

    protected boolean isFreeCluster(long entry) {
        if (entry > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.entries_[(int)entry] == 0L;
    }

    protected boolean isEofCluster(long entry) {
        return this.fatType_.isEofCluster(entry);
    }

    protected void testCluster(long cluster) throws IllegalArgumentException {
        if (cluster < 2L || cluster >= (long)this.entries_.length) {
            throw new IllegalArgumentException("invalid cluster value " + cluster);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[type=");
        sb.append((Object)this.fatType_);
        sb.append(", mediumDescriptor=0x");
        sb.append(Integer.toHexString(this.getMediumDescriptor()));
        sb.append(", sectorCount=");
        sb.append(this.sectorCount_);
        sb.append(", sectorSize=");
        sb.append(this.sectorSize_);
        sb.append(", freeClusters=");
        sb.append(this.getFreeClusterCount());
        sb.append("]");
        return sb.toString();
    }
}

