/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.util.Arrays;
import org.dbgl.util.iso.Util;

final class ShortName {
    private final char[] name_;

    public ShortName(byte[] data) {
        char[] nameArr = new char[8];
        for (int i = 0; i < nameArr.length; ++i) {
            nameArr[i] = (char)Util.getUInt8(data, i);
        }
        if (Util.getUInt8(data, 0) == 5) {
            nameArr[0] = 229;
        }
        char[] extArr = new char[3];
        for (int i = 0; i < extArr.length; ++i) {
            extArr[i] = (char)Util.getUInt8(data, 8 + i);
        }
        String name = new String(nameArr).trim();
        String ext = new String(extArr).trim();
        ShortName.checkString(name, "name", 1, 8);
        ShortName.checkString(ext, "extension", 0, 3);
        char[] result = new char[11];
        Arrays.fill(result, ' ');
        System.arraycopy(name.toCharArray(), 0, result, 0, name.length());
        System.arraycopy(ext.toCharArray(), 0, result, 8, ext.length());
        this.name_ = result;
    }

    private static void checkString(String str, String strType, int minLength, int maxLength) {
        if (str == null) {
            throw new IllegalArgumentException(strType + " is null");
        }
        if (str.length() < minLength) {
            throw new IllegalArgumentException(strType + " must have at least " + minLength + " characters: " + str);
        }
        if (str.length() > maxLength) {
            throw new IllegalArgumentException(strType + " has more than " + maxLength + " characters: " + str);
        }
    }

    public String asSimpleString() {
        return new String(this.name_).trim();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.asSimpleString() + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortName)) {
            return false;
        }
        return Arrays.equals(this.name_, ((ShortName)obj).name_);
    }

    public int hashCode() {
        return Arrays.hashCode(this.name_);
    }
}

