/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.service.TextService;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class Label_ {
    private Label_() {
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static class Builder
    extends ControlBuilder<Builder> {
        private String labelText_;
        private boolean large_;

        Builder(Composite composite) {
            super(composite, 0, 1, 0x1000000, false, false);
        }

        public Builder grabHorSpace() {
            this.horizontalAlignment_ = 4;
            this.grabExcessHorizontalSpace_ = true;
            return this;
        }

        public Builder large() {
            this.large_ = true;
            return this;
        }

        public Builder txt(String txt) {
            this.labelText_ = txt;
            return this;
        }

        public Builder key(String key) {
            return this.txt(TextService.getInstance().get(key));
        }

        public Builder key(String key, String param) {
            return this.txt(TextService.getInstance().get(key, param));
        }

        public Builder key(String key, Object[] objs) {
            return this.txt(TextService.getInstance().get(key, objs));
        }

        public Label build() {
            Label label = new Label(this.composite_, this.style_);
            if (DarkTheme.forced()) {
                label.setBackground(this.composite_.getBackground());
                label.setForeground(DarkTheme.defaultForeground);
            }
            label.setLayoutData(this.layoutData());
            if (this.labelText_ != null) {
                label.setText(this.labelText_);
            }
            if (this.large_) {
                FontData[] fontData = label.getFont().getFontData();
                int height = fontData[0].getHeight();
                fontData[0].setHeight((int)((double)height * 1.5));
                final Font largeFont = new Font((Device)this.composite_.getDisplay(), fontData[0]);
                label.setFont(largeFont);
                label.addDisposeListener(new DisposeListener(){

                    @Override
                    public void widgetDisposed(DisposeEvent e) {
                        largeFont.dispose();
                    }
                });
            }
            return label;
        }
    }
}

