/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.BaseDaControlConvertor;
import org.dbgl.gui.controls.CommaSeparatedDaControlConvertor;
import org.dbgl.gui.controls.SpaceSeparatedDaControlConvertor;

public abstract class SeparatedValuesDaControlConvertor
extends BaseDaControlConvertor {
    protected final char separatorChar_;

    public SeparatedValuesDaControlConvertor(char seperatorChar) {
        this.separatorChar_ = seperatorChar;
    }

    @Override
    public String toConfValue(String existingValue, String[] values) {
        String joinedValues = StringUtils.join((Object[])values, this.separatorChar_);
        if (StringUtils.isBlank(existingValue)) {
            return joinedValues;
        }
        String[] exVals = this.toControlValues(existingValue);
        if (exVals.length != values.length) {
            System.err.println("configuration values mismatch: [" + existingValue + "] vs. [" + joinedValues + "]");
            return existingValue;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                builder.append(this.separatorChar_);
            }
            builder.append(StringUtils.isBlank(values[i]) ? exVals[i] : values[i]);
        }
        return builder.toString();
    }

    @Override
    public String toConfValueForDisplay(String[] values) {
        String[] parts = StringUtils.split(this.toConfValue(null, values), this.separatorChar_);
        return Stream.of(parts).map(x -> StringUtils.isBlank(x) ? "..." : x).collect(Collectors.joining(", "));
    }

    @Override
    public String[] toControlValues(String value) {
        return value == null ? new String[]{} : StringUtils.split(value, this.separatorChar_);
    }

    public static SeparatedValuesDaControlConvertor detect(String value) {
        if (StringUtils.contains((CharSequence)value, 32)) {
            return SpaceSeparatedDaControlConvertor.getInstance();
        }
        if (StringUtils.contains((CharSequence)value, 44)) {
            return CommaSeparatedDaControlConvertor.getInstance();
        }
        return null;
    }
}

