/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.dialog.SettingsDialog;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.factory.DosboxVersionFactory;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.SettingsService;
import org.dbgl.util.ExecuteUtils;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditDosboxVersionDialog
extends SizeControlledTabbedDialog<DosboxVersion> {
    private final boolean isDefault_;
    private final DosboxVersion dbversion_;
    private String lastTitleSet = null;
    private int lastOptionSelection = -1;

    public EditDosboxVersionDialog(Shell parent, boolean isDefault, DosboxVersion dbversion) {
        super(parent, "dosboxdialog");
        this.isDefault_ = isDefault;
        this.dbversion_ = dbversion;
    }

    @Override
    protected String getDialogTitle() {
        return this.dbversion_ == null || this.dbversion_.getId() == -1 ? this.text_.get("dialog.dosboxversion.title.add") : this.text_.get("dialog.dosboxversion.title.edit", new Object[]{this.dbversion_.getTitle(), this.dbversion_.getId()});
    }

    private void setTitleByVersion(Combo family, Combo version, Text title) {
        if (this.lastTitleSet == null || StringUtils.isBlank(title.getText()) || StringUtils.equals(title.getText(), this.lastTitleSet)) {
            String fam = family.getText().equals("Official") ? "DOSBox" : family.getText();
            this.lastTitleSet = fam + " " + version.getText();
            title.setText(this.lastTitleSet);
        }
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite("dialog.dosboxversion.tab.info", 5);
        final Combo family = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.family")).cmb(c -> ((Combo_.Builder)c.horSpan(1)).items(SettingsService.SUPPORTED_DOSBOX_FAMILIES.stream().map(x -> x.title_).toList())).combo();
        final Combo version = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.version")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).visibleItemCount(15)).combo();
        final Text title = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.title")).txt(t -> (Text_.Builder)t.horSpan(4)).text();
        Chain chainPath = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.path")).txt(t -> (Text_.Builder)t.horSpan(3)).but(b -> b.browse(false, SystemUtils.IS_OSX ? Button_.BrowseType.FILE : Button_.BrowseType.DIR, Button_.CanonicalType.DOSBOX, false)).build();
        final Text path = chainPath.getText();
        final Text exe = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.executable")).txt(t -> ((Text_.Builder)t.horSpan(3)).tooltip("dialog.dosboxversion.executable.tooltip", FileLocationService.DOSBOX_EXE_STRING)).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.DOSBOXEXE, false)).text();
        final Text conf = Chain.on(composite).lbl(l -> l.key("dialog.profile.configfile")).txt(t -> (Text_.Builder)t.horSpan(3)).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.DOSBOXCONF, false)).text();
        final Text parameters = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.parameters")).txt(t -> (Text_.Builder)t.horSpan(4)).text();
        final Button multiconf = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.multiconfsupport")).but(b -> (Button_.Builder)b.horSpan(4)).button();
        final Button usingCurses = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.altstartup")).but(b -> ((Button_.Builder)b.horSpan(4)).key("dialog.dosboxversion.altstartupexplanation")).button();
        final Button defaultButton = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.default")).but(b -> (Button_.Builder)b.horSpan(4)).button();
        chainPath.getButton().setData("altControl", conf);
        family.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                version.setItems((String[])SettingsService.SUPPORTED_DOSBOX_FAMILIES.get((int)family.getSelectionIndex()).versions_.toArray(String[]::new));
                version.select(version.getItemCount() - 1);
                version.pack();
            }
        });
        Composite dynamicOptionsTab = this.createTabWithComposite("dialog.dosboxversion.tab.dynamicoptions", 2);
        final Button enableCustomization = Chain.on(dynamicOptionsTab).lbl(l -> l.key("dialog.dosboxversion.dynamicoptions.enablecustomization")).but(b -> b).button();
        Composite dynamicOptionsComposite = ((Composite_.Builder)Composite_.on(dynamicOptionsTab).layoutData(new GridData(4, 4, true, true, 2, 1))).innerLayout(1).build();
        SashForm sashForm = EditDosboxVersionDialog.createSashForm(dynamicOptionsComposite, 1);
        Composite left = Composite_.on(sashForm).innerLayout(1).build();
        final List optionsList = Chain.on(left).lbl(l -> l.key("dialog.settings.options")).lst(l -> l).list();
        Composite right = Composite_.on(sashForm).innerLayout(1).build();
        final Text values = Chain.on(right).lbl(l -> l.key("dialog.settings.values")).txt(Text_.Builder::multi).text();
        enableCustomization.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                optionsList.setEnabled(enableCustomization.getSelection());
                values.setEnabled(enableCustomization.getSelection());
            }
        });
        final LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        optionsList.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.updateOptionsMap(optionsMap, optionsList, EditDosboxVersionDialog.this.lastOptionSelection, values);
                EditDosboxVersionDialog.this.lastOptionSelection = optionsList.getSelectionIndex();
                if (EditDosboxVersionDialog.this.lastOptionSelection != -1) {
                    values.setText((String)optionsMap.get(optionsList.getItem(EditDosboxVersionDialog.this.lastOptionSelection)));
                }
            }
        });
        this.createOkCancelButtons(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (!EditDosboxVersionDialog.this.isValid(title, path, exe, conf, usingCurses, family, version)) {
                    return;
                }
                try {
                    SettingsDialog.updateOptionsMap(optionsMap, optionsList, EditDosboxVersionDialog.this.lastOptionSelection, values);
                    optionsMap.entrySet().forEach(x -> x.setValue(Settings.combineValues((String)x.getValue(), values.getLineDelimiter())));
                    if (EditDosboxVersionDialog.this.dbversion_ == null || EditDosboxVersionDialog.this.dbversion_.getId() == -1) {
                        DosboxVersion dbv = DosboxVersionFactory.create(title.getText(), family.getText(), version.getText(), defaultButton.getSelection(), multiconf.getSelection(), usingCurses.getSelection(), enableCustomization.getSelection() ? optionsMap : null, path.getText(), exe.getText(), parameters.getText(), conf.getText());
                        EditDosboxVersionDialog.this.result_ = new DosboxVersionRepository().add(dbv);
                    } else {
                        EditDosboxVersionDialog.this.dbversion_.setTitle(title.getText());
                        EditDosboxVersionDialog.this.dbversion_.setFamily(family.getText());
                        EditDosboxVersionDialog.this.dbversion_.setVersion(version.getText());
                        EditDosboxVersionDialog.this.dbversion_.setDefault(defaultButton.getSelection());
                        EditDosboxVersionDialog.this.dbversion_.setMultiConfig(multiconf.getSelection());
                        EditDosboxVersionDialog.this.dbversion_.setUsingCurses(usingCurses.getSelection());
                        EditDosboxVersionDialog.this.dbversion_.setDynamicOptions(enableCustomization.getSelection() ? optionsMap : null);
                        EditDosboxVersionDialog.this.dbversion_.setPath(path.getText());
                        EditDosboxVersionDialog.this.dbversion_.setExe(exe.getText());
                        EditDosboxVersionDialog.this.dbversion_.setExecutableParameters(parameters.getText());
                        EditDosboxVersionDialog.this.dbversion_.setConfigurationFileLocation(conf.getText());
                        new DosboxVersionRepository().update(EditDosboxVersionDialog.this.dbversion_);
                        EditDosboxVersionDialog.this.result_ = EditDosboxVersionDialog.this.dbversion_;
                    }
                }
                catch (SQLException e) {
                    Mess_.on(EditDosboxVersionDialog.this.shell_).exception(e).warning();
                }
                EditDosboxVersionDialog.this.shell_.close();
            }
        });
        if (this.dbversion_ != null) {
            title.setText(this.dbversion_.getTitle());
            path.setText(this.dbversion_.getPath().getPath());
            exe.setText(this.dbversion_.getExe().getPath());
            conf.setText(this.dbversion_.getConfigurationFile().getPath());
            parameters.setText(this.dbversion_.getExecutableParameters());
            family.setText(this.dbversion_.getFamily());
            version.setItems((String[])SettingsService.SUPPORTED_DOSBOX_FAMILIES.get((int)family.getSelectionIndex()).versions_.toArray(String[]::new));
            version.setText(this.dbversion_.getVersion());
            defaultButton.setSelection(this.dbversion_.isDefault());
            multiconf.setSelection(this.dbversion_.isMultiConfig());
            usingCurses.setSelection(this.dbversion_.isUsingCurses());
            title.setFocus();
        } else {
            family.setText(SettingsService.OFFICIAL_DOSBOX_FAM.title_);
            version.setItems((String[])SettingsService.OFFICIAL_DOSBOX_FAM.versions_.toArray(String[]::new));
            version.select(version.getItemCount() - 1);
            defaultButton.setSelection(this.isDefault_);
            multiconf.setSelection(true);
            SelectionAdapter verListener = new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    EditDosboxVersionDialog.this.setTitleByVersion(family, version, title);
                }
            };
            family.addSelectionListener(verListener);
            version.addSelectionListener(verListener);
            this.setTitleByVersion(family, version, title);
            family.setFocus();
        }
        if (this.dbversion_ != null && this.dbversion_.getDynamicOptions() != null) {
            enableCustomization.setSelection(true);
            optionsMap.putAll(this.dbversion_.getDynamicOptions());
            optionsMap.entrySet().forEach(x -> x.setValue(StringRelatedUtils.stringArrayToString(Settings.splitValues((String)x.getValue()), values.getLineDelimiter())));
        } else {
            optionsList.setEnabled(false);
            values.setEnabled(false);
            for (String s : this.settings_.getProfileSectionItemNames()) {
                optionsMap.put(s, this.settings_.getMultilineValue("profile", s, values.getLineDelimiter()));
            }
        }
        optionsMap.keySet().forEach(optionsList::add);
    }

    private boolean isValid(Text title, Text path, Text exe, Text conf, Button usingCurses, Combo family, Combo version) {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (StringUtils.isBlank(title.getText())) {
            mess.key("dialog.dosboxversion.required.title").bind(title);
        }
        if (StringUtils.isBlank(path.getText())) {
            mess.key("dialog.dosboxversion.required.path").bind(path);
        }
        if (StringUtils.isBlank(conf.getText())) {
            mess.key("dialog.dosboxversion.required.conf").bind(conf);
        }
        if (mess.noErrors()) {
            DosboxVersion dbversion = DosboxVersionFactory.create("", family.getText(), version.getText(), false, false, false, null, path.getText(), exe.getText(), "", conf.getText());
            File executable = dbversion.getCanonicalExecutable();
            File configFile = dbversion.getConfigurationCanonicalFile();
            boolean exeAvailable = FilesUtils.isReadableFile(executable);
            if (!exeAvailable) {
                mess.key("dialog.dosboxversion.error.dosboxexemissing", new Object[]{executable}).bind(path);
            }
            if (!FilesUtils.isReadableFile(configFile) && exeAvailable && Mess_.on(this.shell_).key("dialog.dosboxversion.confirm.createmissingdosboxconf", new Object[]{configFile}).confirm()) {
                try {
                    ExecuteUtils.doCreateDosboxConf(dbversion);
                }
                catch (IOException e) {
                    Mess_.on(this.shell_).exception(e).warning();
                }
            }
            if (!usingCurses.getSelection() && !FilesUtils.isReadableFile(configFile)) {
                mess.key("dialog.dosboxversion.error.dosboxconfmissing", new Object[]{configFile}).bind(path);
            }
        }
        return mess.valid();
    }
}

