/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Chain;
import org.dbgl.model.ImgSizeCommand;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class EditImgSizeDialog
extends SizeControlledTabbedDialog<String> {
    private ImgSizeCommand sizeCommand;

    public EditImgSizeDialog(Shell parent, String command) {
        super(parent, "imgsizedialog");
        this.sizeCommand = new ImgSizeCommand(command);
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.imgsize.title");
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite("dialog.imgsize.params", 2);
        Spinner bytesPerSector = Chain.on(composite).lbl(l -> l.key("dialog.imgsize.bytespersector")).spn(s -> s.min(1).max(4096).incr(1).pageIncr(512).select(this.sizeCommand.getBytesPerSector())).spinner();
        Spinner sectorsPerTrack = Chain.on(composite).lbl(l -> l.key("dialog.imgsize.sectorspertrack")).spn(s -> s.min(1).max(255).incr(1).pageIncr(64).select(this.sizeCommand.getSectorsPerTrack())).spinner();
        Spinner heads = Chain.on(composite).lbl(l -> l.key("dialog.imgsize.heads")).spn(s -> s.min(1).max(64).incr(1).pageIncr(16).select(this.sizeCommand.getHeads())).spinner();
        Spinner cylinders = Chain.on(composite).lbl(l -> l.key("dialog.imgsize.cylinders")).spn(s -> s.min(1).max(8192).incr(1).pageIncr(20).select(this.sizeCommand.getCylinders())).spinner();
        bytesPerSector.setFocus();
        Text totalSize = Chain.on(composite).lbl(l -> l.key("dialog.imgsize.totalsize")).txt(t -> t.val(this.text_.get("dialog.imgsize.totalsize.value", new Long[]{this.sizeCommand.getTotalSize(), this.sizeCommand.getTotalSizeInMB()})).nonEditable()).text();
        ModifyListener listener = event -> {
            this.sizeCommand = new ImgSizeCommand(bytesPerSector.getSelection(), sectorsPerTrack.getSelection(), heads.getSelection(), cylinders.getSelection());
            totalSize.setText(this.text_.get("dialog.imgsize.totalsize.value", new Long[]{this.sizeCommand.getTotalSize(), this.sizeCommand.getTotalSizeInMB()}));
            composite.layout();
        };
        bytesPerSector.addModifyListener(listener);
        sectorsPerTrack.addModifyListener(listener);
        heads.addModifyListener(listener);
        cylinders.addModifyListener(listener);
        this.createOkCancelButtons(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                EditImgSizeDialog.this.result_ = EditImgSizeDialog.this.sizeCommand.toString();
                EditImgSizeDialog.this.shell_.close();
            }
        });
    }
}

