/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.model.FileLocation;
import org.dbgl.model.ICanonicalize;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ImportExportProfilesService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportListDialog
extends SizeControlledTabbedDialog<Object> {
    private String[] xslBaseNames_;
    private final List<Profile> profiles_;

    public ExportListDialog(Shell parent, List<Profile> profs) {
        super(parent, "exportlistdialog");
        this.profiles_ = profs;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.exportlist.title");
    }

    @Override
    protected boolean prepare() {
        if (FileLocationService.getInstance().hasXslDir()) {
            this.xslBaseNames_ = FileLocationService.getInstance().listXslBaseNames();
            if (this.xslBaseNames_.length == 0) {
                Mess_.on(this.getParent()).key("dialog.exportlist.error.noxslfiles").fatal();
                return false;
            }
        } else {
            Mess_.on(this.getParent()).key("dialog.exportlist.error.noxsldir").fatal();
            return false;
        }
        return true;
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite("dialog.exportlist.options", 3);
        final Combo fileTypes = Chain.on(composite).lbl(l -> l.key("dialog.exportlist.exportfiletype")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(this.xslBaseNames_)).combo();
        Chain chn = Chain.on(composite).lbl(l -> l.key("dialog.exportlist.filename")).txt(t -> t.val(FileLocationService.EXPORT_DIR_STRING + "dbgllist")).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.DOC, true)).build();
        final Text filename = chn.getText();
        final ICanonicalize canonicalizer = (ICanonicalize)chn.getButton().getData("canonicalizer");
        final Button saveXml = Chain.on(composite).lbl(l -> l.key("dialog.exportlist.exportintermediatexml")).but(b -> b).button();
        fileTypes.setFocus();
        fileTypes.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                int index;
                String file = filename.getText();
                String type = fileTypes.getItem(fileTypes.getSelectionIndex());
                int usi = type.lastIndexOf(95);
                if (usi != -1) {
                    type = type.substring(usi + 1);
                }
                if ((index = file.lastIndexOf(46)) == -1) {
                    filename.setText(file + "." + type);
                } else {
                    filename.setText(file.substring(0, index + 1) + type);
                }
            }
        });
        fileTypes.select(0);
        fileTypes.notifyListeners(13, new Event());
        this.createGoCancelButtons("dialog.exportlist.startexport", new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (!ExportListDialog.this.isValid(filename, canonicalizer)) {
                    return;
                }
                try {
                    File exportFile = new FileLocation(filename.getText(), canonicalizer).getCanonicalFile();
                    File xmlFile = saveXml.getSelection() ? new File(String.valueOf(exportFile) + ".xml") : null;
                    File xsltFile = FileLocationService.getInstance().xslBaseNameToFile(fileTypes.getItem(fileTypes.getSelectionIndex()));
                    ImportExportProfilesService.export(ExportListDialog.this.profiles_, xmlFile, xsltFile, exportFile);
                    if (Mess_.on(ExportListDialog.this.shell_).key("dialog.exportlist.confirm.viewexport").confirm()) {
                        SystemUtils.openForBrowsing(exportFile.getPath());
                    }
                }
                catch (IOException | ParserConfigurationException | TransformerException e) {
                    Mess_.on(ExportListDialog.this.shell_).exception(e).warning();
                }
            }
        });
    }

    private boolean isValid(Text filename, ICanonicalize canonicalizer) {
        Mess_.Builder mess = Mess_.on(this.shell_);
        String file = filename.getText();
        File target = new FileLocation(file, canonicalizer).getCanonicalFile();
        if (StringUtils.isBlank(file)) {
            mess.key("dialog.exportlist.required.filename").bind(filename);
        } else if (FilesUtils.isExistingFile(target)) {
            if (!Mess_.on(this.shell_).key("dialog.exportlist.confirm.overwrite", new Object[]{target}).confirm()) {
                mess.key("dialog.exportlist.notice.anotherfilename").bind(filename);
            }
        } else {
            File dir = target.getParentFile();
            if (dir == null || !dir.exists()) {
                mess.key("dialog.exportlist.error.dirmissing").bind(filename);
            }
        }
        return mess.valid();
    }
}

